/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.filtering.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class GATKApplyVQSRJob
extends ISWFJob {
    public static final String JOB_ID = "applyVQSR";
    public static final String JOB_NAME = "GATK - ApplyVQSR";
    public static final String INPUT_RECALIBRATION_TABLE = "INPUT_recalibration_report";
    public static final String INPUT_VCF_FILES = "INPUT_VARIANTS_VCF";
    public static final String OUTPUT_VCF_FILES = "OUTPUT_VARIANTS_VCF";

    public GATKApplyVQSRJob() {
        super(JOB_ID, JOB_NAME);
        GATKHelper.addToolGroup(this.jobDesc);
        this.jobDesc.setDesc("Apply a score cutoff to filter variants based on a recalibration table\n");
        this.jobDesc.setRef(GATKHelper.getCitation(GATKHelper.getManualPage("ApplyVQSR", "org_broadinstitute_hellbender_tools_walkers_vqsr_ApplyVQSR.php")));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_VCF_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input VCF Files");
        varReadInputFile.setHelpMsg("Input VCF Files.");
        varReadInputFile.addAcceptedFileFormat("VCF");
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor recalibratioTableOutputFiles = VariableDescriptor.createDescriptorFor((String)INPUT_RECALIBRATION_TABLE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        recalibratioTableOutputFiles.isRequired = true;
        recalibratioTableOutputFiles.setVariableName("Recalibration Table report");
        recalibratioTableOutputFiles.setHelpMsg("Input recalibration table for VQSR this is the output of VariantRecalibrator tool.");
        this.jobDesc.addVariable(recalibratioTableOutputFiles);
    }

    protected void createOutputs() {
        VariableDescriptor bamOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_VCF_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        bamOutputFile.isRequired = true;
        bamOutputFile.setVariableName("Recalibrated VCF Files");
        bamOutputFile.setHelpMsg("Recalibrated VCF Files");
        this.jobDesc.addVariable(bamOutputFile);
    }

    protected void createOptions() {
        GATKHelper.createSharedOptions(this.jobDesc);
    }

    protected void createRules() {
    }

    public boolean isValid() {
        boolean valid = super.isValid();
        return valid &= this.validateEqualNumberOfFiles(VariantAnaylsisVariableBag.INPUT_BAM_FILES, INPUT_RECALIBRATION_TABLE);
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = GATKHelper.getGATKCmdPrefix() + " ApplyBQSR " + GATKHelper.getTmpOption();
        FilesVariable inputVCFFilesVar = (FilesVariable)this.getVariable(INPUT_VCF_FILES);
        FilesVariable inputTableFilesVar = (FilesVariable)this.getVariable(INPUT_RECALIBRATION_TABLE);
        FilesVariable outVCFFilesVar = (FilesVariable)this.getVariable(OUTPUT_VCF_FILES);
        JobVariable refFileVar = this.getVariable(VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        GATKHelper.checkPrepareReference(builder, refFileVar);
    }
}

