/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.calling.varscan2;

import com.biotechvana.variantseq.jobs.SamtoolsHelper;
import com.biotechvana.variantseq.jobs.VarScanHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.descriptors.IntVariableDescriptor;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class Varscan2GermlineVariantsJob
extends ISWFJob {
    public static final String JOB_ID = "mpileup2VarScan";
    public static final String JOB_NAME = "Varscan2 Germline variants";
    public static final String INPUT_BAM_FILES = VariantAnaylsisVariableBag.INPUT_BAM_FILES;
    public static final String INTER_MPILEUP_FILES = "MPILEUP_FILES";
    public static final String OUTPUT_VARIANTS_VCF = "OUTPUT_VARIANTS_VCF";
    public static final String SUB_PROGRAM = "subPrgram";
    public static final String SUB_SNP = "SNPs";
    public static final String SUB_INDEL = "Indel";
    public static final String SUB_CONS = "Consensus";

    public Varscan2GermlineVariantsJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("MultiSample Germline variants using Varscan2 and samtools.");
        this.jobDesc.addPublication(VarScanHelper.getCitation());
        this.jobDesc.addLink(VarScanHelper.getManualLink(JOB_ID));
    }

    protected void createInputs() {
        VariableDescriptor refVar = VarScanHelper.createReferenceVar();
        this.jobDesc.addVariable(refVar);
        VariableDescriptor inputVar = VarScanHelper.createInputBamFilesVar();
        this.jobDesc.addVariable(inputVar);
    }

    protected void createOutputs() {
        VariableDescriptor output = VarScanHelper.createMpileupFilesVar();
        this.jobDesc.addVariable(output);
        output = VarScanHelper.createOutputVCFFilesVar();
        this.jobDesc.addVariable(output);
    }

    protected void createOptions() {
        SelectionListVariableDescriptor optionVarSelectionList = VariableDescriptor.SelectionList((String)SUB_PROGRAM, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVarSelectionList.isRequired = true;
        optionVarSelectionList.setVariableName("Calling Type");
        optionVarSelectionList.setHelpMsg("Choose which command to use for calling.");
        optionVarSelectionList.addOptionValue(SUB_CONS, SUB_CONS, "Consensus calls (SNP/Indel/Reference) using mpileup2cns");
        optionVarSelectionList.addOptionValue(SUB_SNP, SUB_SNP, "Calls SNPs using mpileup2snp");
        optionVarSelectionList.addOptionValue(SUB_INDEL, SUB_INDEL, "Calls Indels using mpileup2indel");
        optionVarSelectionList.setDefaultIndexValue(0);
        this.jobDesc.addVariable((VariableDescriptor)optionVarSelectionList);
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum read depth");
        optionVar.setHelpMsg("Minimum read depth at a position to make a call. Default is 8");
        optionVar.setCommandParamater("--min-coverage");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum supporting reads");
        optionVar.setHelpMsg("Minimum supporting reads at a position to call variants. Default is 2");
        optionVar.setCommandParamater("--min-reads2");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum base quality at a position to count a read");
        optionVar.setHelpMsg("Minimum base quality at a position to count a read. Default is 15");
        optionVar.setCommandParamater("--min-avg-qual");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum variant allele frequency threshold");
        optionVar.setHelpMsg("Minimum variant allele frequency threshold. Default is 0.01 ");
        optionVar.setCommandParamater("--min-var-freq");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum frequency to call homozygote");
        optionVar.setHelpMsg("Minimum frequency to call homozygote. Default is 0.75");
        optionVar.setCommandParamater("--min-freq-for-hom");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Default p-value threshold for calling variants");
        optionVar.setHelpMsg("Default p-value threshold for calling variants. Default is 0.99 ");
        optionVar.setCommandParamater("--p-value");
        this.jobDesc.addVariable(optionVar);
        IntVariableDescriptor optionVarInt = VariableDescriptor.Int((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVarInt.setVariableName("Ignore variants with >90% support on one strand");
        optionVarInt.setHelpMsg("Ignore variants with >90% support on one strand");
        optionVarInt.setCommandParamater("--strand-filter");
        optionVarInt.setMinValue(0.0);
        optionVarInt.setMaxValue(1.0);
        this.jobDesc.addVariable((VariableDescriptor)optionVarInt);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Report only variant (SNP/indel) positions");
        optionVar.setCommandParamater("--variants");
        this.jobDesc.addVariable(optionVar);
        SamtoolsHelper.createMpileupOptions(this.jobDesc);
    }

    protected void createRules() {
        new VariablesRule(this.getVariable(SUB_PROGRAM), this.getVariableByCMDSwitch("--variants"), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, SUB_CONS, true);
    }

    protected void generateCommand(StringBuilder builder) {
        String mpileup = SamtoolsHelper.getSamtoolsCmdPrefix() + " mpileup ";
        String varscan = VarScanHelper.getVarscanCmdPrefix() + " mpileup2cns ";
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(INPUT_BAM_FILES);
        FilesVariable outMpileupFilesVar = (FilesVariable)this.getVariable(INTER_MPILEUP_FILES);
        FilesVariable outVCFFilesVar = (FilesVariable)this.getVariable(OUTPUT_VARIANTS_VCF);
        JobVariable refFileVar = this.getVariable(VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        String mergeBamsInputStr = "mergeBamIn";
        builder.append(Varscan2GermlineVariantsJob.st((String)BashHelper.assign((String)"sampleName", (String)"allSamples")));
        builder.append(Varscan2GermlineVariantsJob.st((String)BashHelper.assign((String)mergeBamsInputStr, (String)"")));
        builder.append(BashHelper.Batcher_noLog((FilesVariable)inputBamFilesVar, (String)Varscan2GermlineVariantsJob.st((String)BashHelper.strAppend((String)mergeBamsInputStr, (String)" ${_inputFile}")), (boolean)true));
        builder.append(Varscan2GermlineVariantsJob.st((String)BashHelper.arrayAdd((JobVariable)outMpileupFilesVar, (String)"${outputFolder}/${sampleName}.pileup")) + Varscan2GermlineVariantsJob.st((String)BashHelper.arrayAdd((JobVariable)outVCFFilesVar, (String)"${outputFolder}/${sampleName}.vcf")));
        builder.append(BashHelper.command_withTrack((String)BashHelper.$((String)mergeBamsInputStr), (String)(mpileup + this.getOptionParamatersStrAs$("Mpileup") + BashHelper.$((String)mergeBamsInputStr) + " -B  > ${outputFolder}/${sampleName}.pileup "), (String)"Samtools mpileup"));
        builder.append(BashHelper.command_withTrack((String)BashHelper.$((String)mergeBamsInputStr), (String)(varscan + " ${outputFolder}/${sampleName}.pileup " + this.getOptionParamatersStrAs$() + " --variants --output-vcf 1    > ${outputFolder}/${sampleName}.vcf "), (String)"Varscan mpileup2cns"));
    }
}

