/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.calling.varscan2;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.jobs.SamtoolsHelper;
import com.biotechvana.variantseq.jobs.VarScanHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class VarScanSomaticJob
extends ISWFJob {
    public static final String JOB_ID = "somaticVarScan";
    public static final String JOB_NAME = "VarScan2 somatic variants";
    public static final String INPUT_NORMAL_BAM_FILES = "NORMAL_BAM";
    public static final String INPUT_TUMOR_BAM_FILES = "TUMOR_BAM";
    static final String INTER_SAMPLE_FILES = "SAMPLE_FILES";
    public static final String OUTPUT_VARIANTS_SNP_VCF = "OUTPUT_SNP_VCF";
    public static final String OUTPUT_VARIANTS_INDEL_VCF = "OUTPUT_INDEL_VCF";

    public VarScanSomaticJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.addPublication(VarScanHelper.getCitation());
        this.jobDesc.addLink(VarScanHelper.getManualLink(JOB_ID));
    }

    protected void createInputs() {
        VariableDescriptor refVar = VarScanHelper.createReferenceVar();
        this.jobDesc.addVariable(refVar);
        VariableDescriptor inputVar = VarScanHelper.createInputNormalBamFilesVar();
        this.jobDesc.addVariable(inputVar);
        inputVar = VarScanHelper.createInputTumorBamFilesVar();
        this.jobDesc.addVariable(inputVar);
    }

    protected void createOutputs() {
        VariableDescriptor output = VarScanHelper.createOutputSNPVCFFilesVar();
        this.jobDesc.addVariable(output);
        output = VarScanHelper.createOutputIndelVCFFilesVar();
        this.jobDesc.addVariable(output);
        VariableDescriptor internalNames = VariableDescriptor.createDescriptorFor((String)INTER_SAMPLE_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        this.jobDesc.addVariable(internalNames);
    }

    protected void createOptions() {
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum read depth");
        optionVar.setHelpMsg("Minimum coverage in normal and tumor to call variant. Default is 8");
        optionVar.setCommandParamater("--min-coverage");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum coverage Normal");
        optionVar.setHelpMsg("Minimum coverage in normal to call somatic. Default is 8");
        optionVar.setCommandParamater("--min-coverage-normal");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum coverage tumor");
        optionVar.setHelpMsg("Minimum coverage in tumor to call somatic. Default is 6");
        optionVar.setCommandParamater("--min-coverage-tumor");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum variant frequency to call a heterozygote");
        optionVar.setHelpMsg("Minimum variant frequency to call a heterozygote. Default is 0.10");
        optionVar.setCommandParamater("--min-var-freq");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum frequency to call homozygote");
        optionVar.setHelpMsg("Minimum frequency to call homozygote. Default is 0.75");
        optionVar.setCommandParamater("--min-freq-for-hom");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Estimated purity (non-tumor content) of normal sample");
        optionVar.setHelpMsg("Estimated purity (non-tumor content) of normal sample. Default is 1.00");
        optionVar.setCommandParamater("--normal-purity");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Estimated purity (tumor content) of tumor sample");
        optionVar.setHelpMsg("Estimated purity (tumor content) of tumor sample. Default is 1.00");
        optionVar.setCommandParamater("--tumor-purity");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("P-value threshold to call a heterozygote");
        optionVar.setHelpMsg("P-value threshold to call a heterozygote. Default is 0.99");
        optionVar.setCommandParamater("--p-value");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("P-value threshold to call a somatic site");
        optionVar.setHelpMsg("P-value threshold to call a somatic site. Default is 0.05");
        optionVar.setCommandParamater("--somatic-p-value");
        this.jobDesc.addVariable(optionVar);
        SamtoolsHelper.createMpileupOptions(this.jobDesc);
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String mpileup = SamtoolsHelper.getSamtoolsCmdPrefix() + " mpileup ";
        String varscan = VarScanHelper.getVarscanCmdPrefix() + " somatic ";
        FilesVariable inputNormalBamFilesVar = (FilesVariable)this.getVariable(INPUT_NORMAL_BAM_FILES);
        FilesVariable inputTumorBamFilesVar = (FilesVariable)this.getVariable(INPUT_TUMOR_BAM_FILES);
        FilesVariable outSnpFilesVar = (FilesVariable)this.getVariable(OUTPUT_VARIANTS_SNP_VCF);
        FilesVariable outIndelFilesVar = (FilesVariable)this.getVariable(OUTPUT_VARIANTS_INDEL_VCF);
        JobVariable refFileVar = this.getVariable(VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        FilesVariable internalSamplesNames = (FilesVariable)this.getVariable(INTER_SAMPLE_FILES);
        GATKHelper.checkPrepareReference(builder, refFileVar);
        builder.append(BashHelper.Batcher_noLog((FilesVariable)inputNormalBamFilesVar, (String)(VarScanSomaticJob.st((String)BashHelper.arrayAdd((JobVariable)internalSamplesNames, (String)(inputNormalBamFilesVar.$("${_i}") + "," + inputTumorBamFilesVar.$("${_i}")))) + VarScanSomaticJob.st((String)BashHelper.assign((String)"normalBaseName", (String)BashHelper.getBaseName((JobVariable)inputNormalBamFilesVar, (String)"${_i}"))) + VarScanSomaticJob.st((String)BashHelper.assign((String)"tumarBaseName", (String)BashHelper.getBaseName((JobVariable)inputTumorBamFilesVar, (String)"${_i}"))) + VarScanSomaticJob.st((String)BashHelper.assign((String)"tempName", (String)"$(hlp_lncName $normalBaseName $tumarBaseName )")) + String.valueOf(BashHelper.If((String)BashConditions.emptyStr((String)"$tempName")).Then(VarScanSomaticJob.st((String)BashHelper.arrayAdd((JobVariable)outSnpFilesVar, (String)"${outputFolder}/${normalBaseName}_${tumarBaseName}.snp.vcf")) + VarScanSomaticJob.st((String)BashHelper.arrayAdd((JobVariable)outIndelFilesVar, (String)"${outputFolder}/${normalBaseName}_${tumarBaseName}.indel.vcf"))).Else(VarScanSomaticJob.st((String)BashHelper.arrayAdd((JobVariable)outSnpFilesVar, (String)"${outputFolder}/${tempName}.snp.vcf")) + VarScanSomaticJob.st((String)BashHelper.arrayAdd((JobVariable)outIndelFilesVar, (String)"${outputFolder}/${tempName}.indel.vcf"))))), (boolean)true));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputNormalBamFilesVar, (String)"", (String)(VarScanSomaticJob.st((String)BashHelper.assign((String)"outputPrefix", (String)BashHelper.getBaseName((String)outSnpFilesVar.getBashVarName("${_i}"), (String)".snp.vcf"))) + mpileup + this.getOptionParamatersStrAs$("Mpileup") + " -q 1 -B " + inputNormalBamFilesVar.$("${_i}") + " " + inputTumorBamFilesVar.$("${_i}") + " | " + varscan + " --output-snp ${outputFolder}/${outputPrefix}.snp --output-indel ${outputFolder}/${outputPrefix}.indel  --mpileup 1 " + this.getOptionParamatersStrAs$() + "   --output-vcf 1  "), (String)"Varscan"));
    }
}

