/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.calling.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class GATKUnifedGenotyperJob
extends ISWFJob {
    public static final String JOB_ID = "unifiedGenotyper";
    public static final String JOB_NAME = "Standard analysis with unified genotyper";
    public static final String INPUT_BAM_FILES = VariantAnaylsisVariableBag.INPUT_BAM_FILES;
    public static final String OUTPUT_VARIANTS_VCF = "OUTPUT_VARIANTS_VCF";
    public static final String OPTION_BAM_OUT = "OPTION_BAM_OUT";
    public static final String OPTION_ALLELE_SPECIFIC_ANNOTATIONS = "ALLELE_SPECIFIC_ANNOTATIONS";

    public GATKUnifedGenotyperJob() {
        super(JOB_ID, JOB_NAME);
        GATKHelper.addToolGroup(this.jobDesc);
        this.jobDesc.setDesc("Call germline SNPs and indels via local re-assembly of haplotypes");
        this.jobDesc.setRef(GATKHelper.getCitation("HaplotypeCaller : <a href=\"https://software.broadinstitute.org/gatk/documentation/tooldocs/current/org_broadinstitute_hellbender_tools_walkers_haplotypecaller_HaplotypeCaller.php\">Manual Page</a>"));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = GATKHelper.createInputBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor optionaVar = VariableDescriptor.createDescriptorFor((String)OPTION_BAM_OUT, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        optionaVar.setVariableName("Generate Realignmed reads Bam File");
        optionaVar.setHelpMsg("Output the new realigned reads as the HaplotypeCaller performs a local reassembly and realignment on the orginal.");
        this.jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)OPTION_ALLELE_SPECIFIC_ANNOTATIONS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        optionaVar.setVariableName("Allele-specific annotations");
        optionaVar.setHelpMsg("Allele-specific annotations");
        this.jobDesc.addVariable(optionaVar);
    }

    protected void createOutputs() {
        VariableDescriptor variantOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_VARIANTS_VCF, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        variantOutputFile.setVariableName("Variants vcf");
        variantOutputFile.setHelpMsg("variant calls output vcf files");
        this.jobDesc.addVariable(variantOutputFile);
    }

    protected void createOptions() {
        GATKHelper.createSharedOptions(this.jobDesc);
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = GATKHelper.getGATKCmdPrefix() + " HaplotypeCaller " + GATKHelper.getTmpOption();
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(VariantAnaylsisVariableBag.INPUT_BAM_FILES);
        FilesVariable outFilesVar = (FilesVariable)this.getVariable(OUTPUT_VARIANTS_VCF);
        JobVariable refFileVar = this.getVariable(VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        String outputExt = ".g.vcf";
        GATKHelper.checkPrepareReference(builder, refFileVar);
        builder.append(BashHelper.Batcher_noLog((FilesVariable)inputBamFilesVar, (String)BashHelper.arrayAdd((JobVariable)outFilesVar, (String)("${outputFolder}/${inputFileBaseName}" + outputExt)), (boolean)true));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)"", (String)(cmdPrefix + this.getOptionParamatersStrAs$() + "-I ${_inputFile} -ERC GVCF -O " + outFilesVar.$("${_i}")), (String)"HaplotypeCaller"));
    }
}

