/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.calling.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class GATKMutec2Job
extends ISWFJob {
    public static final String JOB_ID = "mutect2";
    public static final String JOB_NAME = "Mutect2";
    public static final String INPUT_NORMAL_BAM_FILES = "NORMAL_BAM";
    public static final String INPUT_TUMOR_BAM_FILES = "TUMOR_BAM";
    public static final String OUTPUT_VARIANTS_VCF = "OUTPUT_VARIANTS_VCF";
    public static final String OPTION_BAM_OUT = "OPTION_BAM_OUT";
    public static final String OPTION_ALLELE_SPECIFIC_ANNOTATIONS = "ALLELE_SPECIFIC_ANNOTATIONS";
    public static final String OPTION_TUMOR_ONLY_MODE = "TUMOR_ONLY_MODE";

    public GATKMutec2Job() {
        super(JOB_ID, JOB_NAME);
        GATKHelper.addToolGroup(this.jobDesc);
        this.jobDesc.setDesc("Call somatic SNVs and indels via local assembly of haplotypes");
        this.jobDesc.setRef(GATKHelper.getCitation(GATKHelper.getManualPage(JOB_NAME, "org_broadinstitute_hellbender_tools_walkers_mutect_Mutect2.php")));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = GATKHelper.createInputTumorBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
        varReadInputFile = GATKHelper.createInputNormalBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor onlyTumor = VariableDescriptor.createDescriptorFor((String)OPTION_TUMOR_ONLY_MODE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        onlyTumor.setVariableName("Tumor only Mode");
        onlyTumor.setHelpMsg("This mode runs on a single sample.");
        this.jobDesc.addVariable(onlyTumor);
    }

    protected void createOutputs() {
        VariableDescriptor variantOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_VARIANTS_VCF, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        variantOutputFile.setVariableName("Variants vcf");
        variantOutputFile.setHelpMsg("variant calls output vcf files");
        this.jobDesc.addVariable(variantOutputFile);
    }

    protected void createOptions() {
        GATKMutec2Job.createMutect2Option(this.jobDesc);
        GATKHelper.createSharedOptions(this.jobDesc, new String[]{GATKHelper.GATK_OPTION_SWITCH_CREATE_BAM_MD5, GATKHelper.GATK_OPTION_SWITCH_CREATE_VCF_MD5, GATKHelper.GATK_OPTION_SWITCH_INTERVALS, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_PADDING, GATKHelper.GATK_OPTION_SWITCH_EXCLUDE_INTERVALS, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_EXCLUSION_PADDING, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_MERGING_RULE, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_SET_RULE, GATKHelper.GATK_OPTION_SWITCH_LENIENT, GATKHelper.GATK_OPTION_SWITCH_READ_VALIDATION_STRINGENCY, GATKHelper.GATK_OPTION_SWITCH_ARGUMENTS_FILE, GATKHelper.GATK_OPTION_SWITCH_GATK_CONFIG_FILE});
    }

    public static void createMutect2Option(JobDescriptor jobDesc) {
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("A panel of normals PoNs");
        optionVar.setHelpMsg("PoNs : VCF file of sites observed in normal to help filter out commonly seen sequencing noise that may appear as low allele-fraction somatic variants. Default is null");
        optionVar.setCommandParamater("-pon");
        optionVar.setCommandParamaterAlt("--panel-of-normals");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Default Population allele fraction");
        optionVar.setHelpMsg("Population allele fraction assigned to alleles not found in germline resource. Default is -1.0");
        optionVar.setCommandParamater("-default-af");
        optionVar.setCommandParamaterAlt("--af-of-alleles-not-in-resource");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Annotate with num Discovered Alleles");
        optionVar.setHelpMsg("If provided, we will annotate records with the number of alternate alleles that were discovered (but not necessarily genotyped) at a given siteDepending on the value of the --max_alternate_alleles argument, we may genotype only a fraction of the alleles being sent on for genotyping. Using this argument instructs the genotyper to annotate (in the INFO field) the number of alternate alleles that were originally discovered at the site.");
        optionVar.setCommandParamater("--annotate-with-num-discovered-alleles");
        jobDesc.addVariable(optionVar);
        optionVar = GATKHelper.createOptionAnnotation();
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Base Quality Score Threshold");
        optionVar.setHelpMsg("Bases with a quality below this threshold will reduced to the minimum usable qualiy score (6). Default is 18");
        optionVar.setCommandParamater("--base-quality-score-threshold");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Contamination Fraction to Filter");
        optionVar.setHelpMsg("Fraction of contamination in sequencing data (for all samples) to aggressively remove. If this fraction is greater is than zero, the caller will aggressively attempt to remove contamination through biased down-sampling of reads. Basically, it will ignore the contamination fraction of reads for each alternate allele. So if the pileup contains N total bases, then we will try to remove (N * contamination fraction) bases for each alternate allele. Default is 0.0");
        optionVar.setCommandParamater("-contamination");
        optionVar.setCommandParamaterAlt("--contamination-fraction-to-filter");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Disable all tool default annotations");
        optionVar.setHelpMsg("Hook allowing for the user to remove default annotations from the tool");
        optionVar.setCommandParamater("--disable-tool-default-annotations");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Downsampling stride");
        optionVar.setHelpMsg("Downsample a pool of reads starting within a range of one or more bases. Default is 1");
        optionVar.setCommandParamater("--downsampling-stride");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Call all apparent germline site even though they will ultimately be filtered.");
        optionVar.setHelpMsg("Call all apparent germline site even though they will ultimately be filtered (EXPERIMENTAL).");
        optionVar.setCommandParamater("--genotype-germline-sites");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Call sites in the PoN even though they will ultimately be filtered.");
        optionVar.setHelpMsg("Call sites in the PoN even though they will ultimately be filtered.");
        optionVar.setCommandParamater("--genotype-pon-sites");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Population vcf of germline sequencing containing allele fractions");
        optionVar.setHelpMsg("A resource, such as gnomAD, containing population allele frequencies of common and rare variants");
        optionVar.setCommandParamater("--germline-resource");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Heterozygosity value used to compute prior likelihoods for any locus");
        optionVar.setHelpMsg("The expected heterozygosity value used to compute prior probability that a locus is non-reference. The default priors are for provided for humans: het = 1e-3 which means that the probability of N samples being hom-ref at a site is: 1 - sum_i_2N (het / i) A hets value of 0.01 implies that two randomly chosen chromosomes from the population of organisms would differ from each other (one being A and the other B) at a rate of 1 in 100 bp. Note that this quantity has nothing to do with the likelihood of any given sample having a heterozygous genotype, which in the GATK is purely determined by the probability of the observed data P(D | AB) under the model that there may be a AB het genotype. The posterior probability of this AB genotype would use the het prior, but the GATK only uses this posterior probability in determining the prob. that a site is polymorphic. So changing the het parameters only increases the chance that a site will be called non-reference across all samples, but doesn't actually change the output genotype likelihoods at all, as these aren't posterior probabilities at all. The quantity that changes whether the GATK considers the possibility of a het genotype at all is the ploidy, which determines how many chromosomes each individual in the species carries. Default is 0.001 ");
        optionVar.setCommandParamater("--heterozygosity");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Standard deviation of eterozygosity for SNP and indel calling");
        optionVar.setHelpMsg("The standard deviation of the distribution of alt allele fractions. The above heterozygosity parameters give the *mean* of this distribution; this parameter gives its spread. Default is 0.01");
        optionVar.setCommandParamater("--heterozygosity-stdev");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Heterozygosity for indel calling.");
        optionVar.setHelpMsg("This argument informs the prior probability of having an indel at a site. Default is 1.25E-4");
        optionVar.setCommandParamater("--indel-heterozygosity");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("LOD threshold to consider pileup active");
        optionVar.setHelpMsg("Only variants with estimated tumor LODs exceeding this threshold will be considered active. Default is 2.0");
        optionVar.setCommandParamater("-init-lod");
        optionVar.setCommandParamaterAlt("--initial-tumor-lod");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Maximum population allele frequency in tumor-only mode.");
        optionVar.setHelpMsg("In tumor-only mode, we discard variants with population allele frequencies greater than this threshold. Default is 0.01");
        optionVar.setCommandParamater("-max-af");
        optionVar.setCommandParamaterAlt("--max-population-af");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Maximum number of reads to retain per alignment start position");
        optionVar.setHelpMsg("Maximum number of reads to retain per alignment start position. Reads above this threshold will be downsampled. Set to 0 to disable. Default is 50");
        optionVar.setCommandParamater("--max-reads-per-alignment-start");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum base quality required to consider a base for calling");
        optionVar.setHelpMsg("Bases with a quality below this threshold will not be used for calling. Default is 10");
        optionVar.setCommandParamater("-mbq");
        optionVar.setCommandParamaterAlt("--min-base-quality-score");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Use double precision in the native pairHmm");
        optionVar.setHelpMsg("Use double precision in the native pairHmm. This is slower but matches the java implementation better");
        optionVar.setCommandParamater("--native-pair-hmm-use-double-precision");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("LOD threshold for calling normal variant non-germline");
        optionVar.setHelpMsg("This is a measure of the minimum evidence to support that a variant observed in the tumor is not also present in the normal. Applies to normal data in a tumor with matched normal analysis. The default has been tuned for diploid somatic analyses. It is unlikely such analyses will require changing the default value. Increasing the parameter may increase the sensitivity of somatic calling, but may also increase calling false positive, i.e. germline, variants. Default is 2.2");
        optionVar.setCommandParamater("--normal-lod");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("The minimum phred-scaled confidence threshold at which variants should be called");
        optionVar.setHelpMsg("The minimum phred-scaled confidence threshold at which variants should be called. Only variant sites with QUAL equal or greater than this threshold will be called. Note that since version 3.7, we no longer differentiate high confidence from low confidence calls at the calling step. The default call confidence threshold is set low intentionally to achieve high sensitivity, which will allow false positive calls as a side effect. Be sure to perform some kind of filtering after calling to reduce the amount of false positives in your final callset. Note that when HaplotypeCaller is used in GVCF mode (using either -ERC GVCF or -ERC BP_RESOLUTION) the call threshold is automatically set to zero. Call confidence thresholding will then be performed in the subsequent GenotypeGVCFs command. Default is 10.0");
        optionVar.setCommandParamater("-stand-call-conf");
        optionVar.setCommandParamaterAlt("--standard-min-confidence-threshold-for-calling");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("LOD threshold to emit tumor variant to VCF");
        optionVar.setHelpMsg("Only variants with tumor LODs exceeding this threshold will be written to the VCF, regardless of filter status. Set to less than or equal to tumor_lod. Increase argument value to reduce false positives in the callset. Default setting of 3 is permissive and will emit some amount of negative training data that  FilterMutectCalls should then filter. Default is 3.0");
        optionVar.setCommandParamater("-emit-lod");
        optionVar.setCommandParamaterAlt("--tumor-lod-to-emit");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Use the new allele frequency / QUAL score model");
        optionVar.setHelpMsg("Use the new allele frequency / QUAL score model instead of the so-called exact model");
        optionVar.setCommandParamater("-new-qual");
        optionVar.setCommandParamaterAlt("--use-new-qual-calculator");
        jobDesc.addVariable(optionVar);
    }

    protected void createRules() {
        new VariablesRule(this.getVariable(OPTION_TUMOR_ONLY_MODE), this.getVariable(INPUT_TUMOR_BAM_FILES), VariablesRule.Condition.True, VariablesRule.Action.Enable);
        new VariablesRule(this.getVariable(OPTION_TUMOR_ONLY_MODE), this.getVariable(INPUT_TUMOR_BAM_FILES), VariablesRule.Condition.False, VariablesRule.Action.Enable);
        new VariablesRule(this.getVariable(OPTION_TUMOR_ONLY_MODE), this.getVariable(INPUT_NORMAL_BAM_FILES), VariablesRule.Condition.False, VariablesRule.Action.Enable, true);
    }

    protected void generateCommand(StringBuilder builder) {
        String mutectCmdPrefix = GATKHelper.getGATKCmdPrefix() + " Mutect2 " + GATKHelper.getTmpOption();
        FilesVariable inputTumorFilesVar = (FilesVariable)this.getVariable(INPUT_TUMOR_BAM_FILES);
        FilesVariable inputNormalFilesVar = (FilesVariable)this.getVariable(INPUT_NORMAL_BAM_FILES);
        FilesVariable outFilesVar = (FilesVariable)this.getVariable(OUTPUT_VARIANTS_VCF);
        JobVariable refFileVar = this.getVariable(VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        JobVariable modeVar = this.getVariable(OPTION_TUMOR_ONLY_MODE);
        GATKHelper.checkPrepareReference(builder, refFileVar);
        String optionalVar = " --activity-profile-out ${sampleTumorName}_activity_profile --assembly-region-out ${sampleTumorName}_assembly_region ";
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputTumorFilesVar, (String)(GATKMutec2Job.st((String)BashHelper.assign((String)"sampleTumorName", (String)"$(getSamRG ${_inputFile} )")) + BashHelper.arrayAdd((JobVariable)outFilesVar, (String)"${outputFolder}/${sampleTumorName}.vcf") + String.valueOf(BashHelper.If((String)BashConditions.False((JobVariable)modeVar)).Then(GATKMutec2Job.st((String)BashHelper.assign((String)"sampleNormalName", (String)("$(getSamRG " + inputNormalFilesVar.$("${_i}") + " )"))) + GATKMutec2Job.st((String)BashHelper.assign((String)"normalOptions", (String)("-normal ${sampleNormalName}  -I " + inputNormalFilesVar.$("${_i}"))))))), (String)(mutectCmdPrefix + this.getOptionParamatersStrAs$() + optionalVar + "-I ${_inputFile} -tumor ${sampleTumorName}  ${normalOptions} -O " + outFilesVar.$("${_i}")), (String)"MuTect2"));
    }
}

