/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.calling.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.MultiSelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class GATKHaplotypeCallerJob
extends ISWFJob {
    public static final String JOB_ID = "haplotypeCaller";
    public static final String JOB_NAME = "GATK - HaplotypeCaller";
    public static final String INPUT_BAM_FILES = VariantAnaylsisVariableBag.INPUT_BAM_FILES;
    public static final String OUTPUT_VARIANTS_VCF = "OUTPUT_VARIANTS_VCF";
    public static final String OPTION_BAM_OUT = "OPTION_BAM_OUT";
    public static final String OPTION_EMIT_REF_CONFIDENCE = "EMIT_REF_CONFIDENCE";
    public static final String ERC_MODE_NONE = "NONE";
    public static final String ERC_MODE_BP_RESOLUTION = "BP_RESOLUTION";
    public static final String ERC_MODE_GVCF = "GVCF";

    public GATKHaplotypeCallerJob() {
        super(JOB_ID, JOB_NAME);
        GATKHelper.addToolGroup(this.jobDesc);
        this.jobDesc.setDesc("Call germline SNPs and indels via local re-assembly of haplotypes");
        this.jobDesc.setRef(GATKHelper.getCitation("HaplotypeCaller : <a href=\"https://software.broadinstitute.org/gatk/documentation/tooldocs/current/org_broadinstitute_hellbender_tools_walkers_haplotypecaller_HaplotypeCaller.php\">Manual Page</a>"));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = GATKHelper.createInputBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor optionaVar = VariableDescriptor.createDescriptorFor((String)OPTION_BAM_OUT, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        optionaVar.setVariableName("Generate Realignmed reads Bam File");
        optionaVar.setHelpMsg("Output the new realigned reads as the HaplotypeCaller performs a local reassembly and realignment on the orginal.");
        optionaVar.setCommandParamater("-bamout");
        optionaVar.setSubProgName("_NO_CMD_");
        this.jobDesc.addVariable(optionaVar);
        SelectionListVariableDescriptor selectionListOptionaVar = VariableDescriptor.SelectionList((String)OPTION_EMIT_REF_CONFIDENCE, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        selectionListOptionaVar.setVariableName("Mode for emitting reference confidence scores");
        selectionListOptionaVar.isRequired = true;
        selectionListOptionaVar.setHelpMsg("The reference confidence mode makes it possible to emit a per-bp or summarized confidence estimate for a site being strictly homozygous-reference.");
        selectionListOptionaVar.addOptionValue(ERC_MODE_NONE, ERC_MODE_NONE, "Regular calling without emitting reference confidence calls.");
        selectionListOptionaVar.addOptionValue(ERC_MODE_BP_RESOLUTION, ERC_MODE_BP_RESOLUTION, "Reference model emitted site by site");
        selectionListOptionaVar.addOptionValue(ERC_MODE_GVCF, ERC_MODE_GVCF, "Reference model emitted with condensed non-variant blocks, i.e. the GVCF format.");
        selectionListOptionaVar.setDefaultIndexValue(0);
        selectionListOptionaVar.setCommandParamater("-ERC");
        selectionListOptionaVar.setCommandParamaterAlt("--emit-ref-confidence");
        this.jobDesc.addVariable((VariableDescriptor)selectionListOptionaVar);
    }

    protected void createOutputs() {
        VariableDescriptor variantOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_VARIANTS_VCF, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        variantOutputFile.setVariableName("Variants gvcf/vcf");
        variantOutputFile.setHelpMsg("output gvcf/vcf files");
        variantOutputFile.isRequired = true;
        this.jobDesc.addVariable(variantOutputFile);
    }

    public static void creareOptionHC(JobDescriptor jobDesc) {
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Alleles set");
        optionVar.setHelpMsg("The set of alleles at which to genotype when --genotyping_mode is GENOTYPE_GIVEN_ALLELES. When the caller is put into GENOTYPE_GIVEN_ALLELES mode it will genotype the samples using only the alleles provide in this rod binding");
        optionVar.setCommandParamater("--alleles");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Annotate with num Discovered Alleles");
        optionVar.setHelpMsg("If provided, we will annotate records with the number of alternate alleles that were discovered (but not necessarily genotyped) at a given siteDepending on the value of the --max_alternate_alleles argument, we may genotype only a fraction of the alleles being sent on for genotyping. Using this argument instructs the genotyper to annotate (in the INFO field) the number of alternate alleles that were originally discovered at the site.");
        optionVar.setCommandParamater("--annotate-with-num-discovered-alleles");
        jobDesc.addVariable(optionVar);
        GATKHelper.createSharedOptions(jobDesc, GATKHelper.GATK_OPTION_SWITCH_ANNOTATION, null);
        MultiSelectionListVariableDescriptor multiSelectionListOptionaVar = VariableDescriptor.MultiSelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        multiSelectionListOptionaVar.setVariableName("Annotations group");
        multiSelectionListOptionaVar.setHelpMsg("One or more groups of annotations to apply to variant calls");
        multiSelectionListOptionaVar.addOptionValue("AS_StandardAnnotation");
        multiSelectionListOptionaVar.addOptionValue("ReducibleAnnotation");
        multiSelectionListOptionaVar.addOptionValue("StandardAnnotation");
        multiSelectionListOptionaVar.addOptionValue("StandardHCAnnotation");
        multiSelectionListOptionaVar.addOptionValue("StandardMutectAnnotation");
        multiSelectionListOptionaVar.setCommandParamater("--annotation-group");
        multiSelectionListOptionaVar.setCommandParamaterAlt("-G");
        jobDesc.addVariable((VariableDescriptor)multiSelectionListOptionaVar);
        multiSelectionListOptionaVar = VariableDescriptor.MultiSelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        multiSelectionListOptionaVar.setVariableName("Annotations to exclude");
        multiSelectionListOptionaVar.setHelpMsg("One or more specific annotations to exclude from variant calls. Which annotations to exclude from output in the variant calls. Note that this argument has higher priority than the -A or -G arguments, so these annotations will be excluded even if they are explicitly included with the other options");
        multiSelectionListOptionaVar.addOptionValue("BaseQualityRankSumTest");
        multiSelectionListOptionaVar.addOptionValue("Coverage");
        multiSelectionListOptionaVar.addOptionValue("DepthPerAlleleBySample");
        multiSelectionListOptionaVar.addOptionValue("DepthPerSampleHC");
        multiSelectionListOptionaVar.addOptionValue("ExcessHet");
        multiSelectionListOptionaVar.addOptionValue("FisherStrand");
        multiSelectionListOptionaVar.addOptionValue("InbreedingCoeff");
        multiSelectionListOptionaVar.addOptionValue("MappingQualityRankSumTest");
        multiSelectionListOptionaVar.addOptionValue("QualByDepth");
        multiSelectionListOptionaVar.addOptionValue("ReadPosRankSumTest");
        multiSelectionListOptionaVar.addOptionValue("RMSMappingQuality");
        multiSelectionListOptionaVar.addOptionValue("StrandOddsRatio");
        multiSelectionListOptionaVar.setCommandParamater("--annotations-to-exclude");
        multiSelectionListOptionaVar.setCommandParamaterAlt("-AX");
        jobDesc.addVariable((VariableDescriptor)multiSelectionListOptionaVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Base Quality Score Threshold");
        optionVar.setHelpMsg("Bases with a quality below this threshold will reduced to the minimum usable qualiy score (6). Default is 18");
        optionVar.setCommandParamater("--base-quality-score-threshold");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Contamination Fraction to Filter");
        optionVar.setHelpMsg("Fraction of contamination in sequencing data (for all samples) to aggressively remove. If this fraction is greater is than zero, the caller will aggressively attempt to remove contamination through biased down-sampling of reads. Basically, it will ignore the contamination fraction of reads for each alternate allele. So if the pileup contains N total bases, then we will try to remove (N * contamination fraction) bases for each alternate allele. Default is 0.0");
        optionVar.setCommandParamater("-contamination");
        optionVar.setCommandParamaterAlt("--contamination-fraction-to-filter");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("dbSNP files");
        optionVar.setHelpMsg("One or more dbSNP files");
        optionVar.setCommandParamater("--dbsnp");
        optionVar.setCommandParamaterAlt("-D");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Disable all tool default annotations");
        optionVar.setHelpMsg("Hook allowing for the user to remove default annotations from the tool");
        optionVar.setCommandParamater("--disable-tool-default-annotations");
        jobDesc.addVariable(optionVar);
        SelectionListVariableDescriptor selectionListOptionVar = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        selectionListOptionVar.setVariableName("Genotyping Mode");
        selectionListOptionVar.setHelpMsg("Specifies how to determine the alternate alleles to use for genotyping. Default is DISCOVERY");
        selectionListOptionVar.setCommandParamater("--genotyping-mode");
        selectionListOptionVar.addOptionValue("DISCOVERY", "DISCOVERY", "The genotyper will choose the most likely alternate allel");
        selectionListOptionVar.addOptionValue("GENOTYPE_GIVEN_ALLELES", "GENOTYPE_GIVEN_ALLELES", "Only the alleles passed by the user should be considered");
        jobDesc.addVariable((VariableDescriptor)selectionListOptionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Heterozygosity value used to compute prior likelihoods for any locus");
        optionVar.setHelpMsg("The expected heterozygosity value used to compute prior probability that a locus is non-reference. The default priors are for provided for humans: het = 1e-3 which means that the probability of N samples being hom-ref at a site is: 1 - sum_i_2N (het / i) A hets value of 0.01 implies that two randomly chosen chromosomes from the population of organisms would differ from each other (one being A and the other B) at a rate of 1 in 100 bp. Note that this quantity has nothing to do with the likelihood of any given sample having a heterozygous genotype, which in the GATK is purely determined by the probability of the observed data P(D | AB) under the model that there may be a AB het genotype. The posterior probability of this AB genotype would use the het prior, but the GATK only uses this posterior probability in determining the prob. that a site is polymorphic. So changing the het parameters only increases the chance that a site will be called non-reference across all samples, but doesn't actually change the output genotype likelihoods at all, as these aren't posterior probabilities at all. The quantity that changes whether the GATK considers the possibility of a het genotype at all is the ploidy, which determines how many chromosomes each individual in the species carries. Default is 0.001 ");
        optionVar.setCommandParamater("--heterozygosity");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Standard deviation of eterozygosity for SNP and indel calling");
        optionVar.setHelpMsg("The standard deviation of the distribution of alt allele fractions. The above heterozygosity parameters give the *mean* of this distribution; this parameter gives its spread. Default is 0.01");
        optionVar.setCommandParamater("--heterozygosity-stdev");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Heterozygosity for indel calling.");
        optionVar.setHelpMsg("This argument informs the prior probability of having an indel at a site. Default is 1.25E-4");
        optionVar.setCommandParamater("--indel-heterozygosity");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Maximum number of reads to retain per alignment start position");
        optionVar.setHelpMsg("Maximum number of reads to retain per alignment start position. Reads above this threshold will be downsampled. Set to 0 to disable. Default is 50");
        optionVar.setCommandParamater("--max-reads-per-alignment-start");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum base quality required to consider a base for calling");
        optionVar.setHelpMsg("Bases with a quality below this threshold will not be used for calling. Default is 10");
        optionVar.setCommandParamater("-mbq");
        optionVar.setCommandParamaterAlt("--min-base-quality-score");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Use double precision in the native pairHmm");
        optionVar.setHelpMsg("Use double precision in the native pairHmm. This is slower but matches the java implementation better");
        optionVar.setCommandParamater("--native-pair-hmm-use-double-precision");
        jobDesc.addVariable(optionVar);
        selectionListOptionVar = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        selectionListOptionVar.setVariableName("Output Mode");
        selectionListOptionVar.setHelpMsg("Specifies which type of calls should be outputed");
        selectionListOptionVar.setCommandParamater("--output-mode");
        selectionListOptionVar.addOptionValue("EMIT_VARIANTS_ONLY", "EMIT_VARIANTS_ONLY", "produces calls only at variant site");
        selectionListOptionVar.addOptionValue("EMIT_ALL_CONFIDENT_SITES", "EMIT_ALL_CONFIDENT_SITES", "produces calls at variant sites and confident reference sites");
        selectionListOptionVar.addOptionValue("EMIT_ALL_SITES", "EMIT_ALL_SITES", "produces calls at any callable site regardless of confidence; this argument is intended only for point mutations (SNPs) in DISCOVERY mode or generally when running in GENOTYPE_GIVEN_ALLELES mode; it will by no means produce a comprehensive set of indels in DISCOVERY mode");
        jobDesc.addVariable((VariableDescriptor)selectionListOptionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Ploidy (number of chromosomes) per sample.");
        optionVar.setHelpMsg("Sample ploidy - equivalent to number of chromosomes per pool. In pooled experiments this should be = # of samples in pool * individual sample ploidy");
        optionVar.setCommandParamater("-ploidy");
        optionVar.setCommandParamaterAlt("--sample-ploidy");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("The minimum phred-scaled confidence threshold at which variants should be called");
        optionVar.setHelpMsg("The minimum phred-scaled confidence threshold at which variants should be called. Only variant sites with QUAL equal or greater than this threshold will be called. Note that since version 3.7, we no longer differentiate high confidence from low confidence calls at the calling step. The default call confidence threshold is set low intentionally to achieve high sensitivity, which will allow false positive calls as a side effect. Be sure to perform some kind of filtering after calling to reduce the amount of false positives in your final callset. Note that when HaplotypeCaller is used in GVCF mode (using either -ERC GVCF or -ERC BP_RESOLUTION) the call threshold is automatically set to zero. Call confidence thresholding will then be performed in the subsequent GenotypeGVCFs command. Default is 10.0");
        optionVar.setCommandParamater("-stand-call-conf");
        optionVar.setCommandParamaterAlt("--standard-min-confidence-threshold-for-calling");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Use the new allele frequency / QUAL score model");
        optionVar.setHelpMsg("Use the new allele frequency / QUAL score model instead of the so-called exact model");
        optionVar.setCommandParamater("-new-qual");
        optionVar.setCommandParamaterAlt("--use-new-qual-calculator");
        jobDesc.addVariable(optionVar);
        String advancedOption = "Advanced Option";
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Do not analyze soft clipped bases in the reads");
        optionVar.setHelpMsg("Do not analyze soft clipped bases in the reads");
        optionVar.setCommandParamater("--dont-use-soft-clipped-bases");
        jobDesc.addVariable(optionVar);
    }

    protected void createOptions() {
        GATKHaplotypeCallerJob.creareOptionHC(this.jobDesc);
        GATKHelper.createSharedOptions(this.jobDesc, new String[]{GATKHelper.GATK_OPTION_SWITCH_CREATE_BAM_INDEX, GATKHelper.GATK_OPTION_SWITCH_CREATE_BAM_MD5, GATKHelper.GATK_OPTION_SWITCH_CREATE_VCF_INDEX, GATKHelper.GATK_OPTION_SWITCH_CREATE_VCF_MD5, GATKHelper.GATK_OPTION_SWITCH_DISABLE_TOOL_DEFAULT_READ_FILTERS, GATKHelper.GATK_OPTION_SWITCH_INTERVALS, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_MERGING_RULE, GATKHelper.GATK_OPTION_SWITCH_EXCLUDE_INTERVALS, GATKHelper.GATK_OPTION_SWITCH_GATK_CONFIG_FILE, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_EXCLUSION_PADDING, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_PADDING, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_SET_RULE, GATKHelper.GATK_OPTION_SWITCH_LENIENT, GATKHelper.GATK_OPTION_SWITCH_READ_FILTER, GATKHelper.GATK_OPTION_SWITCH_READ_VALIDATION_STRINGENCY});
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String haplotypeCallerPrefix = GATKHelper.getGATKCmdPrefix() + " HaplotypeCaller " + GATKHelper.getTmpOption();
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(VariantAnaylsisVariableBag.INPUT_BAM_FILES);
        FilesVariable outFilesVar = (FilesVariable)this.getVariable(OUTPUT_VARIANTS_VCF);
        JobVariable refFileVar = this.getVariable(VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        JobVariable ercMode = this.getVariable(OPTION_EMIT_REF_CONFIDENCE);
        String outputExt = ".g.vcf";
        GATKHelper.checkPrepareReference(builder, refFileVar);
        builder.append(BashHelper.If((String)BashConditions.or((String)BashConditions.Equal((JobVariable)ercMode, (String)ERC_MODE_GVCF), (String)BashConditions.Equal((JobVariable)ercMode, (String)ERC_MODE_BP_RESOLUTION))).Then(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)GATKHaplotypeCallerJob.st((String)BashHelper.arrayAdd((JobVariable)outFilesVar, (String)"${outputFolder}/${inputFileBaseName}.g.vcf")), (String)(haplotypeCallerPrefix + this.getOptionParamatersStrAs$() + "-I ${_inputFile}  -O " + outFilesVar.$("${_i}")), (String)"HaplotypeCaller")).Else(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)GATKHaplotypeCallerJob.st((String)BashHelper.arrayAdd((JobVariable)outFilesVar, (String)"${outputFolder}/${inputFileBaseName}.vcf")), (String)(haplotypeCallerPrefix + this.getOptionParamatersStrAs$() + "-I ${_inputFile}  -O " + outFilesVar.$("${_i}")), (String)"HaplotypeCaller")));
    }
}

