/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.annotation;

import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.MultiSelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;
import com.biotechvana.workflow.variables.ListJobVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AnnotationVEPJob
extends ISWFJob {
    public static final String JOB_ID = "annotationVEP";
    public static final String JOB_NAME = "VEP- Variant Effect Prediction";
    private static final String INPUT_SPECIES = "INPUT_SPECIES";
    private static final String INPUT_RELEASE = "INPUT_RELEASE";
    private static final String INPUT_VERSION = "INPUT_VERSION";
    private static final String INPUT_ASSEMPLY = "INPUT_ASSEMPLY";
    private HashMap<String, ArrayList<String>> assemplyMap;
    public static final String INPUT_VCF_FILES = "INPUT_VARIANTS_VCF";
    public static final String OUTPUT_VARIANTS_VCF = "OUTPUT_VARIANTS_VCF";
    SelectionListVariableDescriptor varInputAssemply;
    static String GROUP_Colocated_Variants = "Co-located variants";
    static String GROUP_IDN = "Identifiers";
    static String GROUP_OUTFEILDS = "Output Fields";
    static String GROUP_Format = "Data format";

    public AnnotationVEPJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("VEP determines the effect of variants (SNPs, insertions, deletions, CNVs or structural variants) on genes, transcripts, and protein sequence, as well as regulatory regions.");
        this.jobDesc.setRef("McLaren W, Gil L, Hunt SE, Riat HS, Ritchie GR, Thormann A, Flicek P, Cunningham F. The Ensembl Variant Effect Predictor. Genome Biology Jun 6;17(1):122. (2016) <a href=\"http://dx.doi.org/10.1186/s13059-016-0974-4\"> doi:10.1186/s13059-016-0974-4 </a>");
    }

    protected void createInputs() {
        VariableDescriptor varInputGenome = VariableDescriptor.createDescriptorFor((String)INPUT_SPECIES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.SelectionList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInputGenome.isRequired = true;
        varInputGenome.setVariableName("Select Ensembl Species");
        varInputGenome.setHelpMsg("Choose species name");
        this.loadSupportedGenomes((SelectionListVariableDescriptor)varInputGenome);
        varInputGenome.setCommandParamater("--species");
        this.jobDesc.addVariable(varInputGenome);
        this.assemplyMap = new HashMap();
        this.loadGenemosAssembly();
        this.varInputAssemply = (SelectionListVariableDescriptor)VariableDescriptor.createDescriptorFor((String)INPUT_ASSEMPLY, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.SelectionList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        this.varInputAssemply.isRequired = false;
        this.varInputAssemply.setVariableName("Select Ensembl Assembly");
        this.varInputAssemply.setHelpMsg("Choose Assembly version");
        this.jobDesc.addVariable((VariableDescriptor)this.varInputAssemply);
        VariableDescriptor varInputVersion = VariableDescriptor.createDescriptorFor((String)INPUT_VERSION, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInputVersion.setVariableName("Use Assembly Version GRCh37");
        varInputVersion.setHelpMsg("Assembly Version GRCh37. By Default the used version is GRCh38, check this option to use GRCh37 instead");
        varInputVersion.setCommandParamater("--assembly GRCh37 --port 3337");
        this.jobDesc.addVariable(varInputVersion);
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_VCF_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input VCF Files");
        varReadInputFile.setHelpMsg("Input Files in VCF format.");
        varReadInputFile.addAcceptedFileFormat("VCF");
        this.jobDesc.addVariable(varReadInputFile);
    }

    protected void createOutputs() {
        VariableDescriptor variantOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_VARIANTS_VCF, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        variantOutputFile.setVariableName("Annotated Output Files");
        variantOutputFile.setHelpMsg("Annotated Output Files");
        this.jobDesc.addVariable(variantOutputFile);
    }

    protected void createOptions() {
        this.createIdentifiersGroup(this.jobDesc);
        this.createOutputOptions(this.jobDesc);
        this.createCoLocatedVariantsGroup(this.jobDesc);
        this.createDataFormatGroup(this.jobDesc);
    }

    private void createCoLocatedVariantsGroup(JobDescriptor jobDesc) {
        VariableDescriptor optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Checks for the existence of known variants that are co-located with the input");
        optionaVar.setHelpMsg("Checks for the existence of known variants that are co-located with your input. By default the alleles are compared and variants on an allele-specific basis - to compare only coordinates, use --no_check_alleles.Some databases may contain variants with unknown (null) alleles and these are included by default; to exclude them use --exclude_null_alleles.");
        optionaVar.setCommandParamater("--check_existing");
        optionaVar.setVariableGroup(GROUP_Colocated_Variants);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Do not include variants with unknown alleles");
        optionaVar.setHelpMsg("Do not include variants with unknown alleles when checking for co-located variants. The human variation database contains variants from HGMD and COSMIC for which the alleles are not publically available; by default these are included when using --check_existing, use this flag to exclude them.");
        optionaVar.setCommandParamater("--exclude_null_alleles");
        optionaVar.setVariableGroup(GROUP_Colocated_Variants);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("No Alleles checking - compare only based on coordinates.");
        optionaVar.setHelpMsg("Disable this Alleles checking and compare using coordinates alone. When checking for existing variants, by default VEP only reports a co-located variant if none of the input alleles are novel. For example, if the user input has alleles A/G, and an existing co-located variant has alleles A/C, the co-located variant will not be reported. Strand is also taken into account - in the same example, if the user input has alleles T/G but on the negative strand, then the co-located variant will be reported since its alleles match the reverse complement of user input.");
        optionaVar.setCommandParamater("--no_check_alleles");
        optionaVar.setVariableGroup(GROUP_Colocated_Variants);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Add the global allele frequency (AF) from 1000 Genomes Phase 3 data for any known co-located variant");
        optionaVar.setHelpMsg("Add the global allele frequency (AF) from 1000 Genomes Phase 3 data for any known co-located variant. For this and all --af_* flags, the frequency reported is for the input allele only, not necessarily the non-reference or derived allele. Supercedes --gmaf. Output fields [AF]");
        optionaVar.setCommandParamater("--af");
        optionaVar.setVariableGroup(GROUP_Colocated_Variants);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Report the highest allele frequency observed in any population from 1000 genomes, ESP or gnomAD");
        optionaVar.setHelpMsg("Report the highest allele frequency observed in any population from 1000 genomes, ESP or gnomAD. Output fields [MAX_AF, MAX_AF_POPS]");
        optionaVar.setCommandParamater("--max_af");
        optionaVar.setVariableGroup(GROUP_Colocated_Variants);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Add allele frequency from continental populations (AFR,AMR,EAS,EUR,SAS) of 1000 Genomes Phase 3");
        optionaVar.setHelpMsg("Add allele frequency from continental populations (AFR,AMR,EAS,EUR,SAS) of 1000 Genomes Phase 3 to the output. Supercedes --maf_1kg. Output fields [AFR_AF, AMR_AF, EAS_AF, EUR_AF, SAS_AF]");
        optionaVar.setCommandParamater("--af_1kg");
        optionaVar.setVariableGroup(GROUP_Colocated_Variants);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Include allele frequency from NHLBI-ESP populations.");
        optionaVar.setHelpMsg("Include allele frequency from NHLBI-ESP populations. Supercedes --maf_esp. Output fields [AA_AF, EA_AF]");
        optionaVar.setCommandParamater("--af_esp");
        optionaVar.setVariableGroup(GROUP_Colocated_Variants);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Include allele frequency from Genome Aggregation Database (gnomAD)");
        optionaVar.setHelpMsg("Include allele frequency from Genome Aggregation Database (gnomAD) exome populations. Note only data from the gnomAD exomes are included; to retrieve data from the additional genomes data set.Output fields [gnomAD_AF, gnomAD_AFR_AF, gnomAD_AMR_AF, gnomAD_ASJ_AF, gnomAD_EAS_AF, gnomAD_FIN_AF, gnomAD_NFE_AF, gnomAD_OTH_AF, gnomAD_SAS_AF]");
        optionaVar.setCommandParamater("--af_gnomad");
        optionaVar.setVariableGroup(GROUP_Colocated_Variants);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Report Pubmed IDs for publications that cite existing variant");
        optionaVar.setHelpMsg("Report Pubmed IDs for publications that cite existing variant. Output fields [PUBMED]");
        optionaVar.setCommandParamater("--pubmed");
        optionaVar.setVariableGroup(GROUP_Colocated_Variants);
        jobDesc.addVariable(optionaVar);
        SelectionListVariableDescriptor selectionListOptionaVar = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        selectionListOptionaVar.setVariableName("Exclude/Inlcude Variants that have been flagged as failed");
        selectionListOptionaVar.setHelpMsg("When checking for co-located variants, by default the script will exclude variants that have been flagged as failed. Default: Exclude");
        selectionListOptionaVar.addOptionValue("Exclude", "0", "Exclude failed co-located variants");
        selectionListOptionaVar.addOptionValue("Include", "1", "Include failed co-located variants");
        selectionListOptionaVar.setCommandParamater("--failed");
        selectionListOptionaVar.setVariableGroup(GROUP_Colocated_Variants);
        jobDesc.addVariable((VariableDescriptor)selectionListOptionaVar);
    }

    private void createIdentifiersGroup(JobDescriptor jobDesc) {
        VariableDescriptor optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Add HGVS nomenclature based on Ensembl stable identifiers to the output");
        optionaVar.setVariableGroup(GROUP_IDN);
        optionaVar.setCommandParamater("--hgvs");
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Add genomic HGVS nomenclature based on the input chromosome name");
        optionaVar.setVariableGroup(GROUP_IDN);
        optionaVar.setCommandParamater("--hgvsg");
        jobDesc.addVariable(optionaVar);
        SelectionListVariableDescriptor selectionListOptionaVar = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        selectionListOptionaVar.setVariableName("Enable or disable 3' shifting of HGVS notations.");
        selectionListOptionaVar.setHelpMsg("Enable or disable 3' shifting of HGVS notations. When enabled, this causes ambiguous insertions or deletions (typically in repetetive sequence tracts) to be \"shifted\" to their most 3' possible coordinates (relative to the transcript sequence and strand) before the HGVS notations are calculated; the flag HGVS_OFFSET is set to the number of bases by which the variant has shifted, relative to the input genomic coordinates. Disabling retains the original input coordinates of the variant. Default shift");
        selectionListOptionaVar.addOptionValue("shift", "1", "Enable shift");
        selectionListOptionaVar.addOptionValue("Do not shift", "0", "Disable shift");
        selectionListOptionaVar.setVariableGroup(GROUP_IDN);
        selectionListOptionaVar.setCommandParamater("--shift_hgvs");
        jobDesc.addVariable((VariableDescriptor)selectionListOptionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Add version numbers to Ensembl transcript identifiers");
        optionaVar.setVariableGroup(GROUP_IDN);
        optionaVar.setCommandParamater("--transcript_version");
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Add the Ensembl protein identifier to the output where appropriate");
        optionaVar.setHelpMsg("Add the Ensembl protein identifier to the output where appropriate. Output fields [ENSP]");
        optionaVar.setVariableGroup(GROUP_IDN);
        optionaVar.setCommandParamater("--protein");
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Adds the gene symbol");
        optionaVar.setHelpMsg("Adds the gene symbol (e.g. HGNC) (where available) to the output. Output fields [SYMBOL, SYMBOL_SOURCE, HGNC_ID]");
        optionaVar.setVariableGroup(GROUP_IDN);
        optionaVar.setCommandParamater("--symbol");
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Adds the CCDS transcript identifer");
        optionaVar.setHelpMsg("Adds the CCDS transcript identifer (where available) to the output. Output fields [CCDS]");
        optionaVar.setVariableGroup(GROUP_IDN);
        optionaVar.setCommandParamater("--ccds");
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Adds best match accessions for translated protein products from UniProt");
        optionaVar.setHelpMsg("Adds best match accessions for translated protein products from three UniProt-related databases (SWISSPROT, TREMBL and UniParc) to the output. Output fields [SWISSPROT, TREMBL, UNIPARC]");
        optionaVar.setVariableGroup(GROUP_IDN);
        optionaVar.setCommandParamater("--uniprot");
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Adds the transcript support level for this transcript to the output.");
        optionaVar.setHelpMsg("Adds the transcript support level for this transcript to the output. Note : not available for GRCh37. Output fields [TSL].");
        optionaVar.setCommandParamater("--tsl");
        optionaVar.setVariableGroup(GROUP_IDN);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Adds the APPRIS isoform annotation for this transcript to the output.");
        optionaVar.setHelpMsg("Adds the APPRIS isoform annotation for this transcript to the output. Output fields [APPRIS]");
        optionaVar.setCommandParamater("--appris");
        optionaVar.setVariableGroup(GROUP_IDN);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Adds a flag indicating if the transcript is the canonical transcript for the gene");
        optionaVar.setHelpMsg("Adds a flag indicating if the transcript is the canonical transcript for the gene. Output fields [CANONICAL]");
        optionaVar.setCommandParamater("--canonical");
        optionaVar.setVariableGroup(GROUP_IDN);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Adds the biotype of the transcript or regulatory feature");
        optionaVar.setHelpMsg("Adds the biotype of the transcript or regulatory feature. Output fields [BIOTYPE]");
        optionaVar.setCommandParamater("--biotype");
        optionaVar.setVariableGroup(GROUP_IDN);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Output aligned RefSeq mRNA identifier for transcript");
        optionaVar.setHelpMsg("Output aligned RefSeq mRNA identifier for transcript. Note that theRefSeq and Ensembl transcripts aligned in this way MAY NOT, AND FREQUENTLY WILL NOT, match exactly in sequence, exon structure and protein product. Output fields [RefSeq]");
        optionaVar.setCommandParamater("--xref_refseq");
        optionaVar.setVariableGroup(GROUP_IDN);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Load a file of chromosome synonyms");
        optionaVar.setHelpMsg("Load a file of chromosome synonyms. File should be tab-delimited with the primary identifier in column 1 and the synonym in column 2. Synonyms are used bi-directionally so columns may be switched. Synoyms allow different chromosome identifiers to be used in the input file and any annotation source (cache, database, GFF, custom file, FASTA file).");
        optionaVar.setCommandParamater("--synonyms");
        optionaVar.setVariableGroup(GROUP_IDN);
        jobDesc.addVariable(optionaVar);
    }

    private void createOutputOptions(JobDescriptor jobDesc) {
        VariableDescriptor optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Output the Sequence Ontology variant class");
        optionaVar.setHelpMsg("Output the Sequence Ontology variant class. Output fields [VARIANT_CLASS] ");
        optionaVar.setCommandParamater("--variant_class");
        optionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable(optionaVar);
        SelectionListVariableDescriptor selectionListOptionaVar = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        selectionListOptionaVar.setVariableName("SIFT prediction");
        selectionListOptionaVar.setHelpMsg("Species limited SIFT predicts whether an amino acid substitution affects protein function based on sequence homology and the physical properties of amino acids. Output fields [SIFT]");
        selectionListOptionaVar.setCommandParamater("--sift");
        selectionListOptionaVar.addOptionValue("Prediction Term", "p", "Prediction Term");
        selectionListOptionaVar.addOptionValue("Prediction Score", "s", "Prediction Score");
        selectionListOptionaVar.addOptionValue("Both", "b", "Prediction Term and Score");
        selectionListOptionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable((VariableDescriptor)selectionListOptionaVar);
        selectionListOptionaVar = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        selectionListOptionaVar.setVariableName("PolyPhen prediction [Human only]");
        selectionListOptionaVar.setHelpMsg("[Human only] PolyPhen is a tool which predicts possible impact of an amino acid substitution on the structure and function of a human protein using straightforward physical and comparative considerations. VEP uses the humVar score by default - use --humdiv to retrieve the humDiv score. Output fields [PolyPhen]");
        selectionListOptionaVar.addOptionValue("Prediction Term", "p", "Prediction Term");
        selectionListOptionaVar.addOptionValue("Prediction Score", "s", "Prediction Score");
        selectionListOptionaVar.addOptionValue("Both", "b", "Prediction Term and Score");
        selectionListOptionaVar.setCommandParamater("--polyphen");
        selectionListOptionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable((VariableDescriptor)selectionListOptionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Retrieve the humDiv PolyPhen prediction instead humVar [Human only]");
        optionaVar.setHelpMsg("Human only Retrieve the humDiv PolyPhen prediction instead of the default humVar. Output fields [PolyPhen]");
        optionaVar.setCommandParamater("--humdiv");
        optionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable(optionaVar);
        selectionListOptionaVar = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        selectionListOptionaVar.setVariableName("Feature tag to Retrieve with the nearest protein-coding transcription start site (TSS) to each input variant.");
        selectionListOptionaVar.setHelpMsg("Retrieve the transcript or gene with the nearest protein-coding transcription start site (TSS) to each input variant. Note that the nearest TSS may not belong to a transcript that overlaps the input variant, and more than one may be reported in the case where two are equidistant from the input coordinates.");
        selectionListOptionaVar.addOptionValue("Transcript", "transcript", "Use Transcript to retrieve the transcript stable ID");
        selectionListOptionaVar.addOptionValue("Gene", "gene", "Use Gene to retrieve the gene stable ID");
        selectionListOptionaVar.addOptionValue("Symbol", "symbol", "Use Symbol to retrieve the gene symbol.");
        selectionListOptionaVar.setCommandParamater("--nearest");
        selectionListOptionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable((VariableDescriptor)selectionListOptionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Distance up and/or downstream between a variant and a transcript");
        optionaVar.setHelpMsg("Modify the distance up and/or downstream between a variant and a transcript for which VEP will assign the upstream_gene_variant or downstream_gene_variant consequences. Giving one distance will modify both up- and downstream distances; prodiving two separated by commas will set the up- (5') and down- (3') stream distances respectively. Default 5000");
        optionaVar.setCommandParamater("--distance");
        optionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Indicates if the overlapped gene is associated with a phenotype, disease or trait.");
        optionaVar.setHelpMsg("Indicates if the overlapped gene is associated with a phenotype, disease or trait. Output fields [GENE_PHENO]");
        optionaVar.setCommandParamater("--gene_phenotype");
        optionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Look for overlaps with regulatory regions");
        optionaVar.setHelpMsg("Look for overlaps with regulatory regions. The script can also call if a variant falls in a high information position within a transcription factor binding site. Output lines have a Feature type of RegulatoryFeature or MotifFeature. Output fields [MOTIF_NAME, MOTIF_POS, HIGH_INF_POS, MOTIF_SCORE_CHANGE]");
        optionaVar.setCommandParamater("--regulatory");
        optionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.MultiSelectionList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Report only regulatory regions that are found in the given cell type(s)");
        optionaVar.setHelpMsg("Report only regulatory regions that are found in the given cell type(s). The functional type in each cell type is reported under CELL_TYPE in the output. Output fields [CELL_TYPE]");
        optionaVar.setCommandParamater("--cell_type");
        this.loadSupportedCellTypes((SelectionListVariableDescriptor)((MultiSelectionListVariableDescriptor)optionaVar));
        optionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Consider only alternate alleles present in the genotypes of the specified individual(s)");
        optionaVar.setHelpMsg("Consider only alternate alleles present in the genotypes of the specified individual(s). May be a single individual, a comma-separated list or \"all\" to assess all individuals separately. Individual variant combinations homozygous for the given reference allele will not be reported. Each individual and variant combination is given on a separate line of output. Only works with VCF files containing individual genotype data; individual IDs are taken from column headers. Output fields [IND, ZYG]");
        optionaVar.setCommandParamater("--individual");
        optionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Force VCF genotypes to be interpreted as phased");
        optionaVar.setHelpMsg("Force VCF genotypes to be interpreted as phased. For use with plugins that depend on phased data.");
        optionaVar.setCommandParamater("--phased");
        optionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Identify allele number from VCF input");
        optionaVar.setHelpMsg("Identify allele number from VCF input, where 1 = first ALT allele, 2 = second ALT allele etc. Useful when using --minimal. Output fields [ALLELE_NUM]");
        optionaVar.setCommandParamater("--allele_number");
        optionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Give cDNA, CDS and protein positions as Position/Length");
        optionaVar.setCommandParamater("--total_length");
        optionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Adds affected exon and intron numbering to to output");
        optionaVar.setHelpMsg("Adds affected exon and intron numbering to to output. Format is Number/Total. Output fields [EXON, INTRON]");
        optionaVar.setCommandParamater("--numbers");
        optionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Adds names of overlapping protein domains to output");
        optionaVar.setHelpMsg("Adds names of overlapping protein domains to output. Output fields [DOMAINS] ");
        optionaVar.setCommandParamater("--domains");
        optionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Don't URI escape HGVS strings.");
        optionaVar.setHelpMsg("Don't URI escape HGVS strings. Default escape");
        optionaVar.setCommandParamater("--no_escape");
        optionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Don't overwrite existing CSQ entry in VCF INFO field");
        optionaVar.setHelpMsg("Don't overwrite existing CSQ entry in VCF INFO field. Default Overwrites");
        optionaVar.setCommandParamater("--keep_csq");
        optionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Change the name of the INFO key that VEP write the consequences to in its VCF output.");
        optionaVar.setHelpMsg("Change the name of the INFO key that VEP write the consequences to in its VCF output [CSQ|ANN|(other)]. Use \"ANN\" for compatibility with other tools such as snpEff. Default CSQ ");
        optionaVar.setCommandParamater("--vcf_info_field");
        optionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable(optionaVar);
        selectionListOptionaVar = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        selectionListOptionaVar.setVariableName("Consequence Terms Type");
        selectionListOptionaVar.setHelpMsg("The type of consequence terms to output. Default SO");
        selectionListOptionaVar.setCommandParamater("-t");
        selectionListOptionaVar.setCommandParamaterAlt("--terms");
        selectionListOptionaVar.addOptionValue("Ensmble Terms", "ensembl", "Ensmble Terms");
        selectionListOptionaVar.addOptionValue("SO Terms", "so", " Sequence Ontology Terms");
        selectionListOptionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable((VariableDescriptor)selectionListOptionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Don't write header lines in output files.");
        optionaVar.setCommandParamater("--no_headers");
        optionaVar.setVariableGroup(GROUP_OUTFEILDS);
        jobDesc.addVariable(optionaVar);
    }

    private void createDataFormatGroup(JobDescriptor jobDesc) {
        VariableDescriptor optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.SelectionList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Output Compresssion Type");
        optionaVar.setHelpMsg("Writes output compressed using either gzip or bgzip. Default no Compresssion");
        optionaVar.setCommandParamater("--compress_output");
        optionaVar.setVariableGroup(GROUP_Format);
        jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Convert alleles to their most minimal representation before consequence calculation");
        optionaVar.setHelpMsg("Convert alleles to their most minimal representation before consequence calculation i.e. sequence that is identical between each pair of reference and alternate alleles is trimmed off from both ends, with coordinates adjusted accordingly. Note this may lead to discrepancies between input coordinates and coordinates reported by VEP relative to transcript sequences; to avoid issues, use --allele_number and/or ensure that your input variants have unique identifiers. The MINIMISED flag is set in the VEP output where relevant.");
        optionaVar.setCommandParamater("--minimal");
        optionaVar.setVariableGroup(GROUP_Format);
        jobDesc.addVariable(optionaVar);
    }

    protected void createRules() {
        new VariablesRule(this.getVariable(INPUT_SPECIES), this.getVariable(INPUT_VERSION), VariablesRule.Condition.Contain, VariablesRule.Action.Enable, "homo_sapiens", true);
        new VariablesRule(this.getVariable(INPUT_SPECIES), this.getVariable(INPUT_ASSEMPLY), VariablesRule.Condition.Contain, VariablesRule.Action.Disable, "homo_sapiens", true);
    }

    private void loadSupportedGenomes(SelectionListVariableDescriptor varInputGenome) {
        List text = this.loadJobResource("veb", "EnsSupportedOrganisms.csv");
        for (String line : text) {
            String[] tokens = line.split("\t");
            String optionValue = tokens[0];
            String[] stringArray = tokens;
            if (tokens.length == 0) continue;
            String token = stringArray[0];
            varInputGenome.addOptionValue(token, optionValue, optionValue + " Species");
        }
    }

    private void loadGenemosAssembly() {
        List text = this.loadJobResource("veb", "OrganismsAssemblies.csv");
        for (String line : text) {
            String[] tokens = line.split("\t");
            String species = tokens[0];
            ArrayList<String> assemblies = new ArrayList<String>();
            int i = 1;
            while (i < tokens.length) {
                String assembly = tokens[i].trim();
                assemblies.add(assembly);
                ++i;
            }
            this.assemplyMap.put(species, assemblies);
        }
    }

    private void loadSupportedCellTypes(SelectionListVariableDescriptor varInputList) {
        List text = this.loadJobResource("veb", "cellTypes.csv");
        for (String cellType : text) {
            String token = cellType.replace("_", " ");
            String optionValue = cellType;
            varInputList.addOptionValue(token, optionValue, token + " Cell Type");
        }
    }

    public boolean notifyVarValueChanged(String varKey, String value) {
        if (varKey.equals(INPUT_SPECIES)) {
            ListJobVariable varAssembly = (ListJobVariable)this.getVariable(INPUT_ASSEMPLY);
            varAssembly.setValue("");
            ArrayList<String> assemblies = this.assemplyMap.get(value);
            this.varInputAssemply.clearOptionValues();
            if (assemblies != null && assemblies.size() > 0) {
                this.varInputAssemply.setDefaultIndexValue(0);
                this.varInputAssemply.isRequired = true;
                this.varInputAssemply.setGUIVisible(true);
                for (String assembly : assemblies) {
                    this.varInputAssemply.addOptionValue(assembly, assembly, "Assembly for " + value);
                }
                varAssembly.setValue(assemblies.get(0));
            } else {
                this.varInputAssemply.isRequired = false;
                this.varInputAssemply.setGUIVisible(false);
            }
            varAssembly.refresh();
        }
        return super.notifyVarValueChanged(varKey, value);
    }

    protected void generateCommand(StringBuilder builder) {
        String vepCmdPrefix = " vep ";
        String vepPrepareCmdPrefix = " db_download_vep ";
        FilesVariable inputVCFFilesVar = (FilesVariable)this.getVariable(INPUT_VCF_FILES);
        FilesVariable outFilesVar = (FilesVariable)this.getVariable(OUTPUT_VARIANTS_VCF);
        builder.append(String.valueOf(BashHelper.If((String)BashConditions.notEmptyStr((JobVariable)this.getVariable(INPUT_ASSEMPLY))).Then(AnnotationVEPJob.st((String)BashHelper.assign((String)"assemblyOption", (String)("--assembly " + this.getVariable(INPUT_ASSEMPLY).$()))))) + BashHelper.command_withTrack((String)this.getVariable(INPUT_SPECIES).$(), (String)(vepPrepareCmdPrefix + "$assemblyOption --species  " + this.getVariable(INPUT_SPECIES).$()), (String)"Check VEP database"));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputVCFFilesVar, (String)AnnotationVEPJob.st((String)BashHelper.arrayAdd((JobVariable)outFilesVar, (String)"${outputFolder}/${inputFileBaseName}.txt")), (String)(BashHelper.If((String)BashConditions.True((JobVariable)this.getVariable(INPUT_VERSION))).Then(AnnotationVEPJob.st((String)BashHelper.assign((String)"assemblyOption", (String)"--assembly GRCh37 --port 3337"))).toString() + String.valueOf(BashHelper.If((String)BashConditions.notEmptyStr((JobVariable)this.getVariable(INPUT_ASSEMPLY))).Then(AnnotationVEPJob.st((String)BashHelper.assign((String)"assemblyOption", (String)("--assembly " + this.getVariable(INPUT_ASSEMPLY).$()))))) + vepCmdPrefix + this.getOptionParamatersStrAs$() + " $assemblyOption --tab  --cache --dir_cache /home/gpro/ensembl/vep_data  -i ${_inputFile}   --stats_file ${outputFolder}/${inputFileBaseName}_summary.html    -O " + outFilesVar.$("${_i}")), (String)"VEP"));
    }
}

