/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs;

import com.biotechvana.utils.Constants;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.descriptors.JobLink;
import com.biotechvana.workflow.descriptors.Publication;
import com.biotechvana.workflow.descriptors.VariableDescriptor;

public class VarScanHelper {
    public static String getVarscanCmdPrefix() {
        return "java -jar " + Constants.PIPELINE_BASE_PATH + "VarScan2 ";
    }

    public static VariableDescriptor createReferenceVar() {
        VariableDescriptor varReferenceFasta = VariableDescriptor.createDescriptorFor((String)VariantAnaylsisVariableBag.INPUT_REF_FASTA, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReferenceFasta.isRequired = true;
        varReferenceFasta.setVariableName("Input Reference fasta file");
        varReferenceFasta.setShortHelpMsg("Drag an Reference fasta file");
        varReferenceFasta.setHelpMsg("Reference fasta file.");
        varReferenceFasta.setCommandParamater("-f");
        varReferenceFasta.setSubProgName("Mpileup");
        return varReferenceFasta;
    }

    public static VariableDescriptor createInputBamFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)VariantAnaylsisVariableBag.INPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input Bam Files");
        varReadInputFile.setHelpMsg("Input Bam Files");
        varReadInputFile.addAcceptedFileFormat("BAM");
        return varReadInputFile;
    }

    public static VariableDescriptor createMpileupFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"MPILEUP_FILES", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("mpileup Files");
        varReadInputFile.setHelpMsg("mpileup Files.");
        varReadInputFile.addAcceptedFileFormat("MPILEUP");
        return varReadInputFile;
    }

    public static VariableDescriptor createOutputVCFFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"OUTPUT_VARIANTS_VCF", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("VCF Files");
        varReadInputFile.setHelpMsg("VCF Files.");
        varReadInputFile.addAcceptedFileFormat("VCF");
        return varReadInputFile;
    }

    public static VariableDescriptor createOutputSNPVCFFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"OUTPUT_SNP_VCF", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("SNP VCF Files");
        varReadInputFile.setHelpMsg("SNP VCF Files.");
        varReadInputFile.addAcceptedFileFormat("VCF");
        return varReadInputFile;
    }

    public static VariableDescriptor createOutputIndelVCFFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"OUTPUT_INDEL_VCF", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("INDEL VCF Files");
        varReadInputFile.setHelpMsg("INDEL VCF Files.");
        varReadInputFile.addAcceptedFileFormat("VCF");
        return varReadInputFile;
    }

    public static VariableDescriptor createInputTumorMpileupFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"TUMOR_MPILEUP", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Tumor mpileup Files");
        varReadInputFile.setHelpMsg("Tumor mpileup Files.");
        varReadInputFile.addAcceptedFileFormat("MPILEUP");
        return varReadInputFile;
    }

    public static VariableDescriptor createInputNormalMpileupFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"NORMAL_MPILEUP", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Normal mpileup Files");
        varReadInputFile.setHelpMsg("Normal mpileup Files.");
        varReadInputFile.addAcceptedFileFormat("MPILEUP");
        return varReadInputFile;
    }

    public static VariableDescriptor createInputTumorBamFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"TUMOR_BAM", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input Tumor Bam Files");
        varReadInputFile.setHelpMsg("Input Tumor Bam Files.");
        varReadInputFile.addAcceptedFileFormat("BAM");
        return varReadInputFile;
    }

    public static VariableDescriptor createInputNormalBamFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"NORMAL_BAM", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input Normal Bam Files");
        varReadInputFile.setHelpMsg("Input Normal Bam Files.");
        varReadInputFile.addAcceptedFileFormat("BAM");
        return varReadInputFile;
    }

    public static VariableDescriptor createFatherBamFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"FATHER_BAM", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input Father Bam Files");
        varReadInputFile.setHelpMsg("Input Father Bam Files.");
        varReadInputFile.addAcceptedFileFormat("BAM");
        return varReadInputFile;
    }

    public static VariableDescriptor createMotherBamFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"MOTHER_BAM", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input Mother Bam Files");
        varReadInputFile.setHelpMsg("Input Mother Bam Files.");
        varReadInputFile.addAcceptedFileFormat("BAM");
        return varReadInputFile;
    }

    public static VariableDescriptor createChildBamFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)"CHILD_BAM", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input Child Bam Files");
        varReadInputFile.setHelpMsg("Input Child Bam Files.");
        varReadInputFile.addAcceptedFileFormat("BAM");
        return varReadInputFile;
    }

    public static Publication getCitation() {
        return new Publication().setAuthors("Koboldt, D.C., Zhang, Q., Larson, D.E., Shen, D., McLellan, M.D., Lin, L., Miller, C.A., Mardis, E.R., Ding, L. and Wilson, R.K.").setTitle("VarScan 2: Somatic mutation and copy number alteration discovery in cancer by exome sequencing").setJournal("Genome research").setVolume(22).setIssue(3).setYear(2012).setPages("568-576").setDOI("10.1101/gr.129684.111").setPubmed("22300766");
    }

    public static JobLink getManualLink(String toolName) {
        return new JobLink().setTitle("VarScan2").setUrl("http://varscan.sourceforge.net/using-varscan.html").setType(JobLink.LinkType.Manual);
    }
}

