/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.variables;

import com.biotechvana.pipelinestools.utils.PipelineUtils;
import com.biotechvana.utils.StringUtils;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.variables.JobVariable;

public class FileVariable
extends JobVariable {
    public static String IS_PAIRED_TITLE = "Pair End Files";
    VariableDescriptor.FileFormatInfo currentFileFormat;
    String actualFileFormat = "";

    public FileVariable(WorkflowJob containerJob, VariableDescriptor varDesc) {
        super(containerJob, varDesc);
        this.setFileFormat(this.desc.getDefaultFileFormat());
    }

    public void setFileFormat(String fileFormat) {
        this.actualFileFormat = fileFormat;
        VariableDescriptor.FileFormatInfo selectedFileFormat = this.getAcceptedFileFormatInfo(this.actualFileFormat);
        this.currentFileFormat = selectedFileFormat.createCopy();
        if (this.hasMappedVars()) {
            for (JobVariable v : this.linkedVars) {
                ((FileVariable)v).setFileFormat(fileFormat);
            }
        }
        this.notifyValueChanged();
    }

    public String getFileFormat() {
        return this.actualFileFormat;
    }

    public VariableDescriptor.FileFormatInfo getFileFormatInfo() {
        return this.currentFileFormat;
    }

    protected VariableDescriptor.FileFormatInfo getAcceptedFileFormatInfo(String fileFormat) {
        return this.desc.getAcceptedFileFormatInfo(fileFormat);
    }

    public void setIsPairedFiles(boolean b) {
        this.currentFileFormat.isPaired = b;
        this.containerJob.notifyVarValueChanged(this.getKey(), this.value);
        if (this.hasMappedVars()) {
            for (JobVariable v : this.linkedVars) {
                ((FileVariable)v).setIsPairedFiles(b);
            }
        }
        this.notifyValueChanged();
    }

    public void setShowPairingOptions(boolean b) {
        this.currentFileFormat.showPairingOptions = b;
        if (!b) {
            this.currentFileFormat.isPaired = b;
        }
        if (this.hasMappedVars()) {
            for (JobVariable v : this.linkedVars) {
                ((FileVariable)v).setIsPairedFiles(b);
            }
        }
        this.notifyValueChanged();
        this.containerJob.notifyLayoutchanged();
    }

    public boolean getIsPairedFiles() {
        return this.currentFileFormat.isPaired;
    }

    public boolean getShowPairingOptions() {
        return this.currentFileFormat.showPairingOptions;
    }

    public String getFileFormatAsBashVar() {
        String str = "\n#     " + this.desc.getVariableName() + "  FileFormat in " + this.containerJob.getFriendlyName() + " \n";
        if (this.hasMapping()) {
            str = str + "# (" + this.containerJob.getJobID() + "_" + this.desc.getKey() + ") is mapped to " + this.mappedToVar.desc.getVariableName() + " in " + this.mappedToVar.getJob().getFriendlyName() + "\n";
            return str;
        }
        String varName = this.getBashVarName();
        if (this.desc.getVarType() != VariableDescriptor.VariableType.Files) {
            this.desc.getVarType();
        }
        if (this.desc.getVarType() == VariableDescriptor.VariableType.FileList) {
            str = str + this.getFormatAsBashVarNameOnly() + "=\"" + this.getFileFormat() + "\"\n";
            return str;
        }
        this.desc.getVarType();
        if (this.desc.getVarType() != VariableDescriptor.VariableType.File) {
            this.desc.getVarType();
        }
        this.desc.getVarType();
        return "";
    }

    public String getFileFormatAsBashVar(JobVariable var) {
        String str = "\n#     " + this.desc.getVariableName() + "  Properties in " + this.containerJob.getFriendlyName() + " \n";
        if (this.hasMapping()) {
            str = str + "# (" + this.containerJob.getJobID() + "_" + this.desc.getKey() + ") is mapped to " + this.mappedToVar.desc.getVariableName() + " in " + this.mappedToVar.getJob().getFriendlyName() + "\n";
            return str;
        }
        if (this.desc.getVarType() != VariableDescriptor.VariableType.Files) {
            this.desc.getVarType();
        }
        if (this.desc.getVarType() == VariableDescriptor.VariableType.FileList) {
            str = str + this.getFormatAsBashVarNameOnly() + "=\"" + ((FileVariable)var).getFormatAsBashVarName() + "\"\n";
            return str;
        }
        this.desc.getVarType();
        if (this.desc.getVarType() != VariableDescriptor.VariableType.File) {
            this.desc.getVarType();
        }
        this.desc.getVarType();
        return "";
    }

    public String getCountAsBashVarName() {
        if (this.hasMapping()) {
            return ((FileVariable)this.mappedToVar).getCountAsBashVarName();
        }
        return "${#" + this.getBashVarName("@") + "}";
    }

    public String getFormatAsBashVarName() {
        if (this.hasMapping()) {
            return ((FileVariable)this.mappedToVar).getFormatAsBashVarName();
        }
        String str = "${" + this.containerJob.getJobID() + "_" + this.desc.getKey() + "_format}";
        return str;
    }

    public String[] getPairedFileListsAsStrings() {
        String[] files;
        String[] pairedLists = new String[]{"", ""};
        String[] stringArray = files = this.getValue().split("\n");
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.isEmpty()) {
                String[] pairedFiles = line.split(",");
                if (pairedFiles.length == 2) {
                    if (!pairedFiles[0].isEmpty()) {
                        pairedLists[0] = String.valueOf(pairedLists[0]) + pairedFiles[0] + "\n";
                    }
                    if (!pairedFiles[1].isEmpty()) {
                        pairedLists[1] = String.valueOf(pairedLists[1]) + pairedFiles[1] + "\n";
                    }
                } else if (line.startsWith(",")) {
                    pairedLists[1] = String.valueOf(pairedLists[1]) + pairedFiles[0] + "\n";
                } else {
                    pairedLists[0] = String.valueOf(pairedLists[0]) + pairedFiles[0] + "\n";
                }
            }
            ++n2;
        }
        return pairedLists;
    }

    public String[] getFilesList() {
        if (StringUtils.isEmpty((String)this.value)) {
            return new String[0];
        }
        String[] files = this.getValue().split("\n");
        return files;
    }

    @Override
    public void onValidate() {
        String[] twoList;
        if (this.getIsPairedFiles() && FileVariable.numberOfLines((twoList = this.getPairedFileListsAsStrings())[0]) != FileVariable.numberOfLines(twoList[1])) {
            this._isValid = false;
            this.errorMsg = this.desc.getVariableName() + " Number of files does not match.";
        }
        super.onValidate();
    }

    @Override
    public String getBashVarDecleration_oldVersion() {
        String str = "\n#     " + this.desc.getVariableName() + "  Value in " + this.containerJob.getFriendlyName() + " \n";
        if (this.hasMapping()) {
            str = str + "# (" + this.containerJob.getJobID() + "_" + this.desc.getKey() + ") is mapped to " + this.mappedToVar.desc.getVariableName() + " in " + this.mappedToVar.getJob().getFriendlyName() + "\n";
            return str;
        }
        if (this.getValue().isEmpty() && this.getCMDParamaterValue().isEmpty() && this.desc.getVarRole() == VariableDescriptor.VariableRole.Option) {
            return "";
        }
        String varName = this.getBashVarName();
        if (this.desc.getVarType() == VariableDescriptor.VariableType.Files || this.desc.getVarType() == VariableDescriptor.VariableType.Folders) {
            String[] lines = this.value.split("\n");
            int counter = 0;
            str = str + "# which is an array of Files/Folders \n";
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!line.isEmpty()) {
                    str = str + varName + "[" + counter + "]=\"" + PipelineUtils.sanitizeFilePathWithTelda(this.containerJob.getWorkflowManager().getUserManager().getHostPathManager().getUserHomePath(), line, this.containerJob.getWorkflowManager().getUserManager().getIsChRooted()) + "\" \n";
                    ++counter;
                }
                ++n2;
            }
            str = str + "# ******* " + this.desc.getVariableName() + " *******\n\n";
            return str;
        }
        if (this.desc.getVarType() == VariableDescriptor.VariableType.FileList) {
            String[] lines = this.value.split("\n");
            int counter = 0;
            str = str + "# which is an array of Files/Folders \n";
            str = str + "declare -A " + this.getBashVarName() + " \n";
            String[] stringArray = lines;
            int n = lines.length;
            int n3 = 0;
            while (n3 < n) {
                String line = stringArray[n3];
                if (!line.isEmpty()) {
                    String[] pairedFiles = line.split(",");
                    if (pairedFiles.length > 0) {
                        str = str + varName + "[0," + counter + "]=\"" + PipelineUtils.sanitizeFilePathWithTelda(this.containerJob.getWorkflowManager().getUserManager().getHostPathManager().getUserHomePath(), pairedFiles[0], this.containerJob.getWorkflowManager().getUserManager().getIsChRooted()) + "\" \n";
                    }
                    if (pairedFiles.length > 1) {
                        str = str + varName + "[1," + counter + "]=\"" + PipelineUtils.sanitizeFilePathWithTelda(this.containerJob.getWorkflowManager().getUserManager().getHostPathManager().getUserHomePath(), pairedFiles[1], this.containerJob.getWorkflowManager().getUserManager().getIsChRooted()) + "\" \n";
                    }
                    ++counter;
                }
                ++n3;
            }
            str = str + this.getFormatAsBashVarNameOnly() + "=\"" + this.getFileFormat() + "\"\n";
            str = str + "# ******* " + this.desc.getVariableName() + " *******\n\n";
            return str;
        }
        if (this.desc.getVarType() == VariableDescriptor.VariableType.File || this.desc.getVarType() == VariableDescriptor.VariableType.Folder) {
            Object path = "";
            path = this.parentVar != null ? this.parentVar.$() + "/" + this.value : (this.value.isEmpty() ? "" : PipelineUtils.sanitizeFilePathWithTelda(this.containerJob.getWorkflowManager().getUserManager().getHostPathManager().getUserHomePath(), this.value, this.containerJob.getWorkflowManager().getUserManager().getIsChRooted()));
            str = str + varName + "=\"" + (String)path + "\" \n\n";
            return str;
        }
        return "";
    }

    @Override
    protected String onGetBashVarDecleration() {
        String varName = this.getBashVarName();
        Object str = "";
        if (this.desc.getVarType() == VariableDescriptor.VariableType.File || this.desc.getVarType() == VariableDescriptor.VariableType.Folder) {
            Object path = "";
            path = this.parentVar != null ? this.parentVar.$() + "/" + this.value : (this.value.isEmpty() ? "" : PipelineUtils.sanitizeFilePathWithTelda(this.containerJob.getWorkflowManager().getUserManager().getHostPathManager().getUserHomePath(), this.value, this.containerJob.getWorkflowManager().getUserManager().getIsChRooted()));
            str = (String)str + varName + "=\"" + (String)path + "\" \n\n";
            return str;
        }
        return "";
    }

    public String getFormatAsBashVarNameOnly() {
        if (this.hasMapping()) {
            return ((FileVariable)this.mappedToVar).getFormatAsBashVarNameOnly();
        }
        String str = this.containerJob.getJobID() + "_" + this.desc.getKey() + "_format";
        return str;
    }

    @Override
    public String get_cmdValue() {
        if (this.desc.getVarType() == VariableDescriptor.VariableType.File) {
            return this.$();
        }
        return "";
    }
}

