/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.tracking.tasks;

import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.biotechvana.workflow.tracking.ITrackerInfo;
import com.biotechvana.workflow.tracking.TrackInfo;
import com.biotechvana.workflow.tracking.events.InfoTrackEvent;
import com.biotechvana.workflow.tracking.events.ProcessingFinishedTrackEvent;
import com.biotechvana.workflow.tracking.events.ProcessingTrackEvent;
import com.biotechvana.workflow.tracking.events.SubProcessTrackEvent;
import com.biotechvana.workflow.tracking.events.VarInfoTrackEvent;
import com.biotechvana.workflow.tracking.tasks.CMDTaskTracker;
import com.biotechvana.workflow.tracking.tasks.TaskTracker;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WorkflowJobTracker
extends TaskTracker {
    HashMap<String, VariableIndex> fileVarIndex = new HashMap();
    WorkflowJob workflowjob;
    ArrayList<InfoTrackEvent> inputsInfo = new ArrayList();
    LinkedHashMap<String, CMDTaskTracker> cmdTasks = new LinkedHashMap();
    private TrackInfo trackInfo;
    private EventsGroup eventsGroup;
    SubmissionHistoryEntry entry;
    TaskTracker parentTracker;
    List<ITrackerInfo> entries = new ArrayList<ITrackerInfo>();
    private int N_UNNAMED_TASKS = 1;

    public WorkflowJobTracker(WorkflowJob workflowjob, SubmissionHistoryEntry entry) {
        super(entry);
        this.workflowjob = workflowjob;
    }

    @Override
    protected void init(SubmissionHistoryEntry entry) {
        this.entry = entry;
        this.trackInfo = entry.getTrackInfo();
        this.eventsGroup = new EventsGroup(this.trackInfo.getPID());
        this.entries.addAll(entry.getTrackInfo().getTrackerInfoEntries());
        int j = 0;
        while (j < this.entries.size()) {
            Object taskId;
            VarInfoTrackEvent infoEvent;
            ITrackerInfo o = this.entries.get(j);
            if (o instanceof VarInfoTrackEvent && ((infoEvent = (VarInfoTrackEvent)o).getInfoType() == Tracking.TrackInfoType.Input || infoEvent.getInfoType() == Tracking.TrackInfoType.Output)) {
                int i;
                String[] files;
                String varFullKey = infoEvent.getVariableFullKey();
                JobVariable var = this.workflowjob.getVariable(varFullKey);
                if (var.getDescVarType() == VariableDescriptor.VariableType.File || var.getDescVarType() == VariableDescriptor.VariableType.Folder) {
                    String indexValue = var.getValue();
                    this.fileVarIndex.put(indexValue, new VariableIndex(var, 0));
                }
                if (var.getDescVarType() == VariableDescriptor.VariableType.Files || var.getDescVarType() == VariableDescriptor.VariableType.Folders) {
                    files = ((FilesVariable)var).getFilesList();
                    i = 0;
                    while (i < files.length) {
                        this.fileVarIndex.put(files[i], new VariableIndex(var, i));
                        ++i;
                    }
                }
                if (var.getDescVarType() == VariableDescriptor.VariableType.FileList) {
                    files = ((FileListVariable)var).getPairedFileLists();
                    i = 0;
                    while (i < ((String)files[0]).length) {
                        this.fileVarIndex.put(files[0][i], new VariableIndex(var, 0, i));
                        this.fileVarIndex.put(files[1][i], new VariableIndex(var, 1, i));
                        ++i;
                    }
                }
                this.inputsInfo.add(infoEvent);
            }
            if (o instanceof SubProcessTrackEvent && ((taskId = ((SubProcessTrackEvent)o).getTaskId()) == null || ((String)taskId).isBlank()) && this.entries.size() > j + 2 && this.entries.get(j + 1) instanceof ProcessingTrackEvent) {
                ProcessingTrackEvent nextEvent = (ProcessingTrackEvent)this.entries.get(j + 1);
                taskId = nextEvent.getTaskId();
                if (taskId == null || ((String)taskId).isBlank()) {
                    taskId = this.workflowjob.getJobDescID() + "." + this.N_UNNAMED_TASKS;
                    ++this.N_UNNAMED_TASKS;
                }
                ((SubProcessTrackEvent)o).setTaskId((String)taskId);
            }
            this.eventsGroup.add(o);
            ++j;
        }
        if (this.eventsGroup.getVersion().equals(this.eventsGroup.EVENTS_VERSION_1)) {
            this.initV1(this.entries);
        } else {
            this.initV2(this.eventsGroup);
        }
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        for (String keyValue : this.cmdTasks.keySet()) {
            if (this.cmdTasks.get(keyValue).nOfTasks() != 0) continue;
            toBeRemoved.add(keyValue);
        }
        for (String keyValue : toBeRemoved) {
            this.cmdTasks.remove(keyValue);
        }
    }

    private void initV2(EventsGroup eventsGroup) {
        if (eventsGroup.entries.size() == 1) {
            this.initV2((EventsGroup)eventsGroup.entries.get(0));
            return;
        }
        ArrayList<ITrackerInfo> currentPatch = new ArrayList<ITrackerInfo>();
        boolean addingBackground = false;
        for (ITrackerInfo o : eventsGroup.entries) {
            if (addingBackground && !(o instanceof EventsGroup) && currentPatch.size() > 0) {
                addingBackground = false;
                this.initV2(currentPatch);
                currentPatch.clear();
            }
            if ((o instanceof SubProcessTrackEvent || o instanceof EventsGroup) && !addingBackground) {
                this.initV1(currentPatch);
                currentPatch.clear();
                addingBackground = true;
            }
            currentPatch.add(o);
        }
        if (!addingBackground) {
            this.initV1(currentPatch);
        } else {
            this.initV2(currentPatch);
        }
    }

    private void initV2(List<ITrackerInfo> entries) {
        SubProcessTrackEvent subProcessTrackEvent = null;
        int startIndex = 0;
        CMDTaskTracker cmdTaskTracker = null;
        if (entries.size() > 0) {
            if (entries.get(0) instanceof SubProcessTrackEvent) {
                subProcessTrackEvent = (SubProcessTrackEvent)entries.get(0);
                startIndex = 1;
                String taskKey = subProcessTrackEvent.getTaskId();
                String varKey = subProcessTrackEvent.getVariableKey();
                VarInfoTrackEvent infoVar = this.getCorspondingVariableInfo(subProcessTrackEvent, varKey);
                if (!this.cmdTasks.containsKey(taskKey + varKey)) {
                    cmdTaskTracker = new CMDTaskTracker(this);
                    Object newTaskName = taskKey;
                    if (taskKey.isBlank()) {
                        newTaskName = this.workflowjob.getJobDescID() + "." + this.N_UNNAMED_TASKS;
                        ++this.N_UNNAMED_TASKS;
                    }
                    this.cmdTasks.put(taskKey + varKey, cmdTaskTracker);
                    cmdTaskTracker.setTaskName((String)newTaskName);
                }
                cmdTaskTracker = this.cmdTasks.get(taskKey + varKey);
                cmdTaskTracker.addTrackerVariables(varKey);
                cmdTaskTracker.addVarTrackerInfo(infoVar);
            }
            int i = startIndex;
            while (i < entries.size()) {
                ITrackerInfo o = entries.get(i);
                if (o instanceof EventsGroup) {
                    if (cmdTaskTracker == null) {
                        this.initV1(((EventsGroup)o).entries);
                    } else {
                        cmdTaskTracker.addBlockInfo(((EventsGroup)o).entries);
                    }
                }
                ++i;
            }
        }
    }

    private void initV1(List<ITrackerInfo> entries) {
        LinkedHashMap groups = new LinkedHashMap();
        ArrayList<ITrackerInfo> localGroup = null;
        int localGroupIndex = -1;
        ArrayList firstGroup = new ArrayList();
        int firstLocalGroupIndex = -1;
        int lastLocalGroupIndex = -1;
        boolean adding = false;
        boolean addingSubProcess = false;
        boolean addingInBetween = false;
        int i = 0;
        while (i < entries.size()) {
            InfoTrackEvent infoEvent;
            ITrackerInfo o = entries.get(i);
            if (o instanceof ProcessingTrackEvent && !adding) {
                adding = true;
                localGroup = new ArrayList<ITrackerInfo>();
                localGroupIndex = i;
            }
            if (o instanceof SubProcessTrackEvent) {
                if (adding) {
                    groups.put(localGroupIndex, localGroup);
                    localGroup = new ArrayList();
                    localGroupIndex = i;
                    addingSubProcess = true;
                } else {
                    adding = true;
                    addingSubProcess = true;
                    localGroupIndex = i;
                    if (i > 0) {
                        if (entries.get(i - 1) instanceof InfoTrackEvent) {
                            --localGroupIndex;
                            infoEvent = (InfoTrackEvent)entries.get(i - 1);
                            if (infoEvent.getInfoType() == Tracking.TrackInfoType.Input || infoEvent.getInfoType() == Tracking.TrackInfoType.Output) {
                                if (localGroup != null) {
                                    localGroup.remove(infoEvent);
                                }
                                localGroup = new ArrayList();
                                localGroup.add(infoEvent);
                            }
                        }
                    } else {
                        localGroup = new ArrayList();
                    }
                }
            }
            if (o instanceof InfoTrackEvent && ((infoEvent = (InfoTrackEvent)o).getInfoType() == Tracking.TrackInfoType.Input || infoEvent.getInfoType() == Tracking.TrackInfoType.Output) && addingSubProcess) {
                groups.put(localGroupIndex, localGroup);
                localGroup = new ArrayList();
                localGroupIndex = i;
                adding = false;
                addingSubProcess = false;
            }
            if (adding) {
                localGroup.add(o);
                addingInBetween = false;
            } else {
                if (!addingInBetween) {
                    localGroup = new ArrayList();
                    groups.put(i, localGroup);
                    addingInBetween = true;
                }
                localGroup.add(o);
            }
            ++i;
        }
        if (adding) {
            groups.put(localGroupIndex, localGroup);
            adding = false;
        }
        for (ArrayList group : groups.values()) {
            this.createCmdTask(group);
        }
    }

    private void createCmdTask(ArrayList<ITrackerInfo> group) {
        SubProcessTrackEvent subProcessTrackEvent = null;
        int subProcessTrackEventIndx = -1;
        int j = 0;
        while (j < group.size()) {
            ITrackerInfo o = group.get(j);
            if (o instanceof SubProcessTrackEvent) {
                subProcessTrackEvent = (SubProcessTrackEvent)o;
                subProcessTrackEventIndx = j;
                break;
            }
            ++j;
        }
        LinkedHashMap groupBy = new LinkedHashMap();
        LinkedHashMap<String, ProcessingTrackEvent> starts = new LinkedHashMap<String, ProcessingTrackEvent>();
        ArrayList info = new ArrayList();
        ArrayList rest = new ArrayList();
        LinkedHashMap firstInfoPerProcess = new LinkedHashMap();
        HashMap fileStructralIndex = new HashMap();
        int j2 = 0;
        while (j2 < group.size()) {
            ProcessingTrackEvent startEvent;
            InfoTrackEvent infoEvent;
            ITrackerInfo o = group.get(j2);
            if (o instanceof ProcessingTrackEvent) {
                ProcessingTrackEvent startEvent2 = (ProcessingTrackEvent)o;
                String taskId = startEvent2.getTaskId();
                ArrayList<ArrayList<String>> files = startEvent2.getFileList();
                String variable = this.getOrgVariable(files);
                String fileToIndex = this.filesToIndex(files);
                fileStructralIndex.containsKey(fileToIndex);
                if (!groupBy.containsKey(taskId)) {
                    groupBy.put(taskId, new LinkedHashMap());
                    firstInfoPerProcess.put(taskId, new LinkedHashMap());
                }
                if (!((LinkedHashMap)groupBy.get(taskId)).containsKey(variable)) {
                    ((LinkedHashMap)groupBy.get(taskId)).put(variable, new LinkedHashMap());
                    ((HashMap)((HashMap)firstInfoPerProcess).get(taskId)).put(variable, o);
                }
                if (!((LinkedHashMap)((LinkedHashMap)groupBy.get(taskId)).get(variable)).containsKey(fileToIndex)) {
                    ((LinkedHashMap)((LinkedHashMap)groupBy.get(taskId)).get(variable)).put(fileToIndex, new ArrayList());
                }
                ((ArrayList)((LinkedHashMap)((LinkedHashMap)groupBy.get(taskId)).get(variable)).get(fileToIndex)).add(startEvent2);
                starts.put(fileToIndex, startEvent2);
            }
            if (o instanceof ProcessingFinishedTrackEvent) {
                ProcessingFinishedTrackEvent finishEvent = (ProcessingFinishedTrackEvent)o;
                ArrayList<ArrayList<String>> files = finishEvent.getFileList();
                String variable = this.getOrgVariable(files);
                String fileToIndex = this.filesToIndex(files);
                ProcessingTrackEvent startEvent3 = (ProcessingTrackEvent)((HashMap)starts).get(fileToIndex);
                String taskId = startEvent3.getTaskId();
                if (!groupBy.containsKey(taskId)) {
                    groupBy.put(taskId, new LinkedHashMap());
                    firstInfoPerProcess.put(taskId, new LinkedHashMap());
                }
                if (!((LinkedHashMap)groupBy.get(taskId)).containsKey(variable)) {
                    ((LinkedHashMap)groupBy.get(taskId)).put(variable, new LinkedHashMap());
                    ((HashMap)((HashMap)firstInfoPerProcess).get(taskId)).put(variable, o);
                }
                if (!((LinkedHashMap)((LinkedHashMap)groupBy.get(taskId)).get(variable)).containsKey(fileToIndex)) {
                    ((LinkedHashMap)((LinkedHashMap)groupBy.get(taskId)).get(variable)).put(fileToIndex, new ArrayList());
                }
                ((ArrayList)((LinkedHashMap)((LinkedHashMap)groupBy.get(taskId)).get(variable)).get(fileToIndex)).add(finishEvent);
            }
            if (o instanceof InfoTrackEvent && (infoEvent = (InfoTrackEvent)o).getInfoType() == Tracking.TrackInfoType.Process && (startEvent = this.getCorospondingInfo(((HashMap)starts).values(), infoEvent)) != null) {
                String taskId = startEvent.getTaskId();
                ArrayList<ArrayList<String>> files = startEvent.getFileList();
                String variable = this.getOrgVariable(files);
                String fileToIndex = this.filesToIndex(files);
                ((ArrayList)((LinkedHashMap)((LinkedHashMap)groupBy.get(taskId)).get(variable)).get(fileToIndex)).add(infoEvent);
            }
            ++j2;
        }
        for (Map.Entry entry : groupBy.entrySet()) {
            String taskKey = (String)entry.getKey();
            CMDTaskTracker cmdTaskTracker = null;
            HashMap subGroupBy = (HashMap)entry.getValue();
            for (Map.Entry subEntry : subGroupBy.entrySet()) {
                String varKey = (String)subEntry.getKey();
                if (!this.cmdTasks.containsKey(taskKey + varKey)) {
                    cmdTaskTracker = new CMDTaskTracker(this);
                    Object newTaskName = taskKey;
                    if (taskKey.isBlank()) {
                        newTaskName = this.workflowjob.getJobDescID() + "." + this.N_UNNAMED_TASKS;
                        ++this.N_UNNAMED_TASKS;
                    }
                    this.cmdTasks.put(taskKey + varKey, cmdTaskTracker);
                    cmdTaskTracker.setTaskName((String)newTaskName);
                }
                cmdTaskTracker = this.cmdTasks.get(taskKey + varKey);
                LinkedHashMap subSubGroupBy = (LinkedHashMap)subEntry.getValue();
                VarInfoTrackEvent infoVar = this.getCorspondingVariableInfo((ITrackerInfo)((HashMap)((HashMap)firstInfoPerProcess).get(taskKey)).get(varKey), varKey);
                cmdTaskTracker.addTrackerVariables(varKey);
                cmdTaskTracker.addVarTrackerInfo(infoVar);
                for (Map.Entry subSubSubGroupBy : subSubGroupBy.entrySet()) {
                    String fileToIndex = (String)subSubSubGroupBy.getKey();
                    ArrayList entries = (ArrayList)subSubSubGroupBy.getValue();
                    cmdTaskTracker.addBlockInfo(entries);
                }
            }
        }
    }

    private VarInfoTrackEvent getCorspondingVariableInfo(ITrackerInfo info, String varKey) {
        int startIndex = this.entries.indexOf(info);
        int i = startIndex - 1;
        while (i >= 0) {
            VarInfoTrackEvent infoEvent;
            ITrackerInfo o = this.entries.get(i);
            if (o instanceof VarInfoTrackEvent && ((infoEvent = (VarInfoTrackEvent)o).getInfoType() == Tracking.TrackInfoType.Input || infoEvent.getInfoType() == Tracking.TrackInfoType.Output) && ((VarInfoTrackEvent)o).getVariableKey().equals(varKey)) {
                return (VarInfoTrackEvent)o;
            }
            --i;
        }
        return null;
    }

    private ProcessingTrackEvent getCorospondingInfo(Collection<ProcessingTrackEvent> starts, InfoTrackEvent infoEvent) {
        for (ProcessingTrackEvent start : starts) {
            ArrayList<ArrayList<String>> files = start.getFileList();
            if (!this.doesMatch(files, infoEvent)) continue;
            return start;
        }
        return null;
    }

    private boolean doesMatch(ArrayList<ArrayList<String>> files, InfoTrackEvent infoEvent) {
        boolean doesMatch = false;
        for (ArrayList<String> list : files) {
            for (String file : list) {
                if (!infoEvent.getLogMsg().contains(file)) {
                    return false;
                }
                doesMatch = true;
            }
        }
        return doesMatch;
    }

    private CMDTaskTracker createCmdTask(String currentTask, ArrayList<ITrackerInfo> infos) {
        ArrayList<ProcessingTrackEvent> starts = new ArrayList<ProcessingTrackEvent>();
        for (ITrackerInfo o : infos) {
            if (!(o instanceof ProcessingTrackEvent)) continue;
            starts.add((ProcessingTrackEvent)o);
        }
        LinkedHashMap<String, ProcessingFinishedTrackEvent> ends = new LinkedHashMap<String, ProcessingFinishedTrackEvent>();
        HashSet<String> varKeys = new HashSet<String>();
        for (ITrackerInfo o : infos) {
            if (!(o instanceof ProcessingFinishedTrackEvent)) continue;
            ArrayList<ArrayList<String>> files = ((ProcessingFinishedTrackEvent)o).getFileList();
            varKeys.add(this.getOrgVariable(files));
            ends.put(this.filesToIndex(files), (ProcessingFinishedTrackEvent)o);
        }
        CMDTaskTracker cmdTaskTracker = new CMDTaskTracker(this);
        cmdTaskTracker.setTaskName(currentTask);
        for (ProcessingTrackEvent o : starts) {
            ArrayList<ArrayList<String>> files = o.getFileList();
            ProcessingFinishedTrackEvent processingFinishedTrackEvent = (ProcessingFinishedTrackEvent)ends.get(this.filesToIndex(files));
        }
        return null;
    }

    String filesToIndex(ArrayList<ArrayList<String>> files) {
        Object index = null;
        for (ArrayList<String> list : files) {
            for (String file : list) {
                index = index == null ? file : (String)index + "_" + file;
            }
        }
        return index;
    }

    private String getOrgVariable(ArrayList<ArrayList<String>> files) {
        HashSet<String> varsKey = new HashSet<String>();
        for (ArrayList<String> subList : files) {
            for (String file : subList) {
                if (!this.fileVarIndex.containsKey(file)) continue;
                varsKey.add(this.fileVarIndex.get((Object)file).var.getKey());
                return this.fileVarIndex.get((Object)file).var.getKey();
            }
        }
        return null;
    }

    public int nOfTasks() {
        return this.cmdTasks.size();
    }

    public TaskTracker getTracker() {
        return this.parentTracker;
    }

    public Collection<CMDTaskTracker> getCmdTasks() {
        return this.cmdTasks.values();
    }

    public String getLog(ProcessingTrackEvent startEvent) {
        if (this.entry != null) {
            return this.entry.getTrackInfo().getLogMsg(startEvent);
        }
        return "";
    }

    public SubmissionHistoryEntry getSubmissionHistoryEntry() {
        return this.entry;
    }

    class EventsGroup
    implements ITrackerInfo {
        String EVENTS_VERSION_1 = "v1";
        String EVENTS_VERSION_2 = "v2";
        String pid;
        String ppid;
        EventsGroup parentGroup;
        HashMap<String, String> pidMap = new HashMap();
        LinkedHashMap<String, EventsGroup> allGroups = new LinkedHashMap();
        List<ITrackerInfo> entries = new ArrayList<ITrackerInfo>();
        LinkedHashMap<String, EventsGroup> childGroups = new LinkedHashMap();

        public EventsGroup(String pid) {
            this.pid = pid;
            this.allGroups.put(pid, this);
        }

        public EventsGroup(String pid, String ppid) {
            this.pid = pid;
            this.ppid = ppid;
            this.allGroups.put(pid, this);
        }

        public void add(ITrackerInfo o) {
            String pid = o.getPID();
            String ppid = o.getPPID();
            this.pidMap.put(pid, ppid);
            if (o instanceof ProcessingFinishedTrackEvent) {
                pid = o.getPPID();
                ppid = this.pidMap.get(pid);
            }
            if (pid == null || this.pid.equals(pid)) {
                this.entries.add(o);
                return;
            }
            EventsGroup eventLocalGroup = this.allGroups.get(pid);
            if (eventLocalGroup == null) {
                eventLocalGroup = new EventsGroup(pid, ppid);
                eventLocalGroup.allGroups = this.allGroups;
                this.allGroups.put(pid, eventLocalGroup);
                eventLocalGroup.setParent(this.allGroups.get(ppid));
            }
            eventLocalGroup.add(o);
        }

        private void setParent(EventsGroup eventsGroup) {
            if (eventsGroup == null) {
                if (this.ppid != null) {
                    eventsGroup = new EventsGroup(this.ppid);
                }
                this.parentGroup = eventsGroup;
                eventsGroup.childGroups.put(this.pid, this);
                eventsGroup.entries.add(this);
            } else {
                this.parentGroup = eventsGroup;
                eventsGroup.childGroups.put(this.pid, this);
                eventsGroup.entries.add(this);
            }
        }

        public String toString() {
            return this.entries.toString();
        }

        private String tabs(int level) {
            Object tabs = "";
            int i = 0;
            while (i < level) {
                tabs = (String)tabs + "\t";
                ++i;
            }
            return tabs;
        }

        @Override
        public String getTime() {
            return null;
        }

        @Override
        public String getTaskName() {
            return this.pid;
        }

        @Override
        public ExecStatus getExecStatus() {
            return ExecStatus.Finished;
        }

        @Override
        public String toString(int i) {
            return this.entries.toString();
        }

        @Override
        public String toTrackInfo(int i) {
            return null;
        }

        @Override
        public void setLogMsg(String sublogMsg) {
        }

        @Override
        public String getLogMsg() {
            return null;
        }

        @Override
        public String getPID() {
            return this.pid;
        }

        @Override
        public String getPPID() {
            return this.ppid;
        }

        String getVersion() {
            if (this.entries.size() > 0 && this.entries.get(0).getPID() == null) {
                return this.EVENTS_VERSION_1;
            }
            return this.EVENTS_VERSION_2;
        }
    }

    class VariableIndex {
        JobVariable var;
        int index = 0;
        int pair = 0;

        public VariableIndex(JobVariable var, int i) {
            this.var = var;
            this.index = i;
        }

        public VariableIndex(JobVariable var, int pair, int i) {
            this.var = var;
            this.pair = pair;
            this.index = i;
        }
    }
}

