/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.template;

import com.biotechvana.workflow.template.WorkflowTemplate;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class WorkflowTemplateReader {
    static final int WRITER_CURRENT_VERSION = 1;
    WorkflowTemplateDeserializer workflowTemplateDeserializer = new WorkflowTemplateDeserializer();
    Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().registerTypeAdapter(WorkflowTemplate.class, (Object)this.workflowTemplateDeserializer).create();

    public WorkflowTemplate loadFromFile(String fileName) throws IOException {
        String line;
        Object allFile = "";
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        while ((line = br.readLine()) != null) {
            allFile = (String)allFile + line;
        }
        return (WorkflowTemplate)this.gson.fromJson((String)allFile, WorkflowTemplate.class);
    }

    class WorkflowTemplateDeserializer
    implements JsonDeserializer<WorkflowTemplate> {
        WorkflowTemplateDeserializer() {
        }

        public WorkflowTemplate deserialize(JsonElement json, Type clazz, JsonDeserializationContext context) throws JsonParseException {
            WorkflowTemplate newTemplate = new WorkflowTemplate();
            JsonObject templateAsJson = json.getAsJsonObject();
            int writerVersion = templateAsJson.get("Version").getAsInt();
            if (writerVersion == 1) {
                String metadata = templateAsJson.get("Metadata").getAsString();
                try {
                    newTemplate.getMetadata().load(new StringReader(metadata));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                JsonElement elem = templateAsJson.get("Startup");
                newTemplate.startUpJobDescId = (String)context.deserialize(elem, String.class);
                elem = templateAsJson.get("Default Name");
                newTemplate.defaultName = (String)context.deserialize(elem, String.class);
                elem = templateAsJson.get("Tasks");
                newTemplate.tasksIdToJobDescId = (HashMap)context.deserialize(elem, HashMap.class);
                elem = templateAsJson.get("Target Mapping");
                newTemplate.varMapTo = (ArrayList)context.deserialize(elem, ArrayList.class);
                elem = templateAsJson.get("Source Mapping");
                newTemplate.varMapFrom = (ArrayList)context.deserialize(elem, ArrayList.class);
                elem = templateAsJson.get("Values");
                newTemplate.customVariableValues = (HashMap)context.deserialize(elem, HashMap.class);
                elem = templateAsJson.get("INPUT");
                newTemplate.declaredInputVar = (ArrayList)context.deserialize(elem, ArrayList.class);
                elem = templateAsJson.get("OUTPUT");
                newTemplate.declaredOutputVar = (ArrayList)context.deserialize(elem, ArrayList.class);
                elem = templateAsJson.get("Recommended");
                newTemplate.recommendationVarToSet = (ArrayList)context.deserialize(elem, ArrayList.class);
            }
            return newTemplate;
        }
    }
}

