/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.manager;

import com.biotechvana.commons.model.UserNotifyListener;
import com.biotechvana.pipelinestools.utils.PipelineExecutor;
import com.biotechvana.users.UserManager;
import com.biotechvana.utils.WorkspaceUtils;
import com.biotechvana.workflow.IValidationResult;
import com.biotechvana.workflow.ValidationResult;
import com.biotechvana.workflow.Workflow;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.WorkflowMetadata;
import com.biotechvana.workflow.WorkflowStartupJob;
import com.biotechvana.workflow.WorkflowValidationSet;
import com.biotechvana.workflow.configuration.IPipelineConfiguration;
import com.biotechvana.workflow.configuration.SimpleWorkflowConfiguration;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.manager.JobsCatalog;
import com.biotechvana.workflow.manager.PipelinesCreatorHelper;
import com.biotechvana.workflow.manager.WorkflowCatalog;
import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.biotechvana.workflow.template.WorkflowTemplate;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class WorkflowManager
implements IWorkflowManager {
    @Inject
    private WorkflowCatalog currentWorkflowCatalog;
    @Inject
    private JobsCatalog currentJobCatalog;
    @Inject
    PipelinesCreatorHelper pipelinesCreatorHelper;
    UserManager userManager;

    @Override
    public UserManager getUserManager() {
        return this.userManager;
    }

    @Override
    public WorkflowCatalog getWorkflowCatalog() {
        return this.currentWorkflowCatalog;
    }

    @Override
    public JobsCatalog getJobsCatalog() {
        return this.currentJobCatalog;
    }

    public WorkflowManager() {
    }

    @Inject
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @PostConstruct
    public void init(UserManager userManager) {
        userManager.addUserNotiferList(new UserNotifyListener(){

            public void userChanging() {
            }

            public void userChanged() {
                WorkflowManager.this.currentWorkflowCatalog.clear();
            }
        });
        this.currentWorkflowCatalog.setWorkflowManager(this);
        this.currentJobCatalog.setWorkflowManager(this);
    }

    public WorkflowManager(WorkflowCatalog currentWorkflowCatalog, JobsCatalog currentJobCatalog) {
        this.currentWorkflowCatalog = currentWorkflowCatalog;
        this.currentJobCatalog = currentJobCatalog;
    }

    @Override
    public IValidationResult submitPipeline(final IPipelineConfiguration pipelineConfiguration) {
        WorkflowValidationSet result = new WorkflowValidationSet();
        IValidationResult validation = pipelineConfiguration.validate();
        if (!validation.isOK()) {
            return validation;
        }
        if (!this.getWorkflowCatalog().checkExperimentConfigurationName(pipelineConfiguration)) {
            return new ValidationResult(4, -100, "There is a project with the same name , Please change the name.");
        }
        validation = pipelineConfiguration.feedWorkflow();
        if (!validation.isOK()) {
            return new ValidationResult(4, -300, "Can not assign pipeline options, Please revise the configuratin. \n" + validation.getMessage());
        }
        boolean valid = pipelineConfiguration.getWorkflow().isValid();
        if (!valid) {
            return new ValidationResult(4, -200, "Pipeline is not valid.\n" + pipelineConfiguration.getWorkflow().getFirstErrorMsg());
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Submit Pipeline", -1);
                monitor.subTask("Checking Configuration ");
                monitor.subTask("Generating and Submitting Pipeline Script");
                StringBuilder command = new StringBuilder();
                boolean res = pipelineConfiguration.getWorkflow().getCommand(WorkflowManager.this, command);
                if (res) {
                    monitor.subTask("Saving Configuration ");
                    WorkflowManager.this.pipelinesCreatorHelper.SavePipelineConfiguration(pipelineConfiguration);
                    WorkflowManager.this.pipelinesCreatorHelper.SaveProjectPipeline(pipelineConfiguration.getWorkflow());
                    monitor.subTask("Uploading Configuration");
                    WorkflowManager.this.pipelinesCreatorHelper.uploadEperimentConfiguration(pipelineConfiguration, monitor);
                    WorkflowManager.this.pipelinesCreatorHelper.uploadProjectPipeline(pipelineConfiguration.getWorkflow(), monitor);
                    String scriptName = "." + pipelineConfiguration.getWorkflow().getWorkflowName() + "_command";
                    WorkflowManager.this.pipelinesCreatorHelper.uploadPipelineScript(command.toString(), scriptName, pipelineConfiguration.getWorkflow().getWorkflowFolder(), monitor);
                    monitor.subTask("Executing Pipeline Script");
                    String execCmd = "chmod 755  " + pipelineConfiguration.getWorkflow().getWorkflowScriptPath(WorkflowManager.this) + " && bash " + pipelineConfiguration.getWorkflow().getWorkflowScriptPath(WorkflowManager.this) + " \n";
                    boolean bl = PipelineExecutor.runCommandWithHTTP(WorkflowManager.this.userManager, execCmd, "", "", ".temp_command");
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(WorkspaceUtils.getShell()).run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return new ValidationResult(8, -400, "Can not submit Pipeline, Operation was interrupted", e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return new ValidationResult(8, -400, "Can not submit Pipeline, Operation was interrupted", e);
        }
        this.getWorkflowCatalog().addProject(pipelineConfiguration);
        return ValidationResult.Valid_RESULT;
    }

    @Deprecated
    public ValidationResult submitWorkflow(Workflow workflow) {
        boolean valid = workflow.isValid();
        if (valid) {
            return ValidationResult.Valid_RESULT;
        }
        return new ValidationResult(4, -1, "Workflow is not valid. " + workflow.getFirstErrorMsg());
    }

    @Deprecated
    public ValidationResult saveWorkflow(Workflow selected_wf) {
        boolean valid = this.pipelinesCreatorHelper.checkProjectName(selected_wf.getWorkflowId());
        if (valid) {
            this.pipelinesCreatorHelper.SaveProjectPipeline(selected_wf);
            return ValidationResult.Valid_RESULT;
        }
        return new ValidationResult(4, -1, "Project with the same name exist. Change the name and try again");
    }

    @Deprecated
    public ValidationResult savePoject(IPipelineConfiguration experimentConfiguration) {
        boolean valid = true;
        if (valid) {
            this.pipelinesCreatorHelper.SavePipelineConfiguration(experimentConfiguration);
        }
        return ValidationResult.Valid_RESULT;
    }

    public IPipelineConfiguration loadPipelineConfiguration(String taskID) {
        return this.getWorkflowCatalog().getPipelineConfigurationByTaskId(taskID);
    }

    public void reSubmit() {
    }

    @Override
    public void delete(String taskId, String projectName) {
        this.currentWorkflowCatalog.removeSavedPipelineConfiguration(projectName);
        this.pipelinesCreatorHelper.removeSavedProject(taskId, projectName);
    }

    public PipelinesCreatorHelper getPipelinesCreatorHelper() {
        return this.pipelinesCreatorHelper;
    }

    @Override
    public ValidationResult submitPipeline(Workflow workflow) {
        throw new NoSuchMethodError("No Implemented Yet");
    }

    @Override
    public IValidationResult submitWorkflowJob(WorkflowJob task) {
        WorkflowJob taskExecutor = task;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Submit Task", -1);
                monitor.subTask("Checking Configuration ...");
                monitor.subTask("Generating and Submitting Task Script");
                StringBuilder command = new StringBuilder();
                monitor.subTask("Saving Configuration ");
                monitor.subTask("Uploading Configuration");
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(WorkspaceUtils.getShell()).run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return new ValidationResult(8, -400, "Can not submit Task, Operation was interrupted", e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return new ValidationResult(8, -400, "Can not submit Task, Operation was interrupted", e);
        }
        boolean res = task.runJob();
        if (!res) {
            WorkflowValidationSet vSet = new WorkflowValidationSet(4, -1, "Invalid or missing configartions parameters in Job");
            for (String errMsg : task.getAllErrorMsgs()) {
                vSet.add(new ValidationResult(4, -1, errMsg));
            }
            return vSet;
        }
        return ValidationResult.Valid_RESULT;
    }

    @Override
    public IValidationResult runWorkflowJob(WorkflowJob task, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.subTask("Running Task .. ");
        boolean res = task.runJob();
        if (!res) {
            WorkflowValidationSet vSet = new WorkflowValidationSet(4, -1, "Invalid or missing configartions parameters in Job");
            for (String errMsg : task.getAllErrorMsgs()) {
                vSet.add(new ValidationResult(4, -1, errMsg));
            }
            return vSet;
        }
        return ValidationResult.Valid_RESULT;
    }

    @Override
    public IValidationResult runWorkflowJob(WorkflowJob task) {
        return this.runWorkflowJob(task, null);
    }

    Workflow createWorkflow(WorkflowTemplate template) {
        WorkflowStartupJob startupJob = (WorkflowStartupJob)this.currentJobCatalog.createJobInstanceById(template.getStarterTaskId(), new Object[0]);
        Workflow workflow = new Workflow(startupJob);
        WorkflowMetadata metaData = (WorkflowMetadata)template.getMetadata().clone();
        workflow.setMetadata(metaData);
        workflow.setWorkflowId(template.getDefaultWorkflowName());
        workflow.setWorkflowName(template.getDefaultWorkflowName());
        return workflow;
    }

    @Override
    public IPipelineConfiguration getWorkflowConfigurator(String templateId) {
        Class classDef;
        WorkflowTemplate wtm = this.currentWorkflowCatalog.getTemplateByID(templateId);
        String startupJobId = wtm.getStarterTaskId();
        String startupJobClazzName = this.currentJobCatalog.getJobFullName(startupJobId);
        ClassLoader classLoader = this.currentJobCatalog.getClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if ((classDef = this.currentWorkflowCatalog.getConfigurationImlpsClass(startupJobClazzName)) == null) {
            SimpleWorkflowConfiguration worflowConfig = new SimpleWorkflowConfiguration(this);
            worflowConfig.setWorkflowTemplateId(templateId);
            return worflowConfig;
        }
        try {
            IPipelineConfiguration newObj = (IPipelineConfiguration)classDef.getDeclaredConstructors()[0].newInstance(this);
            newObj.setWorkflowTemplateId(templateId);
            return newObj;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Class getWorkflowConfiguratorWizardClass(Class configurationimplClazz) {
        return this.currentWorkflowCatalog.getConfigurationWizardClass(configurationimplClazz);
    }

    @Override
    public WorkflowJob restart(SubmissionHistoryEntry entry) {
        String taskId = entry.getTaskTemplateId();
        WorkflowJob job = this.getJobsCatalog().createJobInstanceById(taskId, new Object[0]);
        System.out.print(entry);
        return job;
    }
}

