/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.manager;

import com.biotechvana.commons.model.FTPHelper;
import com.biotechvana.pipelinestools.utils.PipelineExecutor;
import com.biotechvana.users.UserManager;
import com.biotechvana.workflow.SubmissionHistoryManager;
import com.biotechvana.workflow.Workflow;
import com.biotechvana.workflow.WorkflowConstants;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.WorkflowStartupJob;
import com.biotechvana.workflow.configuration.IPipelineConfiguration;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.manager.PipelineConfigDeserializer;
import com.biotechvana.workflow.manager.TPipelineConfigurationSelector;
import com.biotechvana.workflow.manager.WorkflowManager;
import com.biotechvana.workflow.template.WorkflowTemplate;
import com.biotechvana.workflow.variables.JobVariable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;

public class PipelinesCreatorHelper {
    UserManager userManager;
    @Inject
    @Optional
    SubmissionHistoryManager submissionHistoryManager;
    @Inject
    FTPHelper ftpManager;
    static int connectionTimeOut = 30000;
    String grpoServerSideFolder = ".gpro";
    String appNameServerSideFolder;
    String configServerSideFolder = "Projects";
    String pipelineServerSideFolder = "Pipelines";
    private static final String WORKFLOW_STRUCTURE_FILE_EXT = ".gpw";
    private static final String WORKFLOW_INSTANCE_FILE_EXT = ".gpiw";
    static final String JOB_START_TOKEN = "#Jobs";
    static final String MAP_START_TOKEN = "#Map";
    static final String VALUE_START_TOKEN = "#Values";
    static final String PRO_START_TOKEN = "#Properties";
    static final String WORK_FLOWNAME_TOKEN = "#Name";

    @Inject
    @Optional
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
        this.appNameServerSideFolder = userManager.getModuleId();
    }

    public void SaveStructureToDisk(Workflow workflow) {
        File folder = this.userManager.getLocalPathManager().getModuleFolder();
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!(folder = new File(folder, this.userManager.getModuleId())).exists()) {
            folder.mkdir();
        }
        if (!(folder = new File(folder, "Pipelines")).exists()) {
            folder.mkdir();
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(folder, workflow.getWorkflowName() + WORKFLOW_STRUCTURE_FILE_EXT))));
            writer.write(PipelinesCreatorHelper.writeStructure(workflow));
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            System.out.println(ex.getStackTrace());
        }
    }

    public String SavePipelineConfiguration(IPipelineConfiguration conf) {
        TPipelineConfigurationSelector ts = new TPipelineConfigurationSelector(conf);
        File folder = this.getUserProjectsFolder();
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
        String filePath = folder.getAbsolutePath() + "/" + conf.getPojectName() + ".config";
        try {
            BufferedWriter br = new BufferedWriter(new FileWriter(filePath));
            br.write(gson.toJson((Object)ts));
            br.close();
            return filePath;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    String serverSideProjectsFolder() {
        return this.grpoServerSideFolder + "/" + this.appNameServerSideFolder + "/" + this.configServerSideFolder;
    }

    String serverSidePipelinesFolder() {
        return this.grpoServerSideFolder + "/" + this.appNameServerSideFolder + "/" + this.pipelineServerSideFolder;
    }

    public void setUpServerSideFolder() {
        Object cmd = "";
        cmd = " [ -d  " + this.grpoServerSideFolder + " ] || mkdir " + this.grpoServerSideFolder + " \n cd " + this.grpoServerSideFolder + "\n [ -d  " + this.appNameServerSideFolder + " ] || mkdir " + this.appNameServerSideFolder + " \n cd " + this.appNameServerSideFolder + "\n [ -d  " + this.configServerSideFolder + " ] || mkdir " + this.configServerSideFolder + " \n [ -d  " + this.pipelineServerSideFolder + " ] || mkdir " + this.pipelineServerSideFolder + " \n";
        PipelineExecutor.runCommandWithHTTP(this.userManager, (String)cmd, "", "", ".temp_command");
    }

    public void uploadEperimentConfiguration(IPipelineConfiguration experimentConfiguration, IProgressMonitor monitor) {
        this.setUpServerSideFolder();
        File projectFile = this.getUserProjectsFolder();
        String projectName = experimentConfiguration.getPojectName();
        projectFile = new File(projectFile, "/" + projectName + ".config");
        try {
            this.ftpManager.uploadFile(projectFile.getAbsolutePath(), this.serverSideProjectsFolder(), monitor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void uploadProjectPipeline(Workflow workflow, IProgressMonitor monitor) {
        this.setUpServerSideFolder();
        File projectFile = this.getUserPipelinesFolder();
        String pipelineName = workflow.getWorkflowId();
        projectFile = new File(projectFile, "/" + pipelineName + WORKFLOW_INSTANCE_FILE_EXT);
        try {
            this.ftpManager.uploadFile(projectFile.getAbsolutePath(), this.serverSidePipelinesFolder(), monitor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getUserPipelinesFolder() {
        File folder = this.userManager.getLocalPathManager().getModuleFolder();
        if (!(folder = new File(folder, "Pipelines")).exists()) {
            folder.mkdir();
        }
        return folder;
    }

    public File getUserProjectsFolder() {
        File folder = this.userManager.getLocalPathManager().getModuleFolder();
        if (!(folder = new File(folder, "Projects")).exists()) {
            folder.mkdir();
        }
        return folder;
    }

    public void SaveProjectPipeline(Workflow workflow) {
        File folder = this.getUserPipelinesFolder();
        String projectFileName = workflow.getWorkflowId();
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(folder, projectFileName + WORKFLOW_INSTANCE_FILE_EXT))));
            writer.write(this.writeProject(workflow));
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            System.out.println(ex.getStackTrace());
        }
    }

    public void removeSavedProject(String taskId, String projectName) {
        File localProjectFile = new File(String.valueOf(this.getUserProjectsFolder()) + "/" + projectName + ".config");
        File localInstanceFile = new File(String.valueOf(this.getUserPipelinesFolder()) + "/" + taskId + WORKFLOW_INSTANCE_FILE_EXT);
        if (localProjectFile.exists()) {
            localProjectFile.delete();
        }
        if (localInstanceFile.exists()) {
            localInstanceFile.delete();
        }
    }

    public String writeProject(Workflow workflow) {
        String key;
        StringBuilder workflowStructure = new StringBuilder();
        StringWriter writer = new StringWriter();
        try {
            workflow.getMetadata().store(writer, "Metadata");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        workflowStructure.append(writer.toString());
        workflowStructure.append("#Name\t" + workflow.getWorkflowName() + "\n");
        List<WorkflowJob> jobs = workflow.getAllJobs();
        workflowStructure.append("#Jobs\n");
        for (WorkflowJob job : jobs) {
            if (job instanceof WorkflowStartupJob) continue;
            workflowStructure.append(job.getJobDescID() + "\t" + job.getJobID() + "\t" + job.getFriendlyName());
            workflowStructure.append("\n");
        }
        workflowStructure.append("#Map\n");
        for (WorkflowJob job : jobs) {
            HashMap<String, JobVariable> map = job.getVariablesMap();
            for (String varKey : map.keySet()) {
                if (map.get(varKey).getJob().getJobID().equals(WorkflowConstants.WORKFLOW_OPTIONS_JOBID)) continue;
                String inVarFullkey = job.getVariable(varKey).getFullKey();
                String outVarFullkey = map.get(varKey).getFullKey();
                workflowStructure.append(inVarFullkey + "=" + outVarFullkey);
                workflowStructure.append("\n");
            }
        }
        workflowStructure.append("#Values\n");
        for (WorkflowJob job : jobs) {
            for (JobVariable var : job.getAllVariables()) {
                if (var.hasMapping() || var.getValue().isEmpty() || var.getDescVarType() == VariableDescriptor.VariableType.Checked && var.getValue().equals("false")) continue;
                key = var.getFullKey();
                String value = var.getValue();
                value = value.replace("\n", ";");
                workflowStructure.append(key + "=" + value);
                workflowStructure.append("\n");
            }
        }
        workflowStructure.append("#Properties\n");
        for (WorkflowJob job : jobs) {
            if (job.getJobID().equals(WorkflowConstants.WORKFLOW_OPTIONS_JOBID)) continue;
            for (JobVariable var : job.getInputVariables()) {
                if (var.hasMapping() || var.getAtts().isEmpty() || var.getDescVarType() == VariableDescriptor.VariableType.Checked && var.getValue().equals("false")) continue;
                key = var.getFullKey();
                workflowStructure.append(key + "=" + var.getAtts());
                workflowStructure.append("\n");
            }
        }
        return workflowStructure.toString();
    }

    public static String writeStructure(Workflow workflow) {
        String key;
        StringBuilder workflowStructure = new StringBuilder();
        StringWriter writer = new StringWriter();
        try {
            workflow.getMetadata().store(writer, "Metadata");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        workflowStructure.append(writer.toString());
        workflowStructure.append("#Name\t" + workflow.getWorkflowName() + "\n");
        workflowStructure.append("#Jobs\n");
        List<WorkflowJob> jobs = workflow.getAllJobs();
        for (WorkflowJob job : jobs) {
            if (job instanceof WorkflowStartupJob) continue;
            workflowStructure.append(job.getJobDescID() + "\t" + job.getJobID() + "\t" + job.getFriendlyName());
            workflowStructure.append("\n");
        }
        workflowStructure.append("#Map\n");
        for (WorkflowJob job : jobs) {
            HashMap<String, JobVariable> map = job.getVariablesMap();
            for (String varKey : map.keySet()) {
                if (map.get(varKey).getJob().getJobID().equals(WorkflowConstants.WORKFLOW_OPTIONS_JOBID)) continue;
                String inVarFullkey = job.getVariable(varKey).getFullKey();
                String outVarFullkey = map.get(varKey).getFullKey();
                workflowStructure.append(inVarFullkey + "=" + outVarFullkey);
                workflowStructure.append("\n");
            }
        }
        workflowStructure.append("#Values\n");
        for (WorkflowJob job : jobs) {
            if (job.getJobID().equals(WorkflowConstants.WORKFLOW_OPTIONS_JOBID)) continue;
            for (JobVariable var : job.getOptionVariables()) {
                if (var.hasMapping() || var.getValue().isEmpty() || var.getDescVarType() == VariableDescriptor.VariableType.Checked && var.getValue().equals("false")) continue;
                key = var.getFullKey();
                workflowStructure.append(key + "=" + var.getValue());
                workflowStructure.append("\n");
            }
        }
        workflowStructure.append("#Properties\n");
        for (WorkflowJob job : jobs) {
            if (job.getJobID().equals(WorkflowConstants.WORKFLOW_OPTIONS_JOBID)) continue;
            for (JobVariable var : job.getInputVariables()) {
                if (var.hasMapping() || var.getAtts().isEmpty() || var.getDescVarType() == VariableDescriptor.VariableType.Checked && var.getValue().equals("false")) continue;
                key = var.getFullKey();
                workflowStructure.append(key + "=" + var.getAtts());
                workflowStructure.append("\n");
            }
        }
        return workflowStructure.toString();
    }

    public boolean checkProjectName(String workflowName) {
        File folder = this.userManager.getLocalPathManager().getModuleFolder();
        folder = new File(folder, this.userManager.getModuleId() + "/Projects/" + workflowName + WORKFLOW_INSTANCE_FILE_EXT);
        System.out.println(folder.getAbsolutePath());
        return !folder.exists();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Workflow loadPipelineFromFile(WorkflowManager workflowManager, File pipelineFile) {
        try {
            boolean foundTemplate = false;
            String templateID = null;
            Workflow workflow = new Workflow();
            List fileContent = IOUtils.readLines((Reader)new FileReader(pipelineFile));
            Object metaData = "";
            metaData = (String)metaData + (String)fileContent.get(0) + "\n";
            metaData = (String)metaData + (String)fileContent.get(1) + "\n";
            int currentLineIndex = 2;
            while (currentLineIndex < fileContent.size()) {
                String line = (String)fileContent.get(currentLineIndex);
                if (line.startsWith("#")) break;
                metaData = (String)metaData + (String)fileContent.get(currentLineIndex) + "\n";
                if (line.startsWith("TemplateID")) {
                    templateID = line.split("=")[1];
                }
                ++currentLineIndex;
            }
            for (WorkflowTemplate wf : workflowManager.getWorkflowCatalog().getWorkflowTemplates()) {
                if (!wf.getMetadata().getTemplateId().equals(templateID)) continue;
                workflow = wf.createWorkflow(workflowManager);
                foundTemplate = true;
            }
            workflow.getMetadata().load(new StringReader((String)metaData));
            block6: while (currentLineIndex < fileContent.size()) {
                String propertyInfo;
                String currentLine = (String)fileContent.get(currentLineIndex);
                ++currentLineIndex;
                if (currentLine.startsWith("#") && currentLine.equals(JOB_START_TOKEN)) {
                    while (!foundTemplate) {
                        String jobInfo = (String)fileContent.get(currentLineIndex);
                        if (jobInfo.startsWith("#")) continue block6;
                        String[] jobInfos = jobInfo.split("\t");
                        String jobDescID = jobInfos[0];
                        String jobWorkflowId = jobInfos[1];
                        String jobName = jobInfos[2];
                        WorkflowJob job = workflowManager.getJobsCatalog().createJobInstanceById(jobDescID, new Object[0]);
                        if (job == null) {
                            return null;
                        }
                        job.setFriendlyName(jobName);
                        job.setJobId(jobWorkflowId);
                        workflow.addJob(job);
                        if (++currentLineIndex >= fileContent.size()) continue block6;
                    }
                    continue;
                }
                if (currentLine.startsWith("#") && currentLine.equals(MAP_START_TOKEN)) {
                    String mapInfo;
                    if (currentLineIndex >= fileContent.size()) break;
                    while (!(mapInfo = (String)fileContent.get(currentLineIndex)).startsWith("#")) {
                        String[] mapInfos = mapInfo.split("=");
                        String inputVar = mapInfos[0];
                        String outputVar = mapInfos[1];
                        workflow.addMappingFullName(outputVar, inputVar);
                        if (++currentLineIndex < fileContent.size()) continue;
                        continue block6;
                    }
                    continue;
                }
                if (currentLine.startsWith("#") && currentLine.equals(VALUE_START_TOKEN)) {
                    String valueInfo;
                    while (!(valueInfo = (String)fileContent.get(currentLineIndex)).startsWith("#") && ++currentLineIndex < fileContent.size()) {
                    }
                    continue;
                }
                if (!currentLine.startsWith("#") || !currentLine.equals(PRO_START_TOKEN)) continue;
                while (currentLineIndex < fileContent.size() && !(propertyInfo = (String)fileContent.get(currentLineIndex)).startsWith("#")) {
                    String[] propertyInfos = propertyInfo.split("=");
                    String varFullName = propertyInfos[0];
                    String varProperties = propertyInfos[1];
                    String[] varFullNames = varFullName.split("\\.");
                    workflow.getJobById(varFullNames[1]).getVariable(varFullNames[2]).setAtts(varProperties);
                    ++currentLineIndex;
                }
            }
            workflow.setWorkflowName("LoadedFile " + workflow.getMetadata().getPipelineID());
            return workflow;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static IPipelineConfiguration loadProjectFromFile(File projectFile, Collection<Class> classesOfT) {
        Object allFile = "";
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(projectFile));
            while ((line = br.readLine()) != null) {
                allFile = (String)allFile + line;
            }
            PipelineConfigDeserializer deserializer = new PipelineConfigDeserializer();
            Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().registerTypeAdapter(TPipelineConfigurationSelector.class, (Object)deserializer).create();
            for (Class classOfT : classesOfT) {
                deserializer.registerConfigurationType(classOfT);
            }
            TPipelineConfigurationSelector ts = (TPipelineConfigurationSelector)gson.fromJson((String)allFile, new TypeToken<TPipelineConfigurationSelector>(){}.getType());
            return ts.config;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void uploadPipelineScript(String cmd, String fileName, String workflowFolder, IProgressMonitor monitor) {
        try {
            this.ftpManager.uploadFileFromString(cmd, workflowFolder, fileName, monitor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void syncProjects() {
        try {
            try {
                File destination = this.userManager.getLocalPathManager().getModuleFolder();
                String remoteFiles = this.serverSideProjectsFolder();
                this.ftpManager.downloadFolder(remoteFiles, destination.getAbsolutePath());
                destination = this.userManager.getLocalPathManager().getModuleFolder();
                remoteFiles = this.serverSidePipelinesFolder();
                this.ftpManager.downloadFolder(remoteFiles, destination.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

