/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.manager;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.configuration.IPipelineConfiguration;
import com.biotechvana.workflow.manager.TPipelineConfigurationSelector;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class PipelineConfigDeserializer
implements JsonDeserializer<TPipelineConfigurationSelector> {
    String tConfigTypeElementName = "type";
    Gson gson = new Gson();
    Map<String, Class<? extends IPipelineConfiguration>> pipelineConfigurationTypeRegistry = new HashMap<String, Class<? extends IPipelineConfiguration>>();

    PipelineConfigDeserializer() {
    }

    void registerConfigurationType(Class<? extends IPipelineConfiguration> pipelineConfiguration) {
        String barnTypeName = Constants.MODULE_ID + "." + pipelineConfiguration.getSimpleName();
        this.pipelineConfigurationTypeRegistry.put(barnTypeName, pipelineConfiguration);
    }

    public TPipelineConfigurationSelector deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject tConfigObject = json.getAsJsonObject();
        JsonElement animalTypeElement = tConfigObject.get(this.tConfigTypeElementName);
        TPipelineConfigurationSelector barn = new TPipelineConfigurationSelector();
        barn.type = animalTypeElement.getAsString();
        Class<? extends IPipelineConfiguration> animalType = this.pipelineConfigurationTypeRegistry.get(barn.type);
        barn.config = (IPipelineConfiguration)this.gson.fromJson(tConfigObject.get("config"), animalType);
        return barn;
    }
}

