/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.executer;

import com.biotechvana.workflow.executer.BashBlock;
import com.biotechvana.workflow.executer.BashStatement;

public class IFObject
extends BashStatement {
    String cond = "";
    BashBlock thenBlock;
    BashBlock elseBlock;
    String body = "";
    String elseBody = "";

    public IFObject(String cond) {
        this.cond = cond;
        this.thenBlock = new BashBlock();
        this.elseBlock = new BashBlock();
        this.thenBlock.setParent(this);
        this.elseBlock.setParent(this);
        this.internalIndetLevels = 1;
    }

    public IFObject Then(String ifBody) {
        this.body = ifBody;
        this.thenBlock.addStatment(ifBody);
        return this;
    }

    public IFObject Then(IFObject nestedIf) {
        return this.Then(nestedIf.toString());
    }

    public IFObject Else(String elseBody) {
        this.elseBody = elseBody;
        this.elseBlock.addStatment(elseBody);
        return this;
    }

    public IFObject Else(IFObject nestedIf) {
        return this.Else(nestedIf.toString());
    }

    public BashBlock getThenBlock() {
        return this.thenBlock;
    }

    public BashBlock getElseBlock() {
        return this.elseBlock;
    }

    @Override
    public void generate(StringBuilder builder) {
        this.cond = this.cond.trim();
        String sperator = " ";
        if (this.cond.charAt(0) == '[') {
            sperator = "";
        }
        String indent = this.getIndent();
        builder.append("\n");
        builder.append(indent + "if [" + sperator + this.cond + sperator + "];");
        builder.append("\n" + indent + "then\n");
        this.thenBlock.generate(builder);
        if (!this.elseBlock.isEmpty()) {
            builder.append("\n" + indent + "else\n");
            this.elseBlock.generate(builder);
        }
        builder.append(indent + "\nfi\n");
    }
}

