/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.descriptors;

import com.biotechvana.workflow.IVariableDescriptor;
import com.biotechvana.workflow.VariableCustomAction;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.descriptors.CheckedVariableDescriptor;
import com.biotechvana.workflow.descriptors.DoubleVariableDescriptor;
import com.biotechvana.workflow.descriptors.FileVariableDescriptor;
import com.biotechvana.workflow.descriptors.FilesVariableDescriptor;
import com.biotechvana.workflow.descriptors.FolderVariableDescriptor;
import com.biotechvana.workflow.descriptors.FoldersVariableDescriptor;
import com.biotechvana.workflow.descriptors.GroupVariableDescriptor;
import com.biotechvana.workflow.descriptors.IntVariableDescriptor;
import com.biotechvana.workflow.descriptors.ListVariableDescriptor;
import com.biotechvana.workflow.descriptors.MultiSelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.PairedFilesVariableDescriptor;
import com.biotechvana.workflow.descriptors.RangeVariableDescriptor;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.StringVariableDescriptor;
import com.biotechvana.workflow.descriptors.StringsVariableDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class VariableDescriptor
implements IVariableDescriptor {
    static int __Count = 0;
    private String key;
    protected String defaultValue = "";
    private String variableName;
    private VariableRole varRole = VariableRole.NONE;
    protected VariableType varType = VariableType.NONE;
    public boolean isRequired = false;
    private ArrayList<VariablesRule> rules = new ArrayList();
    private ArrayList<VariablesRule> actions = new ArrayList();
    boolean hasEnableAction = false;
    private String helpMsg;
    private String shortHelpMsg;
    String commandParamater = "";
    String commandParamaterAlt = "";
    String commandParamaterSep = " ";
    String groupName = null;
    HashMap<String, FileFormatInfo> acceptedFileFormatInfo = null;
    int defualtFileFomatIndex = 0;
    boolean guiVisible = true;
    boolean isTracked = false;
    ArrayList<String> samplesResources = new ArrayList();
    HashMap<String, String> samplesResourcesDisplyName = new HashMap();
    String subProg = null;
    boolean isFileName = false;
    List<VariableCustomAction> variableCustomActions = null;
    private boolean isLocked;

    public static FileVariableDescriptor File(String key, VariableRole varRole) {
        return new FileVariableDescriptor(key, varRole);
    }

    public static FolderVariableDescriptor Folder(String key, VariableRole varRole) {
        return new FolderVariableDescriptor(key, varRole);
    }

    public static FilesVariableDescriptor Files(String key, VariableRole varRole) {
        return new FilesVariableDescriptor(key, varRole);
    }

    public static PairedFilesVariableDescriptor FileList(String key, VariableRole varRole) {
        return new PairedFilesVariableDescriptor(key, varRole);
    }

    public static FoldersVariableDescriptor Folders(String key, VariableRole varRole) {
        return new FoldersVariableDescriptor(key, varRole);
    }

    public static RangeVariableDescriptor Range(String key, VariableRole varRole) {
        return new RangeVariableDescriptor(key, varRole);
    }

    public static SelectionListVariableDescriptor SelectionList(String key, VariableRole varRole) {
        return new SelectionListVariableDescriptor(key, varRole);
    }

    public static MultiSelectionListVariableDescriptor MultiSelectionList(String key, VariableRole varRole) {
        return new MultiSelectionListVariableDescriptor(key, varRole);
    }

    public static CheckedVariableDescriptor Checked(String key, VariableRole varRole) {
        return new CheckedVariableDescriptor(key, varRole);
    }

    public static StringVariableDescriptor String(String key, VariableRole varRole) {
        return new StringVariableDescriptor(key, varRole);
    }

    public static IntVariableDescriptor Int(String key, VariableRole varRole) {
        return new IntVariableDescriptor(key, varRole);
    }

    public static StringsVariableDescriptor Strings(String key, VariableRole varRole) {
        return new StringsVariableDescriptor(key, varRole);
    }

    public static DoubleVariableDescriptor Double(String key, VariableRole varRole) {
        return new DoubleVariableDescriptor(key, varRole);
    }

    public static GroupVariableDescriptor Group(String key, VariableRole varRole) {
        return new GroupVariableDescriptor(key, varRole);
    }

    public static ListVariableDescriptor List(String key, VariableRole varRole) {
        return new ListVariableDescriptor(key, varRole);
    }

    public static VariableDescriptor createDescriptorFor(String key, VariableType varType, VariableRole varRole) {
        VariableDescriptor varDesc = null;
        if (varType == VariableType.File) {
            varDesc = VariableDescriptor.File(key, varRole);
        }
        if (varType == VariableType.Folder) {
            varDesc = VariableDescriptor.Folder(key, varRole);
        }
        if (varType == VariableType.Files) {
            varDesc = VariableDescriptor.Files(key, varRole);
        }
        if (varType == VariableType.FileList) {
            varDesc = VariableDescriptor.FileList(key, varRole);
        }
        if (varType == VariableType.Folders) {
            varDesc = VariableDescriptor.Folders(key, varRole);
        }
        if (varType == VariableType.Range) {
            varDesc = VariableDescriptor.Range(key, varRole);
        }
        if (varType == VariableType.SelectionList) {
            varDesc = VariableDescriptor.SelectionList(key, varRole);
        }
        if (varType == VariableType.MultiSelectionList) {
            varDesc = VariableDescriptor.MultiSelectionList(key, varRole);
        }
        if (varType == VariableType.Checked) {
            varDesc = VariableDescriptor.Checked(key, varRole);
        }
        if (varType == VariableType.String) {
            varDesc = VariableDescriptor.String(key, varRole);
        }
        if (varType == VariableType.Int) {
            varDesc = VariableDescriptor.Int(key, varRole);
        }
        if (varType == VariableType.Strings) {
            varDesc = VariableDescriptor.Strings(key, varRole);
        }
        if (varType == VariableType.Double) {
            varDesc = VariableDescriptor.Double(key, varRole);
        }
        return varDesc;
    }

    public VariableDescriptor(String key) {
        ++__Count;
        this.key = key;
        this.variableName = key;
    }

    public VariableDescriptor(String key, VariableRole varRole) {
        this(key);
        this.varRole = varRole;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String k) {
        this.key = k;
    }

    public VariableRole getVarRole() {
        return this.varRole;
    }

    public VariableType getVarType() {
        return this.varType;
    }

    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public VariableDescriptor setVariableName(String varName) {
        this.variableName = varName;
        return this;
    }

    public VariableDescriptor setDefaultValue(String val) {
        this.defaultValue = val;
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public ArrayList<VariablesRule> getRules() {
        return this.rules;
    }

    public void addRule(VariablesRule variablesRule) {
        this.rules.add(variablesRule);
    }

    public boolean hasRules() {
        return this.rules.size() > 0;
    }

    public boolean hasActions() {
        return this.actions.size() > 0;
    }

    public boolean hasEnableActions() {
        return this.hasEnableAction;
    }

    public void addAction(VariablesRule variablesRule) {
        this.actions.add(variablesRule);
        if (variablesRule.getAction() == VariablesRule.Action.Enable) {
            this.hasEnableAction = true;
        }
    }

    public VariableDescriptor setHelpMsg(String hMsg) {
        this.helpMsg = hMsg;
        return this;
    }

    @Override
    public VariableDescriptor setShortHelpMsg(String shortHelpMsg) {
        this.shortHelpMsg = shortHelpMsg;
        return this;
    }

    public String getHelpMsg() {
        return this.helpMsg;
    }

    public String getShortHelpMsg() {
        return this.shortHelpMsg;
    }

    public void setCommandParamaterSep(String sep) {
        this.commandParamaterSep = sep;
    }

    @Override
    public String getCommandParamaterSep() {
        return this.commandParamaterSep;
    }

    public VariableDescriptor setCommandParamater(String paramater) {
        this.commandParamater = paramater;
        return this;
    }

    public VariableDescriptor setCommandParamaterAlt(String paramaterAlt) {
        this.commandParamaterAlt = paramaterAlt;
        return this;
    }

    public String getHelpMsgAll() {
        String msg = this.helpMsg;
        return msg;
    }

    @Override
    public VariableDescriptor setVariableGroup(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public boolean hasGroup() {
        return this.groupName != null && !this.groupName.isEmpty();
    }

    public String getVarGroup() {
        return this.groupName;
    }

    @Override
    public String getCommandParamater() {
        return this.commandParamater;
    }

    @Override
    public String getCommandParamaterAlt() {
        return this.commandParamaterAlt;
    }

    public FileFormatInfo getAcceptedFileFormatInfo(String fileFormat) {
        if (this.acceptedFileFormatInfo != null && this.acceptedFileFormatInfo.containsKey(fileFormat)) {
            return this.acceptedFileFormatInfo.get(fileFormat);
        }
        FileFormatInfo info = new FileFormatInfo();
        info.fileFormatName = fileFormat;
        info.isPaired = false;
        info.showPairingOptions = false;
        info.title1 = this.getVariableName();
        info.title2 = this.getVariableName();
        return info;
    }

    public FileFormatInfo addAcceptedFileFormat(String fileFormat) {
        if (this.acceptedFileFormatInfo == null) {
            this.acceptedFileFormatInfo = new HashMap();
        }
        FileFormatInfo info = new FileFormatInfo();
        info.fileFormatName = fileFormat;
        info.isPaired = false;
        info.showPairingOptions = false;
        info.title1 = this.getVariableName();
        info.title2 = this.getVariableName();
        this.acceptedFileFormatInfo.put(fileFormat, info);
        return info;
    }

    public FileFormatInfo addAcceptedFileFormat(String fileFormat, boolean isPaired, boolean showPairningOptions, String title1, String title2) {
        FileFormatInfo info = this.addAcceptedFileFormat(fileFormat);
        info.isPaired = isPaired;
        info.showPairingOptions = showPairningOptions;
        info.title1 = title1;
        info.title2 = title2;
        return info;
    }

    public FileFormatInfo addAcceptedFileFormat(String fileFormat, boolean isPaired, String showPairningOptionsMsg, String title1, String title2) {
        FileFormatInfo info = this.addAcceptedFileFormat(fileFormat);
        info.isPaired = isPaired;
        info.showPairingOptions = true;
        info.PairningOptionsMsg = showPairningOptionsMsg;
        info.title1 = title1;
        info.title2 = title2;
        return info;
    }

    public FileFormatInfo addAcceptedFileFormat(String fileFormat, boolean isPaired, boolean showPairningOptions) {
        FileFormatInfo info = this.addAcceptedFileFormat(fileFormat);
        info.isPaired = isPaired;
        info.showPairingOptions = showPairningOptions;
        info.title1 = this.getVariableName() + " 1";
        info.title2 = this.getVariableName() + " 2";
        return info;
    }

    public FileFormatInfo addAcceptedFileFormat(String fileFormat, boolean isPaired) {
        FileFormatInfo info = this.addAcceptedFileFormat(fileFormat);
        info.isPaired = isPaired;
        info.showPairingOptions = false;
        info.title1 = this.getVariableName() + " 1";
        info.title2 = this.getVariableName() + " 2";
        return info;
    }

    public FileFormatInfo addAcceptedFileFormat(String fileFormat, boolean isPaired, String title1, String title2) {
        FileFormatInfo info = this.addAcceptedFileFormat(fileFormat);
        info.isPaired = isPaired;
        info.showPairingOptions = false;
        info.title1 = title1;
        info.title2 = title2;
        return info;
    }

    public ArrayList<String> getAcceptedFileTypes() {
        ArrayList<String> acceptedFileTypes = new ArrayList<String>();
        if (this.acceptedFileFormatInfo != null) {
            acceptedFileTypes.addAll(this.acceptedFileFormatInfo.keySet());
        }
        return acceptedFileTypes;
    }

    public String getDefaultFileFormat() {
        ArrayList<String> acceptedFileTypes = this.getAcceptedFileTypes();
        if (acceptedFileTypes != null && acceptedFileTypes.size() > this.defualtFileFomatIndex) {
            return acceptedFileTypes.get(this.defualtFileFomatIndex);
        }
        return "";
    }

    public VariableDescriptor setGUIVisible(boolean b) {
        this.guiVisible = b;
        return this;
    }

    public boolean getGUIVisible() {
        return this.guiVisible;
    }

    public boolean getIsTracked() {
        return this.isTracked;
    }

    public void setIsTracked(boolean isTracked) {
        this.isTracked = isTracked;
    }

    public void addSampleResources(String sampleName, String diplayName) {
        this.samplesResources.add(sampleName);
        this.samplesResourcesDisplyName.put(sampleName, diplayName);
    }

    public ArrayList<String> getSampleResources() {
        return this.samplesResources;
    }

    public boolean hasResources() {
        return this.samplesResources.size() > 0;
    }

    public String getSampleResourcesName(String sample) {
        return this.samplesResourcesDisplyName.get(sample);
    }

    @Override
    public VariableDescriptor setSubProgName(String subProgName) {
        this.subProg = subProgName.replace(" ", "_");
        return this;
    }

    public boolean isSubProg() {
        return this.subProg != null;
    }

    public String getSubProgName() {
        return this.subProg;
    }

    public void setIsFileName(boolean isFileName) {
        this.isFileName = isFileName;
    }

    public boolean isFileName() {
        return this.isFileName;
    }

    @Override
    public VariableDescriptor setRecommendedValue(String value) {
        return this;
    }

    public VariableDescriptor setRecommendedValueIndex(int index) {
        return this;
    }

    @Override
    public VariableDescriptor setRecommendationDesc(String recDesc) {
        return this;
    }

    public VariableDescriptor addCustomAction(VariableCustomAction variableCustomAction) {
        if (this.variableCustomActions == null) {
            this.variableCustomActions = new ArrayList<VariableCustomAction>();
        }
        this.variableCustomActions.add(variableCustomAction);
        return this;
    }

    public List<VariableCustomAction> getCustomActions() {
        return this.variableCustomActions;
    }

    public VariableDescriptor setReadOnly(boolean bValue) {
        this.isLocked = bValue;
        return this;
    }

    public boolean isReadOnly() {
        return this.isLocked;
    }

    public VariableDescriptor setIsRequired(boolean isRequired) {
        this.isRequired = isRequired;
        return this;
    }

    public class FileFormatInfo {
        public String PairningOptionsMsg;
        public String fileFormatName;
        public boolean isPaired;
        public boolean showPairingOptions;
        public String title1;
        public String title2;

        public FileFormatInfo createCopy() {
            FileFormatInfo newCopy = new FileFormatInfo();
            newCopy.PairningOptionsMsg = this.PairningOptionsMsg;
            newCopy.fileFormatName = this.fileFormatName;
            newCopy.isPaired = this.isPaired;
            newCopy.showPairingOptions = this.showPairingOptions;
            newCopy.title1 = this.title1;
            newCopy.title2 = this.title2;
            return newCopy;
        }
    }

    public static enum VariableRole {
        Input,
        Output,
        Option,
        Internal,
        NONE;

    }

    public static enum VariableType {
        File,
        Folder,
        Files,
        FileList,
        Folders,
        Range,
        NONE,
        SelectionList,
        MultiSelectionList,
        Checked,
        String,
        Int,
        Strings,
        Double,
        Complex;

    }
}

