/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.descriptors;

import com.biotechvana.workflow.descriptors.VariableDescriptor;
import java.util.ArrayList;
import java.util.HashMap;

public class SelectionListVariableDescriptor
extends VariableDescriptor {
    private int defaultValueIndex = 0;
    private ArrayList<String> optionsValues = new ArrayList();
    private HashMap<String, String> optionsValuesCmdParam = null;
    private HashMap<String, String> optionsValuesHelpMsg = null;

    public SelectionListVariableDescriptor(String key, VariableDescriptor.VariableRole varRole) {
        super(key, varRole);
        this.varType = VariableDescriptor.VariableType.SelectionList;
    }

    public SelectionListVariableDescriptor addOptionValue(String possibleValue) {
        this.optionsValues.add(possibleValue);
        return this;
    }

    public SelectionListVariableDescriptor addOptionValue(String possibleValue, String cmdParamValue, String helpMsg) {
        this.optionsValues.add(possibleValue);
        if (this.optionsValuesCmdParam == null) {
            this.optionsValuesCmdParam = new HashMap();
            this.optionsValuesHelpMsg = new HashMap();
        }
        this.optionsValuesCmdParam.put(possibleValue, cmdParamValue);
        this.optionsValuesHelpMsg.put(possibleValue, helpMsg);
        return this;
    }

    public SelectionListVariableDescriptor clearOptionValues() {
        this.optionsValues.clear();
        if (this.optionsValuesCmdParam != null) {
            this.optionsValuesCmdParam.clear();
            this.optionsValuesCmdParam.clear();
            this.optionsValuesHelpMsg.clear();
            this.optionsValuesCmdParam = null;
            this.optionsValuesHelpMsg = null;
        }
        return this;
    }

    public ArrayList<String> getOptionsValues() {
        return this.optionsValues;
    }

    public SelectionListVariableDescriptor setDefaultIndexValue(int index) {
        if (index < this.optionsValues.size() && index >= 0) {
            this.defaultValueIndex = index;
            this.defaultValue = this.optionsValues.get(index);
        }
        return this;
    }

    public int getDefaultValueIndex() {
        return this.defaultValueIndex;
    }

    public int getOptionValueIndex(String value) {
        return this.optionsValues.indexOf(value);
    }

    public String getOptionValueCmdParamValue(String value) {
        if (this.optionsValuesCmdParam != null) {
            return this.optionsValuesCmdParam.get(value);
        }
        return value;
    }

    public String getOptionValueByCmdParamValue(String cmdParmValue) {
        if (this.optionsValuesCmdParam != null) {
            for (String pValue : this.optionsValues) {
                if (!this.optionsValuesCmdParam.get(pValue).equals(cmdParmValue)) continue;
                return pValue;
            }
        }
        return null;
    }

    public String[] getHelpAvlOptions() {
        if (this.varType == VariableDescriptor.VariableType.SelectionList || this.varType == VariableDescriptor.VariableType.MultiSelectionList) {
            if (this.optionsValuesHelpMsg != null) {
                String[] msgs = new String[this.optionsValues.size()];
                int i = 0;
                while (i < msgs.length) {
                    msgs[i] = this.optionsValues.get(i) + " : " + this.optionsValuesHelpMsg.get(this.optionsValues.get(i));
                    ++i;
                }
                return msgs;
            }
            String[] msgs = new String[this.optionsValues.size()];
            int i = 0;
            while (i < msgs.length) {
                msgs[i] = this.optionsValues.get(i);
                ++i;
            }
            return msgs;
        }
        return null;
    }

    public String getHelpAvlOption(String pValue) {
        if (this.optionsValuesHelpMsg != null) {
            return this.optionsValuesHelpMsg.get(pValue);
        }
        return null;
    }

    public HashMap<String, String> getOptionsValuesCmdParam() {
        return this.optionsValuesCmdParam;
    }
}

