/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.descriptors;

import com.biotechvana.workflow.descriptors.VariableDescriptor;
import java.util.ArrayList;
import java.util.List;

public class DescFilters {

    public static enum FCExpressionOperator {
        Equal("="),
        GreaterThan(">"),
        LessThan("<"),
        GreaterThanOrEqual(">="),
        LessThanOrEqual("<="),
        NotEqual("!=");

        String op;

        private FCExpressionOperator(String op) {
            this.op = op;
        }
    }

    static class JobDescriptorFilter1 {
        String desc;
        String name;
        VariableDescriptor[] inputParameters;
        VariableDescriptor targetVariable;
        VariableDescriptor[] internalParameters;
        VariableDescriptor outputVariable;

        JobDescriptorFilter1() {
        }
    }

    static class JobDescriptorFilter2 {
        String desc;
        String name;
        VariableDescriptor[] inParameters;
        VariableDescriptor targetVariable;

        JobDescriptorFilter2() {
        }
    }

    public static class JobDescriptorFilterBase {
        String desc;
        String name;
        VariableDescriptor targetVariable;
        FCExpressionOperator comparison_operator = FCExpressionOperator.Equal;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setTargetVaraible(VariableDescriptor storeVariable) {
            this.targetVariable = storeVariable;
        }

        public VariableDescriptor getTargetVariable() {
            return this.targetVariable;
        }

        public FCExpressionOperator getComparisonOperator() {
            return this.comparison_operator;
        }

        public void setComparisonOperator(FCExpressionOperator comparison_operator) {
            this.comparison_operator = comparison_operator;
        }
    }

    public static class JobDescriptorFilterExtractor {
        String desc = "";
        String name;
        String cmd_script = "";
        List<VariableDescriptor> inputParameters = new ArrayList<VariableDescriptor>();
        List<VariableDescriptor> internalParameters = new ArrayList<VariableDescriptor>();
        VariableDescriptor inputVariable;
        VariableDescriptor storeVariable;

        public JobDescriptorFilterExtractor(String name) {
            this.name = name;
        }

        public void addArg(VariableDescriptor extractorArg) {
            this.inputParameters.add(extractorArg);
            this.updateGroups();
        }

        public List<VariableDescriptor> getInputParameters() {
            return this.inputParameters;
        }

        public List<VariableDescriptor> getInternalParameters() {
            return this.internalParameters;
        }

        private void updateGroups() {
            for (VariableDescriptor var : this.inputParameters) {
                var.setVariableGroup(this.name);
            }
            for (VariableDescriptor var : this.internalParameters) {
                var.setVariableGroup(this.name);
            }
            if (this.storeVariable != null) {
                this.storeVariable.setVariableGroup(this.name);
            }
        }

        public String getName() {
            return this.name;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setCMDScript(String cmd_script) {
            this.cmd_script = cmd_script;
        }

        public String getCMDScript() {
            return this.cmd_script;
        }

        public void createStoreVariable(VariableDescriptor.VariableType d) {
            this.storeVariable = VariableDescriptor.createDescriptorFor("FILTER_OPT_QP", VariableDescriptor.VariableType.Double, VariableDescriptor.VariableRole.Output);
            this.storeVariable.setVariableName("Percent of Positions with Q quality score - PQ ");
            this.storeVariable.setHelpMsg("Percent of Positions QP that should have min quality score of Q");
            this.storeVariable.setCommandParamater("--pq");
        }

        public void setStoreVariable(VariableDescriptor storeVariable) {
            this.storeVariable = storeVariable;
        }

        public VariableDescriptor getStoreVariable() {
            return this.storeVariable;
        }

        public VariableDescriptor getInputVariable() {
            return this.inputVariable;
        }

        public void setInputVariable(VariableDescriptor varOutputFiles) {
            this.inputVariable = varOutputFiles;
        }
    }

    static class JobDescriptorFilterStatus {
        String desc;
        String name;
        VariableDescriptor targetVariable;

        JobDescriptorFilterStatus() {
        }
    }

    public static class JobDescriptorStatusFilter
    extends JobDescriptorFilterBase {
        String status_value;

        public void setStatusValue(String status_value) {
            this.status_value = status_value;
        }

        public String getStatusValue() {
            return this.status_value;
        }
    }

    public static class JobDescriptorThresholdFilter
    extends JobDescriptorFilterBase {
        VariableDescriptor thresholdVariable;

        public void setThresholdVariable(VariableDescriptor threshold_variable) {
            this.thresholdVariable = threshold_variable;
        }

        public VariableDescriptor getThresholdVariable() {
            return this.thresholdVariable;
        }
    }
}

