/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow;

import com.biotechvana.workflow.IValidationResult;
import org.eclipse.core.runtime.Assert;

public class ValidationResult
implements IValidationResult {
    public static final ValidationResult Valid_RESULT = new ValidationResult(0, 0, "Valid", null);
    private static final IValidationResult[] theEmptyArray = new IValidationResult[0];
    private String message = "";
    private int code = 0;
    private Throwable exception = null;
    private int severity = 0;

    public ValidationResult(int severity, int code, String message) {
        this.setSeverity(severity);
        this.setCode(code);
        this.setMessage(message);
    }

    public ValidationResult(int severity, int code, String message, Throwable exception) {
        this.setSeverity(severity);
        this.setCode(code);
        this.setMessage(message);
        this.setException(exception);
    }

    protected void setSeverity(int severity) {
        Assert.isLegal((severity == 0 || severity == 4 || severity == 2 || severity == 1 || severity == 8 ? 1 : 0) != 0);
        this.severity = severity;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ValidationResult ");
        if (this.severity == 0) {
            buf.append("OK");
        } else if (this.severity == 4) {
            buf.append("ERROR");
        } else if (this.severity == 2) {
            buf.append("WARNING");
        } else if (this.severity == 1) {
            buf.append("INFO");
        } else if (this.severity == 8) {
            buf.append("CANCEL");
        } else {
            buf.append("severity=");
            buf.append(this.severity);
        }
        buf.append(": ");
        buf.append(" code=");
        buf.append(this.code);
        buf.append(' ');
        buf.append(this.message);
        buf.append(' ');
        return buf.toString();
    }

    @Override
    public IValidationResult[] getChildren() {
        return theEmptyArray;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    @Override
    public boolean isMultiValidation() {
        return false;
    }

    @Override
    public boolean isOK() {
        return this.severity == 0;
    }

    @Override
    public boolean matches(int severityMask) {
        return (this.severity & severityMask) != 0;
    }

    protected void setCode(int code) {
        this.code = code;
    }

    protected void setException(Throwable exception) {
        this.exception = exception;
    }

    protected void setMessage(String message) {
        this.message = message == null ? "" : message;
    }

    public void appendMessage(String message) {
        this.message = message == null ? message : String.valueOf(this.message) + message;
    }
}

