/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow;

import com.biotechvana.commons.ftpservice.IRemoteFile;
import com.biotechvana.commons.model.FTPHelper;
import com.biotechvana.pipelinestools.utils.PipelineExecutor;
import com.biotechvana.pipelinestools.utils.PipelineUtils;
import com.biotechvana.users.UserManager;
import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.submissionhistory.SubmissionHistory;
import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.biotechvana.workflow.tracking.ITrackerInfo;
import com.biotechvana.workflow.tracking.TrackerInfoEntry;
import com.biotechvana.workflow.tracking.events.InfoTrackEvent;
import com.biotechvana.workflow.variables.JobVariable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import jakarta.inject.Inject;
import java.awt.Desktop;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmissionHistoryManager {
    static Logger LOG = LoggerFactory.getLogger(SubmissionHistoryManager.class);
    static int connectionTimeOut = 300000;
    public static String HISTORY_FILE_NAME = "hist.hist";
    private SubmissionHistory userHistory = new SubmissionHistory(this);
    private UserManager userManager;
    @Inject
    private FTPHelper ftpManager;
    @Inject
    private IWorkflowManager workflowManager;

    public void deleteEntry(Collection<SubmissionHistoryEntry> entries) {
        Object cmd = "";
        String varTaskIds = "varTaskIds";
        String varSubmissionDates = "varSubmissionDates";
        String varTaskNames = "varTaskNames";
        String varTaskTypes = "varTaskTypes";
        for (SubmissionHistoryEntry entry : entries) {
            cmd = (String)cmd + BashHelper.arrayAdd(varTaskIds, entry.getTaskTemplateId()) + "\n";
            cmd = (String)cmd + BashHelper.arrayAdd(varSubmissionDates, "" + entry.getSubmissionTimeStamp()) + "\n";
            cmd = (String)cmd + BashHelper.arrayAdd(varTaskNames, entry.getTaskName()) + "\n";
            cmd = entry.getTaskType() == SubmissionHistoryEntry.TaskType.Pipeline ? (String)cmd + BashHelper.arrayAdd(varTaskTypes, " -p ") + "\n" : (String)cmd + BashHelper.arrayAdd(varTaskTypes, "") + "\n";
        }
        cmd = (String)cmd + BashHelper.forIndex("i", "${#" + varTaskIds + "[@]}", "i++", "/home/gpro/gpro_bin/gpro_JobControl.sh -a remove    -t  ${" + varTaskIds + "[$i]}  -s  ${" + varSubmissionDates + "[$i]}  -n  ${" + varTaskNames + "[$i]}      ${" + varTaskTypes + "[$i]}  -m " + this.userManager.getModuleId() + " \n ");
        PipelineExecutor.runCommandWithHTTP(this.userManager, (String)cmd, "", "", ".temp_command");
        for (SubmissionHistoryEntry entry : entries) {
            try {
                String trackFileName = String.valueOf(this.userManager.getLocalPathManager().getTrackFolder()) + "/" + entry.getTaskName() + "_" + entry.getSubmissionTimeStamp() + ".track";
                File trackFile = new File(trackFileName);
                trackFile.delete();
                if (entry.getTaskType() == SubmissionHistoryEntry.TaskType.Pipeline) {
                    this.workflowManager.delete(entry.getTaskTemplateId(), entry.getTaskName());
                    String logDirName = String.valueOf(this.userManager.getLocalPathManager().getLogFolder()) + "/" + entry.getTaskName() + "_" + entry.getSubmissionTimeStamp();
                    File logDir = new File(logDirName);
                    File[] fileArray = logDir.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File logFile = fileArray[n2];
                        logFile.delete();
                        ++n2;
                    }
                    logDir.delete();
                    continue;
                }
                String logFileName = String.valueOf(this.userManager.getLocalPathManager().getLogFolder()) + "/" + entry.getTaskName() + "_" + entry.getSubmissionTimeStamp() + ".log";
                File logFile = new File(logFileName);
                logFile.delete();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void deleteEntry(SubmissionHistoryEntry entry) {
        ArrayList<SubmissionHistoryEntry> enties = new ArrayList<SubmissionHistoryEntry>();
        enties.add(entry);
        this.deleteEntry(enties);
    }

    public void downloadLogFile(SubmissionHistoryEntry entry) {
        if (entry.getTaskType() == SubmissionHistoryEntry.TaskType.Job) {
            try {
                IRemoteFile iRemoteFile2;
                Object remoteFileName = entry.getScriptFolderPath() + "/" + entry.getTaskTemplateId() + "_log";
                remoteFileName = PipelineUtils.sanitizeFTPFilePath(this.userManager.getHostPathManager().getUserHomePath(), (String)remoteFileName, this.userManager.getIsChRooted());
                boolean firstAttempt = false;
                boolean skipDown = true;
                try {
                    iRemoteFile2 = this.ftpManager.getFTPManager().resolveRemoteFile((String)remoteFileName);
                    if (iRemoteFile2.exists() && iRemoteFile2.getFileSize() > 0L) {
                        firstAttempt = true;
                        skipDown = false;
                    }
                }
                catch (IOException iRemoteFile2) {
                    // empty catch block
                }
                if (!firstAttempt) {
                    remoteFileName = this.ftpPath(this.userManager.getHostPathManager().getRemoteAppLogFolder() + entry.getTaskName() + "_" + entry.getSubmissionTimeStamp() + ".log");
                    try {
                        iRemoteFile2 = this.ftpManager.getFTPManager().resolveRemoteFile((String)remoteFileName);
                        if (iRemoteFile2.exists() && iRemoteFile2.getFileSize() > 0L) {
                            skipDown = false;
                        }
                    }
                    catch (IOException iRemoteFile3) {
                        // empty catch block
                    }
                }
                if (!skipDown) {
                    String fileName = String.valueOf(this.userManager.getLocalPathManager().getLogFolder()) + "/" + entry.getTaskName() + "_" + entry.getSubmissionTimeStamp() + ".log";
                    File destination = this.userManager.getLocalPathManager().getLogFolder();
                    this.ftpManager.downloadFile((String)remoteFileName, destination.getAbsolutePath());
                    File localFile = new File(String.valueOf(this.userManager.getLocalPathManager().getLogFolder()) + "/" + entry.getTaskTemplateId() + "_log");
                    if (localFile.exists()) {
                        localFile.renameTo(new File(fileName));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                LOG.debug("Can not get log file for " + String.valueOf(entry), (Throwable)e);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LOG.debug("Can not get log file for " + String.valueOf(entry), (Throwable)ex);
            }
        } else {
            File logFolder = this.userManager.getLocalPathManager().getLogFolder();
            File projectLogFoler = new File(String.valueOf(logFolder) + "/" + entry.getTaskName() + "_" + entry.getSubmissionTimeStamp());
            if (!projectLogFoler.exists()) {
                boolean skipDown = projectLogFoler.mkdir();
            }
            Object workflowFolder = entry.getScriptFolderPath();
            workflowFolder = PipelineUtils.sanitizeFTPFilePath(this.userManager.getHostPathManager().getUserHomePath(), (String)workflowFolder, this.userManager.getIsChRooted());
            String remoteMainLogName = (String)workflowFolder + "/" + entry.getTaskName() + "_log";
            try {
                IRemoteFile iRemoteFile = this.ftpManager.getFTPManager().resolveRemoteFile(remoteMainLogName);
                if (iRemoteFile.exists() && iRemoteFile.getFileSize() > 0L) {
                    this.ftpManager.downloadFile(projectLogFoler.getAbsolutePath(), remoteMainLogName);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
                LOG.debug("Can not get log file for " + String.valueOf(entry), (Throwable)e1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LOG.debug("Can not get log file for " + String.valueOf(entry), (Throwable)ex);
            }
            workflowFolder = (String)workflowFolder + "/" + entry.getTaskName();
            ArrayList<CallSite> logsFiles = new ArrayList<CallSite>();
            try {
                IRemoteFile[] remoteFtpFiles;
                IRemoteFile[] iRemoteFileArray = remoteFtpFiles = this.ftpManager.getFTPManager().listFiles((String)workflowFolder);
                int n = remoteFtpFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IRemoteFile remoteFtpFile = iRemoteFileArray[n2];
                    if (remoteFtpFile.isFolder()) {
                        IRemoteFile[] remoteFtpSubFiles;
                        IRemoteFile[] iRemoteFileArray2 = remoteFtpSubFiles = this.ftpManager.getFTPManager().listFiles(remoteFtpFile.getPath());
                        int n3 = remoteFtpSubFiles.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IRemoteFile remoteFtpSubFile = iRemoteFileArray2[n4];
                            if (remoteFtpSubFile.getName().endsWith("_log")) {
                                LOG.info(" downloading Log " + remoteFtpSubFile.getName());
                                logsFiles.add((CallSite)((Object)((String)workflowFolder + "/" + remoteFtpFile.getName() + "/" + remoteFtpSubFile.getName())));
                                this.ftpManager.downloadFile(remoteFtpSubFile, projectLogFoler.getAbsolutePath());
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
                LOG.debug("Can not get log file for " + String.valueOf(entry), (Throwable)e1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LOG.debug("Can not get log file for " + String.valueOf(entry), (Throwable)ex);
            }
        }
    }

    public void downloadTrackFile(SubmissionHistoryEntry entry) {
        LOG.info("Start downloading track file " + String.valueOf(entry));
        String remoteFileName = this.ftpPath(this.userManager.getHostPathManager().getRemoteAppTrackFolder() + entry.getTaskName() + "_" + entry.getSubmissionTimeStamp() + ".track");
        String destination = this.userManager.getLocalPathManager().getTrackFolder().getAbsolutePath();
        try {
            IRemoteFile iRemoteFile = this.ftpManager.getFTPManager().resolveRemoteFile(remoteFileName);
            if (iRemoteFile.exists() && iRemoteFile.getFileSize() > 0L) {
                this.ftpManager.downloadFile(iRemoteFile, destination);
            }
            LOG.info("Finished downloading track file " + String.valueOf(entry));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOG.info("Can not find track file " + String.valueOf(entry), (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.info("Can not download track file " + String.valueOf(entry), (Throwable)e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOG.info("Can not download track file " + String.valueOf(entry), (Throwable)ex);
        }
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    @Inject
    @Optional
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public SubmissionHistory getUserSubmissionHistory() {
        return this.userHistory;
    }

    public SubmissionHistory loadCurrentUserHistory() {
        return this.loadCurrentUserHistory(false, false);
    }

    public SubmissionHistory loadCurrentUserHistory(boolean userChanged, boolean localOnly) {
        SubmissionHistory userHist = null;
        if (userHist == null) {
            userHist = new SubmissionHistory(this);
            boolean needUpdate = this.downloadHistFile(this.userHistory);
            userHist.updateEntries(localOnly);
        }
        this.userHistory = userHist;
        return userHist;
    }

    public void pasueEntry(SubmissionHistoryEntry entry) {
        try {
            Object cmd = "";
            cmd = "/home/gpro/gpro_bin/gpro_JobControl.sh -a pause -pid " + entry.getTrackInfo().getScriptPID() + " -s " + entry.getSubmissionTimeStamp() + " -n " + entry.getTaskName() + " \n";
            System.out.println((String)cmd);
            PipelineExecutor.runCommandWithHTTP(this.userManager, (String)cmd, "", "", ".temp_command");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void resumeEntry(SubmissionHistoryEntry entry) {
        try {
            Object cmd = "";
            cmd = "/home/gpro/gpro_bin/gpro_JobControl.sh -a resume -pid " + entry.getTrackInfo().getScriptPID() + " -s " + entry.getSubmissionTimeStamp() + " -n " + entry.getTaskName() + " \n";
            System.out.println((String)cmd);
            PipelineExecutor.runCommandWithHTTP(this.userManager, (String)cmd, "", "", ".temp_command");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean saveUserHistoryToDisk() {
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
        File userPath = this.userManager.getLocalPathManager().getModuleFolder();
        String histLocalStoreFile = "hist.store";
        LOG.debug("Saving user history to disk");
        Path filePath = userPath.toPath().resolve(histLocalStoreFile);
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try {
                FileOutputStream fos = new FileOutputStream(filePath.toFile());
                try {
                    try (FileChannel fileChannel = fos.getChannel();){
                        fileChannel.lock();
                        Throwable throwable2 = null;
                        Object var10_16 = null;
                        try (BufferedWriter br = new BufferedWriter(new FileWriter(filePath.toFile()));){
                            br.write(gson.toJson((Object)this.userHistory));
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    if (fos == null) return true;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return true;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                } else {
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void stopEntry(SubmissionHistoryEntry entry) {
        try {
            Object cmd = "";
            cmd = "/home/gpro/gpro_bin/gpro_JobControl.sh -a stop -pid " + entry.getTrackInfo().getScriptPID() + " -s " + entry.getSubmissionTimeStamp() + " -n " + entry.getTaskName() + " -f " + entry.getScriptFilePath() + " -m " + this.userManager.getModuleId() + " \n";
            System.out.println((String)cmd);
            PipelineExecutor.runCommandWithHTTP(this.userManager, (String)cmd, "", "", ".temp_command");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sync() {
        boolean needUpdate = this.downloadHistFile(this.userHistory);
        this.userHistory.updateEntries(false);
    }

    public boolean viewReport(SubmissionHistoryEntry entry) {
        return this.viewReport(entry, null);
    }

    public boolean viewReport(SubmissionHistoryEntry entry, IProgressMonitor statusProgressMoniter) {
        String reportFile = this.ftpPath(entry.getScriptFolderPath() + "/report.html");
        if (statusProgressMoniter != null) {
            statusProgressMoniter.beginTask("View Report", -1);
        }
        String destination = this.userManager.getLocalPathManager().getReportFolder().getAbsolutePath();
        try {
            boolean reportDownloaded = this.ftpManager.downloadFile(reportFile, destination);
            if (reportDownloaded && Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI("file://" + destination + "/report.html"));
            }
            boolean bl = reportDownloaded;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        finally {
            if (statusProgressMoniter != null) {
                statusProgressMoniter.done();
            }
        }
        return false;
    }

    private boolean downloadHistFile(SubmissionHistory subHistory) {
        File destination = this.userManager.getLocalPathManager().getModuleFolder();
        File localHistFile = new File(String.valueOf(destination) + "/" + HISTORY_FILE_NAME);
        boolean download = false;
        long remoteFileLastTimeModifed = 0L;
        if (!localHistFile.exists()) {
            download = true;
        }
        try {
            localHistFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String remoteHistFile = this.ftpPath(this.userManager.getHostPathManager().getRemoteUserHistoryFile());
        try {
            String historyFileName = this.ftpPath(this.userManager.getHostPathManager().getRemoteAppUserFolder() + "/" + HISTORY_FILE_NAME);
            IRemoteFile historyRemoteFile = this.ftpManager.getFTPManager().resolveRemoteFile(historyFileName);
            if (historyRemoteFile.exists()) {
                remoteFileLastTimeModifed = historyRemoteFile.getLastModifiedTime();
                download = true;
            } else {
                download = false;
            }
            if (remoteFileLastTimeModifed == 0L) {
                download = false;
            }
            if (download) {
                LOG.debug("Downloading History File destination:" + destination.getAbsolutePath() + " remoteFiles:" + historyRemoteFile.getName());
                this.ftpManager.downloadFile(historyRemoteFile, destination.getAbsolutePath());
                subHistory.setlastTimeUpdates(remoteFileLastTimeModifed);
                return true;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private String ftpPath(String remotePath) {
        return PipelineUtils.sanitizeFTPFilePath(this.userManager.getHostPathManager().getUserHomePath(), remotePath, this.userManager.getIsChRooted());
    }

    public WorkflowJob createJobInstance(SubmissionHistoryEntry entry) {
        String taskTemplateId = entry.getTaskTemplateId();
        String taskIntenalId = entry.getTaskInternalId();
        WorkflowJob job = this.workflowManager.getJobsCatalog().createJobInstanceById(taskTemplateId, new Object[0]);
        job.setJobId(taskIntenalId);
        for (ITrackerInfo info : entry.getTrackInfo().getTrackerInfoEntries()) {
            String varKeyValue;
            String[] tokens;
            if (!(info instanceof TrackerInfoEntry) || ((TrackerInfoEntry)info).getEventtype() != Tracking.TrackEventType.Info || ((InfoTrackEvent)info).getInfoType() == Tracking.TrackInfoType.Process || (tokens = (varKeyValue = info.getLogMsg()).split("=")).length <= 1) continue;
            String varFullKey = tokens[0];
            String varValue = tokens[1];
            if (!varFullKey.contains(".")) continue;
            String[] varKeys = varFullKey.split("\\.");
            JobVariable var = job.getVariable(varKeys[1]);
            if (var == null) {
                WorkflowJob.createPrevoiusJobNameVar(job);
                var = job.getVariable(varKeys[1]);
            }
            varValue = varValue.replace(";", "\n");
            if (var == null) {
                LOG.debug(varFullKey + " Variable does not exist in the current JobDesc, will create one for temporary hold");
                job.setValue(varKeys[1], varValue);
                continue;
            }
            var.setValue(varValue);
        }
        return job;
    }

    public SubmissionHistoryEntry getEntry(String entryId) {
        return this.userHistory.getEntry(entryId);
    }
}

