/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.pipelinestools.utils;

import com.biotechvana.pipelineCommander.PipelineCommander;
import com.biotechvana.users.UserManager;
import com.biotechvana.utils.IPrefs;
import com.biotechvana.utils.WorkspaceUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class PipelineUtils {
    public static String[] getBlastSystemDatabases(UserManager userManager) {
        ArrayList<String> listDbs = new ArrayList<String>();
        Pattern p = Pattern.compile("<li>(.+)</li>");
        try {
            URL url = new URL(userManager.get("ssh_host", "biotechvana.uv.es") + userManager.get("/gpro/gpro/blastdblist.php", ""));
            try {
                String linea;
                URLConnection connection = url.openConnection();
                connection.setConnectTimeout(15000);
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((linea = in.readLine()) != null) {
                    Matcher m = p.matcher(linea);
                    if (!m.find()) continue;
                    listDbs.add(m.group(1));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return listDbs.toArray(new String[listDbs.size()]);
    }

    public static String[] getHmmSystemDatabases(UserManager userManager) {
        ArrayList<String> listDbs = new ArrayList<String>();
        Pattern p = Pattern.compile("<li>(.+)</li>");
        try {
            URL url = new URL(userManager.get("ssh_host", "biotechvana.uv.es") + userManager.get("/gpro/gpro/hmmdblist.php", ""));
            try {
                String linea;
                URLConnection connection = url.openConnection();
                connection.setConnectTimeout(15000);
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((linea = in.readLine()) != null) {
                    Matcher m = p.matcher(linea);
                    if (!m.find()) continue;
                    listDbs.add(m.group(1));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return listDbs.toArray(new String[listDbs.size()]);
    }

    public static void importSystemDatabase(UserManager userManager, String databaseName, String databaseFolder) {
        try {
            String username = userManager.get("ssh_user", "");
            String password = userManager.get("ssh_password", "");
            if (username == null || username.length() == 0 || password == null || password.length() == 0) {
                MessageDialog.openWarning((Shell)WorkspaceUtils.getShell(), (String)"Import system database", (String)"Failed imorting database. Please, contact administrator");
                return;
            }
            StringBuilder command = new StringBuilder();
            command.append("ln -s " + databaseName + " " + databaseFolder);
            PipelineCommander pipelineCommander = new PipelineCommander(userManager.get("ssh_host", "biotechvana.uv.es"), (IPrefs)userManager);
            OutputStreamWriter output = new OutputStreamWriter(System.out);
            pipelineCommander.prepareCommandRequest(username, password, command.toString(), true, userManager.get("email", ""), false);
            pipelineCommander.postPipelineRequest((Writer)output);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            MessageDialog.openWarning((Shell)WorkspaceUtils.getShell(), (String)"Import system database", (String)"Failed imorting database. Please, contact administrator");
        }
    }

    public static String getEvalueString(String expect) {
        double doubleExpect = 1.0E-4;
        String stringExpect = null;
        if (expect.isEmpty()) {
            doubleExpect = 1.0E-4;
        } else {
            try {
                doubleExpect = Double.parseDouble(expect);
            }
            catch (Exception ex) {
                return null;
            }
        }
        try {
            DecimalFormat formatter = new DecimalFormat("0.##E0");
            stringExpect = formatter.format(doubleExpect);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return stringExpect;
    }

    public static void main(String[] args) {
    }

    public static String sanitizeFilePath(String userHomePath, String filePath) {
        if (!((String)filePath).startsWith(userHomePath)) {
            filePath = userHomePath + (String)filePath;
        }
        filePath = ((String)filePath).replaceAll("/{2,}", "/");
        return filePath;
    }

    public static String unSanitizeFilePath(String userHomePath, String filePath) {
        System.out.println("userhomepath: " + userHomePath + " " + filePath);
        if (filePath.startsWith(userHomePath)) {
            filePath = filePath.replaceFirst(userHomePath, "");
        }
        filePath = filePath.replaceAll("/{2,}", "/");
        return filePath;
    }

    public static String sanitizeFilePathOld(UserManager userManager, String filePath) {
        String fullHome;
        String homePrefix = userManager.get("ssh_home_prefix", "");
        String username = userManager.get("ssh_user", "");
        if (homePrefix.charAt(0) == '/') {
            homePrefix.substring(1);
        }
        if (homePrefix.charAt(homePrefix.length() - 1) == '/') {
            homePrefix.substring(0, homePrefix.length() - 1);
        }
        if (((String)filePath).indexOf(fullHome = "/" + homePrefix + "/" + username + "/") == 0) {
            filePath = ((String)filePath).substring(fullHome.length());
        }
        if (((String)filePath).charAt(0) == '/') {
            filePath = ((String)filePath).substring(1);
        }
        filePath = fullHome + (String)filePath;
        filePath = ((String)filePath).replaceAll("/{2,}", "/");
        return filePath;
    }

    public static String sanitizeString(String text) {
        return text.replace(" ", "_");
    }

    public static String sanitizeFilePathWithTelda(String userHomePath, String filePath, boolean isChrooted) {
        if (!isChrooted) {
            return filePath;
        }
        if (!filePath.startsWith(userHomePath) && !filePath.startsWith("$HOME")) {
            if (filePath.isEmpty()) {
                return "$HOME";
            }
            if (filePath.charAt(0) == '/') {
                filePath = filePath.substring(1);
            }
            return "$HOME/" + filePath;
        }
        return filePath;
    }

    public static String sanitizeFTPFilePath(String userHomePath, String filePath, boolean isChrooted) {
        if (isChrooted && filePath.startsWith(userHomePath)) {
            return filePath.replaceFirst(userHomePath, "");
        }
        return filePath;
    }
}

