/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.layer.xml.impl;

import com.biotechvana.layer.xml.XMLLayer;
import com.biotechvana.workflow.CmdListMergeStrategy;
import com.biotechvana.workflow.descriptors.CheckedVariableDescriptor;
import com.biotechvana.workflow.descriptors.DescFilters;
import com.biotechvana.workflow.descriptors.DoubleVariableDescriptor;
import com.biotechvana.workflow.descriptors.FileVariableDescriptor;
import com.biotechvana.workflow.descriptors.FilesVariableDescriptor;
import com.biotechvana.workflow.descriptors.FolderVariableDescriptor;
import com.biotechvana.workflow.descriptors.FoldersVariableDescriptor;
import com.biotechvana.workflow.descriptors.GroupVariableDescriptor;
import com.biotechvana.workflow.descriptors.IntVariableDescriptor;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.JobLink;
import com.biotechvana.workflow.descriptors.ListVariableDescriptor;
import com.biotechvana.workflow.descriptors.MultiSelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.NumVariableDescriptor;
import com.biotechvana.workflow.descriptors.PairedFilesVariableDescriptor;
import com.biotechvana.workflow.descriptors.Publication;
import com.biotechvana.workflow.descriptors.RangeVariableDescriptor;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.StringVariableDescriptor;
import com.biotechvana.workflow.descriptors.StringsVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLLayerImpl
implements XMLLayer {
    @Override
    public void saveToXML(JobDescriptor job, String outPath) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Element v = null;
        Element vrs = null;
        Object af = null;
        Object ff = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.newDocument();
            Element jobEle = dom.createElement("jobDescriptor");
            jobEle.setAttribute("id", job.jobId);
            jobEle.setAttribute("desc", job.getDesc());
            if (job.getToolGroup() != null) {
                jobEle.setAttribute("tool_group", job.getToolGroup());
            }
            if (job.getVersion() != null) {
                jobEle.setAttribute("version", job.getVersion());
                if (job.isLatestVersion()) {
                    jobEle.setAttribute("latest", String.valueOf(job.isLatestVersion()));
                }
            }
            this.getReference(job, jobEle);
            this.addPublication(dom, jobEle, job);
            this.addLinks(dom, jobEle, job);
            vrs = dom.createElement("variables");
            Collection<VariableDescriptor> variables = job.getAllVariables();
            for (VariableDescriptor var : variables) {
                v = this.createVariableElm(dom, var);
                vrs.appendChild(v);
            }
            jobEle.appendChild(vrs);
            dom.appendChild(jobEle);
            this.addExtractors(dom, jobEle, job);
            this.addFilters(dom, jobEle, job);
            this.addCLITools(dom, jobEle, job);
            try {
                Transformer tr = TransformerFactory.newInstance().newTransformer();
                tr.setOutputProperty("indent", "yes");
                tr.setOutputProperty("method", "xml");
                tr.setOutputProperty("encoding", "UTF-8");
                tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                tr.transform(new DOMSource(dom), new StreamResult(new FileOutputStream(outPath)));
            }
            catch (TransformerException te) {
                System.out.println(te.getMessage());
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
        }
        catch (ParserConfigurationException pce) {
            System.out.println("UsersXML: Error trying to instantiate DocumentBuilder " + String.valueOf(pce));
        }
    }

    private Element createVariableElm(Document dom, VariableDescriptor var) {
        ArrayList<String> sampleResources;
        Element ff;
        Element af;
        ArrayList<String> acceptedFileTypes;
        Element v = dom.createElement(var.getVarType().toString() + "Var");
        v.setAttribute("key", var.getKey());
        v.setAttribute("name", var.getVariableName());
        if (var.getDefaultValue() != "") {
            v.setAttribute("defaultVal", var.getDefaultValue());
        }
        if (var.isRequired) {
            v.setAttribute("isRequired", String.valueOf(var.isRequired));
        }
        v.setAttribute("type", var.getVarType().toString());
        v.setAttribute("role", var.getVarRole().toString());
        if (var.getHelpMsg() != null) {
            v.setAttribute("helpMsg", var.getHelpMsg());
        }
        if (var.getShortHelpMsg() != null) {
            v.setAttribute("shortHelpMsg", var.getShortHelpMsg());
        }
        if (var.getCommandParamater() != "") {
            v.setAttribute("commandParameter", var.getCommandParamater());
        }
        if (var.getCommandParamaterAlt() != "") {
            v.setAttribute("commandParameterAlt", var.getCommandParamaterAlt());
        }
        if (var.getCommandParamaterSep() != " ") {
            v.setAttribute("commandParameterSep", var.getCommandParamaterSep());
        }
        if (var.getVarGroup() != null) {
            v.setAttribute("groupName", var.getVarGroup());
        }
        if (!var.getGUIVisible()) {
            v.setAttribute("guiVisible", String.valueOf(var.getGUIVisible()));
        }
        if (var.getIsTracked()) {
            v.setAttribute("isTracked", String.valueOf(var.getIsTracked()));
        }
        if (var.getSubProgName() != null) {
            v.setAttribute("subProg", var.getSubProgName());
        }
        if (var.isFileName()) {
            v.setAttribute("isFileName", String.valueOf(var.isFileName()));
        }
        if ((acceptedFileTypes = var.getAcceptedFileTypes()).size() > 0) {
            af = dom.createElement("acceptedFileFormatInfo");
            int i = 0;
            while (i < acceptedFileTypes.size()) {
                VariableDescriptor.FileFormatInfo fileFormat = var.getAcceptedFileFormatInfo(acceptedFileTypes.get(i));
                ff = dom.createElement("fileFormat");
                ff.setAttribute("fileFormatName", fileFormat.fileFormatName);
                ff.setAttribute("title1", fileFormat.title1);
                ff.setAttribute("title2", fileFormat.title2);
                ff.setAttribute("isPaired", String.valueOf(fileFormat.isPaired));
                ff.setAttribute("showPairingOptions", String.valueOf(fileFormat.showPairingOptions));
                if (fileFormat.PairningOptionsMsg != null) {
                    ff.setAttribute("PairningOptionsMsg", fileFormat.PairningOptionsMsg);
                }
                af.appendChild(ff);
                ++i;
            }
            v.appendChild(af);
        }
        if ((sampleResources = var.getSampleResources()).size() > 0) {
            af = dom.createElement("sampleResources");
            int i = 0;
            while (i < sampleResources.size()) {
                ff = dom.createElement("Resource");
                ff.setAttribute("sampleName", sampleResources.get(i));
                ff.setAttribute("diplayName", var.getSampleResourcesName(sampleResources.get(i)));
                af.appendChild(ff);
                ++i;
            }
            v.appendChild(af);
        }
        if (var instanceof CheckedVariableDescriptor) {
            this.addAttributes((CheckedVariableDescriptor)var, v);
        }
        if (var instanceof FileVariableDescriptor) {
            this.addAttributes((FileVariableDescriptor)var, v);
        }
        if (var instanceof FolderVariableDescriptor) {
            this.addAttributes((FolderVariableDescriptor)var, v);
        }
        if (var instanceof FilesVariableDescriptor) {
            this.addAttributes((FilesVariableDescriptor)var, v);
        }
        if (var instanceof PairedFilesVariableDescriptor) {
            this.addAttributes((PairedFilesVariableDescriptor)var, v);
        }
        if (var instanceof FoldersVariableDescriptor) {
            this.addAttributes((FoldersVariableDescriptor)var, v);
        }
        if (var instanceof RangeVariableDescriptor) {
            this.addAttributes((RangeVariableDescriptor)var, v);
        }
        if (var instanceof SelectionListVariableDescriptor) {
            this.addAttributes((SelectionListVariableDescriptor)var, v, dom);
        }
        if (var instanceof MultiSelectionListVariableDescriptor) {
            this.addAttributes((MultiSelectionListVariableDescriptor)var, v, dom);
        }
        if (var instanceof StringVariableDescriptor) {
            this.addAttributes((StringVariableDescriptor)var, v);
        }
        if (var instanceof IntVariableDescriptor) {
            this.addAttributes((IntVariableDescriptor)var, v);
        }
        if (var instanceof StringsVariableDescriptor) {
            this.addAttributes((StringsVariableDescriptor)var, v);
        }
        if (var instanceof NumVariableDescriptor) {
            this.addAttributes((NumVariableDescriptor)var, v);
        }
        if (var instanceof DoubleVariableDescriptor) {
            this.addAttributes((DoubleVariableDescriptor)var, v);
        }
        if (var instanceof GroupVariableDescriptor) {
            this.addAttributes((GroupVariableDescriptor)var, v);
        }
        if (var instanceof ListVariableDescriptor) {
            this.addAttributes((ListVariableDescriptor)var, v);
        }
        return v;
    }

    private void addExtractors(Document dom, Element jobEle, JobDescriptor job) {
        List<DescFilters.JobDescriptorFilterExtractor> jobFilterExtractors = job.getExtractors();
        if (jobFilterExtractors.size() > 0) {
            Element extractorsElm = dom.createElement("extractors");
            for (DescFilters.JobDescriptorFilterExtractor extractor : jobFilterExtractors) {
                Element extractorElm = dom.createElement("extractor");
                if (extractor.getInputVariable() != null) {
                    extractorElm.setAttribute("inputVariable", extractor.getInputVariable().getKey());
                }
                extractorElm.setAttribute("desc", extractor.getDesc());
                extractorElm.setAttribute("name", extractor.getName());
                extractorElm.setAttribute("cmd_script", extractor.getCMDScript());
                Element vElm = this.createVariableElm(dom, extractor.getStoreVariable());
                Element storeVariableElm = dom.createElement("storeVariable");
                storeVariableElm.appendChild(vElm);
                extractorElm.appendChild(storeVariableElm);
                Element extractorsInputParametersElm = dom.createElement("inputParameters");
                for (VariableDescriptor inVar : extractor.getInputParameters()) {
                    vElm = this.createVariableElm(dom, inVar);
                    extractorsInputParametersElm.appendChild(vElm);
                }
                extractorElm.appendChild(extractorsInputParametersElm);
                Element extractorsInternalParametersElm = dom.createElement("internalParameters");
                for (VariableDescriptor inVar : extractor.getInternalParameters()) {
                    vElm = this.createVariableElm(dom, inVar);
                    extractorsInternalParametersElm.appendChild(vElm);
                }
                extractorElm.appendChild(extractorsInternalParametersElm);
                extractorsElm.appendChild(extractorElm);
            }
            jobEle.appendChild(extractorsElm);
        }
    }

    private void addFilters(Document dom, Element jobEle, JobDescriptor job) {
        List<DescFilters.JobDescriptorFilterBase> jobFilterFilters = job.getFilters();
        if (jobFilterFilters.size() > 0) {
            Element filtersElm = dom.createElement("filters");
            for (DescFilters.JobDescriptorFilterBase filter : jobFilterFilters) {
                Element filterElm = dom.createElement("filter");
                filterElm.setAttribute("name", filter.getName());
                filterElm.setAttribute("desc", filter.getDesc());
                filterElm.setAttribute("targetVariable", filter.getTargetVariable().getKey());
                filterElm.setAttribute("comparison_operator", filter.getComparisonOperator().name());
                if (filter instanceof DescFilters.JobDescriptorThresholdFilter) {
                    DescFilters.JobDescriptorThresholdFilter thresholdFilter = (DescFilters.JobDescriptorThresholdFilter)filter;
                    Element vElm = this.createVariableElm(dom, thresholdFilter.getThresholdVariable());
                    Element thresholdVariable = dom.createElement("thresholdVariable");
                    thresholdVariable.appendChild(vElm);
                    filterElm.appendChild(thresholdVariable);
                    filterElm.setAttribute("type", "ThresholdFilter");
                }
                if (filter instanceof DescFilters.JobDescriptorStatusFilter) {
                    filterElm.setAttribute("type", "StatusFilter");
                    filterElm.setAttribute("status_value", ((DescFilters.JobDescriptorStatusFilter)filter).getStatusValue());
                }
                filtersElm.appendChild(filterElm);
            }
            jobEle.appendChild(filtersElm);
        }
    }

    private void addCLITools(Document dom, Element jobEle, JobDescriptor job) {
        List<JobDescriptor.CLIToolInfo> jobFilterFilters = job.getTaskCmdTools();
        if (jobFilterFilters.size() > 0) {
            Element cli_toolsElm = dom.createElement("cli_tools");
            for (JobDescriptor.CLIToolInfo cliToolInfo : jobFilterFilters) {
                Element cli_toolElm = dom.createElement("cli_tool");
                cli_toolElm.setAttribute("name", cliToolInfo.getName());
                cli_toolElm.setAttribute("id", cliToolInfo.getId());
                cli_toolElm.setAttribute("baseCLI", cliToolInfo.getBaseCLI());
                if (cliToolInfo.getBaseCLISubtool() != null) {
                    cli_toolElm.setAttribute("baseCLISubtool", cliToolInfo.getBaseCLISubtool());
                }
                if (cliToolInfo.mainTool) {
                    cli_toolElm.setAttribute("main_tool", String.valueOf(true));
                }
                if (cliToolInfo.mainInputVariable != null) {
                    cli_toolElm.setAttribute("mainInputVariable", cliToolInfo.mainInputVariable);
                }
                if (cliToolInfo.generatedOutputVariable != null) {
                    cli_toolElm.setAttribute("mainOutputVariable", cliToolInfo.generatedOutputVariable);
                }
                cli_toolsElm.appendChild(cli_toolElm);
            }
            jobEle.appendChild(cli_toolsElm);
        }
    }

    private void addPublication(Document dom, Element jobEle, JobDescriptor job) {
        Publication[] pubs = job.getPublications();
        if (pubs.length > 0) {
            Element publications = dom.createElement("publications");
            Publication[] publicationArray = pubs;
            int n = pubs.length;
            int n2 = 0;
            while (n2 < n) {
                Publication pub = publicationArray[n2];
                Element ePublication = dom.createElement("publication");
                publications.appendChild(ePublication);
                ePublication.setAttribute("authers", pub.getAuthers());
                ePublication.setAttribute("citation", pub.getCitation());
                ePublication.setAttribute("DOI", pub.getDOI(true));
                ePublication.setAttribute("issue", pub.getIssue());
                ePublication.setAttribute("journal", pub.getJournal());
                ePublication.setAttribute("title", pub.getTitle());
                ePublication.setAttribute("pages", pub.getPages());
                ePublication.setAttribute("PubmedId", pub.getPubmed());
                if (pub.getUrl() != null) {
                    ePublication.setAttribute("url", pub.getUrl());
                }
                if (pub.getUrl() == null && pub.getDOI() != null) {
                    ePublication.setAttribute("url", String.format("http://doi.org/%1$s", pub.getDOI(true)));
                }
                ePublication.setAttribute("volume", pub.getVolume());
                ++n2;
            }
            jobEle.appendChild(publications);
        }
    }

    private void addLinks(Document dom, Element jobEle, JobDescriptor job) {
        JobLink[] links = job.getLinks();
        if (links.length > 0) {
            Element elinks = dom.createElement("links");
            JobLink[] jobLinkArray = links;
            int n = links.length;
            int n2 = 0;
            while (n2 < n) {
                JobLink link = jobLinkArray[n2];
                Element eLink = dom.createElement("link");
                elinks.appendChild(eLink);
                eLink.setAttribute("url", link.getUrl());
                eLink.setAttribute("title", link.getTitle());
                eLink.setAttribute("type", link.getType().name());
                ++n2;
            }
            jobEle.appendChild(elinks);
        }
    }

    private void getReference(JobDescriptor job, Element jobEle) {
        Object reference = job.getRef();
        Publication[] pubs = job.getPublications();
        if (reference == null || ((String)reference).isEmpty()) {
            JobLink[] links;
            int n;
            reference = "";
            if (pubs.length > 0) {
                Publication[] publicationArray = pubs;
                n = pubs.length;
                int n2 = 0;
                while (n2 < n) {
                    Publication pub = publicationArray[n2];
                    String ref = "";
                    if (pub.getDOI() != null) {
                        ref = String.format("%1$s. <a href=\"http://doi.org/%2$s\">doi:%2$s.</a>", pub.getCitation(), pub.getDOI(true));
                    } else if (pub.getUrl() != null) {
                        ref = String.format("<a href=\"%s\">- %s</a>", pub.getUrl(), pub.getCitation());
                    }
                    reference = (String)reference + ref + "\n";
                    ++n2;
                }
            }
            if ((links = job.getLinks()).length > 0) {
                JobLink[] jobLinkArray = links;
                int n3 = links.length;
                n = 0;
                while (n < n3) {
                    JobLink link = jobLinkArray[n];
                    String ref = link.getHTMLLink();
                    reference = (String)reference + ref + "\n";
                    ++n;
                }
            }
        }
        jobEle.setAttribute("ref", (String)reference);
    }

    private void addAttributes(CheckedVariableDescriptor var, Element v) {
        v.setAttribute("truePostFix", var.getTruePostFix());
    }

    private void addAttributes(ListVariableDescriptor var, Element v) {
    }

    private void addAttributes(GroupVariableDescriptor var, Element v) {
    }

    private void addAttributes(NumVariableDescriptor var, Element v) {
        if (var.getIsMaxValueSet()) {
            v.setAttribute("maxValue", String.valueOf(var.getMaxValue()));
        }
        if (var.getIsMinValueSet()) {
            v.setAttribute("minValue", String.valueOf(var.getMinValue()));
        }
    }

    private void addAttributes(StringsVariableDescriptor var, Element v) {
        v.setAttribute("cmdListMergeStrategy", var.getCmdListMergeStrategy().toString());
        if (var.getCmdListMergerSep() != " ") {
            v.setAttribute("cmdListMergerSep", var.getCmdListMergerSep());
        }
        if (var.getCmdListMergerQuate() != "") {
            v.setAttribute("cmdListMergerQuate", var.getCmdListMergerQuate());
        }
    }

    private void addAttributes(IntVariableDescriptor var, Element v) {
    }

    private void addAttributes(DoubleVariableDescriptor var, Element v) {
    }

    private void addAttributes(StringVariableDescriptor var, Element v) {
    }

    private void addAttributes(SelectionListVariableDescriptor var, Element v, Document dom) {
        ArrayList<String> l = var.getOptionsValues();
        if (l.size() > 0) {
            Element el = null;
            Element e = null;
            String aux = "";
            el = dom.createElement("optionsValues");
            int i = 0;
            while (i < l.size()) {
                e = dom.createElement("optionValue");
                e.setAttribute("value", l.get(i));
                if (var.getOptionsValuesCmdParam() != null) {
                    aux = var.getOptionsValuesCmdParam().get(l.get(i));
                    if (aux != null) {
                        e.setAttribute("cmdParam", aux);
                    }
                    if ((aux = var.getHelpAvlOption(l.get(i))) != null) {
                        e.setAttribute("helpAvlOption", aux);
                    }
                }
                el.appendChild(e);
                ++i;
            }
            if (var.getDefaultValueIndex() != 0) {
                v.setAttribute("defaultValueIndex", String.valueOf(var.getDefaultValueIndex()));
            }
            v.appendChild(el);
        }
    }

    private void addAttributes(MultiSelectionListVariableDescriptor var, Element v, Document dom) {
        this.addAttributes((SelectionListVariableDescriptor)var, v, dom);
        v.setAttribute("cmdListMergeStrategy", var.getCmdListMergeStrategy().toString());
        if (var.getCmdListMergerSep() != " ") {
            v.setAttribute("cmdListMergerSep", var.getCmdListMergerSep());
        }
        if (var.getCmdListMergerQuate() != "") {
            v.setAttribute("cmdListMergerQuate", var.getCmdListMergerQuate());
        }
    }

    private void addAttributes(RangeVariableDescriptor var, Element v) {
    }

    private void addAttributes(FoldersVariableDescriptor var, Element v) {
        v.setAttribute("cmdListMergeStrategy", var.getCmdListMergeStrategy().toString());
        if (var.getCmdListMergerSep() != " ") {
            v.setAttribute("cmdListMergerSep", var.getCmdListMergerSep());
        }
        if (var.getCmdListMergerQuate() != "") {
            v.setAttribute("cmdListMergerQuate", var.getCmdListMergerQuate());
        }
    }

    private void addAttributes(PairedFilesVariableDescriptor var, Element v) {
    }

    private void addAttributes(FilesVariableDescriptor var, Element v) {
        v.setAttribute("cmdListMergeStrategy", var.getCmdListMergeStrategy().toString());
        if (var.getCmdListMergerSep() != " ") {
            v.setAttribute("cmdListMergerSep", var.getCmdListMergerSep());
        }
        if (var.getCmdListMergerQuate() != "") {
            v.setAttribute("cmdListMergerQuate", var.getCmdListMergerQuate());
        }
    }

    private void addAttributes(FolderVariableDescriptor var, Element v) {
    }

    private void addAttributes(FileVariableDescriptor var, Element v) {
    }

    @Override
    public JobDescriptor loadFromXML(String inputPath) {
        NodeList varl = null;
        NodeList vncl = null;
        Element vn = null;
        NodeList el = null;
        Element e = null;
        VariableDescriptor var = null;
        JobDescriptor job = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(inputPath);
            Element doc = dom.getDocumentElement();
            job = new JobDescriptor(doc.getAttribute("id"));
            job.setDesc(doc.getAttribute("desc"));
            job.setRef(doc.getAttribute("ref"));
            varl = doc.getChildNodes().item(1).getChildNodes();
            int i = 0;
            while (i < varl.getLength()) {
                if (varl.item(i).getNodeType() == 1) {
                    vn = (Element)varl.item(i);
                    var = VariableDescriptor.createDescriptorFor(vn.getAttribute("key"), VariableDescriptor.VariableType.valueOf(vn.getAttribute("type")), VariableDescriptor.VariableRole.valueOf(vn.getAttribute("role")));
                    var.setVariableName(vn.getAttribute("name"));
                    if (vn.getAttribute("defaultVal") != "") {
                        var.setDefaultValue(vn.getAttribute("defaultVal"));
                    }
                    if (vn.getAttribute("isRequired") != "") {
                        var.isRequired = true;
                    }
                    if (vn.getAttribute("helpMsg") != "") {
                        var.setHelpMsg(vn.getAttribute("helpMsg"));
                    }
                    if (vn.getAttribute("shortHelpMsg") != "") {
                        var.setShortHelpMsg(vn.getAttribute("shortHelpMsg"));
                    }
                    if (vn.getAttribute("commandParameter") != "") {
                        var.setCommandParamater(vn.getAttribute("commandParameter"));
                    }
                    if (vn.getAttribute("commandParameterAlt") != "") {
                        var.setCommandParamaterAlt(vn.getAttribute("commandParameterAlt"));
                    }
                    if (vn.getAttribute("commandParameterSep") != "") {
                        var.setCommandParamaterSep(vn.getAttribute("commandParameterSep"));
                    }
                    if (vn.getAttribute("groupName") != "") {
                        var.setVariableGroup(vn.getAttribute("groupName"));
                    }
                    if (vn.getAttribute("guiVisible") != "") {
                        var.setGUIVisible(false);
                    }
                    if (vn.getAttribute("isTracked") != "") {
                        var.setIsTracked(true);
                    }
                    if (vn.getAttribute("subProg") != "") {
                        var.setSubProgName(vn.getAttribute("subProg"));
                    }
                    if (vn.getAttribute("isFileName") != "") {
                        var.setIsFileName(true);
                    }
                    vncl = vn.getChildNodes();
                    int j = 1;
                    while (j < vncl.getLength() - 1) {
                        int u;
                        if (vncl.item(j).getNodeName() == "acceptedFileFormatInfo") {
                            el = vncl.item(j).getChildNodes();
                            u = 1;
                            while (u < el.getLength() - 1) {
                                if (el.item(u).getNodeType() == 1) {
                                    e = (Element)el.item(u);
                                    if (e.getAttribute("PairningOptionsMsg") == "") {
                                        var.addAcceptedFileFormat(e.getAttribute("fileFormatName"), (boolean)Boolean.valueOf(e.getAttribute("isPaired")), Boolean.valueOf(e.getAttribute("showPairingOptions")), e.getAttribute("title1"), e.getAttribute("title2"));
                                    } else {
                                        var.addAcceptedFileFormat(e.getAttribute("fileFormatName"), (boolean)Boolean.valueOf(e.getAttribute("isParied")), e.getAttribute("PairningOptionsMsg"), e.getAttribute("title1"), e.getAttribute("title2"));
                                    }
                                }
                                ++u;
                            }
                        }
                        if (vncl.item(j).getNodeName() == "sampleResources") {
                            el = vncl.item(j).getChildNodes();
                            u = 1;
                            while (u < el.getLength() - 1) {
                                if (el.item(u).getNodeType() == 1) {
                                    e = (Element)el.item(u);
                                    var.addSampleResources(e.getAttribute("sampleName"), e.getAttribute("diplayName"));
                                }
                                ++u;
                            }
                        }
                        if (vncl.item(j).getNodeName() == "optionsValues") {
                            el = vncl.item(j).getChildNodes();
                            SelectionListVariableDescriptor varu = (SelectionListVariableDescriptor)var;
                            int u2 = 1;
                            while (u2 < el.getLength() - 1) {
                                if (el.item(u2).getNodeType() == 1) {
                                    e = (Element)el.item(u2);
                                    if (e.getAttribute("cmdParam") != "" || e.getAttribute("helpAvlOption") != "") {
                                        varu.addOptionValue(e.getAttribute("value"), e.getAttribute("cmdParam"), e.getAttribute("helpAvlOption"));
                                    } else {
                                        varu.addOptionValue(e.getAttribute("value"));
                                    }
                                }
                                ++u2;
                            }
                        }
                        ++j;
                    }
                    if (var instanceof CheckedVariableDescriptor) {
                        ((CheckedVariableDescriptor)var).setCommandPostfix(vn.getAttribute("truePostFix"));
                    }
                    boolean cfr_ignored_0 = var instanceof FileVariableDescriptor;
                    boolean cfr_ignored_1 = var instanceof FolderVariableDescriptor;
                    if (var instanceof FilesVariableDescriptor) {
                        ((FilesVariableDescriptor)var).setCmdListMergeStrategy(CmdListMergeStrategy.valueOf(vn.getAttribute("cmdListMergeStrategy")));
                        if (vn.getAttribute("cmdListMergerSep") != "") {
                            ((FilesVariableDescriptor)var).setCmdListMergerSep(vn.getAttribute("cmdListMergerSep"));
                        }
                        if (vn.getAttribute("cmdListMergerQuate") != "") {
                            ((FilesVariableDescriptor)var).setCmdListMergerQuate(vn.getAttribute("cmdListMergerQuate"));
                        }
                    }
                    boolean cfr_ignored_2 = var instanceof PairedFilesVariableDescriptor;
                    if (var instanceof FoldersVariableDescriptor) {
                        ((FoldersVariableDescriptor)var).setCmdListMergeStrategy(CmdListMergeStrategy.valueOf(vn.getAttribute("cmdListMergeStrategy")));
                        if (vn.getAttribute("cmdListMergerSep") != "") {
                            ((FoldersVariableDescriptor)var).setCmdListMergerSep(vn.getAttribute("cmdListMergerSep"));
                        }
                        if (vn.getAttribute("cmdListMergerQuate") != "") {
                            ((FoldersVariableDescriptor)var).setCmdListMergerQuate(vn.getAttribute("cmdListMergerQuate"));
                        }
                    }
                    boolean cfr_ignored_3 = var instanceof RangeVariableDescriptor;
                    if (var instanceof SelectionListVariableDescriptor && vn.getAttribute("defaultValueIndex") != "") {
                        ((SelectionListVariableDescriptor)var).setDefaultIndexValue(Integer.valueOf(vn.getAttribute("defaultValueIndex")));
                    }
                    if (var instanceof MultiSelectionListVariableDescriptor) {
                        ((MultiSelectionListVariableDescriptor)var).setCmdListMergeStrategy(CmdListMergeStrategy.valueOf(vn.getAttribute("cmdListMergeStrategy")));
                        if (vn.getAttribute("cmdListMergerSep") != "") {
                            ((MultiSelectionListVariableDescriptor)var).setCmdListMergerSep(vn.getAttribute("cmdListMergerSep"));
                        }
                        if (vn.getAttribute("cmdListMergerQuate") != "") {
                            ((MultiSelectionListVariableDescriptor)var).setCmdListMergerQuate(vn.getAttribute("cmdListMergerQuate"));
                        }
                    }
                    boolean cfr_ignored_4 = var instanceof StringVariableDescriptor;
                    boolean cfr_ignored_5 = var instanceof IntVariableDescriptor;
                    if (var instanceof StringsVariableDescriptor) {
                        ((StringsVariableDescriptor)var).setCmdListMergeStrategy(CmdListMergeStrategy.valueOf(vn.getAttribute("cmdListMergeStrategy")));
                        if (vn.getAttribute("cmdListMergerSep") != "") {
                            ((StringsVariableDescriptor)var).setCmdListMergerSep(vn.getAttribute("cmdListMergerSep"));
                        }
                        if (vn.getAttribute("cmdListMergerQuate") != "") {
                            ((StringsVariableDescriptor)var).setCmdListMergerQuate(vn.getAttribute("cmdListMergerQuate"));
                        }
                    }
                    if (var instanceof NumVariableDescriptor) {
                        if (vn.getAttribute("maxValue") != "") {
                            ((NumVariableDescriptor)var).setMaxValue(Double.valueOf(vn.getAttribute("maxValue")));
                        }
                        if (vn.getAttribute("minValue") != "") {
                            ((NumVariableDescriptor)var).setMinValue(Double.valueOf(vn.getAttribute("minValue")));
                        }
                    }
                    boolean cfr_ignored_6 = var instanceof DoubleVariableDescriptor;
                    boolean cfr_ignored_7 = var instanceof GroupVariableDescriptor;
                    boolean cfr_ignored_8 = var instanceof ListVariableDescriptor;
                    job.addVariable(var);
                }
                ++i;
            }
        }
        catch (ParserConfigurationException pce) {
            System.out.println(pce.getMessage());
        }
        catch (SAXException se) {
            System.out.println(se.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        return job;
    }
}

