/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.v2.ftpexplorer;

import com.biotechvana.commons.IFileTransferService;
import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.commons.ftpservice.IFileTransferJob;
import com.biotechvana.commons.ftpservice.IFtpFileTransfer;
import com.biotechvana.commons.ftpservice.IRemoteFile;
import com.biotechvana.commons.ftpservice.TransferStatus;
import com.biotechvana.commons.ftpservice.TransferType;
import com.biotechvana.commons.model.UserLoginInfo;
import com.biotechvana.commons.viewers.IFTPBrowser;
import com.biotechvana.ftpservice.internal.RemoteFileImpl;
import com.biotechvana.ui.v2.ftpexplorer.FTPVLabelProvider;
import com.biotechvana.ui.v2.ftpexplorer.FTPViewerContentProvider;
import com.biotechvana.ui.v2.ftpexplorer.actions.FTPCopyCutAction;
import com.biotechvana.ui.v2.ftpexplorer.actions.FTPDeleteAction;
import com.biotechvana.ui.v2.ftpexplorer.actions.FTPDownloadAction;
import com.biotechvana.ui.v2.ftpexplorer.actions.FTPNewFolderAction;
import com.biotechvana.ui.v2.ftpexplorer.actions.FTPPasteAction;
import com.biotechvana.ui.v2.ftpexplorer.actions.FTPRenameAction;
import com.biotechvana.ui.v2.ftpexplorer.actions.FTPUploadAction;
import com.biotechvana.users.IUsersService;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.StringJoiner;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class FTPViewerComponent
implements IFTPBrowser {
    static Logger LOGGER = LoggerFactory.getLogger(FTPViewerComponent.class);
    private static final boolean DEBUG = true;
    @Inject
    protected IEclipseContext cntx;
    private TableViewer ftpViewer;
    private TableViewerColumn fileColumn;
    private TableViewerColumn sizeColumn;
    private TableViewerColumn dateColumn;
    private boolean showColumns = true;
    private IStructuredSelection copyItems;
    public Clipboard clipboard;
    UserLoginInfo activeLogin;
    @Inject
    IFTPManager manager;
    @Inject
    @Named(value="activeShell")
    private Shell activeShell;
    @Inject
    IFileTransferService fileTransferService;
    @Optional
    @Inject
    IStatusLineManager statusLine;
    @Inject
    IUsersService userService;
    @Inject
    UISynchronize sync;

    @Inject
    public void setActiveLogin(@Optional @Named(value="ACTIVE_LOGIN") UserLoginInfo activeLogin) {
        this.activeLogin = activeLogin;
    }

    public Control createPartControl(Composite parent) {
        try {
            this.serverIsAvailable();
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        this.ftpViewer = new TableViewer(parent, 66306);
        this.ftpViewer.setContentProvider((IContentProvider)new FTPViewerContentProvider(this.manager));
        this.ftpViewer.getTable().setHeaderVisible(this.showColumns);
        this.ftpViewer.getTable().setLinesVisible(true);
        this.fileColumn = new TableViewerColumn(this.ftpViewer, 0);
        this.fileColumn.getColumn().setWidth(500);
        this.fileColumn.getColumn().setText("File");
        this.fileColumn.setLabelProvider((CellLabelProvider)new FTPVLabelProvider());
        this.sizeColumn = new TableViewerColumn(this.ftpViewer, 0x1000000);
        this.sizeColumn.getColumn().setWidth(this.showColumns ? 100 : 0);
        this.sizeColumn.getColumn().setText("Size");
        this.sizeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IRemoteFile) {
                    IRemoteFile file = (IRemoteFile)element;
                    if (file.isFolder()) {
                        return "";
                    }
                    return FileUtils.byteCountToDisplaySize((long)file.getFileSize());
                }
                return "ERROR";
            }
        });
        this.dateColumn = new TableViewerColumn(this.ftpViewer, 0x1000000);
        this.dateColumn.getColumn().setWidth(this.showColumns ? 100 : 0);
        this.dateColumn.getColumn().setText("Date");
        this.dateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IRemoteFile) {
                    IRemoteFile file = (IRemoteFile)element;
                    if (file.isFolder()) {
                        return "";
                    }
                    return DateFormatUtils.format((long)file.getLastModifiedTime(), (String)"dd/MM/YYYY");
                }
                return "ERROR";
            }
        });
        if (this.manager == null) {
            this.ftpViewer.setInput((Object)FTPViewerContentProvider.NOFTPERORR);
        } else {
            try {
                this.updateFTPList();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.addDragCapability();
        this.fileTransferService.customDropCapability((Control)this.ftpViewer.getTable());
        this.createContextMenu();
        this.hookDoubleClickCommand();
        return this.ftpViewer.getControl();
    }

    public void setShowColumns(boolean showColumns) {
        this.showColumns = showColumns;
        this.updateColumnVisibility();
    }

    public void updateColumnVisibility() {
        this.ftpViewer.getTable().setHeaderVisible(this.showColumns);
        this.sizeColumn.getColumn().setWidth(this.showColumns ? 100 : 0);
        this.dateColumn.getColumn().setWidth(this.showColumns ? 100 : 0);
    }

    @Inject
    @Optional
    private void managerWDChanged(@UIEventTopic(value="FTP/WD/CHANGED") String newPath) {
        System.out.println("Working Dir changed");
        this.updateFTPList();
    }

    @Inject
    @Optional
    private void managerConnectionClosed(@UIEventTopic(value="FTP/CONN/CLOSED") Object data) {
        System.out.println("managerConnectionClosed");
        System.out.println(data);
    }

    @Inject
    @Optional
    private void managerConnectionOpened(@UIEventTopic(value="FTP/CONN/OPENED") Object data) {
        System.out.println("managerConnectionOpened");
        System.out.println(data);
    }

    private void addDragCapability() {
        int operations = 7;
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        DragSource source = new DragSource((Control)this.ftpViewer.getTable(), operations);
        source.setTransfer(transfers);
        source.addDragListener(new DragSourceListener(){
            private static final long serialVersionUID = 1L;

            public void dragStart(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)FTPViewerComponent.this.ftpViewer.getSelection();
                Iterator it = selection.iterator();
                String[] ftpFiles = new String[selection.size()];
                StringJoiner joiner = new StringJoiner("|", "ftp:", "");
                while (it.hasNext()) {
                    joiner.add(((IRemoteFile)it.next()).getPath());
                }
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = joiner.toString();
                    System.out.println(event.data);
                } else {
                    System.err.println("Not supported");
                    System.err.println("Data type is: " + String.valueOf(event.dataType));
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    private boolean serverIsAvailable() {
        Object remoteHost;
        block7: {
            block6: {
                this.activeLogin = this.userService.getActiveLogin();
                if (this.activeLogin != null) break block6;
                return false;
            }
            remoteHost = this.activeLogin.getHostInfo().getServerURL();
            if (remoteHost != null && !((String)remoteHost).trim().isEmpty()) break block7;
            return false;
        }
        try {
            if (!((String)remoteHost).startsWith("http://")) {
                remoteHost = "http://" + (String)remoteHost;
            }
            URL url = new URL((String)remoteHost);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.connect();
            return true;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            return false;
        }
    }

    private void updateFTPListSafe() {
        BusyIndicator.showWhile((Display)this.ftpViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (FTPViewerComponent.this.ftpViewer == null || FTPViewerComponent.this.ftpViewer.getTable().isDisposed()) {
                        return;
                    }
                    if (FTPViewerComponent.this.manager == null) {
                        if (!FTPViewerComponent.this.ftpViewer.getTable().isDisposed()) {
                            FTPViewerComponent.this.ftpViewer.setInput(null);
                            FTPViewerComponent.this.ftpViewer.refresh();
                        }
                        return;
                    }
                    IRemoteFile[] files = FTPViewerComponent.this.manager.listFiles(true, true, false);
                    if (files == null) {
                        System.err.println("PWD es null en updateFTPList()");
                    } else {
                        System.out.println("Updating ftp list");
                        FTPViewerComponent.this.ftpViewer.setInput((Object)files);
                        FTPViewerComponent.this.ftpViewer.refresh();
                        System.out.println("Updating ftp list finished");
                    }
                }
                catch (Exception e) {
                    FTPViewerComponent.this.ftpViewer.setInput((Object)FTPViewerContentProvider.NOFTPERORR);
                    FTPViewerComponent.this.ftpViewer.refresh();
                }
            }
        });
    }

    public void updateFTPList() {
        this.sync.asyncExec(new Runnable(){

            @Override
            public void run() {
                FTPViewerComponent.this.updateFTPListSafe();
            }
        });
    }

    public IRemoteFile[] getSelectedFiles() {
        IStructuredSelection selection = (IStructuredSelection)this.ftpViewer.getSelection();
        Iterator it = selection.iterator();
        if (selection.size() == 0) {
            return new IRemoteFile[selection.size()];
        }
        IRemoteFile[] ftpFiles = new IRemoteFile[selection.size()];
        int index = 0;
        while (it.hasNext()) {
            ftpFiles[index] = (IRemoteFile)it.next();
            ++index;
        }
        return ftpFiles;
    }

    public IFTPManager getFtpManager() {
        return this.manager;
    }

    public static boolean isDirectory(FileObject file) throws FileSystemException {
        return file.isFolder();
    }

    private void hookDoubleClickCommand() {
        this.ftpViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)FTPViewerComponent.this.ftpViewer.getSelection();
                IRemoteFile file = (IRemoteFile)selection.getFirstElement();
                try {
                    if (!file.isFile()) {
                        FTPViewerComponent.this.manager.changeWorkingDirectory(file.getPath());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void createContextMenu() {
        Menu menu = new Menu((Control)this.ftpViewer.getTable());
        MenuItem downloadMenuItem = new MenuItem(menu, 8);
        downloadMenuItem.setText("Download");
        downloadMenuItem.addSelectionListener((SelectionListener)new Test2(this));
        new MenuItem(menu, 2);
        MenuItem createFolderMenuItem = new MenuItem(menu, 8);
        createFolderMenuItem.setText("New Folder");
        createFolderMenuItem.addSelectionListener((SelectionListener)new Test(this));
        MenuItem renameMenuItem = new MenuItem(menu, 8);
        renameMenuItem.setText("Rename");
        renameMenuItem.addSelectionListener((SelectionListener)new Test4(this));
        new MenuItem(menu, 2);
        MenuItem deleteMenuItem = new MenuItem(menu, 8);
        deleteMenuItem.setText("Delete");
        deleteMenuItem.addSelectionListener((SelectionListener)new Test3(this));
        MenuItem copyMenuItem = new MenuItem(menu, 8);
        copyMenuItem.setText("Copy");
        copyMenuItem.addSelectionListener((SelectionListener)new Test5(this, ClipboardMode.COPY));
        MenuItem cutMenuItem = new MenuItem(menu, 8);
        cutMenuItem.setText("Cut");
        cutMenuItem.addSelectionListener((SelectionListener)new Test5(this, ClipboardMode.CUT));
        MenuItem pasteMenuItem = new MenuItem(menu, 8);
        pasteMenuItem.setText("Paste");
        pasteMenuItem.addSelectionListener((SelectionListener)new Test6(this));
        this.ftpViewer.getTable().setMenu(menu);
    }

    public Shell getShell() {
        return this.activeShell;
    }

    public void updateFTPList(String parentPath) {
        if (parentPath == this.getFtpManager().getWorkingDirectory().getPath()) {
            this.sync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        FTPViewerComponent.this.updateFTPList();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    @Inject
    @Optional
    private void statusChangeFtpFileTransferHandler(@EventTopic(value="TRANSFER_FILE/CHANGED") IFtpFileTransfer ftpFileTransfer) {
        if (ftpFileTransfer.getTransferType() == TransferType.UPLOAD && ftpFileTransfer.getStatus() == TransferStatus.FINISHED) {
            this.updateFTPList(ftpFileTransfer.getDestinationParentPath());
        }
    }

    @Inject
    @Optional
    private void statusChangeFtpTransferHandler(@EventTopic(value="TRANSFER_JOB/CHANGED") IFileTransferJob ftpFileTransferJob) {
        if (ftpFileTransferJob.getTransferType() == TransferType.UPLOAD && ftpFileTransferJob.getStatus() == TransferStatus.FINISHED) {
            this.updateFTPList(ftpFileTransferJob.getDestination());
        }
    }

    public Object getControl() {
        return this.ftpViewer.getControl();
    }

    @PreDestroy
    public void cleanup() {
        System.out.print("Clean up Viewer ");
        System.out.println(this);
    }

    public boolean setelectPath(String path) {
        return this.manager.changeWorkingDirectory(path);
    }

    @Deprecated
    private void addDropCapability() {
        int operations = 7;
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        DropTarget target = new DropTarget((Control)this.ftpViewer.getTable(), operations);
        target.setTransfer(transfers);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String dropFolder = null;
                dropFolder = event.item != null ? ((RemoteFileImpl)((TableItem)event.item).getData()).getPath() : FTPViewerComponent.this.getFtpManager().getWorkingDirectory().getPath();
                this.performDrop((String[])event.data, dropFolder);
            }

            private void performDrop(String[] data, String dropFolder) {
                String[] stringArray = data;
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    String source = stringArray[n2];
                    FTPViewerComponent.this.fileTransferService.uploadFile((Object)source, dropFolder);
                    ++n2;
                }
            }
        });
    }

    public static class Clipboard {
        public IRemoteFile[] selection;
        public ClipboardMode mode;

        public Clipboard(IRemoteFile[] selection, ClipboardMode mode) {
            this.selection = selection;
            this.mode = mode;
        }
    }

    public static enum ClipboardMode {
        COPY,
        CUT;

    }

    public class Test
    implements SelectionListener {
        FTPViewerComponent ftpViewer;

        public Test(FTPViewerComponent ftpViewer) {
            this.ftpViewer = ftpViewer;
        }

        public void widgetSelected(SelectionEvent e) {
            new FTPNewFolderAction().run(this.ftpViewer);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            new FTPNewFolderAction().run(this.ftpViewer);
        }
    }

    public class Test2
    implements SelectionListener {
        FTPViewerComponent ftpViewer;

        public Test2(FTPViewerComponent ftpViewer) {
            this.ftpViewer = ftpViewer;
        }

        public void widgetSelected(SelectionEvent e) {
            new FTPDownloadAction().run(this.ftpViewer, FTPViewerComponent.this.fileTransferService);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            new FTPDownloadAction().run(this.ftpViewer, FTPViewerComponent.this.fileTransferService);
        }
    }

    public class Test3
    implements SelectionListener {
        FTPViewerComponent ftpViewer;

        public Test3(FTPViewerComponent ftpViewer) {
            this.ftpViewer = ftpViewer;
        }

        public void widgetSelected(SelectionEvent e) {
            new FTPDeleteAction().run(this.ftpViewer);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            new FTPDeleteAction().run(this.ftpViewer);
        }
    }

    public class Test4
    implements SelectionListener {
        FTPViewerComponent ftpViewer;

        public Test4(FTPViewerComponent ftpViewer) {
            this.ftpViewer = ftpViewer;
        }

        public void widgetSelected(SelectionEvent e) {
            new FTPRenameAction().run(this.ftpViewer);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            new FTPRenameAction().run(this.ftpViewer);
        }
    }

    public class Test5
    implements SelectionListener {
        FTPViewerComponent ftpViewer;
        ClipboardMode mode;

        public Test5(FTPViewerComponent ftpViewer, ClipboardMode mode) {
            this.ftpViewer = ftpViewer;
            this.mode = mode;
        }

        public void widgetSelected(SelectionEvent e) {
            new FTPCopyCutAction().run(this.ftpViewer, this.mode);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            new FTPCopyCutAction().run(this.ftpViewer, this.mode);
        }
    }

    public class Test6
    implements SelectionListener {
        FTPViewerComponent ftpViewer;

        public Test6(FTPViewerComponent ftpViewer) {
            this.ftpViewer = ftpViewer;
        }

        public void widgetSelected(SelectionEvent e) {
            new FTPPasteAction().run(this.ftpViewer);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            new FTPPasteAction().run(this.ftpViewer);
        }
    }

    public class Test7
    implements SelectionListener {
        FTPViewerComponent ftpViewer;

        public Test7(FTPViewerComponent ftpViewer) {
            this.ftpViewer = ftpViewer;
        }

        public void widgetSelected(SelectionEvent e) {
            new FTPUploadAction().run(this.ftpViewer, FTPViewerComponent.this.fileTransferService);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            new FTPUploadAction().run(this.ftpViewer, FTPViewerComponent.this.fileTransferService);
        }
    }
}

