/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.fileExplorerBasic.actions;

import com.biotechvana.fileExplorerBasic.FileExplorerBasic;
import jakarta.inject.Inject;
import java.io.File;
import java.util.Iterator;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class FileExplorerRenameAction {
    private FileExplorerBasic fileExplorer;

    @Inject
    public FileExplorerRenameAction(FileExplorerBasic fileExplorer) {
        this.fileExplorer = fileExplorer;
    }

    public void dispose() {
    }

    @Execute
    public void run() {
        IStructuredSelection selection = this.fileExplorer.getSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.renameFile((File)it.next());
        }
    }

    private void renameFile(File fInput) {
        final String path = fInput.getParent();
        final File originalFile = fInput;
        InputDialog dialog = new InputDialog(this.fileExplorer.getShell(), "Rename file", "Enter new name", fInput.getName(), new IInputValidator(){

            public String isValid(String newText) {
                File newFile = new File(path + File.separator + newText);
                if (newFile.equals(originalFile)) {
                    return null;
                }
                if (newFile.exists()) {
                    return "File already exists";
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            String newName = dialog.getValue();
            this.fileExplorer.renameFile(fInput, newName);
        }
    }
}

