/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.pipelineCommander;

import com.biotechvana.pipelineCommander.PipelineCommander;
import com.biotechvana.utils.IPrefs;
import com.biotechvana.utils.WorkspaceUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class PipelineCommanderQueryUtils {
    private static List<List<String>> getModel(String reply) {
        String regexp = "^<td>(.*)</td>$";
        Pattern patternColumn = Pattern.compile(regexp);
        ArrayList<List<String>> model = new ArrayList<List<String>>();
        ArrayList<String> row = new ArrayList<String>();
        String[] lines = reply.split("\n");
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (line.equalsIgnoreCase("<tr>")) {
                row = new ArrayList();
            } else if (line.equalsIgnoreCase("</tr>")) {
                model.add(row);
            } else {
                Matcher m = patternColumn.matcher(line);
                if (m.matches()) {
                    String value = m.group(1).trim();
                    value = value.replace("<![CDATA[", "");
                    value = value.replace("]]>", "");
                    row.add(value);
                } else {
                    row.add("");
                }
            }
            ++i;
        }
        return model;
    }

    public static String prepareQuery(String query, String[] values, String[] formats) {
        int i = 0;
        while (i < values.length) {
            if (formats[i].equalsIgnoreCase("s")) {
                query = query.replaceFirst("\\?", "\"" + values[i] + "\"");
            } else if (formats[i].equalsIgnoreCase("as")) {
                if (values[i].charAt(0) == '[') {
                    values[i] = values[i].substring(1).trim();
                }
                if (values[i].charAt(values[i].length() - 1) == ']') {
                    values[i] = values[i].substring(0, values[i].length() - 1).trim();
                }
                builder = new StringBuilder();
                tokens = values[i].split(",");
                j = 0;
                while (j < tokens.length - 1) {
                    token = tokens[j].trim();
                    if (token.length() > 0) {
                        builder.append("\"" + token + "\",");
                    }
                    ++j;
                }
                if (tokens[tokens.length - 1].length() > 0) {
                    builder.append("\"" + tokens[tokens.length - 1].trim() + "\"");
                }
                query = query.replaceFirst("\\?", builder.toString());
            } else if (formats[i].equalsIgnoreCase("ad")) {
                if (values[i].charAt(0) == '[') {
                    values[i] = values[i].substring(1).trim();
                }
                if (values[i].charAt(values[i].length() - 1) == ']') {
                    values[i] = values[i].substring(0, values[i].length() - 1).trim();
                }
                builder = new StringBuilder();
                tokens = values[i].split(",");
                j = 0;
                while (j < tokens.length - 1) {
                    token = tokens[j].trim();
                    if (token.length() > 0) {
                        builder.append(token + ",");
                    }
                    ++j;
                }
                if (tokens[tokens.length - 1].length() > 0) {
                    builder.append(tokens[tokens.length - 1].trim());
                }
                query = query.replaceFirst("\\?", builder.toString());
            } else {
                query = query.replaceFirst("\\?", values[i]);
            }
            ++i;
        }
        return query;
    }

    public static List<List<String>> runQuery(IPrefs prefs, String host, String user, String password, String database, String preparedQuery) {
        block3: {
            try {
                if (user != null && !user.trim().isEmpty() && password != null && !password.trim().isEmpty()) break block3;
                MessageDialog.openWarning((Shell)WorkspaceUtils.getShell(), (String)"Pipeline connection settings", (String)"Pipeline connection credentials have not been set. Please, go to 'Preferences -> Pipeline connection settings'");
                return null;
            }
            catch (Exception ex) {
                System.out.println("****************************");
                ex.printStackTrace();
                System.out.println("****************************");
                return null;
            }
        }
        PipelineCommander pc = new PipelineCommander(host, prefs);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter output = new OutputStreamWriter(baos);
        pc.prepareQueryRequest(user, password, database, preparedQuery);
        pc.postPipelineRequest(output);
        List<List<String>> model = PipelineCommanderQueryUtils.getModel(baos.toString());
        return model;
    }

    public class CannotPrepareQueryException
    extends Exception {
        public CannotPrepareQueryException(String query, String[] values, String[] formats) {
            super("Query: " + query + "\nValues: " + Arrays.toString(values) + "\nFormats: " + Arrays.toString(formats));
        }
    }

    public class CommanderQueryRunException
    extends Exception {
        public CommanderQueryRunException(String query, String user, String database) {
            super("Query: " + query + "\nUser: " + user + "\nDatabase: " + database);
        }
    }
}

