/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.expert.ui.internal;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.expert.DiagnoseRequest;
import com.biotechvana.expert.ExpertSystemAPI;
import com.biotechvana.expert.ExtraParameter;
import com.biotechvana.expert.Task;
import com.biotechvana.expert.TaskResolutionActionTemplate;
import com.biotechvana.expert.VariableMapping;
import com.biotechvana.expert.VariableParameter;
import com.biotechvana.expert.ui.internal.ExpertSystemProblemOverview;
import com.biotechvana.expert.ui.internal.ExpertSystemResolutionView;
import com.biotechvana.expert.ui.internal.ExpertSystemSummaryView;
import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.biotechvana.workflow.tracking.ITrackerInfo;
import com.biotechvana.workflow.tracking.TrackerInfoEntry;
import com.biotechvana.workflow.tracking.events.InfoTrackEvent;
import com.biotechvana.workflow.tracking.tasks.CMDTaskTracker;
import com.biotechvana.workflow.tracking.tasks.TaskTracker;
import com.biotechvana.workflow.tracking.tasks.WorkflowJobTracker;
import com.biotechvana.workflow.tracking.tasks.WorkflowTracker;
import com.biotechvana.workflow.ui.handlers.OpenJobsMainViewHandler;
import com.biotechvana.workflow.ui.widgets.ConsoleLog2;
import com.biotechvana.workflow.variables.JobVariable;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ExpertSystemView {
    public static final int hIndent = 5;
    @Inject
    ExpertSystemAPI expertSystemAPI;
    @Inject
    IStatusLineManager manager;
    @Inject
    private MPart part;
    @Inject
    @Named(value="activeShell")
    private Shell activeShell;
    @Inject
    MApplication application;
    @Inject
    UISynchronize uiSync;
    @Inject
    IProgressService progressService;
    private DiagnoseRequest diagnoseRequest;
    ExpertSystemProblemOverview problemOverview;
    ExpertSystemSummaryView summeryView;
    ExpertSystemResolutionView resolutionView;
    @Inject
    IWorkflowManager workflowManager;
    boolean gui_ready = false;
    Form form;
    private SashForm toplevel = null;
    private SashForm rightSide = null;
    private Composite bottomPart = null;
    FormToolkit toolkit;
    Section treeViewSection;
    ConsoleLog2 consoleLog2;
    CMDTaskTracker.FilesTask firstNode = null;
    ScrolledForm detailsForm;
    Composite detailsFormBody;
    private TreeViewer tasksTrackingViewer;
    private TreeViewer filesTrackingViewer;
    Section summarySection;
    Section problemSection;
    Section resolutionSection;

    @Inject
    public void setActiveDiagnoseRequest(@Optional @Named(value="activeDiagnoseRequest") DiagnoseRequest diagnoseRequest) {
        this.diagnoseRequest = diagnoseRequest;
        if (this.problemOverview != null) {
            this.problemOverview.reset();
        }
        if (diagnoseRequest != null) {
            this.updateRequestStatus();
        }
        this.setView();
    }

    public DiagnoseRequest getActiveDiagnoseRequest() {
        return this.diagnoseRequest;
    }

    private void setView() {
        if (!this.gui_ready) {
            return;
        }
        if (this.toplevel == null || this.toplevel.isDisposed()) {
            return;
        }
        if (this.diagnoseRequest == null) {
            this.tasksTrackingViewerSetInput(null);
        } else {
            TaskTracker inputElement = this.diagnoseRequest.getTracker();
            if (inputElement instanceof WorkflowTracker) {
                this.tasksTrackingViewerSetInput(inputElement);
                this.treeViewSection.setText(((WorkflowTracker)inputElement).getTaskId());
            } else if (inputElement instanceof WorkflowJobTracker) {
                this.tasksTrackingViewerSetInput(new Object[]{inputElement});
                this.treeViewSection.setText(((WorkflowJobTracker)inputElement).getTaskId());
            }
        }
        this.summeryView.update(this.diagnoseRequest);
        this.problemOverview.update();
    }

    @PostConstruct
    public void createPartControl(Composite parent, EPartService partService) {
        this.toplevel = new SashForm(parent, 2304);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.createTreeViewFormControls(this.toplevel);
        this.rightSide = new SashForm((Composite)this.toplevel, 2560);
        this.createDetailsFormControls(this.rightSide);
        TabFolder composite_2 = new TabFolder((Composite)this.rightSide, 0);
        composite_2.setLayout((Layout)new FillLayout(256));
        TabItem logPage = new TabItem(composite_2, 0);
        logPage.setText("Logs");
        logPage.setImage(SharedImages.LOG);
        this.bottomPart = new Composite((Composite)composite_2, 2048);
        this.bottomPart.setLayout((Layout)new FillLayout());
        this.consoleLog2 = new ConsoleLog2(this.bottomPart);
        logPage.setControl((Control)this.bottomPart);
        int[] nArray = new int[2];
        nArray[0] = 1;
        this.rightSide.setWeights(nArray);
        this.toplevel.setWeights(new int[]{30, 70});
        this.gui_ready = true;
        this.setView();
    }

    void showConsole() {
        this.rightSide.setWeights(new int[]{3, 1});
    }

    void hideConsole() {
        int[] nArray = new int[2];
        nArray[0] = 1;
        this.rightSide.setWeights(nArray);
    }

    private void createTreeViewFormControls(SashForm parent) {
        this.form = this.toolkit.createForm((Composite)parent);
        this.form.setText("Tracked Tasks");
        this.toolkit.decorateFormHeading(this.form);
        this.form.getBody().setLayout((Layout)new FillLayout());
        this.treeViewSection = this.toolkit.createSection(this.form.getBody(), 256);
        Composite client = this.toolkit.createComposite((Composite)this.treeViewSection, 64);
        client.setLayout((Layout)new FillLayout());
        TabFolder tabFolder = new TabFolder(client, 128);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Tasks");
        Composite tasksClient = this.toolkit.createComposite((Composite)tabFolder, 64);
        tasksClient.setLayout((Layout)new FillLayout());
        this.createTaskTreeView(tasksClient);
        tabItem.setControl((Control)tasksClient);
        this.toolkit.paintBordersFor(client);
        this.toolkit.paintBordersFor((Composite)tabFolder);
        this.toolkit.paintBordersFor(tasksClient);
        this.treeViewSection.setClient((Control)client);
        this.treeViewSection.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                ExpertSystemView.this.showConsole();
            }
        });
    }

    private void createFilesTreeView(Composite filesClient) {
        Tree trackingTree = this.toolkit.createTree(filesClient, 2818);
        this.filesTrackingViewer = new TreeViewer(trackingTree);
    }

    private void tasksTrackingViewerSetInput(Object input) {
        this.firstNode = null;
        this.tasksTrackingViewer.setInput(input);
        this.tasksTrackingViewer.expandAll();
        try {
            if (this.firstNode != null) {
                this.tasksTrackingViewer.setSelection((ISelection)new StructuredSelection((Object)this.firstNode));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void createTaskTreeView(Composite tasksClient) {
        Tree trackingTree = this.toolkit.createTree(tasksClient, 2820);
        this.tasksTrackingViewer = new TreeViewer(trackingTree);
        this.tasksTrackingViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof WorkflowTracker) {
                    return null;
                }
                if (inputElement instanceof WorkflowJobTracker) {
                    return new Object[]{inputElement};
                }
                if (inputElement instanceof Object[]) {
                    return (Object[])inputElement;
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof WorkflowJobTracker) {
                    WorkflowJobTracker workflowJobTracker = (WorkflowJobTracker)parentElement;
                    return workflowJobTracker.getCmdTasks().toArray();
                }
                if (parentElement instanceof CMDTaskTracker) {
                    CMDTaskTracker cmdTaskTracker = (CMDTaskTracker)parentElement;
                    return cmdTaskTracker.getCmdTasks().toArray();
                }
                if (parentElement instanceof CMDTaskTracker.FilesTask) {
                    CMDTaskTracker.FilesTask filesTask = (CMDTaskTracker.FilesTask)parentElement;
                    if (ExpertSystemView.this.firstNode == null) {
                        ExpertSystemView.this.firstNode = filesTask;
                    }
                    return filesTask.toTreeList();
                }
                return null;
            }

            public Object getParent(Object element) {
                if (element instanceof WorkflowJobTracker) {
                    WorkflowJobTracker workflowJobTracker = (WorkflowJobTracker)element;
                    return workflowJobTracker.getTracker();
                }
                if (element instanceof CMDTaskTracker) {
                    CMDTaskTracker cmdTaskTracker = (CMDTaskTracker)element;
                    return cmdTaskTracker.getTracker();
                }
                if (element instanceof CMDTaskTracker.FilesTask) {
                    CMDTaskTracker.FilesTask filesTask = (CMDTaskTracker.FilesTask)element;
                    if (ExpertSystemView.this.firstNode == null) {
                        ExpertSystemView.this.firstNode = filesTask;
                    }
                    return filesTask.getCMDTaskTracker();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof WorkflowJobTracker) {
                    WorkflowJobTracker workflowJobTracker = (WorkflowJobTracker)element;
                    return workflowJobTracker.nOfTasks() > 0;
                }
                if (element instanceof CMDTaskTracker) {
                    CMDTaskTracker cmdTaskTracker = (CMDTaskTracker)element;
                    return cmdTaskTracker.nOfTasks() > 0;
                }
                return false;
            }
        });
        this.tasksTrackingViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getImage(Object element) {
                if (element instanceof WorkflowJobTracker) {
                    return SharedImages.PROCESS;
                }
                if (element instanceof WorkflowTracker) {
                    return SharedImages.WORKFLOW;
                }
                if (element instanceof CMDTaskTracker) {
                    CMDTaskTracker cmdTaskTracker = (CMDTaskTracker)element;
                    ExecStatus execStatus = cmdTaskTracker.getStatus();
                    return this.getImageFromStatus(execStatus);
                }
                if (element instanceof CMDTaskTracker.FilesTask) {
                    CMDTaskTracker.FilesTask filesTask = (CMDTaskTracker.FilesTask)element;
                    if (ExpertSystemView.this.firstNode == null) {
                        ExpertSystemView.this.firstNode = filesTask;
                    }
                    return this.getImageFromStatus(filesTask.getStatus());
                }
                return null;
            }

            private Image getImageFromStatus(ExecStatus execStatus) {
                if (execStatus == ExecStatus.Finished) {
                    return SharedImages.ACCEPT;
                }
                if (execStatus == ExecStatus.Failed) {
                    return SharedImages.ERROR;
                }
                if (execStatus == ExecStatus.Running) {
                    return SharedImages.RUNNING;
                }
                if (execStatus == ExecStatus.Warning) {
                    return SharedImages.WARNNING_YELLOW;
                }
                if (execStatus == ExecStatus.Paused) {
                    return SharedImages.RUNNING;
                }
                if (execStatus == ExecStatus.Canceled) {
                    return SharedImages.CANCEL;
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof WorkflowJobTracker) {
                    WorkflowJobTracker workflowJobTracker = (WorkflowJobTracker)element;
                    return workflowJobTracker.getTaskId();
                }
                if (element instanceof CMDTaskTracker) {
                    CMDTaskTracker cmdTaskTracker = (CMDTaskTracker)element;
                    return cmdTaskTracker.getTaskId();
                }
                if (element instanceof CMDTaskTracker.FilesTask) {
                    CMDTaskTracker.FilesTask filesTask = (CMDTaskTracker.FilesTask)element;
                    if (ExpertSystemView.this.firstNode == null) {
                        ExpertSystemView.this.firstNode = filesTask;
                    }
                    return filesTask.getTitle();
                }
                return null;
            }
        });
        this.tasksTrackingViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof TreeSelection) {
                    ExpertSystemView.this.selectionChanged((TreeSelection)selection);
                }
            }
        });
    }

    void selectionChanged(TreeSelection selection) {
        Object selectedObject = selection.getFirstElement();
        TreePath[] path = selection.getPathsFor(selectedObject);
        boolean cfr_ignored_0 = selectedObject instanceof WorkflowJobTracker;
        if (selectedObject instanceof CMDTaskTracker) {
            this.summeryView.setSelection((CMDTaskTracker)selectedObject);
            this.problemOverview.setSelection((CMDTaskTracker)selectedObject);
        }
        if (selectedObject instanceof CMDTaskTracker.FilesTask) {
            this.problemOverview.setSelection((CMDTaskTracker.FilesTask)selectedObject);
            this.summeryView.setSelection((CMDTaskTracker.FilesTask)selectedObject);
            this.updateLog((CMDTaskTracker.FilesTask)selectedObject);
        }
    }

    private void updateLog(CMDTaskTracker.FilesTask selectedObject) {
        String logs = selectedObject.getLog();
        this.showConsole();
        TaskTracker inputElement = this.diagnoseRequest.getTracker();
        if (!(inputElement instanceof WorkflowTracker) && inputElement instanceof WorkflowJobTracker) {
            WorkflowJobTracker workflowJobTracker = (WorkflowJobTracker)inputElement;
            this.consoleLog2.setCurrentEntry(workflowJobTracker.getSubmissionHistoryEntry());
            this.consoleLog2.updateLogText(workflowJobTracker.getSubmissionHistoryEntry().getTrackInfo());
            this.consoleLog2.updateSelected(selectedObject.getStartEvent());
            this.consoleLog2.setRawText(logs);
        }
    }

    private void createDetailsFormControls(SashForm toplevel) {
        if (this.detailsForm == null) {
            this.detailsForm = this.toolkit.createScrolledForm((Composite)toplevel);
            this.detailsForm.getForm().addMessageHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter());
            this.detailsForm.getBody().setLayout((Layout)new FillLayout());
        }
        Control[] controlArray = this.detailsForm.getBody().getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            try {
                c.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        if (this.detailsFormBody != null && !this.detailsFormBody.isDisposed()) {
            this.detailsFormBody.dispose();
        }
        this.detailsFormBody = this.toolkit.createComposite(this.detailsForm.getBody());
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        this.detailsFormBody.setLayout((Layout)layout);
        Dialog.applyDialogFont((Control)this.detailsForm.getBody());
        this.createSummarySection();
        this.addBlack();
        this.createResolutionSection();
        this.addBlack();
    }

    public void updateLayout() {
        this.detailsFormBody.layout();
    }

    private Section createSummarySection() {
        this.summarySection = this.toolkit.createSection(this.detailsFormBody, 258);
        this.summarySection.setActiveToggleColor(this.toolkit.getHyperlinkGroup().getActiveForeground());
        this.summarySection.setToggleColor(this.toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        this.summarySection.setText("Summary");
        this.summarySection.setExpanded(true);
        this.summarySection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ExpertSystemView.this.detailsForm.reflow(false);
            }
        });
        this.summeryView = new ExpertSystemSummaryView(this, this.summarySection, this.toolkit);
        this.summeryView.createSection();
        return this.summarySection;
    }

    private void updateDescSection() {
        this.summeryView.update(this.diagnoseRequest);
    }

    private Section createResolutionSection() {
        this.problemSection = this.toolkit.createSection(this.detailsFormBody, 258);
        this.problemSection.setActiveToggleColor(this.toolkit.getHyperlinkGroup().getActiveForeground());
        this.problemSection.setToggleColor(this.toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        this.problemSection.setText("Resolution Overview");
        this.problemSection.setExpanded(true);
        this.problemSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ExpertSystemView.this.detailsForm.reflow(false);
            }
        });
        this.problemOverview = new ExpertSystemProblemOverview(this, this.problemSection, this.toolkit);
        this.problemOverview.createSection();
        return this.problemSection;
    }

    void addBlack() {
        Label blankLabel = this.toolkit.createLabel(this.detailsFormBody, "");
        GridData gridData = new GridData(4, 1, false, false, 1, 1);
        gridData.widthHint = 5;
        blankLabel.setLayoutData((Object)gridData);
    }

    public ExpertSystemAPI getExpertSystemAPI() {
        return this.expertSystemAPI;
    }

    public IProgressService getProgressService() {
        return this.progressService;
    }

    public UISynchronize getUiSync() {
        return this.uiSync;
    }

    protected void updateRequestStatus() {
        try {
            this.getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Update in Progress, Please wait", -1);
                    try {
                        ExpertSystemView.this.getUiSync().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).ExpertSystemView.this.summeryView != null) {
                                    (this).ExpertSystemView.this.summeryView.updateRequestStatusLabel(true);
                                }
                            }
                        });
                        ExpertSystemView.this.getExpertSystemAPI().updateRequestStatus(ExpertSystemView.this.diagnoseRequest, monitor);
                        monitor.done();
                        ExpertSystemView.this.getUiSync().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).ExpertSystemView.this.summeryView != null) {
                                    (this).ExpertSystemView.this.summeryView.updateRequestStatusLabel(false);
                                    (this).ExpertSystemView.this.problemOverview.update();
                                }
                            }
                        });
                    }
                    catch (ExpertSystemAPI.APIError | ExpertSystemAPI.NoAPIConnection e) {
                        ExpertSystemView.this.getUiSync().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).ExpertSystemView.this.summeryView != null) {
                                    (this).ExpertSystemView.this.summeryView.updateRequestStatusLabel(false);
                                    (this).ExpertSystemView.this.problemOverview.update();
                                }
                            }
                        });
                        e.printStackTrace();
                        throw new InvocationTargetException(e, "Can not update request at the moment");
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void executeTask(TaskResolutionActionTemplate rt) {
        try {
            if (rt.task instanceof Task) {
                Task task = (Task)rt.task;
                String taskId = task.tool_descriptor;
                WorkflowJob job = this.workflowManager.getJobsCatalog().createJobInstanceById(taskId, new Object[0]);
                if (rt.auto_map_same_tool_input.booleanValue()) {
                    this.initTask(job, this.diagnoseRequest.entry);
                }
                job.setJobId(task.name);
                job.setValue("INPUT_CUSTOM_JOB_NAME", task.name + "-EX");
                job.getJobDesc().setDesc(rt.getResolutionDesc() + "\n-----\n" + job.getJobDesc().getDesc());
                if (task.variable_mapping != null) {
                    for (VariableMapping object : task.variable_mapping) {
                    }
                }
                if (task.extra_args != null) {
                    for (ExtraParameter extraParameter : task.extra_args) {
                    }
                }
                if (task.variable_paramaters != null) {
                    for (VariableParameter variableParameter : task.variable_paramaters) {
                        JobVariable variable = job.getVariable(variableParameter.variable);
                        variable.setRequired(variableParameter.required);
                        if (variableParameter.reason != null) {
                            variable.setWarning(variableParameter.reason);
                        }
                        if (variableParameter.value == null || variableParameter.value.isBlank()) continue;
                        variable.setValue(variableParameter.value);
                    }
                }
                IEclipseContext iEclipseContext = EclipseContextFactory.create();
                this.application.getContext().set(WorkflowJob.class, (Object)job);
                iEclipseContext.setParent(this.application.getContext());
                ContextInjectionFactory.invoke((Object)new OpenJobsMainViewHandler(), Execute.class, (IEclipseContext)this.application.getContext());
            }
        }
        catch (Exception e) {
            this.uiSync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)ExpertSystemView.this.activeShell, (String)"Error Executing Task", (String)("Expert System can not init and execute that task, with following errors " + e.getMessage()));
                }
            });
        }
    }

    private void initTask(WorkflowJob job, SubmissionHistoryEntry entry) {
        int indexR;
        int nRestart = 0;
        WorkflowJob.createPrevoiusJobNameVar((WorkflowJob)job);
        for (ITrackerInfo info : entry.getTrackInfo().getTrackerInfoEntries()) {
            String[] varKeys;
            JobVariable var;
            String varKeyValue;
            String[] tokens;
            if (!(info instanceof TrackerInfoEntry) || ((TrackerInfoEntry)info).getEventtype() != Tracking.TrackEventType.Info) continue;
            System.out.print(info);
            if (((InfoTrackEvent)info).getInfoType() == Tracking.TrackInfoType.Process || (tokens = (varKeyValue = info.getLogMsg()).split("=")).length <= 1) continue;
            String varFullKey = tokens[0];
            String varValue = tokens[1];
            if (!varFullKey.contains(".") || (var = job.getVariable((varKeys = varFullKey.split("\\."))[1])).getDescVarRole() == VariableDescriptor.VariableRole.Output) continue;
            varValue = varValue.replace(";", "\n");
            var.setValue(varValue);
            if (!"PREVIOUS_JOB_RESTART".equals(varKeys[1])) continue;
            nRestart = Integer.parseInt(varValue);
        }
        String name = job.getValue("INPUT_CUSTOM_JOB_NAME");
        if (++nRestart > 1 && (indexR = (name = job.getValue("PREVIOUS_JOB_NAME")).lastIndexOf(".")) != -1) {
            name = name.substring(0, indexR);
        }
    }

    public void executeWorkflow(TaskResolutionActionTemplate rt) {
        this.uiSync.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)ExpertSystemView.this.activeShell, (String)"Error Executing Task", (String)"Expert System can not init and execute that task at the moment ");
            }
        });
    }
}

