/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.expert.ui.internal;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.expert.DiagnoseRequest;
import com.biotechvana.expert.QAPost;
import com.biotechvana.expert.QAResolution;
import com.biotechvana.expert.RecommendationActionTemplate;
import com.biotechvana.expert.RequestResolution;
import com.biotechvana.expert.Task;
import com.biotechvana.expert.TaskBase;
import com.biotechvana.expert.TaskResolutionActionTemplate;
import com.biotechvana.expert.Workflow;
import com.biotechvana.expert.ui.internal.ExpertSystemView;
import com.biotechvana.utils.StringUtils;
import com.biotechvana.workflow.tracking.tasks.CMDTaskTracker;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class ExpertSystemProblemOverview {
    ExpertSystemView expertSystemView;
    Section resolutionSection;
    FormToolkit toolkit;
    Composite client;
    ToolItem nextResoltion;
    ToolItem preResoltion;
    Text indexCountTxt;
    int currentIndex = 0;
    Font boldFont;

    public ExpertSystemProblemOverview(ExpertSystemView expertSystemView, Section resolutionSection, FormToolkit toolkit) {
        this.expertSystemView = expertSystemView;
        this.resolutionSection = resolutionSection;
        this.toolkit = toolkit;
    }

    public void createSection() {
        ToolBar tbar = new ToolBar((Composite)this.resolutionSection, 0x800100);
        this.preResoltion = new ToolItem(tbar, 8);
        this.preResoltion.setImage(SharedImages.ARROWLEFT);
        this.preResoltion.setToolTipText("Previous Resolution");
        this.preResoltion.setEnabled(false);
        this.preResoltion.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DiagnoseRequest request = ExpertSystemProblemOverview.this.expertSystemView.getActiveDiagnoseRequest();
                if (ExpertSystemProblemOverview.this.currentIndex > 0) {
                    --ExpertSystemProblemOverview.this.currentIndex;
                    ExpertSystemProblemOverview.this.update();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem sep = new ToolItem(tbar, 2);
        this.indexCountTxt = new Text((Composite)tbar, 2048);
        this.indexCountTxt.setText("0/0");
        this.indexCountTxt.pack();
        this.indexCountTxt.setText("0/0");
        this.indexCountTxt.setEnabled(false);
        sep.setWidth(this.indexCountTxt.getSize().x);
        sep.setControl((Control)this.indexCountTxt);
        this.indexCountTxt.setToolTipText("Viewing 0 out of 0 total Resolution");
        this.nextResoltion = new ToolItem(tbar, 8);
        this.nextResoltion.setImage(SharedImages.ARROWRIGHT);
        this.nextResoltion.setToolTipText("Next Resolution");
        this.nextResoltion.setEnabled(false);
        this.nextResoltion.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DiagnoseRequest request = ExpertSystemProblemOverview.this.expertSystemView.getActiveDiagnoseRequest();
                if (ExpertSystemProblemOverview.this.currentIndex < request.getResolutionsCount() - 1) {
                    ++ExpertSystemProblemOverview.this.currentIndex;
                    ExpertSystemProblemOverview.this.update();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem titem = new ToolItem(tbar, 8);
        titem.setImage(SharedImages.HELP);
        titem.setToolTipText("Select Task/Files to see more information");
        tbar.pack();
        this.resolutionSection.setTextClient((Control)tbar);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = 5;
        this.resolutionSection.setLayoutData((Object)gd);
        this.resolutionSection.setLayout((Layout)new GridLayout(1, false));
        this.update();
        this.resolutionSection.layout(true);
    }

    public void setSelection(CMDTaskTracker.FilesTask selectedObject) {
    }

    public void setSelection(CMDTaskTracker cmdTaskTracker) {
    }

    public void update() {
        this.nextResoltion.setEnabled(false);
        this.preResoltion.setEnabled(false);
        if (this.client != null && !this.client.isDisposed()) {
            this.client.dispose();
            if (!this.boldFont.isDisposed()) {
                this.boldFont.dispose();
            }
        }
        this.client = this.toolkit.createComposite((Composite)this.resolutionSection, 0);
        FontData fontdata = this.client.getFont().getFontData()[0];
        fontdata.setStyle(1);
        this.boldFont = new Font((Device)this.client.getDisplay(), fontdata);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.client.setLayout((Layout)layout);
        DiagnoseRequest request = this.expertSystemView.getActiveDiagnoseRequest();
        if (request == null || request.getStatus() != DiagnoseRequest.DiagnosticRequestStatus.Finished) {
            Label ft = this.toolkit.createLabel(this.client, "", 64);
            GridData layoutData = new GridData(4, 1, true, false);
            layoutData.widthHint = 0;
            layoutData.horizontalIndent = 25;
            ft.setLayoutData((Object)layoutData);
            ft.setText("No Information available at the moment, Please wait");
        } else if (request.getResolutions().length > 0) {
            this.indexCountTxt.setText(this.currentIndex + 1 + "/" + request.getResolutions().length);
            RequestResolution currentRes = request.getResolutions()[this.currentIndex];
            this.createResSection(currentRes);
            if (this.currentIndex < request.getResolutionsCount() - 1) {
                this.nextResoltion.setEnabled(true);
            }
            if (this.currentIndex > 0) {
                this.preResoltion.setEnabled(true);
            }
        } else {
            Label ft = this.toolkit.createLabel(this.client, "", 64);
            GridData layoutData = new GridData(4, 1, true, false);
            layoutData.widthHint = 0;
            layoutData.horizontalIndent = 25;
            ft.setLayoutData((Object)layoutData);
            ft.setText("The expert system could not identify this problem.");
        }
        this.resolutionSection.setClient((Control)this.client);
        this.client.layout();
        this.resolutionSection.layout(true);
        this.expertSystemView.updateLayout();
    }

    private void createResSection(RequestResolution currentRes) {
        if (currentRes.getResolutionTemplate() instanceof RecommendationActionTemplate) {
            this.renderRecommendation(currentRes);
        }
        if (currentRes.getResolutionTemplate() instanceof TaskResolutionActionTemplate) {
            this.renderTaskTempalte(currentRes);
        }
        if (currentRes.getResolutionTemplate() instanceof QAResolution) {
            this.renderQAPosts(currentRes);
        }
    }

    private void renderQAPosts(RequestResolution currentRes) {
        Label ft = this.toolkit.createLabel(this.client, "", 64);
        GridData layoutDataText = new GridData(4, 1, false, false);
        layoutDataText.horizontalIndent = 50;
        layoutDataText.widthHint = 500;
        ft.setLayoutData((Object)layoutDataText);
        ft.setFont(this.boldFont);
        if (!StringUtils.isEmpty((String)currentRes.getProblemDesc())) {
            ft.setText(currentRes.getProblemDesc());
        } else if (currentRes.getResolutionTemplate() != null) {
            ft.setText(currentRes.getResolutionTemplate().getResolutionDesc());
        }
        ft = this.toolkit.createLabel(this.client, "", 64);
        layoutDataText = new GridData(4, 1, false, false);
        layoutDataText.horizontalIndent = 50;
        layoutDataText.widthHint = 500;
        ft.setLayoutData((Object)layoutDataText);
        ft.setText("However the following content may help resolve the issue :");
        int i = 0;
        if (currentRes.getResolutionTemplate() instanceof QAResolution) {
            QAResolution qaResolution = (QAResolution)currentRes.getResolutionTemplate();
            for (final QAPost post : qaResolution.getQAPosts()) {
                Hyperlink link = this.toolkit.createHyperlink(this.client, "", 64);
                layoutDataText = new GridData(4, 1, false, false);
                layoutDataText.horizontalIndent = 50;
                layoutDataText.widthHint = 500;
                link.setLayoutData((Object)layoutDataText);
                link.setText(i + " - Content from " + post.user + "@" + post.db);
                ++i;
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        if (Desktop.isDesktopSupported()) {
                            try {
                                Desktop.getDesktop().browse(new URI(post.url));
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                            catch (URISyntaxException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                });
            }
        }
    }

    private void renderTaskTempalte(RequestResolution currentRes) {
        Label ft = this.toolkit.createLabel(this.client, "", 64);
        GridData layoutDataLabel = new GridData(4, 1, true, false);
        layoutDataLabel.horizontalIndent = 25;
        ft.setLayoutData((Object)layoutDataLabel);
        ft.setText("Problem :");
        ft = this.toolkit.createLabel(this.client, "", 64);
        GridData layoutDataText = new GridData(4, 1, false, false);
        layoutDataText.horizontalIndent = 50;
        layoutDataText.widthHint = 500;
        ft.setLayoutData((Object)layoutDataText);
        ft.setFont(this.boldFont);
        if (!StringUtils.isEmpty((String)currentRes.getProblemDesc())) {
            ft.setText(currentRes.getProblemDesc());
        } else if (currentRes.getResolutionTemplate() != null) {
            ft.setText(currentRes.getResolutionTemplate().getResolutionDesc());
        }
        if (currentRes.getResolutionTemplate() != null) {
            final TaskResolutionActionTemplate rt = (TaskResolutionActionTemplate)currentRes.getResolutionTemplate();
            ft = this.toolkit.createLabel(this.client, "", 64);
            ft.setLayoutData((Object)layoutDataText);
            if (rt.task instanceof Workflow) {
                Workflow workflow = (Workflow)rt.task;
                String taskName = workflow.name;
                ft.setText("Workflow to be executed : Workflow/" + taskName);
                if (workflow.description != null) {
                    ft = this.toolkit.createLabel(this.client, "Workflow Description : " + workflow.description, 64);
                    ft.setLayoutData((Object)layoutDataText);
                }
                for (TaskBase task : workflow.tasks) {
                    if (!(task instanceof Task)) continue;
                    taskName = task.name;
                    String taskId = ((Task)task).tool_descriptor;
                    ft = this.toolkit.createLabel(this.client, "", 64);
                    ft.setLayoutData((Object)layoutDataText);
                    ft.setText("\t -- Task/" + taskId + "/" + taskName);
                }
                Button exBtn = new Button(this.client, 8);
                exBtn.setText("Edit && Execute");
                exBtn.setImage(SharedImages.RUN_EXC);
                layoutDataText = new GridData(0x1000000, 0x1000000, false, false);
                layoutDataText.horizontalIndent = 50;
                layoutDataText.widthHint = 500;
                exBtn.setLayoutData((Object)layoutDataText);
                exBtn.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        System.out.println("Edit && Execute");
                        ExpertSystemProblemOverview.this.expertSystemView.executeWorkflow(rt);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            if (rt.task instanceof Task) {
                ft.setText("Task to be executed");
                Task task = (Task)rt.task;
                String taskId = task.tool_descriptor;
                String taskName = task.name;
                ft.setText("Task to be executed : " + taskId + "/" + taskName);
                if (task.description != null) {
                    ft = this.toolkit.createLabel(this.client, "Desc :" + task.description, 64);
                    ft.setLayoutData((Object)layoutDataText);
                }
                Button exBtn = new Button(this.client, 8);
                exBtn.setText("Edit && Execute");
                exBtn.setImage(SharedImages.RUN_EXC);
                layoutDataText = new GridData(0x1000000, 0x1000000, false, false);
                layoutDataText.horizontalIndent = 50;
                layoutDataText.widthHint = 500;
                exBtn.setLayoutData((Object)layoutDataText);
                exBtn.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        System.out.println("Edit && Execute");
                        ExpertSystemProblemOverview.this.expertSystemView.executeTask(rt);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
        }
    }

    private void renderRecommendation(RequestResolution currentRes) {
        Label ft = this.toolkit.createLabel(this.client, "", 64);
        GridData layoutDataLabel = new GridData(4, 1, true, false);
        layoutDataLabel.horizontalIndent = 25;
        ft.setLayoutData((Object)layoutDataLabel);
        ft.setText("Problem :");
        ft = this.toolkit.createLabel(this.client, "", 64);
        GridData layoutDataText = new GridData(4, 1, false, false);
        layoutDataText.horizontalIndent = 50;
        layoutDataText.widthHint = 500;
        ft.setLayoutData((Object)layoutDataText);
        ft.setFont(this.boldFont);
        if (!StringUtils.isEmpty((String)currentRes.getProblemDesc())) {
            ft.setText(currentRes.getProblemDesc());
        } else if (currentRes.getResolutionTemplate() != null) {
            ft.setText(currentRes.getResolutionTemplate().getResolutionDesc());
        }
        if (currentRes.getRequest().getProblemClass() == DiagnoseRequest.ProblemClass.IdentifiedResolved) {
            if (currentRes.getResolutionTemplate() != null) {
                if (currentRes.getResolutionTemplate() instanceof RecommendationActionTemplate) {
                    RecommendationActionTemplate rt = (RecommendationActionTemplate)currentRes.getResolutionTemplate();
                    ft = this.toolkit.createLabel(this.client, "", 64);
                    ft.setLayoutData((Object)layoutDataLabel);
                    ft.setText("Recommendation : ");
                    ft = this.toolkit.createLabel(this.client, "", 64);
                    ft.setLayoutData((Object)layoutDataText);
                    ft.setText(rt.getRecommendation());
                    ft.setFont(this.boldFont);
                }
                boolean cfr_ignored_0 = currentRes.getResolutionTemplate() instanceof TaskResolutionActionTemplate;
            }
        } else if (currentRes.getRequest().getProblemClass() != DiagnoseRequest.ProblemClass.BUG && currentRes.getRequest().getProblemClass() != DiagnoseRequest.ProblemClass.Identified && currentRes.getRequest().getProblemClass() == DiagnoseRequest.ProblemClass.Identified) {
            ft = this.toolkit.createLabel(this.client, "", 64);
            layoutDataText = new GridData(4, 1, true, false, 2, 1);
            ft.setLayoutData((Object)layoutDataText);
            ft.setText("The expert system could not identify this problem.");
        }
    }

    public void reset() {
        this.currentIndex = 0;
    }
}

