/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.expert;

import com.biotechvana.commons.IGproApp;
import com.biotechvana.commons.model.UserLoginInfo;
import com.biotechvana.expert.APIPaggeResult;
import com.biotechvana.expert.DiagnoseRequest;
import com.biotechvana.expert.DiagnoseRequestLog;
import com.biotechvana.expert.ExpertSystemDataPrivacyDialog;
import com.biotechvana.expert.IExpertSystemManager;
import com.biotechvana.expert.RequestResolution;
import com.biotechvana.expert.ui.handlers.OpenExpertSystemViewViewHandler;
import com.biotechvana.users.UserManager;
import com.biotechvana.workflow.expert.IExpertSystemAPI;
import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

@Creatable
@Singleton
public class ExpertSystemAPI
implements IExpertSystemAPI,
IExpertSystemManager {
    private static String USER_TOKEN_KEY = "USER_TOKEN_KEY";
    private String API = "7rdUur4A.i0yVeCXU7BC98Lfw87MJwtN3gRETblXu";
    private String host = "https://genie.biotechvana.com/";
    private static final String API_PREFIX = "api/";
    private static final String END_POINT_API_STATUS = "api/status";
    private static final String END_POINT_CHECK_USER = "api/user/check";
    private static final String END_POINT_CREATE_USER = "api/user/register";
    private static final String END_POINT_DIAGNOSE_REQUEST = "api/expert/diagnose/";
    private static final String END_POINT_DIAGNOSE_REQUEST_SUBMIT = "api/expert/diagnose/%1$s/submit";
    private static final String END_POINT_REQUEST_STATUS = "api/expert/diagnose/%1$s/status";
    private static final String END_POINT_RESOLUTION = "api/expert/resolution/%1$s";
    private static final String END_POINT_REQUEST_LOG = "api/expert/tracklog/";
    String api_version = "v1";
    @Inject
    UserManager userManager;
    @Inject
    IGproApp gproApp;
    @Named(value="activeShell")
    private Shell activeShell;
    @Inject
    UISynchronize uiSync;
    private UserLoginInfo activeLogin;
    String userToken;
    String userName;
    ArrayList<DiagnoseRequest> userRequests = new ArrayList();
    HashMap<String, DiagnoseRequest> userRequestsMap = new HashMap();
    Boolean updateingRequests = false;
    Job updateJob;
    Client client;
    @Inject
    MApplication application;
    static String USER_ACCEPT_TERMS = "USER_ACCEPT_TERMS";

    @Inject
    public void setActiveLogin(@Optional @Named(value="ACTIVE_LOGIN") UserLoginInfo activeLogin) {
        this.activeLogin = activeLogin;
        if (activeLogin != null) {
            this.userToken = this.userManager.get(USER_TOKEN_KEY, null);
            this.userName = activeLogin.getUserName();
            this.userName = this.userName + "@" + activeLogin.getHostInfo().getServerName();
            if (this.updateJob != null) {
                this.updateJob.schedule();
            }
        } else {
            this.userToken = null;
            this.userName = null;
            this.userRequests.clear();
            this.userRequestsMap.clear();
        }
    }

    @PostConstruct
    public void init() {
        RequestResolution.manager = this;
        DiagnoseRequest.manager = this;
        this.updateJob = new Job("Updating Expert System"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                Boolean bl = ExpertSystemAPI.this.updateingRequests;
                synchronized (bl) {
                    monitor.beginTask("Expert System Update", -1);
                    System.out.println("Update Expert System");
                    ExpertSystemAPI.this.updateingRequests = true;
                    try {
                        ExpertSystemAPI.this.setUpApi();
                        ExpertSystemAPI.this.getAllRequests();
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        return Status.CANCEL_STATUS;
                    }
                    ExpertSystemAPI.this.updateingRequests = false;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        if (this.activeLogin != null) {
            this.updateJob.schedule();
        }
    }

    void getAllRequests() throws NoAPIConnection, APIError {
        block7: {
            this.userRequests.clear();
            this.userRequestsMap.clear();
            try {
                Invocation.Builder invocationBuilder;
                Response response;
                Client client = this.getClient();
                WebTarget webTarget = client.target(this.host).path(END_POINT_DIAGNOSE_REQUEST);
                webTarget = webTarget.queryParam("app", new Object[]{this.gproApp.getAppName()});
                while ((response = (invocationBuilder = webTarget.request(new String[]{"application/json"})).get()).getStatusInfo().toEnum() == Response.Status.OK) {
                    APIPaggeResult resBody = (APIPaggeResult)response.readEntity((GenericType)new GenericType<APIPaggeResult<DiagnoseRequest>>(){});
                    this.userRequests.addAll(resBody.results);
                    if (resBody.next != null) {
                        webTarget = client.target(resBody.next);
                        continue;
                    }
                    break block7;
                }
                throw new APIError(response.getStatusInfo().getReasonPhrase());
            }
            catch (ProcessingException e) {
                if (e.getCause() instanceof ConnectException) {
                    e.getCause().printStackTrace(System.err);
                } else {
                    e.printStackTrace(System.err);
                }
                this.userRequests.clear();
                throw new NoAPIConnection((Throwable)e);
            }
        }
        for (DiagnoseRequest request : this.userRequests) {
            this.userRequestsMap.put(request.entry_id, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagnoseRequest resolve(SubmissionHistoryEntry entry) throws NoAPIConnection, APIError {
        DiagnoseRequest request = this.userRequestsMap.get(entry.getIdentifier());
        if (request != null) {
            request.local_track_file = entry.getTrackFile();
            request.entry = entry;
            return request;
        }
        this.setUpApi();
        String appName = this.gproApp.getAppName();
        String appVersion = this.gproApp.getVersion();
        request = DiagnoseRequest.create(entry, this.userName, appName, appVersion);
        DiagnoseRequest newRequest = this.postRequest(request);
        Boolean bl = this.updateingRequests;
        synchronized (bl) {
            this.userRequests.add(request);
            this.userRequestsMap.put(request.entry_id, request);
        }
        return request;
    }

    private DiagnoseRequest postRequest(DiagnoseRequest request) throws NoAPIConnection, APIError {
        Client client = this.getClient();
        WebTarget webTarget = client.target(this.host).path(END_POINT_DIAGNOSE_REQUEST);
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
        try {
            Response response = invocationBuilder.post(request.asEntity());
            if (response.getStatusInfo().toEnum() == Response.Status.CREATED) {
                DiagnoseRequest resBody = (DiagnoseRequest)response.readEntity(DiagnoseRequest.class);
                request.id = resBody.id;
                webTarget = client.target(this.host).path(END_POINT_REQUEST_LOG);
                invocationBuilder = webTarget.request(new String[]{"application/json"});
                for (DiagnoseRequestLog log : request.getLogEvents()) {
                    Entity logRequestJson = Entity.entity((Object)log, (String)"application/json");
                    response = invocationBuilder.post(logRequestJson);
                    if (response.getStatusInfo().toEnum() == Response.Status.CREATED) {
                        DiagnoseRequestLog responseLog = (DiagnoseRequestLog)response.readEntity(DiagnoseRequestLog.class);
                        log.id = responseLog.id;
                        continue;
                    }
                    System.out.println(response.getStatusInfo());
                }
                webTarget = client.target(this.host).path(String.format(END_POINT_DIAGNOSE_REQUEST_SUBMIT, request.id));
                invocationBuilder = webTarget.request(new String[]{"application/json"});
                response = invocationBuilder.get();
                System.out.println("Request submit finised " + String.valueOf(response.getStatusInfo()));
                return request;
            }
            throw new APIError(response.getStatusInfo().getReasonPhrase());
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof ConnectException) {
                e.getCause().printStackTrace(System.err);
                throw new NoAPIConnection(e.getCause());
            }
            e.printStackTrace(System.err);
            throw new NoAPIConnection(e.getCause());
        }
    }

    void setUpApi() throws NoAPIConnection {
        if (!this.checkOrCreateUser()) {
            this.createUser();
        }
    }

    boolean checkOrCreateUser() throws NoAPIConnection {
        try {
            Client client = this.createClient();
            String password = this.getUserPassword();
            HttpAuthenticationFeature loginFeature = HttpAuthenticationFeature.basicBuilder().credentials(this.userName, password).build();
            client.register((Object)loginFeature);
            WebTarget webTarget = client.target(this.host).path(END_POINT_CHECK_USER);
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
            Response response = invocationBuilder.get();
            if (response.getStatusInfo().toEnum() == Response.Status.OK) {
                String resBody = (String)response.readEntity(String.class);
                System.out.println(response.getStatus());
                System.out.println(resBody);
                return true;
            }
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof ConnectException) {
                e.getCause().printStackTrace(System.err);
            } else {
                e.printStackTrace(System.err);
            }
            throw new NoAPIConnection((Throwable)e);
        }
        return false;
    }

    private boolean createUser() throws NoAPIConnection {
        Client client = this.createClient();
        WebTarget webTarget = client.target(this.host).path(END_POINT_CREATE_USER);
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
        class User {
            String user_name;
            String password;
            String email;
            String server_id;

            User() {
            }
        }
        User newUser = new User();
        newUser.email = this.activeLogin.getEmailAddress();
        newUser.user_name = this.userName;
        newUser.password = this.activeLogin.getPassword();
        newUser.server_id = this.activeLogin.getHostInfo().getServerURL();
        this.userToken = this.userName;
        this.userManager.put(USER_TOKEN_KEY, this.userToken);
        try {
            Response response = invocationBuilder.post(Entity.entity((Object)newUser, (String)"application/json"));
            if (response.getStatusInfo().toEnum() == Response.Status.CREATED) {
                String resBody = (String)response.readEntity(String.class);
                System.out.println(response.getStatus());
                System.out.println(resBody);
                return true;
            }
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof ConnectException) {
                e.getCause().printStackTrace(System.err);
            } else {
                e.printStackTrace(System.err);
            }
            throw new NoAPIConnection((Throwable)e);
        }
        return false;
    }

    public void updateRequestStatus(DiagnoseRequest request, IProgressMonitor monitor) throws APIError, NoAPIConnection {
        Client client = this.getClient();
        WebTarget webTarget = client.target(this.host).path(String.format(END_POINT_REQUEST_STATUS, request.id));
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
        try {
            Response response = invocationBuilder.get();
            if (response.getStatusInfo().toEnum() == Response.Status.OK) {
                DiagnoseRequest requestStatus = (DiagnoseRequest)response.readEntity(DiagnoseRequest.class);
                request.status = requestStatus.status;
                request.resolutions = requestStatus.resolutions;
                this.updateRequestResolutions(request, monitor);
                return;
            }
            throw new APIError(response.getStatusInfo().getReasonPhrase());
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof ConnectException) {
                e.getCause().printStackTrace(System.err);
                throw new NoAPIConnection(e.getCause());
            }
            e.printStackTrace(System.err);
            throw new NoAPIConnection(e.getCause());
        }
    }

    public void updateRequestStatus(DiagnoseRequest request) throws APIError, NoAPIConnection {
        this.updateRequestStatus(request, (IProgressMonitor)new NullProgressMonitor());
    }

    public RequestResolution getRequestResolution(int id) throws APIError, NoAPIConnection {
        Client client = this.getClient();
        WebTarget webTarget = client.target(this.host).path(String.format(END_POINT_RESOLUTION, id));
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
        try {
            Response response = invocationBuilder.get();
            if (response.getStatusInfo().toEnum() == Response.Status.OK) {
                RequestResolution resoltion = (RequestResolution)response.readEntity(RequestResolution.class);
                return resoltion;
            }
            throw new APIError(response.getStatusInfo().getReasonPhrase());
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof ConnectException) {
                e.getCause().printStackTrace(System.err);
                throw new NoAPIConnection(e.getCause());
            }
            e.printStackTrace(System.err);
            throw new NoAPIConnection(e.getCause());
        }
    }

    Client getClient() {
        if (this.client == null) {
            this.client = this.createClient();
            String password = this.getUserPassword();
            HttpAuthenticationFeature loginFeature = HttpAuthenticationFeature.basicBuilder().credentials(this.userName, password).build();
            this.client.register((Object)loginFeature);
            ((Client)this.client.register((Object)loginFeature)).register(MultiPartFeature.class);
        }
        return this.client;
    }

    Client createClient() {
        SslConfigurator sslConfig = SslConfigurator.newInstance();
        SSLContext sslContext = sslConfig.createSSLContext();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).build();
        Client client = (Client)JerseyClientBuilder.newClient().register((Object)registry);
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        JacksonJaxbJsonProvider jsonProvider = new JacksonJaxbJsonProvider(mapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);
        client.register((Object)jsonProvider);
        client.register((Object)new ClientRequestFilter(){

            public void filter(ClientRequestContext context) throws IOException {
                MultivaluedMap headers = context.getHeaders();
                Map cookies = context.getCookies();
                headers.add((Object)"API-Key", (Object)ExpertSystemAPI.this.API);
            }
        });
        return client;
    }

    void testHTTPS() {
        String host = "https://genie.biotechvana.com/";
        SslConfigurator sslConfig = SslConfigurator.newInstance();
        SSLContext sslContext = sslConfig.createSSLContext();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).build();
        Client client = (Client)JerseyClientBuilder.newClient().register((Object)registry);
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        JacksonJaxbJsonProvider jsonProvider = new JacksonJaxbJsonProvider(mapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);
        client.register((Object)jsonProvider);
        client.register((Object)new ClientRequestFilter(){

            public void filter(ClientRequestContext context) throws IOException {
                MultivaluedMap headers = context.getHeaders();
                Map cookies = context.getCookies();
                headers.add((Object)"API-Key", (Object)ExpertSystemAPI.this.API);
            }
        });
        WebTarget webTarget = client.target(host).path("api/tools/");
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
        try {
            Response response = invocationBuilder.get();
            if (response.getStatusInfo().toEnum() == Response.Status.OK) {
                String resBody = (String)response.readEntity(String.class);
                System.out.println(response.getStatus());
                System.out.println(resBody);
            }
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof ConnectException) {
                e.getCause().printStackTrace(System.err);
            } else {
                e.printStackTrace(System.err);
            }
            throw e;
        }
    }

    void update() {
    }

    private String getUserPassword() {
        String password = this.activeLogin.getPassword();
        return password;
    }

    public void submit(final SubmissionHistoryEntry entry) {
        if (this.checkExpertSystemTerms()) {
            Job job = new Job("Expert System Request"){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("Expert System Request", -1);
                    try {
                        final DiagnoseRequest request = ExpertSystemAPI.this.resolve(entry);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ExpertSystemAPI.this.uiSync.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ExpertSystemAPI.this.showExpertSystem();
                                IEclipseContext expertSubContext = (this).ExpertSystemAPI.this.application.getContext();
                                expertSubContext.set("activeDiagnoseRequest", (Object)request);
                            }
                        });
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                    catch (NoAPIConnection e) {
                        e.printStackTrace(System.err);
                        ExpertSystemAPI.this.uiSync.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)(this).ExpertSystemAPI.this.activeShell, (String)"Error", (String)"Can not connect to the Expert System at the moment please try again later");
                            }
                        });
                    }
                    catch (APIError e) {
                        e.printStackTrace(System.err);
                        ExpertSystemAPI.this.uiSync.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)(this).ExpertSystemAPI.this.activeShell, (String)"Request Failed", (String)"Can not create new request at the moment please try again later");
                            }
                        });
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            job.schedule();
        }
    }

    private void showExpertSystem() {
        try {
            IEclipseContext expertSubContext = this.application.getContext();
            ContextInjectionFactory.invoke((Object)new OpenExpertSystemViewViewHandler(), Execute.class, (IEclipseContext)this.application.getContext());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    boolean checkExpertSystemTerms() {
        String userAccpetTerms = this.userManager.get(USER_ACCEPT_TERMS, "false");
        if (!userAccpetTerms.equals("true")) {
            ExpertSystemDataPrivacyDialog dialog = new ExpertSystemDataPrivacyDialog(this.activeShell);
            dialog.create();
            if (dialog.open() == 0 && dialog.getUserSelecttion()) {
                this.userManager.put(USER_ACCEPT_TERMS, "true");
                userAccpetTerms = "true";
                this.userManager.savePreferences();
            }
        }
        return userAccpetTerms.equals("true");
    }

    @Override
    public DiagnoseRequest getRequestById(int id) {
        for (DiagnoseRequest request : this.userRequests) {
            if (request.getReqeustId() != id) continue;
            return request;
        }
        return null;
    }

    public DiagnoseRequest getRequestByEntryId(String entry_id) {
        for (DiagnoseRequest request : this.userRequests) {
            if (!request.getEntryId().equals(entry_id)) continue;
            return request;
        }
        return null;
    }

    private DiagnoseRequest getRequestByEntryId(DiagnoseRequest request) {
        return null;
    }

    public void updateRequestResolutions(DiagnoseRequest diagnoseRequest, IProgressMonitor monitor) {
        diagnoseRequest.clearResolutionsObjects();
        if (diagnoseRequest.getResolutionsIds() != null) {
            Integer[] integerArray = diagnoseRequest.getResolutionsIds();
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                int id = integerArray[n2];
                try {
                    RequestResolution res = this.getRequestResolution(id);
                    diagnoseRequest.addResolution(res);
                }
                catch (APIError | NoAPIConnection e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
    }

    public class APIError
    extends Exception {
        private static final long serialVersionUID = 3033842684046671605L;

        public APIError() {
            super("Can not query the Expert System APIs");
        }

        public APIError(String mgs) {
            super(mgs);
        }
    }

    public class NoAPIConnection
    extends Exception {
        private static final long serialVersionUID = 372842830903191373L;

        public NoAPIConnection() {
            super("Can not Connect to the Expert System APIs ");
        }

        public NoAPIConnection(Throwable ex) {
            super("Can not Connect to the Expert System APIs ", ex);
        }
    }
}

