/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.expert;

import com.biotechvana.expert.DiagnoseRequestLog;
import com.biotechvana.expert.IExpertSystemManager;
import com.biotechvana.expert.RequestResolution;
import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.biotechvana.workflow.tracking.ITrackerInfo;
import com.biotechvana.workflow.tracking.TrackerInfoEntry;
import com.biotechvana.workflow.tracking.tasks.CMDTaskTracker;
import com.biotechvana.workflow.tracking.tasks.TaskTracker;
import com.biotechvana.workflow.tracking.tasks.WorkflowJobTracker;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.File;
import java.util.ArrayList;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class DiagnoseRequest {
    public static IExpertSystemManager manager;
    Integer id;
    String user;
    String app_version;
    String task_id;
    String entry_id;
    String app;
    @JsonProperty(value="problem_class")
    ProblemClass problemClass;
    String task_type;
    String task_status;
    File local_track_file;
    File local_desc_file;
    Integer[] resolutions;
    ArrayList<RequestResolution> resolutionsObjs = new ArrayList();
    DiagnosticRequestStatus status = DiagnosticRequestStatus.Pending;
    public SubmissionHistoryEntry entry;
    @JsonProperty(value="logs")
    ArrayList<DiagnoseRequestLog> logEvents = new ArrayList();

    public ProblemClass getProblemClass() {
        return this.problemClass;
    }

    public String toString() {
        return this.task_id;
    }

    Entity<FormDataMultiPart> asEntity() {
        FileDataBodyPart filePart = new FileDataBodyPart("track_file", this.local_track_file);
        FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
        formDataMultiPart.field("task_id", this.task_id).field("entry_id", this.entry_id).field("task_status", this.task_status).field("task_type", this.task_type).field("user", this.user).field("app", this.app).field("app_version", this.app_version).field("logs", new ArrayList(), MediaType.APPLICATION_JSON_TYPE).bodyPart((BodyPart)filePart);
        return Entity.entity((Object)formDataMultiPart, (MediaType)formDataMultiPart.getMediaType());
    }

    public static DiagnoseRequest create(SubmissionHistoryEntry entry, String userName, String appName, String appVersion) {
        DiagnoseRequest request = new DiagnoseRequest();
        request.task_id = entry.getTaskTemplateId();
        request.entry_id = entry.getIdentifier();
        request.user = userName;
        request.app = appName;
        request.app_version = appVersion;
        request.local_track_file = entry.getTrackFile();
        request.entry = entry;
        request.task_status = entry.getStatus().name();
        request.task_type = entry.getTaskType().name();
        if (entry.getTracker() instanceof WorkflowJobTracker) {
            WorkflowJobTracker workflowJobTracker = (WorkflowJobTracker)entry.getTracker();
            for (CMDTaskTracker cmdTaskTracker : workflowJobTracker.getCmdTasks()) {
                System.out.print(cmdTaskTracker.getTaskId());
                for (CMDTaskTracker.FilesTask filesTask : cmdTaskTracker.getCmdTasks()) {
                    System.out.println(filesTask.getStatus());
                    if (filesTask.getStatus() == ExecStatus.Canceled) continue;
                    DiagnoseRequestLog log = new DiagnoseRequestLog();
                    log.subTaskId = cmdTaskTracker.getTaskId();
                    log.cmdTaskTracker = cmdTaskTracker;
                    log.file_index = filesTask.index;
                    log.var_key = cmdTaskTracker.getVarKey();
                    log.logsMsg = entry.getTrackInfo().getLogMsg(filesTask.getStartEvent());
                    log.events = filesTask.getStartEvent().getEventLine();
                    log.filesTask = filesTask;
                    for (ITrackerInfo o : filesTask.getEvents()) {
                        if (!(o instanceof TrackerInfoEntry)) continue;
                        log.events = String.valueOf(log.events) + "\n" + ((TrackerInfoEntry)o).getEventLine();
                    }
                    log.events = String.valueOf(log.events) + "\n" + filesTask.getFinshEvent().getEventLine();
                    request.addLogEvent(log);
                }
            }
        }
        return request;
    }

    @JsonSetter(value="logs")
    public void addLogEvent(ArrayList<DiagnoseRequestLog> logs) {
        for (DiagnoseRequestLog log : logs) {
            this.addLogEvent(log);
        }
    }

    public void addLogEvent(DiagnoseRequestLog log) {
        log.setRequest(this);
        this.logEvents.add(log);
    }

    public TaskTracker getTracker() {
        if (this.entry != null) {
            return this.entry.getTracker();
        }
        return null;
    }

    public ArrayList<DiagnoseRequestLog> getLogEvents() {
        return this.logEvents;
    }

    public static DiagnoseRequest getRequestById(Integer request_id) {
        return manager.getRequestById(request_id);
    }

    public int getReqeustId() {
        return this.id;
    }

    public String getEntryId() {
        return this.entry_id;
    }

    public Integer getId() {
        return this.id;
    }

    public Integer[] getResolutionsIds() {
        return this.resolutions;
    }

    public DiagnosticRequestStatus getStatus() {
        return this.status;
    }

    public void addResolution(RequestResolution res) {
        this.resolutionsObjs.add(res);
    }

    public RequestResolution[] getResolutions() {
        return this.resolutionsObjs.toArray(new RequestResolution[this.resolutionsObjs.size()]);
    }

    public int getResolutionsCount() {
        return this.resolutionsObjs.size();
    }

    public void clearResolutionsObjects() {
        this.resolutionsObjs.clear();
    }

    public static enum DiagnosticRequestStatus {
        Pending(1),
        Processing(2),
        Finished(3);

        @JsonValue
        int id;

        private DiagnosticRequestStatus(int id) {
            this.id = id;
        }
    }

    public static enum ProblemClass {
        Identified("I"),
        IdentifiedResolved("IR"),
        IdentifiedNoResolution("INR"),
        Unidentified("UI"),
        BUG("B"),
        NO_CLASS("NC");

        @JsonValue
        String id;

        private ProblemClass(String id) {
            this.id = id;
        }
    }
}

