/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.utils;

import com.biotechvana.utils.IPrefs;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProxyManager {
    private static final int TIMEOUT = 10000;
    IPrefs prefsStore;

    public ProxyManager(IPrefs prefsStore) {
        this.prefsStore = prefsStore;
    }

    public String getProxyType() {
        String proxyType;
        block3: {
            try {
                proxyType = this.prefsStore.get("proxy_type", "");
                if (proxyType != null && proxyType.length() != 0) break block3;
                return "proxy_type_none";
            }
            catch (Exception ex) {
                return "proxy_type_none";
            }
        }
        return proxyType;
    }

    public Proxy getDefaultProxyForProtocol(Proxy.Type type) {
        try {
            List<Proxy> listProxy = ProxySelector.getDefault().select(new URI(this.prefsStore.get("ssh_host", "")));
            for (Proxy p : listProxy) {
                System.out.println("P:" + String.valueOf(p));
                System.out.println("Type:" + String.valueOf((Object)p.type()));
                System.out.println("Address:" + String.valueOf(p.address()));
                if (!p.type().equals((Object)type)) continue;
                return p;
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
    }

    private void saveProxyType(String proxyType) throws Exception {
        try {
            this.prefsStore.put("proxy_type", proxyType);
        }
        catch (Exception ex) {
            throw new Exception("Cannot save proxy settings", ex);
        }
    }

    public void setProxyNone() throws Exception {
        try {
            this.saveProxyType("proxy_type_none");
        }
        catch (Exception ex) {
            throw new Exception("Cannot save proxy settings", ex);
        }
    }

    public void setProxySystem() throws Exception {
        try {
            this.saveProxyType("proxy_type_system");
        }
        catch (Exception ex) {
            throw new Exception("Cannot save proxy settings", ex);
        }
    }

    public void setProxyManual(String httpHost, String httpPort, String ftpHost, String ftpPort, String user, String password) throws Exception {
        try {
            this.saveProxyType("proxy_type_manual");
            this.prefsStore.put("proxy_http_host", httpHost);
            this.prefsStore.put("proxy_http_port", httpPort);
            this.prefsStore.put("proxy_ftp_host", ftpHost);
            this.prefsStore.put("proxy_ftp_port", ftpPort);
            this.prefsStore.put("proxy_user", user);
            this.prefsStore.put("proxy_password", password);
        }
        catch (Exception ex) {
            throw new Exception("Cannot save proxy settings", ex);
        }
    }

    public void setProxyAuto(String url) throws Exception {
        try {
            this.saveProxyType("proxy_type_auto");
            this.prefsStore.put("proxy_url", url);
        }
        catch (Exception ex) {
            throw new Exception("Cannot save proxy settings", ex);
        }
    }

    public Map<String, String> getProxyManualSettings() throws Exception {
        HashMap<String, String> mapValues = new HashMap<String, String>();
        try {
            String proxyHTTPHost = this.prefsStore.get("proxy_http_host", "");
            String proxyHTTPPort = this.prefsStore.get("proxy_http_port", "");
            String proxyFTPHost = this.prefsStore.get("proxy_ftp_host", "");
            String proxyFTPPort = this.prefsStore.get("proxy_ftp_port", "");
            String proxyUser = this.prefsStore.get("proxy_user", "");
            String proxyPassword = this.prefsStore.get("proxy_password", "");
            mapValues.put("proxy_http_host", proxyHTTPHost);
            mapValues.put("proxy_http_port", proxyHTTPPort);
            mapValues.put("proxy_ftp_host", proxyFTPHost);
            mapValues.put("proxy_ftp_port", proxyFTPPort);
            mapValues.put("proxy_user", proxyUser);
            mapValues.put("proxy_password", proxyPassword);
        }
        catch (Exception ex) {
            throw new Exception("Cannot retrieve proxy settings", ex);
        }
        return mapValues;
    }

    public void applyProxyManualSettings() throws Exception {
        try {
            String proxyHTTPHost = this.prefsStore.get("proxy_http_host", "");
            String proxyHTTPPort = this.prefsStore.get("proxy_http_port", "");
            String proxyFTPHost = this.prefsStore.get("proxy_ftp_host", "");
            String proxyFTPPort = this.prefsStore.get("proxy_ftp_port", "");
            String proxyUser = this.prefsStore.get("proxy_user", "");
            String proxyPassword = this.prefsStore.get("proxy_password", "");
            System.setProperty("http.proxyHost", proxyHTTPHost);
            System.setProperty("http.proxyPort", proxyHTTPPort);
            System.setProperty("ftp.proxyHost", proxyFTPHost);
            System.setProperty("ftp.proxyPort", proxyFTPPort);
            System.setProperty("proxy.proxyUser", proxyUser);
            System.setProperty("proxy.proxyPassword", proxyPassword);
        }
        catch (Exception ex) {
            throw new Exception("Cannot retrieve proxy settings", ex);
        }
    }

    public String getProxyAutoSettings() throws Exception {
        try {
            return this.prefsStore.get("proxy_url", "");
        }
        catch (Exception ex) {
            throw new Exception("Cannot retrieve proxy settings", ex);
        }
    }
}

