/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.utils;

public class OsDetector {
    public static String OS = System.getProperty("os.name").toLowerCase();
    public static String OS_WIN = "win";
    public static String OS_OSX = "osx";
    public static String OS_UNIX = "linux";
    public static String OS_SOLARIS = "solaris";
    public static String OS_UNDEFINED = "undefined";

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return OS.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0;
    }

    public static boolean isSolaris() {
        return OS.indexOf("sunos") >= 0;
    }

    public static String getOS() {
        if (OsDetector.isWindows()) {
            return OS_WIN;
        }
        if (OsDetector.isMac()) {
            return OS_OSX;
        }
        if (OsDetector.isUnix()) {
            return OS_UNIX;
        }
        if (OsDetector.isSolaris()) {
            return OS_SOLARIS;
        }
        return OS_UNDEFINED;
    }

    public static String getArchitecture() {
        return System.getProperty("os.arch");
    }

    public static boolean is64bits() {
        return System.getProperty("os.arch").contains("64");
    }
}

