/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.wizards.pages;

import com.biotechvana.workflow.configuration.IPipelineConfiguration;
import com.biotechvana.workflow.manager.IWorkflowManager;
import jakarta.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class WorkflowWizardPage
extends WizardPage {
    @Inject
    protected IEclipseContext cntx;
    @Inject
    protected IPipelineConfiguration wfConfig;
    @Inject
    protected IWorkflowManager workflowManager;
    protected static final int TEXT_MIN_WIDTH = 400;
    protected static final int INPUT_FIELD_LABEL_WIDTH = 500;
    protected static final int HORIZONTAL_INDENT = 50;
    protected static final int MAX_WIDTH = 1000;
    protected Font boldFont11 = null;
    protected Font boldFont12 = null;
    protected Color colorlight;
    protected Color colorDark;
    ScrolledComposite scrolledComposite;
    protected Composite container;
    int rowCount = 0;

    protected WorkflowWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        this.setUpColorsAndFonts(parent);
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.container = new Composite((Composite)this.scrolledComposite, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.onCreatePageControl(this.container);
        this.scrolledComposite.setContent((Control)this.container);
        this.scrolledComposite.setMinSize(this.container.computeSize(-1, -1));
        this.setControl((Control)this.scrolledComposite);
        this.setPageComplete(false);
        this.validate();
    }

    protected abstract void validate();

    protected abstract void onCreatePageControl(Composite var1);

    protected Composite createRow(Composite parent) {
        return this.createRow(parent, 3);
    }

    protected Composite createRow(Composite parent, int numOfClms) {
        Composite row = new Composite(parent, 2048);
        row.setLayout((Layout)new GridLayout(numOfClms, false));
        row.setLayoutData((Object)new GridData(4, 4, true, false));
        this.autoSetColor(row, this.rowCount++);
        return row;
    }

    protected void autoSetColor(Composite composite, int colorIndex) {
        int localColorIndex = colorIndex;
        composite.setBackgroundMode(1);
        if (localColorIndex % 2 == 1) {
            composite.setBackground(this.colorlight);
        } else {
            composite.setBackground(this.colorDark);
        }
    }

    protected void setUpColorsAndFonts(Composite parent) {
        FontData fontdata = parent.getFont().getFontData()[0];
        fontdata.setStyle(1);
        fontdata.setHeight(11);
        this.boldFont11 = new Font((Device)parent.getDisplay(), fontdata);
        fontdata.setHeight(12);
        this.boldFont12 = new Font((Device)parent.getDisplay(), fontdata);
        Color c = parent.getDisplay().getSystemColor(22);
        int r = c.getRed() - 10;
        int g = c.getGreen() - 10;
        int b = c.getBlue() - 10;
        if (r < 0) {
            r = 0;
        }
        if (g < 0) {
            g = 0;
        }
        if (b < 0) {
            b = 0;
        }
        this.colorDark = new Color(c.getDevice(), r, g, b);
        r = c.getRed() + 10;
        g = c.getGreen() + 10;
        b = c.getBlue() + 10;
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        this.colorlight = new Color(c.getDevice(), r, g, b);
    }

    protected void layoutPage() {
        this.container.layout(true);
        this.scrolledComposite.setMinSize(this.container.computeSize(-1, -1));
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.onPageDisplay();
        }
        super.setVisible(visible);
    }

    public abstract void onPageDisplay();
}

