/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.wizards.pages;

import com.biotechvana.ui.v2.ftpexplorer.FTPSelectDialog;
import com.biotechvana.workflow.configuration.IPipelineConfiguration;
import com.biotechvana.workflow.wizards.pages.WorkflowWizardPage;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

@Creatable
public class WelcomePage
extends WorkflowWizardPage {
    String wfName = null;
    String wfPath = null;
    private Composite container;
    private Text inputWfNameField;
    private Text inputWfPathField;

    public WelcomePage() {
        super("Basic Pipeline configration");
        this.setTitle("Basic Pipeline Configration");
        this.setDescription("Setup Pipeline name and location");
    }

    @Override
    public void onCreatePageControl(Composite container) {
        Composite row = this.createRow(container);
        Label inputFieldLabel = new Label(row, 0);
        GridData layoutData = new GridData(4, 1, false, false, 3, 1);
        layoutData.widthHint = 500;
        inputFieldLabel.setLayoutData((Object)layoutData);
        inputFieldLabel.setFont(this.boldFont11);
        inputFieldLabel.setText("Selected Pipeline/workflow Description:");
        Text selectedPipelineInfo = new Text(row, 2120);
        layoutData = new GridData(4, 1, true, false, 3, 1);
        layoutData.horizontalIndent = 50;
        layoutData.widthHint = 500;
        selectedPipelineInfo.setLayoutData((Object)layoutData);
        selectedPipelineInfo.setText(this.wfConfig.getWorkflowDesc());
        row = this.createRow(container);
        inputFieldLabel = new Label(row, 0);
        layoutData = new GridData(4, 1, false, false, 3, 1);
        layoutData.widthHint = 500;
        inputFieldLabel.setLayoutData((Object)layoutData);
        inputFieldLabel.setText("Pipeline/Workflow name : ");
        inputFieldLabel.setFont(this.boldFont11);
        inputFieldLabel.setToolTipText("Give a custom name to your Pipeline/Workflow.");
        this.inputWfNameField = new Text(row, 2052);
        layoutData = new GridData(4, 1, false, false, 2, 1);
        layoutData.widthHint = 500;
        layoutData.horizontalIndent = 50;
        this.inputWfNameField.setLayoutData((Object)layoutData);
        this.wfName = this.wfConfig.getPojectName();
        this.inputWfNameField.setMessage("Give a custom name to your Pipeline/Workflow.");
        this.inputWfNameField.setToolTipText("Give a custom name to your Pipeline/Workflow.");
        this.inputWfNameField.setText(this.wfName);
        this.inputWfNameField.addListener(24, new Listener(){
            long lastTimeUpdate = 0L;

            public void handleEvent(Event event) {
                WelcomePage.this.wfName = WelcomePage.this.inputWfNameField.getText();
                WelcomePage.this.validate();
            }
        });
        row = this.createRow(container);
        inputFieldLabel = new Label(row, 0);
        layoutData = new GridData(4, 1, false, false, 3, 1);
        layoutData.widthHint = 500;
        inputFieldLabel.setLayoutData((Object)layoutData);
        inputFieldLabel.setText("Select Output Folder ");
        inputFieldLabel.setFont(this.boldFont11);
        inputFieldLabel.setToolTipText("Folder where Pipeline/Workflow outputs are stored in remote server.");
        this.inputWfPathField = new Text(row, 2060);
        layoutData = new GridData(4, 0x1000000, false, false, 2, 1);
        layoutData.widthHint = 500;
        layoutData.horizontalIndent = 50;
        this.inputWfPathField.setLayoutData((Object)layoutData);
        this.inputWfPathField.setMessage("Select Folder");
        this.inputWfPathField.setToolTipText("Select Folder.");
        this.wfPath = this.wfConfig.getProjectFolder();
        this.inputWfPathField.setText(this.wfPath);
        Button selectPipeline = new Button(row, 8);
        selectPipeline.setText("Browse/Select");
        selectPipeline.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        selectPipeline.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IEclipseContext dialogContext = EclipseContextFactory.create((String)FTPSelectDialog.class.getName());
                dialogContext.setParent(WelcomePage.this.cntx);
                FTPSelectDialog dialog = (FTPSelectDialog)ContextInjectionFactory.make(FTPSelectDialog.class, (IEclipseContext)dialogContext);
                dialog.open();
                WelcomePage.this.wfPath = dialog.getSelectedFile();
                if (WelcomePage.this.wfPath == null) {
                    WelcomePage.this.inputWfPathField.setText("");
                } else {
                    WelcomePage.this.inputWfPathField.setText(WelcomePage.this.wfPath);
                }
                dialogContext.dispose();
                WelcomePage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    protected void validate() {
        String validMsg;
        this.setErrorMessage(null);
        boolean isValid = true;
        if (this.wfName == null || this.wfName.isEmpty()) {
            validMsg = "Pipeline Name is missing";
            this.setErrorMessage(validMsg);
            isValid = false;
        } else {
            this.wfConfig.setProjectName(this.wfName);
            if (!this.workflowManager.getWorkflowCatalog().checkExperimentConfigurationName(this.wfConfig)) {
                isValid = false;
                validMsg = "There is a project with the same name , Please change the name.";
                this.setErrorMessage(validMsg);
            }
        }
        if (this.wfPath == null || this.wfPath.isEmpty()) {
            validMsg = "Pipeline Folder is missing";
            this.setErrorMessage(validMsg);
            isValid = false;
        }
        if (isValid) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    public void setWorkflowConfiguration(IPipelineConfiguration workflowConfiguretion) {
        this.wfConfig = workflowConfiguretion;
    }

    @Override
    public void onPageDisplay() {
        this.wfName = this.wfConfig.getPojectName();
        this.wfPath = this.wfConfig.getProjectFolder();
        this.inputWfNameField.setText(this.wfName);
        this.inputWfPathField.setText(this.wfPath);
    }
}

