/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.wizards.pages;

import com.biotechvana.workflow.configuration.IConfigurationWithReference;
import com.biotechvana.workflow.views.WorkflowJobPlainComposite;
import com.biotechvana.workflow.wizards.pages.MapperReferenceJobCollector;
import com.biotechvana.workflow.wizards.pages.WorkflowFTPWizardPage;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

@Creatable
public class MappingReferencePage
extends WorkflowFTPWizardPage {
    MapperReferenceJobCollector refJobCollector;
    static final String TITLE = "Genomic Reference Information";
    IConfigurationWithReference wfConfigWithReference;
    String desc = "Working with genomic reference, set it up here";

    public MappingReferencePage() {
        super(TITLE);
        this.setTitle(TITLE);
        this.setDescription(this.desc);
    }

    @Override
    protected void validate() {
        this.setErrorMessage(null);
        this.setPageComplete(false);
        if (this.refJobCollector.isValid()) {
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(this.refJobCollector.getFirstErrorMsg());
        }
    }

    @Override
    protected void onCreatePageControl(Composite container) {
        Assert.isLegal((boolean)(this.wfConfig instanceof IConfigurationWithReference));
        this.wfConfigWithReference = (IConfigurationWithReference)this.wfConfig;
        if (this.wfConfigWithReference.getMapperName() != null) {
            this.desc = String.valueOf(this.desc) + "\nYour selected Pipeline has " + this.wfConfigWithReference.getMapperName() + " mapper.";
            this.setDescription(this.desc);
        }
        Label infoLabel = new Label(container, 0);
        infoLabel.setForeground(container.getDisplay().getSystemColor(9));
        infoLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.refJobCollector = new MapperReferenceJobCollector(this.wfConfigWithReference, infoLabel, this);
        WorkflowJobPlainComposite refJobComposite = new WorkflowJobPlainComposite(this.workflowManager, this.refJobCollector, container, 0);
        this.refJobCollector.addObserver(new Observer(){

            @Override
            public void update(Observable arg0, Object arg1) {
                if (!arg1.equals(400)) {
                    MappingReferencePage.this.validate();
                }
            }
        });
    }

    @Override
    public void onPageDisplay() {
    }
}

