/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.wizards.pages;

import com.biotechvana.commons.model.DropManager;
import com.biotechvana.workflow.configuration.IConfigurationWithInputFileList;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.StringsJobVariable;
import com.biotechvana.workflow.views.WorkflowJobPlainComposite;
import com.biotechvana.workflow.wizards.pages.InputFilesJobCollector;
import com.biotechvana.workflow.wizards.pages.WorkflowFTPWizardPage;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

@Creatable
public class InputFilePage
extends WorkflowFTPWizardPage {
    static final int LIST_WIDTH = 500;
    static final int LIST_HEIGHT = 200;
    static final int BTN_WIDTH = 150;
    List firstList;
    DropManager firstListDM;
    static final String TITLE = "Select All input Fastq Files";
    InputFilesJobCollector refJobCollector;

    public InputFilePage() {
        super(TITLE);
        this.setTitle(TITLE);
        this.setDescription("Here you can select all your input files from the remote host. Later you can make more configration on the input file.");
    }

    @Override
    public void onCreatePageControl(Composite container) {
        Assert.isLegal((boolean)(this.wfConfig instanceof IConfigurationWithInputFileList));
        IConfigurationWithInputFileList wfConfigWithInput = (IConfigurationWithInputFileList)this.wfConfig;
        Label infoLabel = new Label(container, 0);
        infoLabel.setForeground(container.getDisplay().getSystemColor(9));
        infoLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.refJobCollector = new InputFilesJobCollector((IConfigurationWithInputFileList)this.wfConfig, infoLabel, false);
        WorkflowJobPlainComposite refJobComposite = new WorkflowJobPlainComposite(this.workflowManager, this.refJobCollector, container, 0);
        this.refJobCollector.addObserver(new Observer(){

            @Override
            public void update(Observable arg0, Object arg1) {
                if (!arg1.equals(400)) {
                    InputFilePage.this.validate();
                }
            }
        });
    }

    @Override
    protected void validate() {
        this.setErrorMessage(null);
        this.setPageComplete(false);
        IConfigurationWithInputFileList wfConfigWithInputFileList = (IConfigurationWithInputFileList)this.wfConfig;
        if (this.refJobCollector.isValid()) {
            String[][] filesValue = InputFilesJobCollector.getPairList(this.refJobCollector.getValue("INPUT_FILES"));
            String[] library = InputFilesJobCollector.getList((String)this.refJobCollector.getValue("INPUT_LIBRARY_NAMES"));
            if (library.length == 0) {
                library = this.refJobCollector.getDefaulLibraryNames();
            }
            if (wfConfigWithInputFileList.isPairEnd()) {
                wfConfigWithInputFileList.setInputFiles(filesValue[0], (String[][])new String[][]{filesValue[1]});
            } else {
                wfConfigWithInputFileList.setInputFiles(filesValue[0], (String[][])new String[0][]);
            }
            wfConfigWithInputFileList.setLibrary(library);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(this.refJobCollector.getFirstErrorMsg());
        }
    }

    @Override
    public void onPageDisplay() {
        IConfigurationWithInputFileList wfConfigWithInputFileList = (IConfigurationWithInputFileList)this.wfConfig;
        StringsJobVariable libraryVariable = (StringsJobVariable)this.refJobCollector.getVariable("INPUT_LIBRARY_NAMES");
        FileListVariable fileVariable = (FileListVariable)this.refJobCollector.getVariable("INPUT_FILES");
        libraryVariable.setValue(wfConfigWithInputFileList.getLibrary());
        if (wfConfigWithInputFileList.isPairEnd()) {
            fileVariable.setValue(wfConfigWithInputFileList.getInputFiles1(), wfConfigWithInputFileList.getInputFiles2());
        } else {
            fileVariable.setValue(wfConfigWithInputFileList.getInputFiles1());
        }
    }
}

