/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.views;

import com.biotechvana.workflow.IWorkflowJobComposite;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.ui.variables.CMDOptionControls;
import com.biotechvana.workflow.ui.variables.VariableComposite;
import com.biotechvana.workflow.variables.JobVariable;
import com.biotechvana.workflow.views.WorkflowJobBasicComposite;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class WorkflowJobClassicComposite
extends WorkflowJobBasicComposite {
    private static String generalGroup = "Uncatogerized";

    public WorkflowJobClassicComposite(IWorkflowManager workflowManager, WorkflowJob job, Composite parent, int style, FormToolkit toolkit, boolean createdesc, boolean addToolbar) {
        super(workflowManager, job, parent, style, toolkit, createdesc, addToolbar);
    }

    public WorkflowJobClassicComposite(IWorkflowManager workflowManager, WorkflowJob job, Composite parent, int style) {
        super(workflowManager, job, parent, style);
    }

    @Override
    protected void setupVariables() {
        JobVariable jobVar;
        Collection vars = this.workflowJob.getAllVariables();
        for (JobVariable var : vars) {
            if (var.getDescVarRole() != VariableDescriptor.VariableRole.Input || var.descHasEnableActions() || var.descHasGroup() || !var.isVisable()) continue;
            this.inputVarBasicGroup.add(var);
        }
        for (String group : this.workflowJob.getJobDesc().getVarGroups()) {
            if (this.workflowJob.getJobDesc().groupType(group) != VariableDescriptor.VariableRole.Input || !WorkflowJobClassicComposite.shouldRenderGroup(this.workflowJob, group)) continue;
            ArrayList<JobVariable> newInputVarGroup = new ArrayList<JobVariable>();
            for (VariableDescriptor var : this.workflowJob.getJobDesc().getGroupVars(group)) {
                jobVar = this.workflowJob.getVariable(var.getKey());
                if (var.hasEnableActions() || !jobVar.isVisable()) continue;
                newInputVarGroup.add(jobVar);
            }
            if (newInputVarGroup.size() <= 0) continue;
            this.inputVarGroups.put(group, newInputVarGroup);
        }
        for (JobVariable var : vars) {
            if (var.getDescVarRole() != VariableDescriptor.VariableRole.Option || var.descHasEnableActions() || var.descHasGroup()) continue;
            if (var.getDescCommandParamater().isEmpty() && var.getDescCommandParamaterAlt().isEmpty() || var.getDescVarType() == VariableDescriptor.VariableType.Strings) {
                this.optionalVarBasicGroup.add(var);
                continue;
            }
            if (!this.optionalVarGroups.containsKey(generalGroup)) {
                this.optionalVarGroups.put(generalGroup, new ArrayList());
            }
            ((Collection)this.optionalVarGroups.get(generalGroup)).add(var);
        }
        for (String group : this.workflowJob.getJobDesc().getVarGroups()) {
            if (this.workflowJob.getJobDesc().groupType(group) != VariableDescriptor.VariableRole.Option || !WorkflowJobClassicComposite.shouldRenderGroup(this.workflowJob, group)) continue;
            ArrayList<JobVariable> newOptionsVarGroup = new ArrayList<JobVariable>();
            for (VariableDescriptor var : this.workflowJob.getJobDesc().getGroupVars(group)) {
                jobVar = this.workflowJob.getVariable(var.getKey());
                if (var.hasEnableActions()) continue;
                newOptionsVarGroup.add(this.workflowJob.getVariable(var.getKey()));
            }
            if (newOptionsVarGroup.size() <= 0) continue;
            this.optionalVarGroups.put(group, newOptionsVarGroup);
        }
    }

    @Override
    protected void createOptionsGroup(Composite optionsGroup) {
        GridData layoutData;
        if (this.optionsCompositeBody != null) {
            this.optionsCompositeBody.dispose();
            this.redraw();
        }
        this.optionsCompositeBody = new Composite(optionsGroup, this.style);
        this.optionsCompositeBody.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        this.optionsCompositeBody.setLayout((Layout)new GridLayout(1, false));
        int colorIndex = 0;
        for (JobVariable var : this.optionalVarBasicGroup) {
            VariableComposite varComposite = VariableComposite.createJobVariableComposite((Composite)this.optionsCompositeBody, (IWorkflowJobComposite)this, (JobVariable)var, (int)this.style);
            layoutData = new GridData(4, 1, true, false, 1, 1);
            varComposite.setLayoutData((Object)layoutData);
            varComposite.setColor(colorIndex);
            ++colorIndex;
        }
        if (this.optionalVarGroups.containsKey(generalGroup)) {
            VariableComposite varComposite;
            Group basicGroup = new Group(this.optionsCompositeBody, this.style);
            layoutData = new GridData(4, 1, true, false, 1, 1);
            basicGroup.setLayoutData((Object)layoutData);
            basicGroup.setLayout((Layout)new GridLayout(5, false));
            for (JobVariable var : (Collection)this.optionalVarGroups.get(generalGroup)) {
                if (!var.descHasRules() && var.hasCommandParameter()) continue;
                varComposite = VariableComposite.createJobVariableComposite((Composite)basicGroup, (IWorkflowJobComposite)this, (JobVariable)this.workflowJob.getVariable(var.getKey()), (int)this.style);
                layoutData = new GridData(4, 1, true, false, 5, 1);
                varComposite.setLayoutData((Object)layoutData);
                varComposite.setColor(colorIndex);
                ++colorIndex;
            }
            for (JobVariable var : (Collection)this.optionalVarGroups.get(generalGroup)) {
                if (var.descHasRules() || !var.hasCommandParameter()) continue;
                varComposite = new CMDOptionControls((Composite)basicGroup, (IWorkflowJobComposite)this, var, this.style);
            }
        }
        for (String group : this.optionalVarGroups.keySet()) {
            if (group.equals(generalGroup)) continue;
            Group varGroup = new Group(this.optionsCompositeBody, this.style);
            FontData fontdata = varGroup.getFont().getFontData()[0];
            fontdata.setStyle(1);
            Font font = new Font((Device)this.getDisplay(), fontdata);
            varGroup.setFont(font);
            varGroup.setText(group);
            layoutData = new GridData(4, 1, true, false, 1, 1);
            varGroup.setLayoutData((Object)layoutData);
            varGroup.setLayout((Layout)new GridLayout(5, false));
            colorIndex = 1;
            for (JobVariable var : (Collection)this.optionalVarGroups.get(group)) {
                if (!var.descHasRules() && var.hasCommandParameter()) continue;
                VariableComposite varComposite = VariableComposite.createJobVariableComposite((Composite)varGroup, (IWorkflowJobComposite)this, (JobVariable)this.workflowJob.getVariable(var.getKey()), (int)this.style);
                layoutData = new GridData(4, 1, true, false, 5, 1);
                varComposite.setLayoutData((Object)layoutData);
                varComposite.setColor(colorIndex);
                ++colorIndex;
            }
            for (JobVariable var : (Collection)this.optionalVarGroups.get(group)) {
                if (var.descHasRules() || !var.hasCommandParameter()) continue;
                CMDOptionControls cMDOptionControls = new CMDOptionControls((Composite)varGroup, (IWorkflowJobComposite)this, var, this.style);
            }
        }
    }

    @Override
    public int varsCommandParamaterMaxStrLen() {
        int len = 5;
        for (String group : this.optionalVarGroups.keySet()) {
            for (JobVariable var : (Collection)this.optionalVarGroups.get(group)) {
                String cmdParm = var.getDescCommandParamater();
                if (cmdParm.length() <= len) continue;
                len = cmdParm.length();
            }
        }
        return len;
    }
}

