/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.internal;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.manager.WorkflowCatalog;
import com.biotechvana.workflow.template.WorkflowTemplate;
import com.biotechvana.workflow.ui.WorkflowSelectionViewfilters;
import com.biotechvana.workflow.ui.widgets.WorkflowVis;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PipelinesSelectorView {
    static final String CLM_PIPELINE_NAME_TITLE = "Name";
    static final int CLM_PIPELINE_NAME_TITLE_INDEX = 0;
    static final String CLM_PIPELINE_READLAYOUT_TITLE = "Read Layout";
    static final int CLM_PIPELINE_READLAYOUT_TITLE_INDEX = 1;
    static final String CLM_PIPELINE_PE_TITLE = "Preprocessing";
    static final int CLM_PIPELINE_PE_TITLE_INDEX = 2;
    static final String CLM_PIPELINE_MAPPER_TITLE = "Mapping";
    static final int CLM_PIPELINE_MAPPER_TITLE_INDEX = 3;
    private TableViewer tableViewer;
    private Table table;
    @Inject
    IWorkflowManager workflowManager;
    WorkflowVis workflowVis;
    WorkflowSelectionViewfilters filters;
    SashForm viewBody;
    List<WorkflowTemplate> allSavedWorkflows;

    @PostConstruct
    public void createPartControl(Composite parent, final ECommandService commandService, final EHandlerService handlerService, final @Optional WorkflowSelectionViewfilters filters) {
        this.viewBody = new SashForm(parent, 512);
        Composite upperPart = new Composite((Composite)this.viewBody, 2048);
        upperPart.setLayout((Layout)new GridLayout(2, false));
        if (filters != null) {
            this.addFilter(upperPart, filters);
            this.filters = filters;
        }
        Label headingText = new Label(upperPart, 0);
        GridData layoutData = new GridData(4, 1, true, false, 2, 1);
        headingText.setLayoutData((Object)layoutData);
        headingText.setText("Select A Pipeline");
        this.tableViewer = new TableViewer(upperPart, 68352);
        layoutData = new GridData(4, 4, true, true, 1, 4);
        layoutData.heightHint = 250;
        layoutData.widthHint = 400;
        this.tableViewer.getControl().setLayoutData((Object)layoutData);
        this.table = this.tableViewer.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText(CLM_PIPELINE_NAME_TITLE);
        tblclmn.setWidth(350);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText(CLM_PIPELINE_READLAYOUT_TITLE);
        tblclmn.setWidth(150);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText(CLM_PIPELINE_PE_TITLE);
        tblclmn.setWidth(250);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tableViewerColumn = new TableViewerColumn(this.tableViewer, 8);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText(CLM_PIPELINE_MAPPER_TITLE);
        tblclmn.setWidth(100);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        if (filters != null) {
            filters.addSelectionTableViewerColumns(this.tableViewer);
        }
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray(new WorkflowTemplate[0]);
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                String missing = "--";
                WorkflowTemplate entry = (WorkflowTemplate)element;
                switch (columnIndex) {
                    case 0: {
                        if (entry.getMetadata() != null) {
                            return entry.getMetadata().getName();
                        }
                        return entry.getDefaultWorkflowName();
                    }
                    case 1: {
                        return filters.getReadLayout(entry);
                    }
                    case 2: {
                        return filters.getPreprecossingSteps(entry);
                    }
                    case 3: {
                        return filters.getMapper(entry);
                    }
                }
                return filters.getColumnText(entry, columnIndex);
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                WorkflowTemplate entry = (WorkflowTemplate)selection.getFirstElement();
                if (entry != null) {
                    PipelinesSelectorView.this.workflowVis.setWorkflow(entry);
                }
            }
        });
        Button clearFilterSelected = new Button(upperPart, 8);
        layoutData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        layoutData.widthHint = 120;
        clearFilterSelected.setLayoutData((Object)layoutData);
        clearFilterSelected.setText("Clear Filters");
        clearFilterSelected.setSelection(true);
        clearFilterSelected.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                filters.clearSelectedFilters();
                PipelinesSelectorView.this.refreshWorkflow();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PipelinesSelectorView.this.refreshWorkflow();
            }
        });
        Button runSelected = new Button(upperPart, 0);
        layoutData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        layoutData.widthHint = 100;
        runSelected.setLayoutData((Object)layoutData);
        runSelected.setImage(SharedImages.RUNNING);
        runSelected.setText("Run");
        runSelected.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PipelinesSelectorView.this.runSelectedWorkflowTemplate(commandService, handlerService);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PipelinesSelectorView.this.runSelectedWorkflowTemplate(commandService, handlerService);
            }
        });
        Composite lowerPart = new Composite((Composite)this.viewBody, 2048);
        lowerPart.setLayout((Layout)new FillLayout());
        TabFolder upperFolder = new TabFolder(lowerPart, 128);
        upperFolder.setLayout((Layout)new FillLayout());
        TabItem item1 = new TabItem(upperFolder, 2048);
        this.workflowVis = new WorkflowVis((Composite)upperFolder, 0, this.workflowManager);
        item1.setControl((Control)this.workflowVis);
        item1.setText("Selected Pipeline");
        this.refreshWorkflow();
        this.viewBody.setWeights(new int[]{3, 1});
    }

    protected void runSelectedWorkflowTemplate(ECommandService commandService, EHandlerService handlerService) {
        int index = this.table.getSelectionIndex();
        if (index >= 0) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("workflow_id", this.allSavedWorkflows.get(index).getMetadata().getTemplateId());
            ParameterizedCommand showWorkflow = commandService.createCommand("com.biotechvana.workflow.ui.command.show.WorkflowView", parameters);
            handlerService.executeHandler(showWorkflow);
        }
    }

    private void addFilter(Composite upperPart, WorkflowSelectionViewfilters filters) {
        filters.renderGUI(upperPart);
        filters.addListener(new WorkflowSelectionViewfilters.FiltersValuesChangedListener(){

            @Override
            public void updateListener() {
                PipelinesSelectorView.this.refreshWorkflow();
            }
        });
    }

    @Focus
    public void setFocus() {
        this.refreshWorkflow();
    }

    private void refreshWorkflow() {
        WorkflowCatalog catalog = this.workflowManager.getWorkflowCatalog();
        if (catalog != null) {
            this.allSavedWorkflows = catalog.getWorkflowTemplates();
            if (this.filters != null) {
                this.allSavedWorkflows = this.filters.applyStaticFilters(this.allSavedWorkflows);
                this.allSavedWorkflows = this.filters.applyFilters(this.allSavedWorkflows);
            }
            this.tableViewer.setInput(this.allSavedWorkflows);
            for (WorkflowTemplate workflowTemplate : this.allSavedWorkflows) {
            }
        }
    }
}

