/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.internal;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.ui.menus.JobsToolBox;
import com.biotechvana.workflow.ui.menus.JobsToolBoxCustomItemTool;
import com.biotechvana.workflow.ui.menus.JobsToolBoxItem;
import com.biotechvana.workflow.ui.menus.JobsToolBoxJobItemTool;
import com.biotechvana.workflow.ui.menus.JobsToolBoxPipelineItemTool;
import com.biotechvana.workflow.views.WorkflowJobClassicComposite;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public class JobsView {
    private final String TITLE = "Jobs Launcher";
    Composite mainBody;
    Composite toolBarBody;
    Composite jobBody;
    ToolBar toolBar;
    SelectionAdapter menuClick;
    Label tmpLabel;
    JobsToolBox activeToolBox;
    WorkflowJob activeTask;
    @Inject
    private MPart part;
    @Inject
    IWorkflowManager workflowManager;
    @Inject
    IEclipseContext eclipseContext;
    Composite jobHolderTab;
    WorkflowJob curJob;
    String curJobId = "";

    @Inject
    public void setActiveToolBox(@Optional JobsToolBox toolBox) {
        this.activeToolBox = toolBox;
        if (toolBox != null) {
            this.activeTask = null;
        }
        if (this.mainBody != null && !this.mainBody.isDisposed()) {
            this.updateContainer();
        }
    }

    @Inject
    public void setInitJob(@Optional WorkflowJob task) {
        this.activeTask = task;
        if (this.mainBody != null && !this.mainBody.isDisposed()) {
            this.updateContainer();
        }
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        this.mainBody = new Composite(parent, 0);
        this.mainBody.setLayout((Layout)new GridLayout(1, false));
        this.toolBarBody = new Composite(this.mainBody, 0);
        GridData gd = new GridData(4, 4, true, false);
        this.toolBarBody.setLayoutData((Object)gd);
        this.toolBarBody.setLayout((Layout)new FillLayout());
        this.jobBody = new Composite(this.mainBody, 0);
        gd = new GridData(4, 4, true, true);
        this.jobBody.setLayoutData((Object)gd);
        this.jobBody.setLayout((Layout)new FillLayout());
        this.updateContainer();
    }

    private void updateContainer() {
        if (this.jobHolderTab != null && !this.jobHolderTab.isDisposed()) {
            this.jobHolderTab.dispose();
            this.jobHolderTab = null;
        }
        if (this.tmpLabel != null && !this.tmpLabel.isDisposed()) {
            this.tmpLabel.dispose();
            this.tmpLabel = null;
        }
        if (this.activeToolBox == null && this.activeTask == null) {
            this.tmpLabel = new Label(this.toolBarBody, 0);
            this.tmpLabel.setText("No Active Selection Yet");
        } else if (this.activeTask != null) {
            if (this.toolBar != null && !this.toolBar.isDisposed()) {
                this.toolBar.dispose();
                this.toolBar = null;
            }
            this.part.setLabel(this.activeTask.getValue("INPUT_CUSTOM_JOB_NAME"));
            this.updateToolContainer(this.activeTask, true);
        } else {
            if (this.toolBar != null && !this.toolBar.isDisposed()) {
                this.toolBar.dispose();
                this.toolBar = null;
            }
            this.toolBar = new ToolBar(this.toolBarBody, 0x820000);
            this.menuClick = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        JobsToolBoxItem item;
                        Widget source = (Widget)e.getSource();
                        if (source.getData() instanceof JobsToolBoxJobItemTool) {
                            item = (JobsToolBoxJobItemTool)source.getData();
                            JobsView.this.updateToolContainer(((JobsToolBoxJobItemTool)item).getClassId());
                        }
                        if (source.getData() instanceof JobsToolBoxPipelineItemTool) {
                            item = (JobsToolBoxPipelineItemTool)source.getData();
                        }
                        if (source.getData() instanceof JobsToolBoxCustomItemTool) {
                            item = (JobsToolBoxCustomItemTool)source.getData();
                            ContextInjectionFactory.invoke((Object)((JobsToolBoxCustomItemTool)item).getCustomAction(), Execute.class, (IEclipseContext)JobsView.this.eclipseContext);
                        }
                    }
                    catch (Exception e1) {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Jobs Launcher", (String)e1.getMessage());
                        e1.printStackTrace();
                    }
                }
            };
            this.activeToolBox.renderAsToolBarItems(this.toolBar, this.menuClick);
            this.toolBar.layout(true);
            this.toolBarBody.layout(true);
            this.part.setLabel(this.activeToolBox.getName());
        }
        this.mainBody.layout(true);
    }

    private void updateToolContainer(String jobClassID) {
        this.updateToolContainer(jobClassID, false);
    }

    private void updateToolContainer(String jobClassID, boolean clearCurrent) {
        if (!clearCurrent && this.curJobId.equals(jobClassID)) {
            return;
        }
        this.mainBody.setLayoutDeferred(true);
        if (this.jobHolderTab != null && !this.jobHolderTab.isDisposed()) {
            this.jobHolderTab.dispose();
            this.jobHolderTab = null;
        }
        this.curJobId = jobClassID;
        this.jobHolderTab = new Composite(this.jobBody, 0);
        this.jobHolderTab.setLayout((Layout)new GridLayout(1, false));
        WorkflowJob job = this.workflowManager.getJobsCatalog().createJobInstanceByFullName(jobClassID, new Object[0]);
        if (job == null) {
            return;
        }
        final WorkflowJobClassicComposite jobCompsote = new WorkflowJobClassicComposite(this.workflowManager, job, this.jobHolderTab, 2048);
        jobCompsote.setLayoutData(new GridData(4, 4, true, true));
        Composite controlsComposite = new Composite(this.jobHolderTab, 0);
        controlsComposite.setLayout((Layout)new GridLayout(1, true));
        controlsComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Button runButton = new Button(controlsComposite, 0);
        runButton.setText("Run Job");
        runButton.setImage(SharedImages.RUNNING);
        runButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        runButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean res = jobCompsote.runJob();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.mainBody.setLayoutDeferred(false);
        this.mainBody.layout();
    }

    private void updateToolContainer(WorkflowJob job, boolean clearCurrent) {
        this.mainBody.setLayoutDeferred(true);
        if (this.jobHolderTab != null && !this.jobHolderTab.isDisposed()) {
            this.jobHolderTab.dispose();
            this.jobHolderTab = null;
        }
        this.jobHolderTab = new Composite(this.jobBody, 0);
        this.jobHolderTab.setLayout((Layout)new GridLayout(1, false));
        if (job == null) {
            return;
        }
        this.curJobId = job.getJobID();
        final WorkflowJobClassicComposite jobCompsote = new WorkflowJobClassicComposite(this.workflowManager, job, this.jobHolderTab, 2048);
        jobCompsote.setLayoutData(new GridData(4, 4, true, true));
        Composite controlsComposite = new Composite(this.jobHolderTab, 0);
        controlsComposite.setLayout((Layout)new GridLayout(1, true));
        controlsComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Button runButton = new Button(controlsComposite, 0);
        runButton.setText("Run Job");
        runButton.setImage(SharedImages.RUNNING);
        runButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        runButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean res = jobCompsote.runJob();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.mainBody.setLayoutDeferred(false);
        this.mainBody.layout();
    }

    private boolean checkSeverConnection() {
        try {
            if (!this.workflowManager.getUserManager().testConnection()) {
                MessageDialog.openWarning((Shell)this.mainBody.getShell(), (String)"Remote host unavailable", (String)"Remote host is not configured or unavalilable. Please, go to \"Preferences > Pipeline connection settings\"");
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            MessageDialog.openWarning((Shell)this.mainBody.getShell(), (String)"Remote host unavailable", (String)"Remote host is not configured or unavalilable. Please, go to \"Preferences > Pipeline connection settings\"");
            return false;
        }
    }
}

