/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.ftpqueue;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.commons.ftpservice.IFTPTransfer;
import com.biotechvana.commons.ftpservice.IFileTransferJob;
import com.biotechvana.commons.ftpservice.IFtpFileTransfer;
import com.biotechvana.commons.ftpservice.TransferStatus;
import com.biotechvana.commons.ftpservice.TransferType;
import com.biotechvana.ui.ftpqueue.TransferJobsTreeContentProvider;
import com.biotechvana.ui.ftpqueue.TransfersControlProgress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TransferJobsView {
    static int COLUMN_NAME_MIN_width = 300;
    static int COLUMN_SIZE_MIN_WIDTH = 100;
    static int COLUMN_STATUS_MIN_WIDTH = 150;
    static int COLUMN_PROGRESS_MIN_WIDTH = 400;
    Map<IFTPTransfer, TransfersControlProgress> transferToControlProgress = new HashMap<IFTPTransfer, TransfersControlProgress>();
    private TreeViewer jobViewer;
    List<IFileTransferJob> transferJobList;
    Timer timer = new Timer();
    AtomicBoolean viewerStructureChanged = new AtomicBoolean();
    HashSet<IFTPTransfer> jobsToBeUpdated = new HashSet();

    public void createPartControl(Composite parent) {
        final Display current_display = parent.getDisplay();
        this.jobViewer = new TreeViewer(parent, 0x10000B00);
        this.jobViewer.setContentProvider((IContentProvider)new TransferJobsTreeContentProvider());
        TreeViewerColumn jobColFile = new TreeViewerColumn(this.jobViewer, 0);
        jobColFile.getColumn().setWidth(COLUMN_NAME_MIN_width);
        jobColFile.getColumn().setText("File");
        jobColFile.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IFileTransferJob) {
                    IFileTransferJob job = (IFileTransferJob)element;
                    return job.getSource();
                }
                IFtpFileTransfer file = (IFtpFileTransfer)element;
                return file.getSourcePath();
            }

            public Image getImage(Object element) {
                if (element instanceof IFTPTransfer) {
                    IFTPTransfer job = (IFTPTransfer)element;
                    if (job.getTransferType() == TransferType.DOWNLOAD) {
                        return SharedImages.ARROWDOWN;
                    }
                    return SharedImages.ARROWUP;
                }
                return null;
            }
        });
        TreeViewerColumn jobColSize = new TreeViewerColumn(this.jobViewer, 0x1000000);
        jobColSize.getColumn().setWidth(COLUMN_SIZE_MIN_WIDTH);
        jobColSize.getColumn().setText("Size");
        jobColSize.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IFTPTransfer) {
                    IFTPTransfer job = (IFTPTransfer)element;
                    return FileUtils.byteCountToDisplaySize((long)job.getTotalSize());
                }
                return "-";
            }
        });
        TreeViewerColumn jobColStatus = new TreeViewerColumn(this.jobViewer, 0x1000000);
        jobColStatus.getColumn().setWidth(COLUMN_STATUS_MIN_WIDTH);
        jobColStatus.getColumn().setText("Status");
        jobColStatus.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IFTPTransfer) {
                    IFTPTransfer job = (IFTPTransfer)element;
                    switch (job.getStatus()) {
                        case RESOLVING: {
                            return "Resolving ...";
                        }
                        case RUNNING: {
                            return "Transfering";
                        }
                        case ERROR: {
                            return "Error";
                        }
                        case FINISHED: {
                            return "Finished";
                        }
                        case PENDING: {
                            return "Pending";
                        }
                        case PAUSED: {
                            return "Paused";
                        }
                        case CANCELING: {
                            return "Canceling ...";
                        }
                        case STOPED: {
                            return "Canceled";
                        }
                    }
                }
                return "";
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        TreeViewerColumn jobColActions = new TreeViewerColumn(this.jobViewer, 0x1000000);
        jobColActions.getColumn().setWidth(COLUMN_PROGRESS_MIN_WIDTH);
        jobColActions.getColumn().setText("Actions");
        jobColActions.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public boolean isLabelProperty(Object element, String property) {
                return super.isLabelProperty(element, property);
            }

            public void update(ViewerCell cell) {
                TreeItem item = (TreeItem)cell.getItem();
                if (cell.getElement() instanceof IFileTransferJob) {
                    IFileTransferJob transferJob = (IFileTransferJob)cell.getElement();
                    if (!transferJob.isFinished()) {
                        TransfersControlProgress transferControlProgress;
                        if (TransferJobsView.this.transferToControlProgress.containsKey(transferJob)) {
                            transferControlProgress = TransferJobsView.this.transferToControlProgress.get(transferJob);
                        } else {
                            transferControlProgress = new TransfersControlProgress((Composite)cell.getViewerRow().getControl(), transferJob);
                            TransferJobsView.this.transferToControlProgress.put((IFTPTransfer)transferJob, transferControlProgress);
                        }
                        if (transferControlProgress != null) {
                            transferControlProgress.refresh();
                        }
                        TreeEditor editor = new TreeEditor(item.getParent());
                        editor.grabHorizontal = true;
                        editor.grabVertical = true;
                        editor.setEditor(transferControlProgress.getConrol(), item, cell.getColumnIndex());
                    }
                } else if (((IFtpFileTransfer)cell.getElement()).getStatus() == TransferStatus.RUNNING) {
                    TransfersControlProgress transferControlProgress;
                    IFtpFileTransfer ftpFileTransfer = (IFtpFileTransfer)cell.getElement();
                    if (TransferJobsView.this.transferToControlProgress.containsKey(cell.getElement())) {
                        transferControlProgress = TransferJobsView.this.transferToControlProgress.get(cell.getElement());
                    } else {
                        transferControlProgress = new TransfersControlProgress((Composite)cell.getViewerRow().getControl(), ftpFileTransfer);
                        TransferJobsView.this.transferToControlProgress.put((IFTPTransfer)ftpFileTransfer, transferControlProgress);
                    }
                    if (transferControlProgress != null) {
                        transferControlProgress.refresh();
                    }
                    TreeEditor editor = new TreeEditor(item.getParent());
                    editor.grabHorizontal = true;
                    editor.grabVertical = true;
                    editor.setEditor(transferControlProgress.getConrol(), item, cell.getColumnIndex());
                }
            }
        });
        Tree tree = this.jobViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.getColumn(0).addListener(11, new Listener(){

            public void handleEvent(Event event) {
                event.height = 45;
            }
        });
        tree.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 45;
            }
        });
        this.timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (TransferJobsView.this.viewerStructureChanged.get()) {
                    HashSet<IFTPTransfer> hashSet = TransferJobsView.this.jobsToBeUpdated;
                    synchronized (hashSet) {
                        TransferJobsView.this.jobsToBeUpdated.clear();
                    }
                    current_display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            TransferJobsView.this.updateUI();
                        }
                    });
                    TransferJobsView.this.viewerStructureChanged.set(false);
                } else {
                    HashSet<IFTPTransfer> hashSet = TransferJobsView.this.jobsToBeUpdated;
                    synchronized (hashSet) {
                        if (TransferJobsView.this.jobsToBeUpdated.size() > 0) {
                            current_display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    for (IFTPTransfer fTransfer : (this).TransferJobsView.this.jobsToBeUpdated) {
                                        TransferJobsView.this.updateUI(fTransfer);
                                    }
                                }
                            });
                            TransferJobsView.this.jobsToBeUpdated.clear();
                        }
                    }
                }
            }
        }, 0L, 1000L);
    }

    public Control getControl() {
        return this.jobViewer.getControl();
    }

    public void setInput(List<IFileTransferJob> transferJobList) {
        this.transferJobList = transferJobList;
        this.jobViewer.setInput(this.transferJobList);
    }

    public void updateUI() {
        ArrayList<IFTPTransfer> to_remove = new ArrayList<IFTPTransfer>();
        for (IFTPTransfer iFTPTransfer : this.transferToControlProgress.keySet()) {
            if (!iFTPTransfer.isFinished()) continue;
            to_remove.add(iFTPTransfer);
            this.transferToControlProgress.get(iFTPTransfer).dispose();
        }
        for (Object object : to_remove) {
            this.transferToControlProgress.remove(object);
        }
        this.jobViewer.refresh();
    }

    public void updateUI(IFTPTransfer refJob) {
        if (refJob.isFinished() && this.transferToControlProgress.containsKey(refJob)) {
            this.transferToControlProgress.get(refJob).dispose();
            this.transferToControlProgress.remove(refJob);
        }
        this.jobViewer.update((Object)refJob, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewerStructureChange(IFileTransferJob newJob) {
        AtomicBoolean atomicBoolean = this.viewerStructureChanged;
        synchronized (atomicBoolean) {
            this.viewerStructureChanged.set(true);
            this.toBeUpdated((IFTPTransfer)newJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toBeUpdated(IFTPTransfer ftpTransfer) {
        HashSet<IFTPTransfer> hashSet = this.jobsToBeUpdated;
        synchronized (hashSet) {
            this.jobsToBeUpdated.add(ftpTransfer);
        }
    }

    public void cleanUp() {
        this.timer.cancel();
    }
}

