/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.ftpqueue;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.commons.ftpservice.IFtpFileTransfer;
import com.biotechvana.commons.ftpservice.TransferStatus;
import com.biotechvana.commons.ftpservice.TransferType;
import com.biotechvana.ui.ftpqueue.TransferJobsTreeContentProvider;
import com.biotechvana.ui.ftpqueue.TransfersControlProgress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ActiveTransfersView {
    Color red = null;
    Color white = null;
    Color black = null;
    Map<Object, Control> activeFileToButton = new HashMap<Object, Control>();
    Map<Object, Control> activeFileToBar = new HashMap<Object, Control>();
    private TreeViewer activeViewer;
    List<IFtpFileTransfer> activeFileList;
    Map<IFtpFileTransfer, TransfersControlProgress> transferToControlProgress = new HashMap<IFtpFileTransfer, TransfersControlProgress>();

    public void createPartControl(Composite parent) {
        Display current_display = parent.getDisplay();
        this.red = new Color((Device)current_display, 179, 39, 45);
        this.white = new Color((Device)current_display, 255, 255, 255);
        this.black = new Color((Device)current_display, 0, 0, 0);
        this.activeViewer = new TreeViewer(parent, 0x10000B00);
        this.activeViewer.setContentProvider((IContentProvider)new TransferJobsTreeContentProvider());
        TreeViewerColumn colFile = new TreeViewerColumn(this.activeViewer, 0);
        colFile.getColumn().setWidth(200);
        colFile.getColumn().setText("File");
        colFile.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IFtpFileTransfer file = (IFtpFileTransfer)element;
                return file.getSourcePath();
            }

            public Image getImage(Object element) {
                IFtpFileTransfer file = (IFtpFileTransfer)element;
                if (file.getTransferType() == TransferType.DOWNLOAD) {
                    return SharedImages.ARROWDOWN;
                }
                return SharedImages.ARROWUP;
            }
        });
        TreeViewerColumn colStatus = new TreeViewerColumn(this.activeViewer, 0);
        colStatus.getColumn().setWidth(150);
        colStatus.getColumn().setText("Status");
        colStatus.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IFtpFileTransfer file = (IFtpFileTransfer)element;
                return file.getStatus().toString();
            }
        });
        TreeViewerColumn colSize = new TreeViewerColumn(this.activeViewer, 0);
        colSize.getColumn().setWidth(150);
        colSize.getColumn().setText("Size");
        colSize.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IFtpFileTransfer file = (IFtpFileTransfer)element;
                return FileUtils.byteCountToDisplaySize((long)file.getTotalSize());
            }
        });
        TreeViewerColumn colTranferedBytes = new TreeViewerColumn(this.activeViewer, 0);
        colTranferedBytes.getColumn().setWidth(400);
        colTranferedBytes.getColumn().setText("Progress");
        colTranferedBytes.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            Map<Object, ProgressBar> bars = new HashMap<Object, ProgressBar>();

            public void update(ViewerCell cell) {
                TreeItem item = (TreeItem)cell.getItem();
                IFtpFileTransfer ftpFileTransfer = (IFtpFileTransfer)cell.getElement();
                if (ftpFileTransfer.getStatus() == TransferStatus.RUNNING) {
                    TransfersControlProgress transferControlProgress;
                    if (ActiveTransfersView.this.transferToControlProgress.containsKey(cell.getElement())) {
                        transferControlProgress = ActiveTransfersView.this.transferToControlProgress.get(cell.getElement());
                    } else {
                        transferControlProgress = new TransfersControlProgress((Composite)cell.getViewerRow().getControl(), ftpFileTransfer);
                        ActiveTransfersView.this.transferToControlProgress.put(ftpFileTransfer, transferControlProgress);
                    }
                    if (transferControlProgress != null) {
                        transferControlProgress.refresh();
                    }
                    TreeEditor editor = new TreeEditor(item.getParent());
                    editor.grabHorizontal = true;
                    editor.grabVertical = true;
                    editor.setEditor(transferControlProgress.getConrol(), item, cell.getColumnIndex());
                }
            }
        });
        Tree table = this.activeViewer.getTree();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.getColumn(0).addListener(11, new Listener(){

            public void handleEvent(Event event) {
                event.height = 45;
            }
        });
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 45;
            }
        });
    }

    public Control getControl() {
        return this.activeViewer.getControl();
    }

    public void setInput(List<IFtpFileTransfer> activeFileList) {
        this.activeFileList = activeFileList;
        this.activeViewer.setInput(activeFileList);
    }

    public void updateUI() {
        ArrayList<IFtpFileTransfer> to_remove = new ArrayList<IFtpFileTransfer>();
        for (Object key : this.transferToControlProgress.keySet()) {
            IFtpFileTransfer file = key;
            if (!file.isFinished()) continue;
            to_remove.add(file);
            this.transferToControlProgress.get(file).dispose();
        }
        for (Object key : to_remove) {
            this.transferToControlProgress.remove(to_remove);
        }
        this.activeViewer.refresh();
    }

    public class StopFileButtonListener
    implements SelectionListener {
        IFtpFileTransfer job;

        public StopFileButtonListener(Object object) {
            this.job = (IFtpFileTransfer)object;
        }

        public void widgetSelected(SelectionEvent e) {
            this.job.setStatus(TransferStatus.STOPED);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.job.setStatus(TransferStatus.STOPED);
        }
    }
}

