/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing.fastxtools;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;

public class FastxtoolkitFastqToFastaJob
extends WorkflowJob {
    private static final String TITLE = "FASTXTOOLKIT: FASTQ to FASTA";
    private static final String HELP = "FASTQ to FASTA : convert fastq files into fasta";
    private static final String LINK = "Online docs: <a href=\"http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastq_to_fasta_usage\">http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastq_to_fasta_usage</a>";
    public static final String JOB_ID = "FASTQ_to_FASTA";
    public static final String JOB_NAME = "FASTXTOOLKIT: FASTQ to FASTA";
    private static final String INPUT_FASTQ_FILE = "INPUT_FASTQ_FILE";

    public FastxtoolkitFastqToFastaJob() {
        this.jobName = "FASTXTOOLKIT: FASTQ to FASTA";
        this.jobDesc = new JobDescriptor(JOB_ID);
        this.jobDesc.setDesc(HELP);
        this.jobDesc.setRef(LINK);
        VariableDescriptor varFastaQ = VariableDescriptor.createDescriptorFor((String)INPUT_FASTQ_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFastaQ.isRequired = true;
        varFastaQ.setVariableName("FASTQ");
        this.jobDesc.addVariable(varFastaQ);
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Rename sequence identifiers to numbers");
        varOption.setCommandParamater("-r");
        varOption.setHelpMsg("Rename sequence identifiers to numbers");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("keep sequences with unknown (N) nucleotides");
        varOption.setCommandParamater("-n");
        varOption.setHelpMsg("keep sequences with unknown (N) nucleotides. Default is to discard such sequences");
        this.jobDesc.addVariable(varOption);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        this.initJobFromDesc(this.jobDesc);
    }

    public String getJobCommand_notNeeded() {
        String progName = String.valueOf(Constants.PIPELINE_FASXTOOLKIT_FASTQ_TO_FASTA_EXE) + " -Q33 ";
        this.autoConnentData();
        if (!this.isValid()) {
            return null;
        }
        String outputFolder = this.getJobDescID();
        this.getVariable("JOB_OUTPUT_FOLDER").setRelativeTo(this.getVariable("INPUT_OUTPUT_FOLDER"));
        this.setValue("JOB_OUTPUT_FOLDER", outputFolder);
        StringBuilder command = new StringBuilder();
        command.append(this.getVariable("JOB_OUTPUT_FOLDER").getBashVarDecleration());
        command.append(this.getVariable(INPUT_FASTQ_FILE).getBashVarDecleration());
        command.append("cd " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\n");
        String forBody = "inptFileBaseName=$(basename $_File | cut -d. -f1);\ninptFileExt=`rev <<< \"$_File\" | cut -d. -f1 | rev`;\n" + progName + " -i $_File  -o $inptFileBaseName.fasta " + this.getOptionParamaters();
        command.append(BashHelper.forEachValue((String)"_File", (String)this.getVariable(INPUT_FASTQ_FILE).$("@"), (String)forBody));
        command.append("cd $HOME \n");
        command.append("\n");
        return command.toString();
    }

    public void generateCommand(StringBuilder command) {
        String progName = String.valueOf(Constants.PIPELINE_FASXTOOLKIT_FASTQ_TO_FASTA_EXE) + " -Q33 ";
        command.append("cd " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\n");
        String forBody = "inptFileBaseName=$(basename $_File | cut -d. -f1);\ninptFileExt=`rev <<< \"$_File\" | cut -d. -f1 | rev`;\n" + progName + " -i $_File  -o $inptFileBaseName.fasta " + this.getOptionParamaters();
        command.append(BashHelper.forEachValue((String)"_File", (String)this.getVariable(INPUT_FASTQ_FILE).$("@"), (String)forBody));
    }
}

