/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing.fastxtools;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;

public class FastxtoolkitFastaClippingHistogramJob
extends WorkflowJob {
    private static final String TITLE = "FASTXTOOLKIT: FASTA Clipping Histogram";
    private static final String HELP = "FASTA Clipping Histogram: Create a Linker Clipping Information Histogram";
    private static final String LINK = "Online docs: <a href=\"http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastq_statistics_usage\">http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastq_statistics_usage</a>";
    public static final String JOB_ID = "FASTX_Clipping_Histogram";
    public static final String JOB_NAME = "FASTXTOOLKIT: FASTA Clipping Histogram";
    private static final String INPUT_FASTA_FILE = "INPUT_FASTA_FILE";

    public FastxtoolkitFastaClippingHistogramJob() {
        this.jobName = "FASTXTOOLKIT: FASTA Clipping Histogram";
        this.jobDesc = new JobDescriptor(JOB_ID);
        this.jobDesc.setDesc(HELP);
        this.jobDesc.setRef(LINK);
        VariableDescriptor varFasta = VariableDescriptor.createDescriptorFor((String)INPUT_FASTA_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFasta.isRequired = true;
        varFasta.setVariableName("FASTA");
        this.jobDesc.addVariable(varFasta);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        this.initJobFromDesc(this.jobDesc);
    }

    public void generateCommand(StringBuilder command) {
        String progName = Constants.PIPELINE_FASXTOOLKIT_FASTA_CLIPPING_HISTOGRAM_EXE;
        command.append(this.getVariable("JOB_OUTPUT_FOLDER").getBashVarDecleration());
        command.append(this.getVariable(INPUT_FASTA_FILE).getBashVarDecleration());
        command.append("cd " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\n");
        String forBody = "inptFileBaseName=$(basename $_File | cut -d. -f1);\n" + progName + " $_File  $inptFileBaseName.png";
        command.append(BashHelper.forEachValue((String)"_File", (String)this.getVariable(INPUT_FASTA_FILE).$("@"), (String)forBody));
    }
}

