/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing;

import com.biotechvana.shared.jobs.PreprocessingFilters;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.VariableCustomAction;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.descriptors.CheckedVariableDescriptor;
import com.biotechvana.workflow.descriptors.FileVariableDescriptor;
import com.biotechvana.workflow.descriptors.IntVariableDescriptor;
import com.biotechvana.workflow.descriptors.MultiSelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.StringsVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.executer.BashProcessBlock;
import com.biotechvana.workflow.executer.CMLPairedTemplate;
import com.biotechvana.workflow.executer.CMLTemplate;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.JobVariable;
import com.biotechvana.workflow.variables.StringsJobVariable;

public class PreProcessingTrimmomaticJob
extends ISWFJob {
    public static final String JOB_ID = "trimmomatic";
    public static final String JOB_NAME = "Trimmomatic";
    public static final String INPUT_FASTQ_FILE = "INPUT_FILES";
    private static final String INPUT_FILE_FORMAT = "INPUT_FILE_FORMAT";
    private static final String INPUT_READ_ADAPTERS = "INPUT_READ_ADAPTERS";
    private static final String INPUT_FASTQC_REPORT_PATH = "INPUT_FASTQC_REPORT_PATH";
    public static final String GROUP_STEPS = "Steps";
    private static final String STEP_SELECTED = "STEP_SELECTED";
    private static final String STEP_ORDER = "STEP_ORDER";
    public static final String OPTION_PR_FILTER = "OPTION_PR_FILTER";
    static String TR_ILLUMINACLIP_STEP = "ILLUMINACLIP";
    static String TR_ILLUMINACLIP_STEP_fastaWithAdaptersEtc = "fastaWithAdaptersEtc";
    static String TR_ILLUMINACLIP_STEP_fastaWithAdaptersSource = "fastaWithAdaptersSource";
    static String TR_ILLUMINACLIP_STEP_seedMismatches = "seedMismatches";
    static String TR_ILLUMINACLIP_STEP_palindromeClipThreshold = "palindromeClipThreshold";
    static String TR_ILLUMINACLIP_STEP_simpleClipThreshold = "simpleClipThreshold";
    static String TR_ILLUMINACLIP_STEP_minAdapterLength = "minAdapterLength";
    static String TR_ILLUMINACLIP_STEP_keepBothReads = "keepBothReads";
    static String TR_SLIDINGWINDOW_STEP = "SLIDINGWINDOW";
    static String TR_SLIDINGWINDOW_STEP_windowSize = "windowSize";
    static String TR_SLIDINGWINDOW_STEP_requiredQuality = "requiredQuality";
    static String TR_LEADING_STEP = "LEADING";
    static String TR_TRAILING_STEP = "TRAILING";
    static String TR_CROP_STEP = "CROP";
    static String TR_HEADCROP_STEP = "HEADCROP";
    static String TR_MINLEN_STEP = "MINLEN";

    public PreProcessingTrimmomaticJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("Trimmomatic is a flexible read trimming tool for Illumina NGS data and that performs a variety of useful trimming tasks for illumina paired-end and single ended data");
        this.jobDesc.setRef("Bolger, A. M., Lohse, M., & Usadel, B. (2014). Trimmomatic: A flexible trimmer for Illumina Sequence Data. Bioinformatics, btu170. Online docs: <a href=\"http://www.usadellab.org/cms/?page=trimmomatic\">http://www.usadellab.org/cms/?page=trimmomatic</a>");
    }

    public String notifyVarValueChanging(String varKey, String newValue) {
        return super.notifyVarValueChanging(varKey, newValue);
    }

    public boolean notifyVarValueChanged(String varKey, String value) {
        boolean goOn = super.notifyVarValueChanged(varKey, value);
        if (goOn && varKey.equals(STEP_SELECTED)) {
            this.setValue(STEP_ORDER, value);
        }
        return goOn;
    }

    protected void generateCommand(StringBuilder builder) {
        FileVariable outFiles = (FileVariable)this.getVariable("OUTPUT_FILES");
        StringsJobVariable order = (StringsJobVariable)this.getVariable(STEP_ORDER);
        builder.append(BashHelper.Batcher_noLog((FileListVariable)((FileListVariable)this.getVariable(INPUT_FASTQ_FILE)), (String)BashHelper.assign((JobVariable)outFiles, (String)"0,$i", (String)"${outputFolder}/${inputFile1BaseName}.fastq"), (String)"", (String)BashHelper.assign((JobVariable)outFiles, (String)"1,$i", (String)"${outputFolder}/${inputFile2BaseName}.fastq"), (String)"", (boolean)true));
        CMLPairedTemplate trimmomaticTemplate = new CMLPairedTemplate();
        trimmomaticTemplate.setInterpreter("java -jar ");
        trimmomaticTemplate.setBaseCommand("trimmomatic-0.36.jar");
        trimmomaticTemplate.get1Template().getBefore().addStatment(BashHelper.assign((JobVariable)outFiles, (String)"0,$i", (String)"${outputFolder}/${inputFile1BaseName}.fastq"));
        trimmomaticTemplate.get1Template().addArgs("SE").addArgs("${_inputFile1}").addArgs("${outputFolder}/${inputFile1BaseName}.fastq");
        trimmomaticTemplate.get2Template().getBefore().addStatment(BashHelper.assign((JobVariable)outFiles, (String)"0,$_i", (String)"${outputFolder}/${inputFile1BaseName}.fastq"));
        trimmomaticTemplate.get2Template().getBefore().addStatment(BashHelper.assign((JobVariable)outFiles, (String)"1,$_i", (String)"${outputFolder}/${inputFile2BaseName}.fastq"));
        trimmomaticTemplate.get2Template().addArgs("PE").addArgs("${_inputFile1}").addArgs("${_inputFile2}").addArgs("${outputFolder}/${inputFile1BaseName}.fastq").addArgs("${outputFolder}/${inputFile1BaseName}_unpaired.fastq").addArgs("${outputFolder}/${inputFile2BaseName}.fastq").addArgs("${outputFolder}/${inputFile2BaseName}_unpaired.fastq");
        String[] stringArray = order.getStringsList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String step = stringArray[n2];
            if (TR_ILLUMINACLIP_STEP.equals(step)) {
                String fastaWithAdaptersEtc = this.getVariable(TR_ILLUMINACLIP_STEP_fastaWithAdaptersSource).$();
                String seedMismatches = this.getVariable(TR_ILLUMINACLIP_STEP_seedMismatches).$();
                String palindromeClipThreshold = this.getVariable(TR_ILLUMINACLIP_STEP_palindromeClipThreshold).$();
                String simpleClipThreshold = this.getVariable(TR_ILLUMINACLIP_STEP_simpleClipThreshold).$();
                String ILLUMINACLIP = String.format("ILLUMINACLIP:%s:%s:%s:%s", fastaWithAdaptersEtc, seedMismatches, palindromeClipThreshold, simpleClipThreshold);
                trimmomaticTemplate.addArgs(ILLUMINACLIP);
            } else if (TR_SLIDINGWINDOW_STEP.equals(step)) {
                String windowSize = this.getVariable(TR_SLIDINGWINDOW_STEP_windowSize).$();
                String requiredQuality = this.getVariable(TR_SLIDINGWINDOW_STEP_requiredQuality).$();
                trimmomaticTemplate.addArgs(String.format("SLIDINGWINDOW:%s:%s", windowSize, requiredQuality));
            } else {
                trimmomaticTemplate.addArgs(this.getVariable(step).getCMDParamaterValue());
            }
            ++n2;
        }
        BashProcessBlock tophatProcess = new BashProcessBlock((CMLTemplate)trimmomaticTemplate);
        tophatProcess.setInputVariable((FileVariable)((FileListVariable)this.getVariable(INPUT_FASTQ_FILE)));
        tophatProcess.setParallel(true);
        tophatProcess.generate(builder);
    }

    protected void generateCommandWrapUp(StringBuilder command) {
        ((FileVariable)this.getVariable("OUTPUT_FILES")).setFileFormat("FASTQ");
        command.append(((FileVariable)this.getVariable("OUTPUT_FILES")).getFileFormatAsBashVar(this.getVariable(INPUT_FASTQ_FILE)));
    }

    protected void createInputs() {
        VariableDescriptor varFastaQ = VariableDescriptor.createDescriptorFor((String)INPUT_FASTQ_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFastaQ.isRequired = true;
        varFastaQ.setVariableName("FASTQ");
        varFastaQ.addAcceptedFileFormat("FASTQ", true, true);
        this.jobDesc.addVariable(varFastaQ);
    }

    protected void createOutputs() {
        VariableDescriptor varOutputFiles = VariableDescriptor.createDescriptorFor((String)"OUTPUT_FILES", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varOutputFiles.setVariableName("Output Files");
        varOutputFiles.addAcceptedFileFormat("FASTQ", false, false);
        varOutputFiles.addAcceptedFileFormat("FASTA and QUAL", true, "FASTA", "QUAL");
        this.jobDesc.addVariable(varOutputFiles);
        PreprocessingFilters.addPrepresoccesingFilter(this.jobDesc, varOutputFiles);
        VariableDescriptor varOption_PR_FILTER = VariableDescriptor.createDescriptorFor((String)OPTION_PR_FILTER, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption_PR_FILTER.setVariableName("Good sequences percet after filtering");
        varOption_PR_FILTER.setHelpMsg("Min Good sequences percet of the total sequences input before preprocessing  to consider the preprocessing as succesfull. Has no effect on the bahavoiur of trimmomatic. Used only for managment pipeline and tracking. Default 80");
        this.jobDesc.addVariable(varOption_PR_FILTER);
        PreprocessingFilters.addPrepresoccesingPRFilter(this.jobDesc, varOutputFiles, varOption_PR_FILTER);
    }

    protected void createOptions() {
        MultiSelectionListVariableDescriptor stringVar = VariableDescriptor.MultiSelectionList((String)STEP_SELECTED, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        stringVar.setVariableName("Select preprocessing steps");
        stringVar.setHelpMsg("Select preprocessing steps to perfrom");
        stringVar.setOrdered(true);
        stringVar.isRequired = true;
        stringVar.addOptionValue(TR_ILLUMINACLIP_STEP, TR_ILLUMINACLIP_STEP, "Cut adapter and other illumina-specific sequences from the read.");
        stringVar.addOptionValue(TR_SLIDINGWINDOW_STEP, TR_SLIDINGWINDOW_STEP, "Perform a sliding window trimming, cutting once the average quality within the window falls below a threshold.");
        stringVar.addOptionValue(TR_LEADING_STEP, TR_LEADING_STEP, "Cut bases off the start of a read, if below a threshold quality");
        stringVar.addOptionValue(TR_TRAILING_STEP, TR_TRAILING_STEP, "Cut bases off the end of a read, if below a threshold quality");
        stringVar.addOptionValue(TR_CROP_STEP, TR_CROP_STEP, "Cut the read to a specified length");
        stringVar.addOptionValue(TR_HEADCROP_STEP, TR_HEADCROP_STEP, "Drop the read if it is below a specified length");
        stringVar.addOptionValue(TR_MINLEN_STEP, TR_MINLEN_STEP, "Cut the specified number of bases from the start of the read");
        stringVar.addCustomAction(new VariableCustomAction("Custom Order", VariableCustomAction.Button, new VariableCustomAction.CustomActionCallback(){

            public void call(JobVariable var) {
                System.out.println("Custom Order");
            }
        }));
        this.jobDesc.addVariable((VariableDescriptor)stringVar);
        StringsVariableDescriptor orderVar = VariableDescriptor.Strings((String)STEP_ORDER, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        orderVar.setVariableName("Select Custom Order of preprocessing steps");
        orderVar.setHelpMsg("Select Custom Order of preprocessing steps");
        orderVar.setReadOnly(true);
        this.jobDesc.addVariable((VariableDescriptor)orderVar);
        CheckedVariableDescriptor chechVar = VariableDescriptor.Checked((String)TR_ILLUMINACLIP_STEP, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        chechVar.setVariableName("ILLUMINACLIP - Find and remove Illumina adapters");
        chechVar.setHelpMsg("Cut adapter and other illumina-specific sequences from the read");
        chechVar.setCommandParamater("ILLUMINACLIP");
        chechVar.setVariableGroup(GROUP_STEPS);
        chechVar.setReadOnly(true);
        this.jobDesc.addVariable((VariableDescriptor)chechVar);
        FileVariableDescriptor fileVar = VariableDescriptor.File((String)TR_ILLUMINACLIP_STEP_fastaWithAdaptersSource, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        fileVar.setVariableName("Input Fasta file containing all the adapters");
        fileVar.setHelpMsg("Specifies the path to a fasta file containing all the adapters, PCR sequences etc. The naming of the various sequences within this file determines how they are used.");
        fileVar.setCommandParamater(TR_ILLUMINACLIP_STEP_fastaWithAdaptersSource);
        fileVar.setVariableGroup(GROUP_STEPS);
        this.jobDesc.addVariable((VariableDescriptor)fileVar);
        IntVariableDescriptor intVar = VariableDescriptor.Int((String)TR_ILLUMINACLIP_STEP_seedMismatches, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        intVar.setVariableName("Maximum mismatch count");
        intVar.setHelpMsg("Specifies the maximum mismatch count which will still allow a full match to be performed");
        intVar.setCommandParamater(TR_ILLUMINACLIP_STEP_seedMismatches);
        intVar.setVariableGroup(GROUP_STEPS);
        this.jobDesc.addVariable((VariableDescriptor)intVar);
        intVar = VariableDescriptor.Int((String)TR_ILLUMINACLIP_STEP_palindromeClipThreshold, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        intVar.setVariableName("Palindrome Clip Threshold");
        intVar.setHelpMsg("Specifies how accurate the match between the two 'adapter ligated' reads must be for PE palindrome read alignment");
        intVar.setCommandParamater(TR_ILLUMINACLIP_STEP_palindromeClipThreshold);
        intVar.setVariableGroup(GROUP_STEPS);
        this.jobDesc.addVariable((VariableDescriptor)intVar);
        intVar = VariableDescriptor.Int((String)TR_ILLUMINACLIP_STEP_simpleClipThreshold, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        intVar.setVariableName("Simple Clip Threshold");
        intVar.setHelpMsg("Specifies how accurate the match between any adapter etc. sequence must be against a read");
        intVar.setCommandParamater(TR_ILLUMINACLIP_STEP_simpleClipThreshold);
        intVar.setVariableGroup(GROUP_STEPS);
        this.jobDesc.addVariable((VariableDescriptor)intVar);
        intVar = VariableDescriptor.Int((String)TR_ILLUMINACLIP_STEP_minAdapterLength, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        intVar.setVariableName("Min Adapter Length");
        intVar.setHelpMsg("In addition to the alignment score, palindrome mode can verify that a minimum length of adapter has been detected. If unspecified, this defaults to 8 bases, for historical reasons. However, since palindrome mode has a very low false positive rate, this can be safely reduced, even down to 1, to allow shorteradapter fragments to be removed.");
        intVar.setCommandParamater(TR_ILLUMINACLIP_STEP_minAdapterLength);
        intVar.setVariableGroup(GROUP_STEPS);
        this.jobDesc.addVariable((VariableDescriptor)intVar);
        chechVar = VariableDescriptor.Checked((String)TR_ILLUMINACLIP_STEP_keepBothReads, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        chechVar.setVariableName("Keep Both Reads");
        chechVar.setHelpMsg("Afterread-though has been detectedby palindrome mode, and the adapter sequence removed, the reverse read contains the same sequence information as the forward read, albeit in reverse complement. For this reason, the default behaviour is to entirely drop the reverse read. By Checking this parameter, the reverse read will also be retained, which may be useful e.g. if the downstream tools cannot handle a combination of paired and unpaired reads.");
        chechVar.setCommandParamater(TR_ILLUMINACLIP_STEP_keepBothReads);
        chechVar.setVariableGroup(GROUP_STEPS);
        this.jobDesc.addVariable((VariableDescriptor)chechVar);
        chechVar = VariableDescriptor.Checked((String)TR_SLIDINGWINDOW_STEP, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        chechVar.setVariableName("SLIDINGWINDOW: Perform a sliding window trimming");
        chechVar.setHelpMsg("Perform a sliding window trimming, cutting once the average quality within the window falls below a threshold");
        chechVar.setCommandParamater(TR_SLIDINGWINDOW_STEP);
        chechVar.setVariableGroup(GROUP_STEPS);
        chechVar.setReadOnly(true);
        chechVar.setDefaultValue(true);
        this.jobDesc.addVariable((VariableDescriptor)chechVar);
        intVar = VariableDescriptor.Int((String)TR_SLIDINGWINDOW_STEP_windowSize, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        intVar.setVariableName("Window Size");
        intVar.setHelpMsg("specifies the number of bases to average across");
        intVar.setCommandParamater(TR_SLIDINGWINDOW_STEP_windowSize);
        intVar.setVariableGroup(GROUP_STEPS);
        this.jobDesc.addVariable((VariableDescriptor)intVar);
        intVar = VariableDescriptor.Int((String)TR_SLIDINGWINDOW_STEP_requiredQuality, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        intVar.setVariableName("Required Quality");
        intVar.setHelpMsg("Specifies the average quality required in sliding window trimming");
        intVar.setCommandParamater(TR_SLIDINGWINDOW_STEP_requiredQuality);
        intVar.setVariableGroup(GROUP_STEPS);
        this.jobDesc.addVariable((VariableDescriptor)intVar);
        intVar = VariableDescriptor.Int((String)TR_LEADING_STEP, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        intVar.setVariableName("Minimum quality for Leading");
        intVar.setHelpMsg("Specifies the minimum quality required to keep a base from the beginning.Remove low quality bases from the beginning. As long as a base has a value below this threshold the base is removed and the next base will be investigated.");
        intVar.setCommandParamater("LEADING");
        intVar.setVariableGroup(GROUP_STEPS);
        intVar.setCommandParamaterSep(":");
        this.jobDesc.addVariable((VariableDescriptor)intVar);
        intVar = VariableDescriptor.Int((String)TR_TRAILING_STEP, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        intVar.setVariableName("Minimum quality for Trailing");
        intVar.setHelpMsg("Specifies the minimum quality required to keep a base from the end. Remove low quality bases from the end. As long as a base has a value below this threshold the base is removed and the next base (which as trimmomatic is starting from the 3` prime end would be base preceding the just removed base) will be investigated. This approach can be used removing the special illumina \"low quality segment\" regions (which are marked with quality score of 2)");
        intVar.setCommandParamater("TRAILING");
        intVar.setVariableGroup(GROUP_STEPS);
        intVar.setCommandParamaterSep(":");
        this.jobDesc.addVariable((VariableDescriptor)intVar);
        intVar = VariableDescriptor.Int((String)TR_CROP_STEP, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        intVar.setVariableName("Crop length");
        intVar.setHelpMsg("Specifies Crop length: The number of bases to keep, from the start of the read. Removes bases regardless of quality from the end of the read, so that the read has maximally the specified length after this step has been performed. Steps performed after CROP might of course further shorten the read.");
        intVar.setCommandParamater("CROP");
        intVar.setVariableGroup(GROUP_STEPS);
        intVar.setCommandParamaterSep(":");
        this.jobDesc.addVariable((VariableDescriptor)intVar);
        intVar = VariableDescriptor.Int((String)TR_HEADCROP_STEP, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        intVar.setVariableName("Head Crop length");
        intVar.setHelpMsg("Specifies Crop length: The number of bases to keep, from the start of the read. Removes the specified number of bases, regardless of quality, from the beginning of the read.");
        intVar.setCommandParamater("HEADCROP");
        intVar.setVariableGroup(GROUP_STEPS);
        intVar.setCommandParamaterSep(":");
        this.jobDesc.addVariable((VariableDescriptor)intVar);
        intVar = VariableDescriptor.Int((String)TR_MINLEN_STEP, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        intVar.setVariableName("Head Crop length");
        intVar.setHelpMsg("Specifies the minimum length of reads to be kept.Removes reads that fall below the specified minimal length. If required, it should normally be after all other processing steps. Reads removed by this step will be counted and included in the \"dropped reads\" count presented in the trimmomatic summary.");
        intVar.setCommandParamater("MINLEN");
        intVar.setCommandParamaterSep(":");
        intVar.setVariableGroup(GROUP_STEPS);
        this.jobDesc.addVariable((VariableDescriptor)intVar);
    }

    protected void createRules() {
        new VariablesRule(this.getVariable(STEP_SELECTED), this.getVariable(TR_ILLUMINACLIP_STEP), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, TR_ILLUMINACLIP_STEP, true);
        new VariablesRule(this.getVariable(STEP_SELECTED), this.getVariable(TR_ILLUMINACLIP_STEP), VariablesRule.Condition.EqualTo, VariablesRule.Action.SetValueTo, TR_ILLUMINACLIP_STEP, "true", false);
        new VariablesRule(this.getVariable(STEP_SELECTED), this.getVariable(TR_SLIDINGWINDOW_STEP), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, TR_SLIDINGWINDOW_STEP, true);
        new VariablesRule(this.getVariable(STEP_SELECTED), this.getVariable(TR_LEADING_STEP), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, TR_LEADING_STEP, true);
        new VariablesRule(this.getVariable(STEP_SELECTED), this.getVariable(TR_LEADING_STEP), VariablesRule.Condition.EqualTo, VariablesRule.Action.SetToRequired, TR_LEADING_STEP, true);
        new VariablesRule(this.getVariable(STEP_SELECTED), this.getVariable(TR_TRAILING_STEP), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, TR_TRAILING_STEP, true);
        new VariablesRule(this.getVariable(STEP_SELECTED), this.getVariable(TR_TRAILING_STEP), VariablesRule.Condition.EqualTo, VariablesRule.Action.SetToRequired, TR_TRAILING_STEP, true);
        new VariablesRule(this.getVariable(STEP_SELECTED), this.getVariable(TR_CROP_STEP), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, TR_CROP_STEP, true);
        new VariablesRule(this.getVariable(STEP_SELECTED), this.getVariable(TR_CROP_STEP), VariablesRule.Condition.EqualTo, VariablesRule.Action.SetToRequired, TR_CROP_STEP, true);
        new VariablesRule(this.getVariable(STEP_SELECTED), this.getVariable(TR_HEADCROP_STEP), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, TR_HEADCROP_STEP, true);
        new VariablesRule(this.getVariable(STEP_SELECTED), this.getVariable(TR_HEADCROP_STEP), VariablesRule.Condition.EqualTo, VariablesRule.Action.SetToRequired, TR_HEADCROP_STEP, true);
        new VariablesRule(this.getVariable(STEP_SELECTED), this.getVariable(TR_MINLEN_STEP), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, TR_MINLEN_STEP, true);
        new VariablesRule(this.getVariable(STEP_SELECTED), this.getVariable(TR_MINLEN_STEP), VariablesRule.Condition.EqualTo, VariablesRule.Action.SetToRequired, TR_MINLEN_STEP, true);
        new VariablesRule(this.getVariable(TR_ILLUMINACLIP_STEP), this.getVariableByCMDSwitch(TR_ILLUMINACLIP_STEP_fastaWithAdaptersSource), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(TR_ILLUMINACLIP_STEP), this.getVariableByCMDSwitch(TR_ILLUMINACLIP_STEP_fastaWithAdaptersSource), VariablesRule.Condition.True, VariablesRule.Action.SetToRequired, true);
        new VariablesRule(this.getVariable(TR_ILLUMINACLIP_STEP), this.getVariableByCMDSwitch(TR_ILLUMINACLIP_STEP_seedMismatches), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(TR_ILLUMINACLIP_STEP), this.getVariableByCMDSwitch(TR_ILLUMINACLIP_STEP_seedMismatches), VariablesRule.Condition.True, VariablesRule.Action.SetToRequired, true);
        new VariablesRule(this.getVariable(TR_ILLUMINACLIP_STEP), this.getVariableByCMDSwitch(TR_ILLUMINACLIP_STEP_palindromeClipThreshold), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(TR_ILLUMINACLIP_STEP), this.getVariableByCMDSwitch(TR_ILLUMINACLIP_STEP_palindromeClipThreshold), VariablesRule.Condition.True, VariablesRule.Action.SetToRequired, true);
        new VariablesRule(this.getVariable(TR_ILLUMINACLIP_STEP), this.getVariableByCMDSwitch(TR_ILLUMINACLIP_STEP_simpleClipThreshold), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(TR_ILLUMINACLIP_STEP), this.getVariableByCMDSwitch(TR_ILLUMINACLIP_STEP_simpleClipThreshold), VariablesRule.Condition.True, VariablesRule.Action.SetToRequired, true);
        new VariablesRule(this.getVariable(TR_ILLUMINACLIP_STEP), this.getVariableByCMDSwitch(TR_ILLUMINACLIP_STEP_minAdapterLength), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(TR_ILLUMINACLIP_STEP), this.getVariableByCMDSwitch(TR_ILLUMINACLIP_STEP_keepBothReads), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(TR_SLIDINGWINDOW_STEP), this.getVariableByCMDSwitch(TR_SLIDINGWINDOW_STEP_requiredQuality), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(TR_SLIDINGWINDOW_STEP), this.getVariableByCMDSwitch(TR_SLIDINGWINDOW_STEP_requiredQuality), VariablesRule.Condition.True, VariablesRule.Action.SetToRequired, true);
        new VariablesRule(this.getVariable(TR_SLIDINGWINDOW_STEP), this.getVariableByCMDSwitch(TR_SLIDINGWINDOW_STEP_windowSize), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(TR_SLIDINGWINDOW_STEP), this.getVariableByCMDSwitch(TR_SLIDINGWINDOW_STEP_windowSize), VariablesRule.Condition.True, VariablesRule.Action.SetToRequired, true);
    }
}

