/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing;

import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileVariable;

public class PreProcessingPlatanusTrimJob
extends WorkflowJob {
    public static final String JOB_ID = "platanus_internal_trim";
    public static final String JOB_NAME = "Platanus mate-pair Trimmer";
    private static final String INPUT_FASTQ_FILE = "INPUT_FILES";
    private static final String INPUT_FASTQ_FILE2 = "INPUT_FASTQ_FILE2";

    public PreProcessingPlatanusTrimJob() {
        this.jobName = JOB_NAME;
        this.jobDesc = new JobDescriptor(JOB_ID);
        this.jobDesc.setDesc("Platanus mate-pair Trimmer is designed for mate-pair library. It is used for trimming internal adaptor sequence, adaptor sequences, and low quality regions. ");
        this.jobDesc.setRef("Kajitani R, Toshimoto K, Noguchi H, Toyoda A, Ogura Y, Okuno M, Yabana M, Harada M, Nagayasu E, Maruyama H, Kohara Y, Fujiyama A, Hayashi T, Itoh T, \u201cEfficient de novo assembly of highly heterozygous genomes from whole-genome shotgun short reads\u201d. Genome Res. 2014 Aug;24(8):1384-95.<a href=\"http://doi.org/10.1101/gr.170720.113\">doi 10.1101/gr.170720.113</a>");
        VariableDescriptor varFastaQ = VariableDescriptor.createDescriptorFor((String)INPUT_FASTQ_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFastaQ.isRequired = true;
        varFastaQ.setVariableName("FASTQ Files");
        varFastaQ.addAcceptedFileFormat("FASTQ", true, false);
        this.jobDesc.addVariable(varFastaQ);
        SelectionListVariableDescriptor varOptionSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptionSelectionList.setVariableName("Internal adaptor type");
        varOptionSelectionList.setHelpMsg("Select internal adaptor type (default Nextera adaptor)");
        varOptionSelectionList.addOptionValue("454 adaptor", "1", "454 adaptor (ATCGTATAACTTCGTATAATGTATGCTATACGAAGTTATTACGT)");
        varOptionSelectionList.addOptionValue("Nextera adaptor", "2", "Nextera adaptor (CTGTCTCTTATACACATCTAGATGTGTATAAGAGACAG)");
        varOptionSelectionList.addOptionValue("Solid adaptor", "3", "Solid adaptor (TGCTGTACCGTACATCCGCCTTGGCCGTACAGCAG)");
        varOptionSelectionList.setCommandParamater("-a");
        this.jobDesc.addVariable((VariableDescriptor)varOptionSelectionList);
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Internal adaptor seq");
        varOption.setHelpMsg("Set internal adaptor seq (if you can use original internal adaptor without -a option)");
        varOption.setCommandParamater("-b");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Quality cutoff value");
        varOption.setHelpMsg("Quality cutoff value (default 15)");
        varOption.setCommandParamater("-q");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Adaptor 1");
        varOption.setHelpMsg("adaptor 1 (default AATGATACGGCGACCACCGAGATCTACACTCTTTCCCTACACGACGCTCTTCCGATCT)");
        varOption.setCommandParamater("-1");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Adaptor 2");
        varOption.setHelpMsg("adaptor 2 (default CAAGCAGAAGACGGCATACGAGATCGGTCTCGGCATTCCTGCTGAACCGCTCTTCCGATCT)");
        varOption.setCommandParamater("-2");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Do not remove read even if the pair is too short ");
        varOption.setHelpMsg("Not remove read even if the pair is too short ");
        varOption.setCommandParamater("-f");
        this.jobDesc.addVariable(varOption);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        VariableDescriptor varOutputFiles = VariableDescriptor.createDescriptorFor((String)"OUTPUT_FILES", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varOutputFiles.setVariableName("Output Files");
        varOutputFiles.addAcceptedFileFormat("FASTQ", true, false);
        this.jobDesc.addVariable(varOutputFiles);
        this.initJobFromDesc(this.jobDesc);
    }

    protected void generateCommand(StringBuilder command) {
        String progName = JOB_ID;
        command.append("cd " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\n");
        StringBuilder bodyBuilder = new StringBuilder();
        bodyBuilder.append("_inputFiles=\" -i1 " + this.getVariable(INPUT_FASTQ_FILE).$("0,$_i") + "  \"\n");
        bodyBuilder.append("inptFileExt=`rev <<< \"" + this.getVariable(INPUT_FASTQ_FILE).$("0,$_i") + "\" | cut -d. -f1 | rev`;\n");
        bodyBuilder.append("_inputFile1Name=$(basename " + this.getVariable(INPUT_FASTQ_FILE).$("0,$_i") + " );\n");
        bodyBuilder.append("_inputFile2Name=$(basename " + this.getVariable(INPUT_FASTQ_FILE).$("1,$_i") + " );\n");
        bodyBuilder.append(String.valueOf(this.getVariable("OUTPUT_FILES").getBashVarName("0,$_i")) + "=\"" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "/${_inputFileName} \"\n");
        bodyBuilder.append(String.valueOf(progName) + "  " + this.getOptionParamatersStrAs$() + " " + this.getVariable(INPUT_FASTQ_FILE).$("0,$_i") + "  " + this.getVariable(INPUT_FASTQ_FILE).$("1,$_i") + "  \n");
        bodyBuilder.append(BashHelper.IF((String)(" -f " + this.getVariable(INPUT_FASTQ_FILE).$("0,$_i") + ".int_trimmed"), (String)("mv " + this.getVariable(INPUT_FASTQ_FILE).$("0,$_i") + ".int_trimmed  ${_inputFile1Name} \n")));
        bodyBuilder.append(BashHelper.IF((String)(" -f " + this.getVariable(INPUT_FASTQ_FILE).$("1,$_i") + ".int_trimmed"), (String)("mv " + this.getVariable(INPUT_FASTQ_FILE).$("1,$_i") + ".int_trimmed ${_inputFile2Name} \n")));
        command.append(BashHelper.forIndex((String)"_i", (String)((FileVariable)this.getVariable(INPUT_FASTQ_FILE)).getCountAsBashVarName(), (String)"_i++", (String)bodyBuilder.toString()));
    }

    public String getJobCommand_notNeeded() {
        String progName = JOB_ID;
        this.autoConnentData();
        if (!this.isValid()) {
            return null;
        }
        String outputFolder = this.getJobDescID();
        this.getVariable("JOB_OUTPUT_FOLDER").setRelativeTo(this.getVariable("INPUT_OUTPUT_FOLDER"));
        this.setValue("JOB_OUTPUT_FOLDER", outputFolder);
        StringBuilder command = new StringBuilder();
        command.append(this.getVariable("JOB_OUTPUT_FOLDER").getBashVarDecleration());
        command.append(this.getVariable(INPUT_FASTQ_FILE).getBashVarDecleration());
        command.append(this.getVariable(INPUT_FASTQ_FILE2).getBashVarDecleration());
        command.append("cd " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\n");
        String forBody = String.valueOf(progName) + " " + this.getOptionParamaters() + " " + this.getVariable(INPUT_FASTQ_FILE).$("$_i") + " " + this.getVariable(INPUT_FASTQ_FILE2).$("$_i");
        command.append(BashHelper.forEachIndex((String)"_i", (String)this.getVariable(INPUT_FASTQ_FILE).getBashVarName(), (String)forBody));
        forBody = BashHelper.IF((String)(" -f " + this.getVariable(INPUT_FASTQ_FILE).$("$_i") + ".int_trimmed"), (String)("mv " + this.getVariable(INPUT_FASTQ_FILE).$("$_i") + ".int_trimmed . \n"));
        forBody = String.valueOf(forBody) + BashHelper.IF((String)(" -f " + this.getVariable(INPUT_FASTQ_FILE2).$("$_i") + ".int_trimmed"), (String)("mv " + this.getVariable(INPUT_FASTQ_FILE2).$("$_i") + ".int_trimmed . \n"));
        command.append(BashHelper.forEachIndex((String)"_i", (String)this.getVariable(INPUT_FASTQ_FILE).getBashVarName(), (String)forBody));
        command.append("cd $HOME \n");
        command.append("\n");
        return command.toString();
    }
}

