/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.IntVariableDescriptor;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class PreProcessingFastqIntersectJob
extends WorkflowJob {
    public static final String JOB_ID = "FastqIntersect";
    public static final String JOB_NAME = "FastqIntersect";
    private static final String INPUT_FASTQ_FILE = "INPUT_FILES";
    private static final String JAVA_MAX_HEAP_SIZE = "JAVA_MAX_HEAP_SIZE";

    public PreProcessingFastqIntersectJob() {
        this.jobName = "FastqIntersect";
        this.jobDesc = new JobDescriptor("FastqIntersect");
        this.jobDesc.setDesc("FastqIntersect is a biotechvana script that gets two fastq paired end files that have been independently preprocessed and performs an intersection between the reads of both files in order to keep only the mate reads that are present in both files. If both files does not have the same sequence order, it automatically sorts output file #2 following file #1\u2019s order");
        VariableDescriptor varFastaQ = VariableDescriptor.createDescriptorFor((String)INPUT_FASTQ_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFastaQ.isRequired = true;
        varFastaQ.setVariableName("FASTQ");
        varFastaQ.addAcceptedFileFormat("FASTQ", true, false);
        this.jobDesc.addVariable(varFastaQ);
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Output mismatching sequence names");
        varOption.setCommandParamater("-m");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Export non-matching FASTQ files");
        varOption.setCommandParamater("-n");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Do not sort output files");
        varOption.setCommandParamater("-u");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)JAVA_MAX_HEAP_SIZE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Maximum Java Heap Size - GB");
        varOption.setHelpMsg("Maximum Memory allocated to Java Virtual Machine of unit GB, default value is 4GB");
        varOption.setCommandParamater("-Xmx");
        varOption.setVariableGroup("Java");
        varOption.setSubProgName("Java");
        varOption.setDefaultValue("4");
        ((IntVariableDescriptor)varOption).setMaxValue(128.0);
        ((IntVariableDescriptor)varOption).setMinValue(1.0);
        this.jobDesc.addVariable(varOption);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        VariableDescriptor varOutputFiles = VariableDescriptor.createDescriptorFor((String)"OUTPUT_FILES", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varOutputFiles.setVariableName("Output Files");
        varOutputFiles.addAcceptedFileFormat("FASTQ", true, false);
        this.jobDesc.addVariable(varOutputFiles);
        this.initJobFromDesc(this.jobDesc);
    }

    protected void generateCommand(StringBuilder command) {
        command.append(BashHelper.If((String)BashConditions.emptyStr((JobVariable)this.getVariable(JAVA_MAX_HEAP_SIZE))).Then(BashHelper.assign((JobVariable)this.getVariable(JAVA_MAX_HEAP_SIZE), (String)"4")));
        String maxHeapSize = this.getVariable(JAVA_MAX_HEAP_SIZE).$();
        String progName = "java  -Xmx" + maxHeapSize + "g -jar " + Constants.PIPELINE_BASE_PATH + "FastqIntersect.jar  ";
        String parsedOptions = this.getOptionParamatersStrAs$();
        command.append("outputFolder=\"" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\"\n");
        command.append(" [ -d \"${outputFolder}/summary\" ] || mkdir \"${outputFolder}/summary\" \n");
        command.append("# to cause fail of pipe - tee \n");
        command.append("set -o pipefail \n");
        command.append(BashHelper.Batcher((FileListVariable)((FileListVariable)this.getVariable(INPUT_FASTQ_FILE)), (String)"", (String)"", (String)(String.valueOf(progName) + parsedOptions + " -o  \"${outputFolder}\" -i1 ${_inputFile1}  -i2 ${_inputFile2} -v | tee \"${outputFolder}/summary/${inputFile1BaseName}_${inputFile2BaseName}_summary.txt\""), (String)(String.valueOf(this.getVariable("OUTPUT_FILES").getBashVarName("0,$_i")) + "=\"${outputFolder}/${inputFile1BaseName}.fastq\" \n" + this.getVariable("OUTPUT_FILES").getBashVarName("1,$_i") + "=\"${outputFolder}/${inputFile2BaseName}.fastq\" \n" + BashHelper.moveWithWarning((String)"${outputFolder}/${inputFile1BaseName}_intersect.fastq", (String)"${outputFolder}/${inputFile1BaseName}.fastq") + BashHelper.moveWithWarning((String)"${outputFolder}/${inputFile2BaseName}_intersect.fastq", (String)"${outputFolder}/${inputFile2BaseName}.fastq"))));
        command.append("set +o pipefail \n");
    }

    protected void generateCommandWrapUp(StringBuilder command) {
        ((FileVariable)this.getVariable("OUTPUT_FILES")).setFileFormat("FASTQ");
        command.append(this.getVariable("OUTPUT_FILES").getPropertiesAsBashVar());
        command.append(((FileVariable)this.getVariable("OUTPUT_FILES")).getFileFormatAsBashVar(this.getVariable(INPUT_FASTQ_FILE)));
    }
}

