/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;

public class PreProcessingFastqCSVTrimerJob
extends WorkflowJob {
    public static final String JOB_ID = "FastqCsvTrimmer";
    public static final String JOB_NAME = "FastqCSVTrimer";
    private static final String INPUT_FASTQ_FILE = "INPUT_FASTQ_FILE";
    private static final String INPUT_CSV_FOLDER = "INPUT_CSV_FOLDER";
    private static final String INPUT_CREATE_DIVIDED_OUTPUTS = "INPUT_CREATE_DIVIDED_OUTPUTS";
    private static final String OPTION_SEPARATOR = "OPTION_SEPARATOR";

    public PreProcessingFastqCSVTrimerJob() {
        this.jobName = JOB_NAME;
        this.jobDesc = new JobDescriptor(JOB_ID);
        this.jobDesc.setDesc("FastqCsvTrimmer  : Trimming of Fastq files using blat output table. It Parse in batch mode a FASTQ and a CSV folder to get trimmed FASTQsbased on it correspondig CSV start and end positions.");
        VariableDescriptor varFastaQ = VariableDescriptor.createDescriptorFor((String)INPUT_FASTQ_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Folder, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFastaQ.isRequired = true;
        varFastaQ.setVariableName("Input FASTQ folder");
        varFastaQ.setCommandParamater("-fastq");
        this.jobDesc.addVariable(varFastaQ);
        VariableDescriptor varCSVFolder = VariableDescriptor.createDescriptorFor((String)INPUT_CSV_FOLDER, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Folder, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varCSVFolder.isRequired = true;
        varCSVFolder.setVariableName("Input CSV folder");
        varCSVFolder.setCommandParamater("-csv");
        this.jobDesc.addVariable(varCSVFolder);
        SelectionListVariableDescriptor varSeparator = VariableDescriptor.SelectionList((String)OPTION_SEPARATOR, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varSeparator.addOptionValue("TAB");
        varSeparator.addOptionValue("SPACE");
        varSeparator.addOptionValue("SEMICOLON");
        varSeparator.addOptionValue("COLON");
        varSeparator.setVariableName("CSV Separator");
        varSeparator.setHelpMsg("CSV separator: TAB, SPACE, SEMICOLON, COLON. Default TAB.");
        this.jobDesc.addVariable((VariableDescriptor)varSeparator);
        VariableDescriptor varDivided = VariableDescriptor.createDescriptorFor((String)INPUT_CREATE_DIVIDED_OUTPUTS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varDivided.setVariableName("Create divided outputs for matching and non-matching sequences.");
        varDivided.setHelpMsg("Create divided outputs for matching and non-matching sequences.");
        varDivided.setCommandParamater("-divide ");
        this.jobDesc.addVariable(varDivided);
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("CSV match column");
        varOption.setHelpMsg("CSV match column. Default 1");
        varOption.setCommandParamater("-match ");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("CSV start column index.");
        varOption.setHelpMsg("CSV start column index. Default 12.");
        varOption.setCommandParamater("-start ");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("CSV end column index");
        varOption.setHelpMsg("CSV end column index. Default 13");
        varOption.setCommandParamater("-end ");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("CSV name column index");
        varOption.setHelpMsg("CSV name column index. Default 10");
        varOption.setCommandParamater("-name ");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("CSV file extension.");
        varOption.setHelpMsg("CSV file extension. Default 'psl'");
        varOption.setCommandParamater("-extension ");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Maximum match cutoff value");
        varOption.setHelpMsg("Maximum match cutoff value. Optional");
        varOption.setCommandParamater("-max_match ");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Minimum match cutoff value");
        varOption.setHelpMsg("Minimum match cutoff value. Optional");
        varOption.setCommandParamater("-min_match ");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Do not trim sequences.");
        varOption.setHelpMsg("Do not trim sequences. Optional");
        varOption.setCommandParamater("-notrim ");
        this.jobDesc.addVariable(varOption);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        this.initJobFromDesc(this.jobDesc);
    }

    public String getJobCommand() {
        String progName = "java -jar " + Constants.PIPELINE_BASE_PATH + "FastqCsvTrimmer.jar ";
        this.autoConnentData();
        if (!this.isValid()) {
            return null;
        }
        String outputFolder = this.getJobDescID();
        this.getVariable("JOB_OUTPUT_FOLDER").setRelativeTo(this.getVariable("INPUT_OUTPUT_FOLDER"));
        this.setValue("JOB_OUTPUT_FOLDER", outputFolder);
        StringBuilder command = new StringBuilder();
        command.append(this.getVariable("JOB_OUTPUT_FOLDER").getBashVarDecleration());
        command.append(String.valueOf(progName) + " -output " + this.getVariable("JOB_OUTPUT_FOLDER").$() + " " + this.getOptionParamaters() + " ");
        return command.toString();
    }
}

