/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.postprocessing.samtools;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.VariableBag;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;

public class SamtoolsHelper {
    public static final String Mpileup = "Mpileup";

    public static VariableDescriptor createInputBamFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)VariableBag.INPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input Bam Files");
        varReadInputFile.setHelpMsg("Input Bam Files.");
        varReadInputFile.addAcceptedFileFormat("BAM");
        return varReadInputFile;
    }

    public static VariableDescriptor createReferenceVar() {
        VariableDescriptor varReferenceFasta = VariableDescriptor.createDescriptorFor((String)VariableBag.INPUT_REF_FASTA, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReferenceFasta.setVariableName("Input Reference fasta file");
        varReferenceFasta.setShortHelpMsg("Drag an Reference fasta file");
        varReferenceFasta.setHelpMsg("Reference fasta file.");
        varReferenceFasta.setCommandParamater("-f");
        return varReferenceFasta;
    }

    public static String getSamtoolsCmdPrefix() {
        return String.valueOf(Constants.PIPELINE_BASE_PATH) + "samtools.1.8 ";
    }

    public static void createMpileupOptions(JobDescriptor jobDesc) {
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Disable probabilistic realignment for the computation of base alignment quality (BAQ)");
        optionVar.setHelpMsg("Disable probabilistic realignment for the computation of base alignment quality (BAQ). BAQ is the Phred-scaled probability of a read base being misaligned. Applying this option greatly helps to reduce false SNPs caused by misalignments.");
        optionVar.setCommandParamater("-B");
        optionVar.setCommandParamaterAlt("--no-BAQ");
        optionVar.setDefaultValue("true");
        optionVar.setVariableGroup(Mpileup);
        optionVar.setSubProgName(Mpileup);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Assume the quality is in the Illumina 1.3+ encoding");
        optionVar.setHelpMsg("Assume the quality is in the Illumina 1.3+ encoding");
        optionVar.setCommandParamater("-6");
        optionVar.setCommandParamaterAlt("--illumina1.3+");
        optionVar.setVariableGroup(Mpileup);
        optionVar.setSubProgName(Mpileup);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Do not skip anomalous read pairs in variant calling");
        optionVar.setHelpMsg("Do not skip anomalous read pairs in variant calling");
        optionVar.setCommandParamater("-A");
        optionVar.setCommandParamaterAlt("--count-orphans");
        optionVar.setVariableGroup(Mpileup);
        optionVar.setSubProgName(Mpileup);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Coefficient for adjusting Mapping Quality");
        optionVar.setShortHelpMsg("Coefficient for downgrading mapping quality for reads containing excessive mismatches.");
        optionVar.setHelpMsg("Coefficient for downgrading mapping quality for reads containing excessive mismatches. Given a read with a phred-scaled probability q of being generated from the mapped position, the new mapping quality is about sqrt((INT-q)/INT)*INT. A zero value disables this functionality; if enabled, the recommended value for BWA is 50. Default is 0");
        optionVar.setCommandParamater("-C");
        optionVar.setCommandParamaterAlt("--adjust-MQ");
        optionVar.setVariableGroup(Mpileup);
        optionVar.setSubProgName(Mpileup);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Read Max Depth");
        optionVar.setShortHelpMsg("At a position, read maximally INT reads per input file.");
        optionVar.setHelpMsg("At a position, read maximally INT reads per input file. Note that samtools has a minimum value of 8000/n where n is the number of input files given to mpileup. This means the default is highly likely to be increased. Once above the cross-sample minimum of 8000 the -d parameter will have an effect. Default is 250");
        optionVar.setCommandParamater("-d");
        optionVar.setCommandParamaterAlt("--max-depth");
        optionVar.setVariableGroup(Mpileup);
        optionVar.setSubProgName(Mpileup);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Recalculate BAQ on the fly, ignore existing BQ tags ");
        optionVar.setHelpMsg("Recalculate BAQ on the fly, ignore existing BQ tags ");
        optionVar.setCommandParamater("-E");
        optionVar.setCommandParamaterAlt("--redo-BAQ");
        optionVar.setVariableGroup(Mpileup);
        optionVar.setSubProgName(Mpileup);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("BED or position list file containing a list of regions");
        optionVar.setHelpMsg("BED or position list file containing a list of regions or sites where pileup or BCF should be generated. Position list files contain two columns (chromosome and position) and start counting from 1. BED files contain at least 3 columns (chromosome, start and end position) and are 0-based half-open.\nWhile it is possible to mix both position-list and BED coordinates in the same file, this is strongly ill advised due to the differing coordinate systems");
        optionVar.setCommandParamater("-l");
        optionVar.setCommandParamaterAlt("--positions");
        optionVar.setVariableGroup(Mpileup);
        optionVar.setSubProgName(Mpileup);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum mapping quality for an alignment to be used");
        optionVar.setHelpMsg("Minimum mapping quality for an alignment to be used. Default is 0");
        optionVar.setCommandParamater("-q");
        optionVar.setCommandParamaterAlt("-min-MQ");
        optionVar.setVariableGroup(Mpileup);
        optionVar.setSubProgName(Mpileup);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum base quality for a base to be considered");
        optionVar.setHelpMsg("Minimum base quality for a base to be considered. Default is 13");
        optionVar.setCommandParamater("-Q");
        optionVar.setCommandParamaterAlt("--min-BQ");
        optionVar.setVariableGroup(Mpileup);
        optionVar.setSubProgName(Mpileup);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Disable read-pair overlap detection");
        optionVar.setHelpMsg("Disable read-pair overlap detection");
        optionVar.setCommandParamater("-x");
        optionVar.setCommandParamaterAlt("--ignore-overlaps");
        optionVar.setVariableGroup(Mpileup);
        optionVar.setSubProgName(Mpileup);
        jobDesc.addVariable(optionVar);
    }
}

