/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.mapping;

import com.biotechvana.shared.jobs.PreprocessingFilters;
import com.biotechvana.utils.FilenameUtils;
import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.JobLink;
import com.biotechvana.workflow.descriptors.Publication;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class MappingHisat2Job
extends WorkflowJob {
    public static final String JOB_ID = "hisat2";
    public static final String JOB_NAME = "Hisat2";
    public static final String OPTION_RM_FILTER = "OPTION_RM";
    public static final String INPUT_INDEX_CHOICE = "INPUT_INDEX_CHOICE";
    public static final String INPUT_INDEX_FASTA_FILE = "INDEX_FASTA_FILE";
    public static final String INPUT_INDEX_PREFIX = "INPUT_INDEX_PREFIX";
    public static final String INPUT_INDEX_FILE = "INPUT_INDEX_FILE";
    public static final String INPUT_FASTQ_FILE = "INPUT_FILES";
    private static final String Use_Existing = "Use Existing";
    private static final String Build_New = "Build New";
    public static final String OUTPUT_ACCEPTED_HITS = "OUTPUT_FILES";
    public static final String OUTPUT_SAM_FILES = "OUTPUT_SAM_FILES";
    public static final String OUTPUT_REF_INDEX = "OUTPUT_REF_INDEX";
    private static final String OPTION_INPUT_GROUP = "Input Option";
    private static final String OPTION_ALIGNMENT_GROUP = "Alignment Option";
    private static final String OPTION_SCORING_GROUP = "Scoring Option";
    private static final String OPTION_SPLICED_ALIGNMENT_GROUP = "Spliced Alignment Option";
    private static final String OPTION_REPORTING_GROUP = "Reporting Option";
    private static final String OPTION_OUTPUT_GROUP = "Output Option";
    public static final String OUTPUT_LIBRARY_NAMES = "OUTPUT_LIBRARY_NAMES";
    private static final String OPTION_KEEP_TO_SAM = "OPTION_KEEP_SAM";

    public MappingHisat2Job() {
        this.jobName = JOB_NAME;
        this.jobDesc = new JobDescriptor(JOB_ID);
        this.jobDesc.setDesc("HISAT2 is a fast and sensitive alignment program for mapping next-generation sequencing reads (whole-genome, transcriptome, and exome sequencing data) against the general human population (as well as against a single reference genome).");
        this.jobDesc.addPublication(new Publication().setAuthors("Kim, D., Paggi, J.M., Park, C., Bennett, C. and Salzberg, S.L.").setTitle("Graph-based genome alignment and genotyping with HISAT2 and HISAT-genotype").setJournal("Nature biotechnology").setVolume(37).setIssue(8).setYear(2019).setPages("907-915").setDOI("10.1038/s41587-019-0201-4").setPubmed("31375807"));
        this.jobDesc.addLink(new JobLink().setTitle(JOB_ID).setUrl("http://daehwankimlab.github.io/hisat2/manual/").setType(JobLink.LinkType.Manual));
        VariableDescriptor varIndexChioce = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_CHOICE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexChioce.setVariableName("Create new index");
        varIndexChioce.setHelpMsg("Use an exisiting index or create new one from a Fasta File");
        varIndexChioce.setDefaultValue("false");
        this.jobDesc.addVariable(varIndexChioce);
        VariableDescriptor varUsedIndexFile = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varUsedIndexFile.isRequired = true;
        varUsedIndexFile.setVariableName("Index File");
        varUsedIndexFile.setShortHelpMsg("Drag an Existing index .ht2 extension");
        varUsedIndexFile.setHelpMsg("hisat2 Index files end with .ht2 extensions and are build by hisat2-build program.");
        this.jobDesc.addVariable(varUsedIndexFile);
        VariableDescriptor varIndexFile = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_FASTA_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexFile.isRequired = true;
        varIndexFile.setVariableName("Input Ref Fasta File");
        varIndexFile.setHelpMsg("Reference Fasta file to build a new index.");
        varIndexFile.setShortHelpMsg("Drag a Fasta file to build a new index.");
        this.jobDesc.addVariable(varIndexFile);
        VariableDescriptor varIndexFilePrefix = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_PREFIX, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexFilePrefix.setVariableName("Prefix");
        varIndexFilePrefix.setIsFileName(true);
        varIndexFilePrefix.setHelpMsg("A prefix name for the output index file. Defualt same as the prefix of the input Fasta File Name.");
        this.jobDesc.addVariable(varIndexFilePrefix);
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_FASTQ_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input File");
        varReadInputFile.addAcceptedFileFormat("FASTQ", false, true);
        varReadInputFile.setHelpMsg("Input Fastq files to map.");
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        VariableDescriptor varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_RM_FILTER, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Expected Overall alignment rate");
        varOptions.setHelpMsg("Min/Expected overall alignment rate to consider the mapping succesfull. Has no effect of the bahavoiur of The mapper. Used only for managment pipeline and tracking. Default 80");
        varOptions.setDefaultValue("80");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Skip the first n reads or pairs in the input");
        varOptions.setHelpMsg("Skip (i.e. do not align) the first <int> reads or pairs in the input.");
        varOptions.setCommandParamater("-s");
        varOptions.setVariableGroup(OPTION_INPUT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Only Align the first <int> reads or read pairs from the input");
        varOptions.setHelpMsg("Align the first <int> reads or read pairs from the input (after the -s/--skip reads or pairs have been skipped), then stop. Default: no limit.");
        varOptions.setCommandParamater("-u");
        varOptions.setVariableGroup(OPTION_INPUT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Trim <n> bases from 5' end");
        varOptions.setHelpMsg("Trim <n> bases from 5' (left) end of each read before alignment. Default is 0.");
        varOptions.setCommandParamater("-5");
        varOptions.setVariableGroup(OPTION_INPUT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Trim <n> bases from 3'");
        varOptions.setHelpMsg("Trim <n> bases from 3' (right) end of each read before alignment. Default is 0");
        varOptions.setCommandParamater("-3");
        varOptions.setVariableGroup(OPTION_INPUT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Input qualities are ASCII chars equal to the Phred quality plus 33");
        varOptions.setHelpMsg("Input qualities are ASCII chars equal to the Phred quality plus 33. This is also called the \"Phred+33\" encoding, which is used by the very latest Illumina pipelines");
        varOptions.setCommandParamater("--phred33");
        varOptions.setVariableGroup(OPTION_INPUT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Input qualities are ASCII chars equal to the Phred quality plus 64.");
        varOptions.setHelpMsg("Input qualities are ASCII chars equal to the Phred quality plus 64. This is also called the \"Phred+64\" encoding.");
        varOptions.setCommandParamater("--phred64");
        varOptions.setVariableGroup(OPTION_INPUT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Convert input qualities from Solexa to Phred");
        varOptions.setHelpMsg("Convert input qualities from Solexa (which can be negative) to Phred (which can't). This scheme was used in older Illumina GA Pipeline versions (prior to 1.3). Default: off.");
        varOptions.setCommandParamater("--solexa-quals");
        varOptions.setVariableGroup(OPTION_INPUT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Quality values are represented in the read input file as space-separated ASCII integers");
        varOptions.setHelpMsg("Quality values are represented in the read input file as space-separated ASCII integers, e.g., 40 40 30 40..., rather than ASCII characters, e.g., II?I.... Integers are treated as being on the Phred quality scale unless --solexa-quals is also specified. Default: off.");
        varOptions.setCommandParamater("--int-quals");
        varOptions.setVariableGroup(OPTION_INPUT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Function governing the maximum number of ambiguous characters (usually Ns and/or .s) allowed in a read");
        varOptions.setHelpMsg("Sets a function governing the maximum number of ambiguous characters (usually Ns and/or .s) allowed in a read as a function of read length. For instance, specifying -L,0,0.15 sets the N-ceiling function f to f(x) = 0 + 0.15 * x, where x is the read length. See also: [setting function options]. Reads exceeding this ceiling are filtered out. Default: L,0,0.15.");
        varOptions.setCommandParamater("--n-ceil");
        varOptions.setVariableGroup(OPTION_ALIGNMENT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Ignore Quality values.");
        varOptions.setHelpMsg("When calculating a mismatch penalty, always consider the quality value at the mismatched position to be the highest possible, regardless of the actual value. I.e. input is treated as though all quality values are high. This is also the default behavior when the input doesn't specify quality values (e.g. in -f, -r, or -c modes)");
        varOptions.setCommandParamater("--ignore-quals");
        varOptions.setVariableGroup(OPTION_ALIGNMENT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Do not attempt to align unpaired reads to the forward (Watson) reference strand");
        varOptions.setHelpMsg("If --nofw is specified, hisat2 will not attempt to align unpaired reads to the forward (Watson) reference strand. In paired-end mode, --nofw and --norc pertain to the fragments; i.e. specifying --nofw causes hisat2 to explore only those paired-end configurations corresponding to fragments from the reverse-complement (Crick) strand.");
        varOptions.setCommandParamater("--nofw");
        varOptions.setVariableGroup(OPTION_ALIGNMENT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Do not attempt to align unpaired reads against the reverse-complement (Crick) reference strand.");
        varOptions.setHelpMsg("If --nofw is specified, hisat2 will not attempt to align unpaired reads to the forward (Watson) reference strand. In paired-end mode, --nofw and --norc pertain to the fragments; i.e. specifying --nofw causes hisat2 to explore only those paired-end configurations corresponding to fragments from the reverse-complement (Crick) strand.");
        varOptions.setCommandParamater("--norc");
        varOptions.setVariableGroup(OPTION_ALIGNMENT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("The maximum (MX) and minimum (MN) mismatch penalties, both integers.");
        varOptions.setHelpMsg("Sets the maximum (MX) and minimum (MN) mismatch penalties, both integers. A number less than or equal to MX and greater than or equal to MN is subtracted from the alignment score for each position where a read character aligns to a reference character, the characters do not match, and neither is an N. If --ignore-quals is specified, the number subtracted quals MX. Otherwise, the number subtracted is MN + floor( (MX-MN)(MIN(Q, 40.0)/40.0) ) where Q is the Phred quality value. Default: MX = 6, MN = 2");
        varOptions.setCommandParamater("--mp");
        varOptions.setVariableGroup(OPTION_SCORING_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("The maximum (MX) and minimum (MN) penalties for soft-clipping per base, both integers.");
        varOptions.setHelpMsg("Sets the maximum (MX) and minimum (MN) penalties for soft-clipping per base, both integers. A number less than or equal to MX and greater than or equal to MN is subtracted from the alignment score for each position. The number subtracted is MN + floor( (MX-MN)(MIN(Q, 40.0)/40.0) ) where Q is the Phred quality value. Default: MX = 2, MN = 1");
        varOptions.setCommandParamater("--sp");
        varOptions.setVariableGroup(OPTION_SCORING_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Disallow soft-clipping");
        varOptions.setHelpMsg("Disallow soft-clipping");
        varOptions.setCommandParamater("--no-softclip");
        varOptions.setVariableGroup(OPTION_SCORING_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Penalty for positions where the read, reference, or both, contain an ambiguous character such as N.");
        varOptions.setHelpMsg("Sets penalty for positions where the read, reference, or both, contain an ambiguous character such as N. Default: 1.");
        varOptions.setCommandParamater("--np");
        varOptions.setVariableGroup(OPTION_SCORING_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("The read gap open (<int1>) and extend (<int2>) penalties");
        varOptions.setHelpMsg("Sets the read gap open (<int1>) and extend (<int2>) penalties. A read gap of length N gets a penalty of <int1> + N * <int2>. Default: 5, 3");
        varOptions.setCommandParamater("--rdg");
        varOptions.setVariableGroup(OPTION_SCORING_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("The reference gap open (<int1>) and extend (<int2>) penalties");
        varOptions.setHelpMsg("Sets the reference gap open (<int1>) and extend (<int2>) penalties. A reference gap of length N gets a penalty of <int1> + N * <int2>. Default: 5, 3");
        varOptions.setCommandParamater("--rfg");
        varOptions.setVariableGroup(OPTION_SCORING_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Function governing the minimum alignment score needed for an alignment to be considered valid");
        varOptions.setHelpMsg("Sets a function governing the minimum alignment score needed for an alignment to be considered \"valid\" (i.e. good enough to report). This is a function of read length. For instance, specifying L,0,-0.6 sets the minimum-score function f to f(x) = 0 + -0.6 * x, where x is the read length. See also: [setting function options]. The default is L,0,-0.2");
        varOptions.setCommandParamater("--score-min");
        varOptions.setVariableGroup(OPTION_SCORING_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Penalty for each pair of canonical splice sites (e.g. GT/AG)");
        varOptions.setHelpMsg("Sets the penalty for each pair of canonical splice sites (e.g. GT/AG). Default: 0");
        varOptions.setCommandParamater("--pen-cansplice");
        varOptions.setVariableGroup(OPTION_SPLICED_ALIGNMENT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Penalty for each pair of non-canonical splice sites (e.g. non-GT/AG)");
        varOptions.setHelpMsg("Sets the penalty for each pair of non-canonical splice sites (e.g. non-GT/AG). Default: 12");
        varOptions.setCommandParamater("---pen-noncansplice");
        varOptions.setVariableGroup(OPTION_SPLICED_ALIGNMENT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Penalty Function for long introns with canonical splice sites");
        varOptions.setHelpMsg("Sets the penalty for long introns with canonical splice sites so that alignments with shorter introns are preferred to those with longer ones. Default: G,-8,1");
        varOptions.setCommandParamater("--pen-canintronlen");
        varOptions.setVariableGroup(OPTION_SPLICED_ALIGNMENT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Penalty Function for long introns with noncanonical splice sites");
        varOptions.setHelpMsg("Sets the penalty for long introns with noncanonical splice sites so that alignments with shorter introns are preferred to those with longer ones. Default: G,-8,1");
        varOptions.setCommandParamater("--pen-noncanintronlen");
        varOptions.setVariableGroup(OPTION_SPLICED_ALIGNMENT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Minimum intron length");
        varOptions.setHelpMsg("Minimum intron length. Default: 20");
        varOptions.setCommandParamater("--min-intronlen");
        varOptions.setVariableGroup(OPTION_SPLICED_ALIGNMENT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Maximum intron length");
        varOptions.setHelpMsg("Maximum intron length. Default: 500000");
        varOptions.setCommandParamater("--max-intronlen");
        varOptions.setVariableGroup(OPTION_SPLICED_ALIGNMENT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("List of known splice sites");
        varOptions.setHelpMsg("With this mode, you can provide a list of known splice sites, which HISAT2 makes use of to align reads with small anchors.You can create such a list using python hisat2_extract_splice_sites.py genes.gtf > splicesites.txt, where hisat2_extract_splice_sites.py is included in the HISAT2 package, genes.gtf is a gene annotation file, and splicesites.txt is a list of splice sites with which you provide HISAT2 in this mode. Note that it is better to use indexes built using annotated transcripts (such as genome_tran or genome_snp_tran), which works better than using this option. It has no effect to provide splice sites that are already included in the indexes.");
        varOptions.setCommandParamater("--known-splicesite-infile");
        varOptions.setVariableGroup(OPTION_SPLICED_ALIGNMENT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Disables use of splice sites found by earlier reads to align later reads in the same run");
        varOptions.setHelpMsg("HISAT2, by default, makes use of splice sites found by earlier reads to align later reads in the same run, in particular, reads with small anchors (<= 15 bp). The option disables this default alignment strategy.");
        varOptions.setCommandParamater("--no-temp-splicesite");
        varOptions.setVariableGroup(OPTION_SPLICED_ALIGNMENT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Disable spliced alignment");
        varOptions.setHelpMsg("Disable spliced alignment");
        varOptions.setCommandParamater("--no-spliced-alignment");
        varOptions.setVariableGroup(OPTION_SPLICED_ALIGNMENT_GROUP);
        this.jobDesc.addVariable(varOptions);
        SelectionListVariableDescriptor varOptionsSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptionsSelectionList.setVariableName("Specify strand-specific information");
        varOptionsSelectionList.setHelpMsg("Specify strand-specific information: the default is unstranded. With this option being used, every read alignment will have an XS attribute tag: '+' means a read belongs to a transcript on '+' strand of genome. '-' means a read belongs to a transcript on '-' strand of genome.");
        varOptionsSelectionList.addOptionValue("F", "F", "Read corresponds to a transcript in single-end reads");
        varOptionsSelectionList.addOptionValue("R", "R", "Read corresponds to the reverse complemented counterpart of a transcript in single-end reads");
        varOptionsSelectionList.addOptionValue("FR", "FR", "Read corresponds to a transcript in paired-end reads");
        varOptionsSelectionList.addOptionValue("RF", "RF", "Read corresponds to the reverse complemented counterpart of a transcript in paired-end reads");
        varOptionsSelectionList.setCommandParamater("--rna-strandness");
        varOptionsSelectionList.setVariableGroup(OPTION_SPLICED_ALIGNMENT_GROUP);
        this.jobDesc.addVariable((VariableDescriptor)varOptionsSelectionList);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Report only those alignments within known transcripts");
        varOptions.setHelpMsg("Report only those alignments within known transcripts");
        varOptions.setCommandParamater("--tmo");
        varOptions.setVariableGroup(OPTION_SPLICED_ALIGNMENT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Report alignments tailored for transcript assemblers including StringTie");
        varOptions.setHelpMsg("Report alignments tailored for transcript assemblers including StringTie. With this option, HISAT2 requires longer anchor lengths for de novo discovery of splice sites. This leads to fewer alignments with short-anchors, which helps transcript assemblers improve significantly in computation and memory usage");
        varOptions.setCommandParamater("--dta");
        varOptions.setVariableGroup(OPTION_SPLICED_ALIGNMENT_GROUP);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Report alignments tailored specifically for Cufflinks");
        varOptions.setHelpMsg("Report alignments tailored specifically for Cufflinks. In addition to what HISAT2 does with the (--dta) option , With this option, HISAT2 looks for novel splice sites with three signals (GT/AG, GC/AG, AT/AC), but all user-provided splice sites are used irrespective of their signals. HISAT2 produces an optional field, XS:A:[+-], for every spliced alignment");
        varOptions.setCommandParamater("--dta-cufflinks\t");
        varOptions.setVariableGroup(OPTION_SPLICED_ALIGNMENT_GROUP);
        this.jobDesc.addVariable(varOptions);
        VariableDescriptor varConvertToSam = VariableDescriptor.createDescriptorFor((String)OPTION_KEEP_TO_SAM, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varConvertToSam.setVariableName("Keep Sam Files");
        varConvertToSam.setHelpMsg("Output files are coverted to bam format and sam files are deleted by default. If you need to keep the sam files format check this option.");
        this.jobDesc.addVariable(varConvertToSam);
        VariableDescriptor outputVarAcceptedHits = VariableDescriptor.createDescriptorFor((String)OUTPUT_ACCEPTED_HITS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        outputVarAcceptedHits.setVariableName("Alignments File");
        outputVarAcceptedHits.setHelpMsg("A list of read alignments in BAM format.");
        this.jobDesc.addVariable(outputVarAcceptedHits);
        varOptions = VariableDescriptor.createDescriptorFor((String)OUTPUT_SAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        varOptions.setVariableName("SAM Files");
        varOptions.setHelpMsg("SAM Files.");
        this.jobDesc.addVariable(varOptions);
        VariableDescriptor outputRefIndex = VariableDescriptor.createDescriptorFor((String)OUTPUT_REF_INDEX, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        outputRefIndex.setVariableName("REF Index");
        outputRefIndex.setHelpMsg("Ref Index");
        this.jobDesc.addVariable(outputRefIndex);
        VariableDescriptor outputVarLibraryName = VariableDescriptor.createDescriptorFor((String)OUTPUT_LIBRARY_NAMES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        outputVarLibraryName.setVariableName("Library Names");
        outputVarLibraryName.setHelpMsg("Library Names");
        outputVarLibraryName.setGUIVisible(false);
        this.jobDesc.addVariable(outputVarLibraryName);
        PreprocessingFilters.addPrepresoccesingRMFilter(this.jobDesc, outputVarAcceptedHits, this.jobDesc.getVariableDescById(OPTION_RM_FILTER));
        this.initJobFromDesc(this.jobDesc);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_FILE), VariablesRule.Condition.False, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_FASTA_FILE), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_PREFIX), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
    }

    public String notifyVarValueChanging(String varKey, String value) {
        try {
            if (varKey.equals(INPUT_INDEX_FILE)) {
                String refIndex = value;
                String ext = FilenameUtils.getExtension((String)refIndex);
                System.out.println(ext);
                if (ext != null && (ext.equals(".ht2") || ext.equals(".ht"))) {
                    String raw = FilenameUtils.getBasename((String)refIndex, (boolean)true);
                    String ext2 = FilenameUtils.getExtension((String)(raw = FilenameUtils.getBasename((String)raw, (boolean)true)), (boolean)true);
                    if (ext2 != null && ext2.equals(".rev")) {
                        raw = FilenameUtils.getBasename((String)raw, (boolean)true);
                    }
                    String path = org.apache.commons.io.FilenameUtils.getPath((String)refIndex);
                    return "/" + path + raw;
                }
                this.getVariable(INPUT_INDEX_FILE).setWarning("May not be a Hisat2 Index File.");
            }
        }
        catch (Exception ex) {
            System.out.println("notifyVarValueChanging Error in " + varKey + "  " + this.getJobDescID());
        }
        return value;
    }

    protected void generateCommand(StringBuilder builder) {
        String outputIndexFile = this.getVariable(OUTPUT_REF_INDEX).getBashVarName();
        String buildIndex = "" + BashHelper.If((String)BashConditions.Equal((JobVariable)this.getVariable(INPUT_INDEX_CHOICE), (String)"true")).Then("_baseDir=$(dirname \"" + this.getVariable(INPUT_INDEX_FASTA_FILE).$() + "\")\n" + "inputIndexFileBaseName=" + BashHelper.getBaseName((JobVariable)this.getVariable(INPUT_INDEX_FASTA_FILE)) + outputIndexFile + "=\"${_baseDir}/${inputIndexFileBaseName}\"\n" + BashHelper.If((String)BashConditions.notEmptyStr((JobVariable)this.getVariable(INPUT_INDEX_PREFIX))).Then(String.valueOf(outputIndexFile) + "=\"${_baseDir}/" + this.getVariable(INPUT_INDEX_PREFIX).$() + "\"\n") + "prefixOption=\"${" + outputIndexFile + "}\"\n" + BashHelper.command_withTrack((String)this.getVariable(INPUT_INDEX_FASTA_FILE).$(), (String)("hisat2-build -q  " + this.getVariable(INPUT_INDEX_FASTA_FILE).$() + " ${prefixOption} "), (String)"hisat2-build Reference Index")).Else(String.valueOf(outputIndexFile) + "=\"" + this.getVariable(INPUT_INDEX_FILE).$() + "\"\n");
        builder.append(buildIndex);
        builder.append("outputFolder=\"" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\"\n");
        builder.append("_refIndex=\"" + this.getVariable(OUTPUT_REF_INDEX).$() + "\"\n");
        builder.append(BashHelper.Batcher_noLog((FileListVariable)((FileListVariable)this.getVariable(INPUT_FASTQ_FILE)), (String)BashHelper.IF((String)(" -z  \"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\" "), (String)"outputFileName=\"${inputFile1BaseName}\"\n", (String)("outputFileName=\"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\"\n")), (String)"", (String)BashHelper.IF((String)(" -z  \"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\" "), (String)"outputFileName=$(hlp_lncName  \"$inputFile1BaseName\" \"$inputFile2BaseName\" )\n[ -z \"${outputFileName}\" ] && outputFileName=\"${inputFile1BaseName}_${inputFile2BaseName}\"\n"), (String)(String.valueOf(this.getVariable(OUTPUT_ACCEPTED_HITS).getBashVarName("$_i")) + "=\"${outputFolder}/${outputFileName}.bam\"\n" + this.getVariable(OUTPUT_SAM_FILES).getBashVarName("$_i") + "=\"${outputFolder}/${outputFileName}.sam\"\n" + this.getVariable(OUTPUT_LIBRARY_NAMES).getBashVarName("$_i") + "=\"${outputFileName}\"\n"), (boolean)true));
        builder.append(BashHelper.BatcherParallelSingleton((FileListVariable)((FileListVariable)this.getVariable(INPUT_FASTQ_FILE)), (String)("outputFileName=\"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\"\n"), (String)(String.valueOf(BashHelper.echo((String)"Running Hisat2 for : ${_inputFile1}")) + "hisat2  " + this.getOptionParamatersStrAs$() + " -S  \"${outputFolder}/${outputFileName}.sam\" -x ${_refIndex} -U ${_inputFile1}  \n"), (String)(String.valueOf(BashHelper.echo((String)"Running Hisat2 for : ${_inputFile1},${_inputFile2}")) + "hisat2  " + this.getOptionParamatersStrAs$() + " -S  \"${outputFolder}/${outputFileName}.sam\" -x ${_refIndex} -1 ${_inputFile1}  -2 ${_inputFile2} \n")));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)((FilesVariable)this.getVariable(OUTPUT_SAM_FILES)), (String)("outputFileName=\"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\"\n"), (String)(String.valueOf(Tracking.trackLog((String)"Converting Sam file ${outputFileName}.sam to Bam")) + BashHelper.echo((String)"Converting Sam file ${outputFileName}.sam to Bam format.") + "[ -s \"${outputFolder}/${outputFileName}.sam\" ] && samtools view -S -b  \"${outputFolder}/${outputFileName}.sam\"  > \"${outputFolder}/${outputFileName}.bam\"\n" + BashHelper.IF((String)BashConditions.False((JobVariable)this.getVariable(OPTION_KEEP_TO_SAM)), (String)(String.valueOf(Tracking.trackLog((String)"Cleaning: Deleting sam file ${outputFileName}.sam")) + "[ -f \"${outputFolder}/${outputFileName}.sam\" ] && rm \"${outputFolder}/${outputFileName}.sam\" "))), (String)"Convert Sam to Bam"));
        FilesVariable outBamFiles = (FilesVariable)this.getVariable(OUTPUT_ACCEPTED_HITS);
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)outBamFiles, (String)"", (String)BashHelper.If((String)BashConditions.fileExist((String)outBamFiles.$("${_i}"))).Then(String.valueOf(MappingHisat2Job.st((String)("samtools sort -o ${outputFolder}/sorted_${inputFileBaseName}.bam " + outBamFiles.$("${_i}")))) + MappingHisat2Job.st((String)("mv " + outBamFiles.$("${_i}") + " ${outputFolder}/unsorted_${inputFileBaseName}.bam")) + MappingHisat2Job.st((String)("mv  ${outputFolder}/sorted_${inputFileBaseName}.bam " + outBamFiles.$("${_i}"))) + MappingHisat2Job.st((String)("samtools index " + outBamFiles.$("${_i}")))).toString(), (String)"samtools index"));
    }

    protected void generateCommandWrapUp(StringBuilder builder) {
    }
}

