/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.mapping;

import com.biotechvana.utils.FilenameUtils;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.CheckedVariableDescriptor;
import com.biotechvana.workflow.descriptors.FileVariableDescriptor;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.StringVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;

public class BuildReferenceJob
extends WorkflowJob {
    public static final String INPUT_INDEX_CHOICE = "INPUT_INDEX_CHOICE";
    public static final String INPUT_INDEX_FILE = "INPUT_INDEX_FILE";
    public static final String INPUT_INDEX_FASTA_FILE = "INDEX_FASTA_FILE";
    public static final String INPUT_INDEX_PREFIX = "INPUT_INDEX_PREFIX";
    public static final String INPUT_GTF_FILE = "INPUT_GTF_FILE";
    public static final String INPUT_INDEX_MAPPER = "INPUT_INDEX_MAPPER";
    private String refIndexFastaFile;
    private boolean buildNew;
    private String refIndex;
    private String refPrefix;
    private String refGTF;
    private String indexType = "";

    public BuildReferenceJob() {
        this.jobName = "Reference Options";
        this.jobDesc = new JobDescriptor("Ref");
        CheckedVariableDescriptor varIndexChioce = VariableDescriptor.Checked((String)INPUT_INDEX_CHOICE, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexChioce.isRequired = true;
        varIndexChioce.setVariableName("Create new index from a Fasta File");
        varIndexChioce.setHelpMsg("Create new Index from a Fasta File or Use an exisiting index.");
        varIndexChioce.setDefaultValue("false");
        this.jobDesc.addVariable((VariableDescriptor)varIndexChioce);
        FileVariableDescriptor varUsedIndexFile = VariableDescriptor.File((String)INPUT_INDEX_FILE, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varUsedIndexFile.isRequired = true;
        varUsedIndexFile.setVariableName("Index File");
        varUsedIndexFile.setShortHelpMsg("Drag an Existing index file.");
        varUsedIndexFile.setHelpMsg("Make sure that the index is in the same format used by the mapper that is selected in the protocol.");
        this.jobDesc.addVariable((VariableDescriptor)varUsedIndexFile);
        FileVariableDescriptor varIndexFile = VariableDescriptor.File((String)INPUT_INDEX_FASTA_FILE, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexFile.isRequired = true;
        varIndexFile.setVariableName("Input Reference Fasta File");
        varIndexFile.setHelpMsg("Reference Fasta file to build a new index.");
        varIndexFile.setShortHelpMsg("Drag a Fasta file to build a new index.");
        this.jobDesc.addVariable((VariableDescriptor)varIndexFile);
        StringVariableDescriptor varIndexFilePrefix = VariableDescriptor.String((String)INPUT_INDEX_PREFIX, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexFilePrefix.setVariableName("Prefix");
        varIndexFilePrefix.setIsFileName(true);
        varIndexFilePrefix.setHelpMsg("A prefix name for the output index file. Defualt value is the same as the prefix of the input Fasta File Name.");
        this.jobDesc.addVariable((VariableDescriptor)varIndexFilePrefix);
        StringVariableDescriptor tempVar = VariableDescriptor.String((String)INPUT_INDEX_MAPPER, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        tempVar.setVariableName("Mapper Type");
        this.jobDesc.addVariable((VariableDescriptor)tempVar);
        FileVariableDescriptor varGTFFile = VariableDescriptor.File((String)INPUT_GTF_FILE, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varGTFFile.setVariableName("GTF-guide file");
        varGTFFile.setHelpMsg("Reference genome GTF guide file");
        this.jobDesc.addVariable((VariableDescriptor)varGTFFile);
        this.initJobFromDesc(this.jobDesc, false, false, false);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_FILE), VariablesRule.Condition.False, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_FASTA_FILE), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_PREFIX), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
    }

    public String notifyVarValueChanging(String varKey, String value) {
        try {
            if (varKey.equals(INPUT_INDEX_FILE)) {
                String refIndex = value;
                String ext = FilenameUtils.getExtension((String)refIndex);
                System.out.println(value);
                if (ext != null && (ext.equals(".bt2") || ext.equals(".bt") || ext.equals(".bt2l"))) {
                    String raw = FilenameUtils.getBasename((String)refIndex, (boolean)true);
                    raw = FilenameUtils.getBasename((String)raw, (boolean)true);
                    String path = org.apache.commons.io.FilenameUtils.getPath((String)refIndex);
                    System.out.println(path);
                    this.getVariable(INPUT_INDEX_FILE).setWarning("Bowtie Index detected.");
                    this.indexType = "Bowtie";
                    this.setValue(INPUT_INDEX_MAPPER, "Bowtie2");
                    return "/" + path + raw;
                }
                if (ext != null && (ext.equals(".ht2") || ext.equals(".ht"))) {
                    String raw = FilenameUtils.getBasename((String)refIndex, (boolean)true);
                    String ext2 = FilenameUtils.getExtension((String)(raw = FilenameUtils.getBasename((String)raw, (boolean)true)), (boolean)true);
                    if (ext2 != null && ext2.equals(".rev")) {
                        raw = FilenameUtils.getBasename((String)raw, (boolean)true);
                    }
                    String path = org.apache.commons.io.FilenameUtils.getPath((String)refIndex);
                    this.getVariable(INPUT_INDEX_FILE).setWarning("Hisat2 Index detected.");
                    this.indexType = "Hisat2";
                    this.setValue(INPUT_INDEX_MAPPER, "hisat2");
                    return "/" + path + raw;
                }
                if (ext != null && (ext.equals(".amb") || ext.equals(".ann") || ext.equals(".bwt") || ext.equals(".pac") || ext.equals(".sa"))) {
                    String raw = FilenameUtils.getBasename((String)refIndex, (boolean)true);
                    String path = org.apache.commons.io.FilenameUtils.getPath((String)refIndex);
                    this.getVariable(INPUT_INDEX_FILE).setWarning("BWA Index detected.");
                    this.indexType = "BWA";
                    this.setValue(INPUT_INDEX_MAPPER, "bwa");
                    return "/" + path + raw;
                }
                this.indexType = "";
                this.setValue(INPUT_INDEX_MAPPER, "");
                this.getVariable(INPUT_INDEX_FILE).setWarning("Unable to detect the index type.");
            }
        }
        catch (Exception ex) {
            System.out.println("notifyVarValueChanging Error in " + varKey + "  " + this.getJobDescID());
        }
        return value;
    }

    public boolean notifyVarValueChanged(String varKey, String value) {
        if (varKey.equals(INPUT_INDEX_FASTA_FILE)) {
            this.setReferenceIndexFastaFile(value, true);
        }
        if (varKey.equals(INPUT_INDEX_PREFIX)) {
            this.setReferenecePrefix(value);
        }
        if (varKey.equals(INPUT_INDEX_FILE)) {
            this.setReferenceIndex(value);
        }
        if (varKey.equals(INPUT_GTF_FILE)) {
            this.setRefereneceGTF(value);
        }
        return true;
    }

    public void setReferenceIndexFastaFile(String refIndexFastaFile) {
        this.setReferenceIndexFastaFile(refIndexFastaFile, false);
    }

    public void setReferenceIndexFastaFile(String refIndexFastaFile, boolean buildNew) {
        this.refIndexFastaFile = refIndexFastaFile;
        this.buildNew = buildNew;
    }

    public String getReferenceIndexFastaFile() {
        return this.refIndexFastaFile;
    }

    public void setReferenceIndex(String refIndex) {
        this.buildNew = false;
        this.refIndex = refIndex;
        this.refIndexFastaFile = "";
        this.refPrefix = "";
    }

    public boolean getReferenceBuildNew() {
        return this.buildNew;
    }

    public String getReferenceIndex() {
        return this.refIndex;
    }

    public void setReferenecePrefix(String prefix) {
        this.refPrefix = prefix;
    }

    public String getReferenecePrefix() {
        return this.refPrefix;
    }

    public void setRefereneceGTF(String gtfFile) {
        this.refGTF = gtfFile;
    }

    public String getRefereneceGTF() {
        return this.refGTF;
    }
}

