/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs;

import com.biotechvana.shared.jobs.MappingPipelineStarter;
import com.biotechvana.shared.jobs.PreprocessingPipelineStarter;
import com.biotechvana.shared.jobs.mapping.MappingBowtie2Job;
import com.biotechvana.shared.jobs.mapping.MappingBwaJob;
import com.biotechvana.shared.jobs.mapping.MappingHisat2Job;
import com.biotechvana.shared.jobs.mapping.MappingSTARJob;
import com.biotechvana.shared.jobs.mapping.MappingTophatJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingCUTADAPTJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingFASTAQCJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingFastqCollapserJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingFastqIntersectJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingFastqMidCleanerJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingPRINSEQJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingTrimmomaticJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastaClippingHistogramJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastaFormatterJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastaNucleotidesChangerJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastqQualityChartJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastqQualityFilterJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastqToFastaJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxArtifactsFilterJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxBarcodeSplitterJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxClipperJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxCollapserJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxNucleotideDistJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxRenamerJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxReverseComplementjOB;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxStatisticsJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxTrimmerJob;
import com.biotechvana.workflow.Workflow;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.WorkflowMetadata;
import com.biotechvana.workflow.WorkflowStartupJob;
import com.biotechvana.workflow.descriptors.Publication;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.manager.JobsCatalog;
import com.biotechvana.workflow.template.WorkflowTemplate;

public class SharedCatalog {
    protected static final String sharedAuthor = "Biotechvana";
    protected static final String sharedRef = "http://biotechvana.com/";
    public static String TAG_All = "all";
    public static final int MAPPER_Bowtie2 = 1;
    public static final int MAPPER_Tophat = 2;
    public static final int MAPPER_Hisat2 = 3;
    public static final int MAPPER_STAR = 4;
    public static final int MAPPER_BWA = 5;
    public static final String[] PrePocessingModules_CP = new String[]{"CUTADAPT", "PRINSEQ"};
    public static final String[] PrePocessingModules_C = new String[]{"CUTADAPT"};
    public static final String[] PrePocessingModules_T = new String[]{"trimmomatic"};
    public static final String[] PrePocessingModules_P = new String[]{"PRINSEQ"};
    protected static String[] mappersId = new String[]{"Bowtie2", "Tophat", "hisat2", "STAR", "bwa"};
    public static IWorkflowManager manager;

    protected static void addTaskMetaInfo(WorkflowTemplate template, String jobId) {
        try {
            WorkflowJob job = manager.getJobsCatalog().createJobInstanceById(jobId, new Object[0]);
            template.getMetadata().addTag(job.getJobDescID());
            template.getMetadata().addTag(job.getJobTags());
            template.getMetadata().addChar(job.getJobChars());
        }
        catch (Exception e) {
            template.getMetadata().addTag(jobId);
        }
    }

    public static void initCatalog(JobsCatalog catalog) {
        JobsCatalog jobsCatalog = catalog;
        jobsCatalog.getClass();
        JobsCatalog.JobCategory PREPROCESSING_CATEGORY = new JobsCatalog.JobCategory(jobsCatalog, "Preprocessing");
        JobsCatalog jobsCatalog2 = catalog;
        jobsCatalog2.getClass();
        JobsCatalog.JobCategory MAPPING_CATEGORY = new JobsCatalog.JobCategory(jobsCatalog2, "Mapping");
        JobsCatalog jobsCatalog3 = catalog;
        jobsCatalog3.getClass();
        JobsCatalog.JobCatalogItem jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog3, "FASTQC", "FASTQC", PreProcessingFASTAQCJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog4 = catalog;
        jobsCatalog4.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog4, "CUTADAPT", "CUTADAPT", PreProcessingCUTADAPTJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog5 = catalog;
        jobsCatalog5.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog5, "PRINSEQ", "PRINSEQ", PreProcessingPRINSEQJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog6 = catalog;
        jobsCatalog6.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog6, "Trimmomatic", "trimmomatic", PreProcessingTrimmomaticJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog7 = catalog;
        jobsCatalog7.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog7, "FastqIntersect", "FastqIntersect", PreProcessingFastqIntersectJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog8 = catalog;
        jobsCatalog8.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog8, "FastqMidCleaner", "FastqMidCleaner", PreProcessingFastqMidCleanerJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog9 = catalog;
        jobsCatalog9.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog9, "FastqCollapser", "FastqCollapser", PreProcessingFastqCollapserJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog10 = catalog;
        jobsCatalog10.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog10, "FASTXTOOLKIT: FASTQ to FASTA", "FASTQ_to_FASTA", FastxtoolkitFastqToFastaJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog11 = catalog;
        jobsCatalog11.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog11, "FASTXTOOLKIT: FASTA Formatter", "FASTX_FASTA_Formatter", FastxtoolkitFastaFormatterJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog12 = catalog;
        jobsCatalog12.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog12, "FASTXTOOLKIT: FASTA Clipping Histogram", "FASTX_Clipping_Histogram", FastxtoolkitFastaClippingHistogramJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog13 = catalog;
        jobsCatalog13.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog13, "FASTXTOOLKIT: FASTA Nucleotides Changer", "FASTX_Nucleotides_Changer", FastxtoolkitFastaNucleotidesChangerJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog14 = catalog;
        jobsCatalog14.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog14, "FASTXTOOLKIT: FASTQ Quality Chart", "FASTX_Quality_Chart", FastxtoolkitFastqQualityChartJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog15 = catalog;
        jobsCatalog15.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog15, "FASTXTOOLKIT: FASTQ Quality Filter", "FASTX_Quality_Filter", FastxtoolkitFastqQualityFilterJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog16 = catalog;
        jobsCatalog16.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog16, "FASTXTOOLKIT: FASTX Artifacts Filter", "FASTX_Artifacts_Filter", FastxtoolkitFastxArtifactsFilterJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog17 = catalog;
        jobsCatalog17.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog17, "FASTXTOOLKIT: FASTX Barcode Splitter", "FASTX_Barcode_Splitter", FastxtoolkitFastxBarcodeSplitterJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog18 = catalog;
        jobsCatalog18.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog18, "FASTXTOOLKIT: FASTX Clipper", "FASTX_Clipper", FastxtoolkitFastxClipperJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog19 = catalog;
        jobsCatalog19.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog19, "FASTXTOOLKIT: FASTX Collapser", "FASTX_Collapser", FastxtoolkitFastxCollapserJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog20 = catalog;
        jobsCatalog20.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog20, "FASTXTOOLKIT: FASTX Nucleotide Distribution", "FASTX_Nucleotide_Distribution", FastxtoolkitFastxNucleotideDistJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog21 = catalog;
        jobsCatalog21.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog21, "FASTXTOOLKIT: FASTX Renamer", "FASTX_Renamer", FastxtoolkitFastxRenamerJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog22 = catalog;
        jobsCatalog22.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog22, "FASTXTOOLKIT: FASTX Reverse Complement", "FASTX_Reverse_Complement", FastxtoolkitFastxReverseComplementjOB.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog23 = catalog;
        jobsCatalog23.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog23, "FASTXTOOLKIT: FASTX Statistics", "FASTX_Stats", FastxtoolkitFastxStatisticsJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog24 = catalog;
        jobsCatalog24.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog24, "FASTXTOOLKIT: FASTX Trimmer", "FASTX_Trimmer", FastxtoolkitFastxTrimmerJob.class.getName(), PREPROCESSING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog25 = catalog;
        jobsCatalog25.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog25, "Bowtie2", "Bowtie2", MappingBowtie2Job.class.getName(), MAPPING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog26 = catalog;
        jobsCatalog26.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog26, "Bwa", "bwa", MappingBwaJob.class.getName(), MAPPING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog27 = catalog;
        jobsCatalog27.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog27, "Trimmomatic", "trimmomatic", PreProcessingTrimmomaticJob.class.getName(), MAPPING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog28 = catalog;
        jobsCatalog28.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog28, "Tophat2", "Tophat", MappingTophatJob.class.getName(), MAPPING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog29 = catalog;
        jobsCatalog29.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog29, "STAR", "STAR", MappingSTARJob.class.getName(), MAPPING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog30 = catalog;
        jobsCatalog30.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog30, "Hisat2", "hisat2", MappingHisat2Job.class.getName(), MAPPING_CATEGORY);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog31 = catalog;
        jobsCatalog31.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog31, "Pipeline Configuration", MappingPipelineStarter.JOB_ID, MappingPipelineStarter.class.getName(), null);
        catalog.addJobsItem(jobItem);
        JobsCatalog jobsCatalog32 = catalog;
        jobsCatalog32.getClass();
        jobItem = new JobsCatalog.JobCatalogItem(jobsCatalog32, "Pipeline Configuration", PreprocessingPipelineStarter.JOB_ID, PreprocessingPipelineStarter.class.getName(), null);
        catalog.addJobsItem(jobItem);
    }

    public static String createSharedPreprocessingModules(WorkflowTemplate template, String[] jobsIdsOptions, boolean paired) {
        if (paired) {
            template.getMetadata().addTag("pairend");
        } else {
            template.getMetadata().addTag("singleend");
        }
        String startUpJobId = template.getStarterTaskId();
        SharedCatalog.addTaskMetaInfo(template, "FASTQC");
        template.addTask("FASTQC");
        template.addMapping(startUpJobId, "INPUT_FILES", "FASTQC", "INPUT_FILES");
        String firstTaskId = null;
        String secondTaskId = null;
        String thirdTaskId = null;
        String lastTaskId = null;
        if (jobsIdsOptions.length > 0) {
            lastTaskId = firstTaskId = jobsIdsOptions[0];
        }
        if (jobsIdsOptions.length > 1) {
            lastTaskId = secondTaskId = jobsIdsOptions[1];
        }
        if (jobsIdsOptions.length > 2) {
            lastTaskId = thirdTaskId = jobsIdsOptions[2];
        }
        if (firstTaskId == "CUTADAPT") {
            SharedCatalog.addCutadapt(template, 1);
        } else if (firstTaskId == "PRINSEQ") {
            SharedCatalog.addPrinseq(template, 1);
        } else if (firstTaskId == "trimmomatic") {
            SharedCatalog.addTrimmomatic(template, 1);
        }
        if (secondTaskId == "CUTADAPT") {
            SharedCatalog.addCutadapt(template, 2);
        } else if (secondTaskId == "PRINSEQ") {
            SharedCatalog.addPrinseq(template, 2);
        } else if (secondTaskId == "trimmomatic") {
            SharedCatalog.addTrimmomatic(template, 2);
        }
        if (thirdTaskId == "CUTADAPT") {
            SharedCatalog.addCutadapt(template, 3);
        } else if (thirdTaskId == "PRINSEQ") {
            SharedCatalog.addPrinseq(template, 3);
        } else if (thirdTaskId == "trimmomatic") {
            SharedCatalog.addTrimmomatic(template, 3);
        }
        template.addMapping("FASTQC", "OUTPUT_FILES", firstTaskId, "INPUT_FILES");
        if (secondTaskId != null) {
            template.addMapping(firstTaskId, "OUTPUT_FILES", secondTaskId, "INPUT_FILES");
        }
        if (thirdTaskId != null) {
            template.addMapping(secondTaskId, "OUTPUT_FILES", thirdTaskId, "INPUT_FILES");
        }
        String postFastQCId = "post_FASTQC";
        template.addTask("FASTQC", postFastQCId);
        SharedCatalog.addTaskMetaInfo(template, "FASTQC");
        template.addMapping(lastTaskId, "OUTPUT_FILES", postFastQCId, "INPUT_FILES");
        return postFastQCId;
    }

    private static void addTrimmomatic(WorkflowTemplate template, int i) {
        template.addTask("trimmomatic");
        SharedCatalog.addTaskMetaInfo(template, "trimmomatic");
    }

    private static void addCutadapt(WorkflowTemplate template, int i) {
        template.addTask("CUTADAPT");
        template.setCustomVariableValueByCMDSwitch("CUTADAPT", "--minimum-length", "50");
        SharedCatalog.addTaskMetaInfo(template, "CUTADAPT");
    }

    private static void addPrinseq(WorkflowTemplate template, int i) {
        template.addTask("PRINSEQ");
        SharedCatalog.addTaskMetaInfo(template, "PRINSEQ");
        template.setCustomVariableValueByCMDSwitch("PRINSEQ", "-ns_max_p", "10");
        template.setCustomVariableValueByCMDSwitch("PRINSEQ", "-trim_ns_left", "1");
        template.setCustomVariableValueByCMDSwitch("PRINSEQ", "-trim_ns_right", "1");
        template.setCustomVariableValueByCMDSwitch("PRINSEQ", "-min_qual_mean", "20");
        template.setCustomVariableValueByCMDSwitch("PRINSEQ", "-trim_qual_right", "28");
        template.setCustomVariableValueByCMDSwitch("PRINSEQ", "-ns_max_p", "15");
    }

    public static WorkflowJob createSharedPreprocessingModulesSE(Workflow workflow) {
        workflow.getMetadata().addTag("singleend");
        WorkflowStartupJob setupJob = workflow.getStartupJob();
        PreProcessingFASTAQCJob fastqc = new PreProcessingFASTAQCJob();
        fastqc.setJobId("pre_" + fastqc.getJobID());
        workflow.addJob((WorkflowJob)fastqc);
        workflow.addMapping((WorkflowJob)setupJob, "INPUT_FILES", (WorkflowJob)fastqc, "INPUT_FILES");
        PreProcessingCUTADAPTJob cutadapt = new PreProcessingCUTADAPTJob();
        workflow.addJob((WorkflowJob)cutadapt);
        workflow.addMapping((WorkflowJob)fastqc, "OUTPUT_FILES", (WorkflowJob)cutadapt, "INPUT_FILES");
        cutadapt.setValueByCMDSwitch("--minimum-length", "50");
        PreProcessingPRINSEQJob prinseq = new PreProcessingPRINSEQJob();
        workflow.addJob((WorkflowJob)prinseq);
        workflow.addMapping((WorkflowJob)cutadapt, "OUTPUT_FILES", (WorkflowJob)prinseq, "INPUT_FILES");
        prinseq.setValueByCMDSwitch("-ns_max_p", "10");
        prinseq.setValueByCMDSwitch("-trim_ns_left", "1");
        prinseq.setValueByCMDSwitch("-trim_ns_right", "1");
        prinseq.setValueByCMDSwitch("-min_qual_mean", "20");
        prinseq.setValueByCMDSwitch("-trim_qual_right", "28");
        prinseq.setValueByCMDSwitch("-ns_max_p", "15");
        PreProcessingFASTAQCJob fastqc_post = new PreProcessingFASTAQCJob();
        fastqc_post.setJobId("post_" + fastqc_post.getJobID());
        workflow.addJob((WorkflowJob)fastqc_post);
        workflow.addMapping((WorkflowJob)prinseq, "OUTPUT_FILES", (WorkflowJob)fastqc_post, "INPUT_FILES");
        return fastqc_post;
    }

    protected static String addMapper(WorkflowTemplate template, String mapperJobId, String preTask, String inputFastqVarKey, boolean paired) {
        template.addTask(mapperJobId);
        SharedCatalog.addTaskMetaInfo(template, mapperJobId);
        template.addMapping(preTask, "OUTPUT_FILES", mapperJobId, inputFastqVarKey);
        if (!(mapperJobId.equals("Bowtie2") || mapperJobId.equals("Tophat") || mapperJobId.equals("hisat2") || mapperJobId.equals("STAR"))) {
            mapperJobId.equals("bwa");
        }
        return mapperJobId;
    }

    protected static String[] getMapperInputOutputKeys(String mapperJobId) {
        String inputFastqVarKey = null;
        String outputBAMVarKey = null;
        if (mapperJobId.equals("Bowtie2")) {
            inputFastqVarKey = "INPUT_FILES";
            outputBAMVarKey = "OUTPUT_FILES";
        }
        if (mapperJobId.equals("Tophat")) {
            inputFastqVarKey = "INPUT_FILES";
            outputBAMVarKey = "OUTPUT_FILES";
        }
        if (mapperJobId.equals("hisat2")) {
            inputFastqVarKey = "INPUT_FILES";
            outputBAMVarKey = "OUTPUT_FILES";
        }
        if (mapperJobId.equals("STAR")) {
            inputFastqVarKey = "INPUT_FILES";
            outputBAMVarKey = "OUTPUT_FILES";
        }
        if (mapperJobId.equals("bwa")) {
            inputFastqVarKey = "INPUT_FILES";
            outputBAMVarKey = "OUTPUT_FILES";
        }
        return new String[]{inputFastqVarKey, outputBAMVarKey};
    }

    protected static String get_PM_Module(WorkflowTemplate template, String[] prepocessingModules, String mapperJobId, boolean paired) {
        WorkflowMetadata metaData = template.getMetadata();
        String[] mapperKeys = SharedCatalog.getMapperInputOutputKeys(mapperJobId);
        String inputFastqVarKey = mapperKeys[0];
        String outputBAMVarKey = mapperKeys[1];
        String fastqc_post = SharedCatalog.createSharedPreprocessingModules(template, prepocessingModules, paired);
        String mapper_jobid = SharedCatalog.addMapper(template, mapperJobId, fastqc_post, inputFastqVarKey, paired);
        return mapper_jobid;
    }

    protected static int getNXZero(int n, int zeros) {
        return (int)((double)n * Math.pow(10.0, zeros));
    }

    public static Publication getSamtoolsCitation() {
        return new Publication().setAuthors("Li, H., Handsaker, B., Wysoker, A., Fennell, T., Ruan, J., Homer, N., Marth, G., Abecasis, G. and Durbin, R.").setTitle("The sequence alignment/map format and SAMtools").setJournal("Bioinformatics").setVolume(25).setIssue(16).setYear(2009).setPages("2078-2079").setDOI("10.1093/bioinformatics/btp352").setPubmed("19505943").setUrl("http://samtools.sourceforge.net");
    }
}

